/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.network;

import de.markusbordihn.easynpc.network.NetworkHandlerInterface;
import de.markusbordihn.easynpc.network.message.NetworkMessageRecord;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;

public class NetworkHandler
implements NetworkHandlerInterface {
    public static final SimpleChannel INSTANCE = ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"easy_npc", (String)"network")).networkProtocolVersion(23).simpleChannel();
    private static int id = 0;
    private final Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> clientMessages = new LinkedHashMap();
    private final Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> serverMessages = new LinkedHashMap();
    private final Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> registeredClientMessages = new LinkedHashMap();
    private final Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> registeredServerMessages = new LinkedHashMap();

    public NetworkHandler() {
        log.info("{} Network Handler for {} with version {} ...", (Object)"\ud83d\udde3 Register Easy NPC: Core", (Object)INSTANCE, (Object)23);
    }

    @Override
    public <M extends NetworkMessageRecord> void sendToServer(M networkMessageRecord) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> INSTANCE.send((Object)networkMessageRecord, PacketDistributor.SERVER.noArg()));
    }

    @Override
    public <M extends NetworkMessageRecord> void sendToPlayer(M networkMessageRecord, ServerPlayer serverPlayer) {
        INSTANCE.send(networkMessageRecord, PacketDistributor.PLAYER.with((Object)serverPlayer));
    }

    @Override
    public <M extends NetworkMessageRecord> void registerClientNetworkMessageHandler(CustomPacketPayload.Type<M> type, StreamCodec<RegistryFriendlyByteBuf, M> codec, Class<M> networkMessage, Function<FriendlyByteBuf, M> creator) {
        int registrationID = id++;
        this.logRegisterClientNetworkMessageHandler(type, networkMessage, registrationID);
        INSTANCE.messageBuilder(networkMessage, registrationID, NetworkDirection.PLAY_TO_CLIENT).encoder(NetworkMessageRecord::write).decoder(creator::apply).consumerNetworkThread((message, context) -> {
            context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> message::handleClient));
            context.setPacketHandled(true);
        }).add();
    }

    @Override
    public <M extends NetworkMessageRecord> void registerServerNetworkMessageHandler(CustomPacketPayload.Type<M> type, StreamCodec<RegistryFriendlyByteBuf, M> codec, Class<M> networkMessage, Function<FriendlyByteBuf, M> creator) {
        int registrationID = id++;
        this.logRegisterServerNetworkMessageHandler(type, networkMessage, registrationID);
        INSTANCE.messageBuilder(networkMessage, registrationID, NetworkDirection.PLAY_TO_SERVER).encoder(NetworkMessageRecord::write).decoder(creator::apply).consumerNetworkThread((message, context) -> {
            context.enqueueWork(() -> message.handleServer(context.getSender()));
            context.setPacketHandled(true);
        }).add();
    }

    @Override
    public <M extends NetworkMessageRecord> void addClientMessage(CustomPacketPayload.Type<M> messageID, Class<M> networkMessage) {
        this.clientMessages.put(messageID, networkMessage);
    }

    @Override
    public <M extends NetworkMessageRecord> void addServerMessage(CustomPacketPayload.Type<M> messageID, Class<M> networkMessage) {
        this.serverMessages.put(messageID, networkMessage);
    }

    @Override
    public Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> getClientMessages() {
        return this.clientMessages;
    }

    @Override
    public Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> getServerMessages() {
        return this.serverMessages;
    }

    @Override
    public <M extends NetworkMessageRecord> void addRegisteredClientMessage(CustomPacketPayload.Type<M> messageID, Class<M> networkMessage) {
        this.registeredClientMessages.put(messageID, networkMessage);
    }

    @Override
    public <M extends NetworkMessageRecord> void addRegisteredServerMessage(CustomPacketPayload.Type<M> messageID, Class<M> networkMessage) {
        this.registeredServerMessages.put(messageID, networkMessage);
    }

    @Override
    public Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> getRegisteredClientMessages() {
        return this.registeredClientMessages;
    }

    @Override
    public Map<CustomPacketPayload.Type<?>, Class<? extends NetworkMessageRecord>> getRegisteredServerMessages() {
        return this.registeredServerMessages;
    }
}

