/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.data.action;

import de.markusbordihn.easynpc.data.action.ActionDataType;
import de.markusbordihn.easynpc.data.action.ActionUtils;
import de.markusbordihn.easynpc.data.condition.ConditionDataSet;
import de.markusbordihn.easynpc.utils.CompoundTagUtils;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public record ActionDataEntry(ActionDataType actionDataType, ConditionDataSet conditionDataSet, String command, class_2338 blockPos, boolean executeAsUser, boolean enableDebug, int permissionLevel) {
    public static final String DATA_TAG = "ActionDataEntry";
    public static final String DATA_COMMAND_TAG = "Cmd";
    public static final String DATA_DEBUG_TAG = "Debug";
    public static final String DATA_EXECUTE_AS_USER_TAG = "ExecAsUser";
    public static final String DATA_PERMISSION_LEVEL_TAG = "PermLevel";
    public static final String DATA_BLOCK_POS_TAG = "BlockPos";
    public static final String DATA_TYPE_TAG = "Type";
    public static final int DEFAULT_PERMISSION_LEVEL = 2;
    public static final int MAX_PERMISSION_LEVEL = 2;
    public static final int MIN_PERMISSION_LEVEL = 0;
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private static final String DEFAULT_COMMAND = "";

    public ActionDataEntry() {
        this(ActionDataType.COMMAND);
    }

    public ActionDataEntry(class_2487 compoundTag) {
        this(ActionDataType.get(compoundTag.method_10558(DATA_TYPE_TAG)), compoundTag.method_10545("ConditionDataSet") ? new ConditionDataSet(compoundTag.method_10562("ConditionDataSet")) : new ConditionDataSet(), compoundTag.method_10545(DATA_COMMAND_TAG) ? compoundTag.method_10558(DATA_COMMAND_TAG) : DEFAULT_COMMAND, compoundTag.method_10545(DATA_BLOCK_POS_TAG) ? CompoundTagUtils.readBlockPos(compoundTag.method_10562(DATA_BLOCK_POS_TAG)) : class_2338.field_10980, compoundTag.method_10545(DATA_EXECUTE_AS_USER_TAG) && compoundTag.method_10577(DATA_EXECUTE_AS_USER_TAG), compoundTag.method_10545(DATA_DEBUG_TAG) && compoundTag.method_10577(DATA_DEBUG_TAG), compoundTag.method_10545(DATA_PERMISSION_LEVEL_TAG) ? ActionDataEntry.checkPermissionLevel(compoundTag.method_10550(DATA_PERMISSION_LEVEL_TAG)) : 2);
    }

    public ActionDataEntry(ActionDataType actionDataType) {
        this(actionDataType, DEFAULT_COMMAND, 2);
    }

    public ActionDataEntry(ActionDataType actionDataType, String command) {
        this(actionDataType, command, 2);
    }

    public ActionDataEntry(ActionDataType actionDataType, String command, int permissionLevel) {
        this(actionDataType, command, permissionLevel, false);
    }

    public ActionDataEntry(ActionDataType actionDataType, String command, int permissionLevel, boolean executeAsUser) {
        this(actionDataType, command, permissionLevel, executeAsUser, false);
    }

    public ActionDataEntry(ActionDataType actionDataType, String command, boolean executeAsUser, boolean enableDebug) {
        this(actionDataType, command, 2, executeAsUser, enableDebug);
    }

    public ActionDataEntry(ActionDataType actionDataType, String command, int permissionLevel, boolean executeAsUser, boolean enableDebug) {
        this(actionDataType, new ConditionDataSet(), command != null ? command : DEFAULT_COMMAND, class_2338.field_10980, executeAsUser, enableDebug, permissionLevel);
    }

    private static int checkPermissionLevel(int permissionLevel) {
        if (permissionLevel > 2) {
            log.warn("Permission level {} is too high, will be set to a safe max. level {}", (Object)permissionLevel, (Object)2);
            return 2;
        }
        if (permissionLevel < 0) {
            log.warn("Permission level {} is too low, will be set to min. level {}", (Object)permissionLevel, (Object)0);
            return 0;
        }
        return permissionLevel;
    }

    public ActionDataEntry withBlockPos(class_2338 blockPos) {
        return new ActionDataEntry(this.actionDataType, this.conditionDataSet, this.command, blockPos, this.enableDebug, this.executeAsUser, this.permissionLevel);
    }

    public String getAction(class_1309 entity, class_3222 serverPlayer) {
        return ActionUtils.parseAction(this.command, entity, serverPlayer);
    }

    public boolean hasCommand() {
        return this.command != null;
    }

    public boolean hasCommandAndNotEmpty() {
        return this.command != null && !this.command.isEmpty();
    }

    public boolean hasBlockPos() {
        return this.blockPos != null && this.blockPos != class_2338.field_10980;
    }

    public boolean isValid() {
        return this.actionDataType != ActionDataType.NONE && this.hasCommand();
    }

    public boolean isValidAndNotEmpty() {
        return this.actionDataType != ActionDataType.NONE && (!this.actionDataType.requiresArgument() || this.hasCommandAndNotEmpty() || this.hasBlockPos());
    }

    public ActionDataEntry create(class_2487 compoundTag) {
        return new ActionDataEntry(compoundTag);
    }

    public class_2487 write(class_2487 compoundTag) {
        compoundTag.method_10582(DATA_TYPE_TAG, this.actionDataType.name());
        if (this.permissionLevel != 2) {
            compoundTag.method_10569(DATA_PERMISSION_LEVEL_TAG, this.permissionLevel);
        }
        if (this.blockPos != class_2338.field_10980) {
            compoundTag.method_10566(DATA_BLOCK_POS_TAG, (class_2520)CompoundTagUtils.writeBlockPos(this.blockPos));
        }
        if (this.command != null && !this.command.trim().isEmpty()) {
            compoundTag.method_10582(DATA_COMMAND_TAG, this.command.trim());
        }
        if (this.executeAsUser) {
            compoundTag.method_10556(DATA_EXECUTE_AS_USER_TAG, true);
        }
        if (this.enableDebug) {
            compoundTag.method_10556(DATA_DEBUG_TAG, true);
        }
        if (this.permissionLevel != 2) {
            compoundTag.method_10569(DATA_PERMISSION_LEVEL_TAG, this.permissionLevel);
        }
        if (!this.conditionDataSet.isEmpty()) {
            this.conditionDataSet.save(compoundTag);
        }
        return compoundTag;
    }

    public class_2487 createTag() {
        return this.write(new class_2487());
    }

    public UUID getId() {
        String idString = DATA_TAG + this.hashCode();
        return UUID.nameUUIDFromBytes(idString.getBytes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        int n;
        ActionDataType dataType;
        Object object2;
        if (!(object instanceof ActionDataEntry)) return false;
        ActionDataEntry actionDataEntry = (ActionDataEntry)object;
        try {
            dataType = object2 = actionDataEntry.actionDataType();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        Object dataSet = object2 = actionDataEntry.conditionDataSet();
        Object command1 = object2 = actionDataEntry.command();
        Object pos = object2 = actionDataEntry.blockPos();
        int asUser = n = actionDataEntry.executeAsUser();
        int debug = n = actionDataEntry.enableDebug();
        int level = n = actionDataEntry.permissionLevel();
        if (this.actionDataType != dataType) return false;
        if (!this.command.equals(command1)) return false;
        if (!this.blockPos.equals(pos)) return false;
        if (this.permissionLevel != level) return false;
        if (this.executeAsUser != asUser) return false;
        if (this.enableDebug != debug) return false;
        if (!this.conditionDataSet.equals(dataSet)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + this.actionDataType.hashCode();
        result = 31 * result + this.command.hashCode();
        result = 31 * result + this.blockPos.hashCode();
        result = 31 * result + this.permissionLevel;
        result = 31 * result + (this.executeAsUser ? 1 : 0);
        result = 31 * result + (this.enableDebug ? 1 : 0);
        if (this.conditionDataSet != null && !this.conditionDataSet.isEmpty()) {
            result = 31 * result + this.conditionDataSet.size();
        }
        return result;
    }

    @Override
    public String toString() {
        return "ActionData [type=" + String.valueOf((Object)this.actionDataType) + ", cmd=" + this.command + ", blockPos=" + String.valueOf(this.blockPos) + ", permLvl=" + this.permissionLevel + ", execAsUser=" + this.executeAsUser + ", debug=" + this.enableDebug + (String)(this.conditionDataSet != null && !this.conditionDataSet.isEmpty() ? ", conditions=" + String.valueOf(this.conditionDataSet) : DEFAULT_COMMAND) + "]";
    }
}

