/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.io;

import de.markusbordihn.easynpc.Constants;
import de.markusbordihn.easynpc.io.BackupDataFiles;
import de.markusbordihn.easynpc.io.CustomPoseDataFiles;
import de.markusbordihn.easynpc.io.CustomPresetDataFiles;
import de.markusbordihn.easynpc.io.CustomSkinDataFiles;
import de.markusbordihn.easynpc.io.PlayerSkinDataFiles;
import de.markusbordihn.easynpc.io.RemoteSkinDataFiles;
import de.markusbordihn.easynpc.io.WorldPresetDataFiles;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.regex.Pattern;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataFileHandler {
    protected static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    protected static final String BACKUP_FOLDER_NAME = "backup";
    protected static final String CACHE_FOLDER_NAME = "cache";
    private static final Pattern VALID_PRESET_FILENAME_PATTERN = Pattern.compile("[a-zA-Z0-9/._-]+");

    private DataFileHandler() {
    }

    public static boolean isValidPresetFilename(String filename) {
        return VALID_PRESET_FILENAME_PATTERN.matcher(filename).matches();
    }

    public static boolean isValidPresetFilename(Path path) {
        return DataFileHandler.isValidPresetFilename(path.getFileName().toString());
    }

    public static boolean isPresetFile(Path path) {
        return path.toString().endsWith(".npc.nbt") && DataFileHandler.isValidPresetFilename(path);
    }

    public static boolean isPresetFile(class_2960 resourceLocation) {
        return resourceLocation.toString().endsWith(".npc.nbt");
    }

    public static String getPresetFileName(String fileName) {
        String result = fileName.replaceAll("[^a-zA-Z0-9/._-]", "").replace("..", "").replace("/", "_");
        return result.endsWith(".npc.nbt") ? result : result + ".npc.nbt";
    }

    public static void registerCommonDataFiles() {
        log.info("{} Common data folders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        DataFileHandler.getCacheFolder();
        DataFileHandler.getCustomDataFolder();
    }

    public static void registerServerDataFiles(MinecraftServer minecraftServer) {
        log.info("{} Server data folders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        log.info("{} Pose data folders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        CustomPoseDataFiles.registerCustomPoseData(minecraftServer);
        log.info("{} Backup data folders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        BackupDataFiles.registerBackupData();
        log.info("{} Preset data folders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        CustomPresetDataFiles.registerCustomPresetData();
        WorldPresetDataFiles.registerWorldPresetData();
    }

    public static void registerClientDataFiles() {
        log.info("{} Client data folders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        log.info("{} Skin data folders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        CustomSkinDataFiles.registerCustomSkinData();
        PlayerSkinDataFiles.registerPlayerSkinData();
        RemoteSkinDataFiles.registerRemoteSkinData();
        log.info("{} Preset data folders ...", (Object)"\ud83d\udde3 Register Easy NPC: Core");
        CustomPresetDataFiles.registerCustomPresetData();
    }

    public static Path getBackupFolder() {
        Path backupFolder = Constants.GAME_DIR.resolve("easy_npc").resolve(BACKUP_FOLDER_NAME);
        try {
            if (Files.exists(backupFolder, new LinkOption[0]) && Files.isDirectory(backupFolder, new LinkOption[0])) {
                return backupFolder;
            }
            log.info("Creating backup folder at {} ...", (Object)backupFolder);
            return Files.createDirectories(backupFolder, new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the backup folder:", (Throwable)exception);
            return null;
        }
    }

    public static Path getCacheFolder() {
        Path cacheFolder = Constants.GAME_DIR.resolve("easy_npc").resolve(CACHE_FOLDER_NAME);
        try {
            if (Files.exists(cacheFolder, new LinkOption[0]) && Files.isDirectory(cacheFolder, new LinkOption[0])) {
                return cacheFolder;
            }
            log.info("Creating cache folder at {} ...", (Object)cacheFolder);
            return Files.createDirectories(cacheFolder, new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the cache folder:", (Throwable)exception);
            return null;
        }
    }

    public static Path getCustomDataFolder() {
        Path customDataFolder = Constants.CONFIG_DIR.resolve("easy_npc");
        try {
            if (Files.exists(customDataFolder, new LinkOption[0]) && Files.isDirectory(customDataFolder, new LinkOption[0])) {
                return customDataFolder;
            }
            log.info("Creating custom data folder at {} ...", (Object)customDataFolder);
            return Files.createDirectories(customDataFolder, new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the custom data folder:", (Throwable)exception);
            return null;
        }
    }

    public static Path getOrCreateBackupFolder(String dataLabel) {
        Path backupFolder = DataFileHandler.getBackupFolder();
        if (backupFolder == null) {
            return null;
        }
        Path backupFolderPath = backupFolder.resolve(dataLabel);
        try {
            if (Files.exists(backupFolderPath, new LinkOption[0]) && Files.isDirectory(backupFolderPath, new LinkOption[0])) {
                return backupFolderPath;
            }
            log.info("Creating backup folder {} at {} ...", (Object)dataLabel, (Object)backupFolder);
            return Files.createDirectories(backupFolderPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the backup folder {}:", (Object)dataLabel, (Object)exception);
            return null;
        }
    }

    public static Path getOrCreateCacheFolder(String dataLabel) {
        Path cacheFolder = DataFileHandler.getCacheFolder();
        if (cacheFolder == null) {
            return null;
        }
        Path cacheFolderPath = cacheFolder.resolve(dataLabel);
        try {
            if (Files.exists(cacheFolderPath, new LinkOption[0]) && Files.isDirectory(cacheFolderPath, new LinkOption[0])) {
                return cacheFolderPath;
            }
            log.info("Creating cache folder {} at {} ...", (Object)dataLabel, (Object)cacheFolder);
            return Files.createDirectories(cacheFolderPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the cache folder {}:", (Object)dataLabel, (Object)exception);
            return null;
        }
    }

    public static Path getOrCreateCustomDataFolder(String dataLabel) {
        Path customDataFolder = DataFileHandler.getCustomDataFolder();
        if (customDataFolder == null) {
            return null;
        }
        Path customDataFolderPath = customDataFolder.resolve(dataLabel);
        try {
            if (Files.exists(customDataFolderPath, new LinkOption[0]) && Files.isDirectory(customDataFolderPath, new LinkOption[0])) {
                return customDataFolderPath;
            }
            log.info("Creating custom data folder {} at {} ...", (Object)dataLabel, (Object)customDataFolder);
            return Files.createDirectories(customDataFolderPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            log.error("There was an error, creating the custom data folder {}:", (Object)dataLabel, (Object)exception);
            return null;
        }
    }

    public static void copyResourceFile(MinecraftServer minecraftServer, class_2960 resourceLocation, File targetFile) {
        block15: {
            if (resourceLocation == null || targetFile == null) {
                return;
            }
            try {
                Optional resources = minecraftServer.method_34864().method_14486(resourceLocation);
                if (!resources.isPresent()) break block15;
                try (InputStream inputStream = ((class_3298)resources.get()).method_14482();
                     FileOutputStream outputStream = new FileOutputStream(targetFile);){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = inputStream.read(buffer)) > 0) {
                        ((OutputStream)outputStream).write(buffer, 0, length);
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed to load resource {}:", (Object)resourceLocation, (Object)e);
            }
        }
    }

    public static void copyResourceFile(class_2960 resourceLocation, File targetFile) {
        block15: {
            if (resourceLocation == null || targetFile == null) {
                return;
            }
            try {
                Optional resources = class_310.method_1551().method_1478().method_14486(resourceLocation);
                if (!resources.isPresent()) break block15;
                try (InputStream inputStream = ((class_3298)resources.get()).method_14482();
                     FileOutputStream outputStream = new FileOutputStream(targetFile);){
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = inputStream.read(buffer)) > 0) {
                        ((OutputStream)outputStream).write(buffer, 0, length);
                    }
                }
            }
            catch (Exception e) {
                log.error("Failed to load resource {}:", (Object)resourceLocation, (Object)e);
            }
        }
    }

    public static String getFileNameFromResourceLocation(class_2960 resourceLocation) {
        if (resourceLocation == null) {
            return null;
        }
        return Paths.get(resourceLocation.method_12832(), new String[0]).getFileName().toString();
    }
}

