/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.level;

import de.markusbordihn.easynpc.data.spawner.SpawnerData;
import de.markusbordihn.easynpc.data.spawner.SpawnerType;
import de.markusbordihn.easynpc.entity.LivingEntityManager;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1917;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseEasyNPCSpawner
extends class_1917 {
    private static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");
    private final Random random = new Random();
    private final SpawnerType spawnerType;
    private boolean isEasyNPC = false;
    private double oSpin;
    private double spin;
    private class_1297 displayEntity;
    private int maxNearbyEntities = 6;
    private int maxSpawnDelay = 800;
    private int minSpawnDelay = 200;
    private int requiredPlayerRange = 16;
    private int spawnCount = 4;
    private int spawnDelay = 20;
    private int spawnRange = 4;
    private class_2960 entityResourceLocation;
    private class_1952 nextSpawnData;
    private UUID easyNPCPresetUUID;
    private UUID easyNPCUUID;

    public BaseEasyNPCSpawner(SpawnerType spawnerType) {
        this.spawnerType = spawnerType;
        class_2487 spawnerData = this.method_8272(new class_2487());
        SpawnerData.setSpawnData(spawnerType, spawnerData);
        this.updateSpawnData(spawnerData);
        this.method_8280(null, null, spawnerData);
    }

    public void method_8273(class_1937 level, class_2338 blockPos, int eventId) {
        level.method_8427(blockPos, class_2246.field_10260, eventId, 0);
    }

    public void method_8277(class_1937 level, class_2338 blockPos, class_1952 spawnData) {
        super.method_8277(level, blockPos, spawnData);
        if (level != null) {
            class_2680 blockState = level.method_8320(blockPos);
            level.method_8413(blockPos, blockState, blockState, 4);
        }
        this.updateSpawnData(this.method_8272(new class_2487()));
    }

    public void method_31589(class_1937 level, class_2338 blockPos) {
        EasyNPC<?> easyNPC;
        if (!this.hasEasyNPC()) {
            return;
        }
        if (!this.isNearPlayer(level, blockPos, this.requiredPlayerRange)) {
            this.oSpin = this.spin;
            return;
        }
        if (this.maxNearbyEntities == 1 && (easyNPC = LivingEntityManager.getEasyNPCEntityByUUID(this.easyNPCUUID)) != null && easyNPC.getEntity().method_5805()) {
            this.oSpin = this.spin;
            return;
        }
        if (this.easyNPCPresetUUID != null && LivingEntityManager.getEntityCountByPresetUUID(this.easyNPCPresetUUID) >= this.maxNearbyEntities) {
            this.oSpin = this.spin;
            return;
        }
        double x = (double)blockPos.method_10263() + level.field_9229.method_43058();
        double y = (double)blockPos.method_10264() + level.field_9229.method_43058();
        double z = (double)blockPos.method_10260() + level.field_9229.method_43058();
        level.method_8406((class_2394)class_2398.field_11251, x, y, z, 0.0, 0.0, 0.0);
        level.method_8406((class_2394)class_2398.field_11240, x, y, z, 0.0, 0.0, 0.0);
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
        }
        this.oSpin = this.spin;
        this.spin = (this.spin + 1000.0 / ((double)this.spawnDelay + 200.0)) % 360.0;
    }

    public void method_31588(class_3218 serverLevel, class_2338 blockPos) {
        class_1297 entity;
        if (!this.hasEasyNPC()) {
            return;
        }
        if (this.requiredPlayerRange > 0 && !this.isNearPlayer((class_1937)serverLevel, blockPos, this.requiredPlayerRange)) {
            return;
        }
        if (this.spawnDelay > 0) {
            --this.spawnDelay;
            return;
        }
        this.delay((class_1937)serverLevel, blockPos);
        if (this.maxNearbyEntities == 1 && this.easyNPCUUID != null && (entity = serverLevel.method_14190(this.easyNPCUUID)) != null && entity.method_5805()) {
            this.delay((class_1937)serverLevel, blockPos);
            return;
        }
        if (this.easyNPCPresetUUID != null && LivingEntityManager.getEntityCountByPresetUUID(this.easyNPCPresetUUID) >= this.maxNearbyEntities) {
            this.delay((class_1937)serverLevel, blockPos);
            return;
        }
        this.spawnEasyNPC(serverLevel, blockPos);
    }

    public class_1297 method_8283(class_1937 level, class_2338 blockPos) {
        if (this.displayEntity == null) {
            this.displayEntity = class_1299.method_17842((class_2487)this.nextSpawnData.method_38093(), (class_1937)level, (class_3730)class_3730.field_16469, Function.identity());
        }
        return this.displayEntity;
    }

    public double method_8278() {
        return this.spin;
    }

    public double method_8279() {
        return this.oSpin;
    }

    private boolean isNearPlayer(class_1937 level, class_2338 pos, int requiredPlayerRange) {
        return level.method_18458((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (double)requiredPlayerRange);
    }

    private void delay(class_1937 level, class_2338 pos) {
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + this.random.nextInt(this.maxSpawnDelay - this.minSpawnDelay);
        this.method_8273(level, pos, 1);
    }

    private void spawnEasyNPC(class_3218 level, class_2338 pos) {
        boolean spawned = false;
        for (int i = 0; i < this.spawnCount; ++i) {
            class_1308 mob;
            double finalZ;
            double finalY;
            double finalX;
            class_1297 entity;
            double z;
            class_2499 posList;
            int posSize;
            class_2487 entityTag = this.nextSpawnData.method_38093();
            Optional entityType = class_1299.method_17684((class_2487)entityTag);
            if (entityType.isEmpty()) {
                this.delay((class_1937)level, pos);
                return;
            }
            if (this.maxNearbyEntities > 1 && entityTag.method_10545("UUID")) {
                entityTag.method_10551("UUID");
            }
            double x = (posSize = (posList = entityTag.method_10554("Pos", 6)).size()) >= 1 ? posList.method_10611(0) : (double)pos.method_10263() + (level.field_9229.method_43058() - level.field_9229.method_43058()) * (double)this.spawnRange + 0.5;
            double y = posSize >= 2 ? posList.method_10611(1) : (double)(pos.method_10264() + level.field_9229.method_43048(3) - 1);
            double d = z = posSize >= 3 ? posList.method_10611(2) : (double)pos.method_10260() + (level.field_9229.method_43058() - level.field_9229.method_43058()) * (double)this.spawnRange + 0.5;
            if (!level.method_18026(((class_1299)entityType.get()).method_58629(x, y, z))) {
                class_2338 possibleSpawnPositions;
                if (this.maxNearbyEntities <= 1 || (possibleSpawnPositions = (class_2338)class_2338.method_25997((class_2338)pos, (int)this.spawnRange, (int)this.spawnRange, possibleBlockPos -> level.method_18026(((class_1299)entityType.get()).method_58629((double)possibleBlockPos.method_10263() + 0.5, (double)possibleBlockPos.method_10264(), (double)possibleBlockPos.method_10260() + 0.5)) && !level.method_8320(possibleBlockPos.method_10074()).method_26215()).orElse(null)) == null) continue;
                x = (double)possibleSpawnPositions.method_10263() + 0.5;
                y = possibleSpawnPositions.method_10264();
                z = (double)possibleSpawnPositions.method_10260() + 0.5;
            }
            if ((entity = class_1299.method_17842((class_2487)entityTag, (class_1937)level, (class_3730)class_3730.field_16469, arg_0 -> BaseEasyNPCSpawner.lambda$spawnEasyNPC$1(finalX = x, finalY = y, finalZ = z, arg_0))) == null) {
                this.delay((class_1937)level, pos);
                return;
            }
            entity.method_5808(entity.method_23317(), entity.method_23318(), entity.method_23321(), level.field_9229.method_43057() * 360.0f, 0.0f);
            if (entity instanceof class_1308) {
                mob = (class_1308)entity;
                if (this.nextSpawnData.method_38097().isEmpty() && !mob.method_5979((class_1936)level, class_3730.field_16469) || !mob.method_5957((class_4538)level)) continue;
                mob.method_5943((class_5425)level, level.method_8404(mob.method_24515()), class_3730.field_16469, null);
            }
            if (!level.method_30736(entity)) {
                this.delay((class_1937)level, pos);
                return;
            }
            level.method_20290(2004, pos, 0);
            if (entity instanceof class_1308) {
                mob = (class_1308)entity;
                mob.method_5990();
            }
            spawned = true;
        }
        if (spawned) {
            this.delay((class_1937)level, pos);
        }
    }

    public boolean hasEasyNPC() {
        return this.isEasyNPC;
    }

    public UUID getEasyNPCUUID() {
        return this.easyNPCUUID;
    }

    public UUID getEasyNPCPresetUUID() {
        return this.easyNPCPresetUUID;
    }

    public void method_8280(class_1937 level, class_2338 blockPos, class_2487 compoundTag) {
        super.method_8280(level, blockPos, compoundTag);
        this.updateSpawnData(compoundTag);
    }

    public void updateSpawnData(class_2487 compoundTag) {
        class_2487 spawnData;
        this.spawnDelay = SpawnerData.getDelay(compoundTag);
        this.minSpawnDelay = SpawnerData.getMinSpawnDelay(compoundTag);
        this.maxSpawnDelay = SpawnerData.getMaxSpawnDelay(compoundTag);
        this.spawnCount = SpawnerData.getSpawnCount(compoundTag);
        this.maxNearbyEntities = SpawnerData.getMaxNearbyEntities(compoundTag);
        this.requiredPlayerRange = SpawnerData.getRequiredPlayerRange(compoundTag);
        this.spawnRange = SpawnerData.getSpawnRange(compoundTag);
        this.nextSpawnData = SpawnerData.getSpawnData(compoundTag);
        this.isEasyNPC = false;
        this.easyNPCUUID = null;
        this.easyNPCPresetUUID = null;
        if (SpawnerData.hasSpawnData(compoundTag) && (spawnData = compoundTag.method_10562("SpawnData")).method_10545("entity")) {
            class_2487 entityData = spawnData.method_10562("entity");
            if (entityData.method_10545("id")) {
                this.entityResourceLocation = class_2960.method_12829((String)entityData.method_10558("id"));
                this.isEasyNPC = this.entityResourceLocation.method_12836().equals("easy_npc");
            }
            if (entityData.method_10545("UUID")) {
                this.easyNPCUUID = entityData.method_25926("UUID");
            }
            if (entityData.method_10545("PresetUUID")) {
                this.easyNPCPresetUUID = entityData.method_25926("PresetUUID");
            }
        }
    }

    private static /* synthetic */ class_1297 lambda$spawnEasyNPC$1(double finalX, double finalY, double finalZ, class_1297 loadedEntity) {
        loadedEntity.method_5808(finalX, finalY, finalZ, loadedEntity.method_36454(), loadedEntity.method_36455());
        return loadedEntity;
    }
}

