/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.altered.fluid;

import net.mcreator.altered.init.AlteredModBlocks;
import net.mcreator.altered.init.AlteredModFluidTypes;
import net.mcreator.altered.init.AlteredModFluids;
import net.mcreator.altered.init.AlteredModItems;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class LiquidLightFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)AlteredModFluidTypes.LIQUID_LIGHT_TYPE.get(), () -> (Fluid)AlteredModFluids.LIQUID_LIGHT.get(), () -> (Fluid)AlteredModFluids.FLOWING_LIQUID_LIGHT.get()).explosionResistance(100.0f).tickRate(40).levelDecreasePerBlock(3).bucket(() -> (Item)AlteredModItems.LIQUID_LIGHT_BUCKET.get()).block(() -> (LiquidBlock)AlteredModBlocks.LIQUID_LIGHT.get());

    private LiquidLightFluid() {
        super(PROPERTIES);
    }

    public static class Flowing
    extends LiquidLightFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends LiquidLightFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

