/*
 * Decompiled with CFR 0.152.
 */
package com.ontey;

import com.ontey.execution.Execution;
import com.ontey.files.Commands;
import com.ontey.files.Config;
import com.ontey.tab.Tab;
import com.ontey.types.AdvancedBroadcast;
import com.ontey.types.Args;
import java.io.File;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class CustomCommand {
    public List<String> commands;
    public List<String> messages;
    public List<String> broadcasts;
    public List<String> aliases;
    @Nullable
    public AdvancedBroadcast advancedBroadcast;
    public Args args;
    public Tab tab;
    @Nullable
    public String permission;
    @Nullable
    public String description;
    @Nullable
    public String usage;
    public final YamlConfiguration config;
    public final File file;
    public final String name;

    public CustomCommand(YamlConfiguration config, File file, String name) {
        this.config = config;
        this.file = file;
        this.name = name;
        this.loadMutable(false);
    }

    public void loadMutable(boolean reload) {
        if (reload) {
            try {
                this.config.load(this.file);
            }
            catch (Exception e) {
                return;
            }
        }
        this.aliases = Commands.getAliases(this.config, this.name);
        this.permission = Commands.getPermission(this.config, this.name);
        this.description = Commands.getDescription(this.config, this.name);
        this.usage = Commands.getUsage(this.config, this.name);
        this.messages = Commands.getMessages(this.config, this.name);
        this.broadcasts = Commands.getBroadcasts(this.config, this.name);
        this.advancedBroadcast = AdvancedBroadcast.of(this.config, this.name);
        this.commands = Commands.getCommands(this.config, this.name);
        this.args = Commands.getArgs(this.config, this.name);
        this.tab = new Tab(this.config, this.name);
    }

    public void execute(CommandSender sender, String label, String[] args) {
        if (!this.args.checkArgs(sender, args)) {
            return;
        }
        if (Config.HOTSWAP) {
            this.loadMutable(true);
        }
        Execution.runCommands(this.commands, sender, args);
        Execution.sendMessages(this.messages, sender, args);
        Execution.sendBroadcasts(this.broadcasts, sender, args);
        Execution.sendAdvancedBroadcast(this.advancedBroadcast, sender, args);
    }

    public String toString() {
        return this.name;
    }
}

