/*
 * Decompiled with CFR 0.152.
 */
package com.ontey;

import com.ontey.CustomCommand;
import com.ontey.Main;
import com.ontey.files.Commands;
import com.ontey.files.Config;
import com.ontey.log.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class Startup {
    public static void loadCommands() {
        Commands.registeredCommands.addAll(Startup.getCommands());
        CommandMap commandMap = Startup.getCommandMap();
        for (CustomCommand command : Commands.registeredCommands) {
            Startup.loadCommand(commandMap, command);
        }
    }

    private static void loadCommand(CommandMap commandMap, final CustomCommand command) {
        BukkitCommand cmd = new BukkitCommand(command.name){

            public boolean execute(@NotNull CommandSender sender, @NotNull String label, String[] args) {
                if (sender == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (label == null) {
                    1.$$$reportNull$$$0(1);
                }
                command.execute(sender, label, args);
                return true;
            }

            @NotNull
            public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String label, @NotNull String[] args) {
                if (sender == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (label == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (args == null) {
                    1.$$$reportNull$$$0(4);
                }
                List<String> list = command.tab.getTabCompleter(args);
                if (list == null) {
                    1.$$$reportNull$$$0(5);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 5 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sender";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "label";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "args";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/ontey/Startup$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/ontey/Startup$1";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "tabComplete";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "tabComplete";
                        break;
                    }
                    case 5: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 5 -> new IllegalStateException(string);
                };
            }
        };
        cmd.setAliases(command.aliases);
        cmd.setDescription(Config.getOrDefault(command.description, Config.DEFAULT_DESCRIPTION));
        cmd.setUsage(Config.getOrDefault(command.usage, Config.DEFAULT_USAGE));
        cmd.setPermission(Commands.getPermission(command.config, command.name));
        commandMap.register(Commands.getNamespace(command.config, command.name), (Command)cmd);
    }

    public static CommandMap getCommandMap() {
        try {
            return (CommandMap)Bukkit.getServer().getClass().getMethod("getCommandMap", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get CommandMap, disabling plugin", e);
        }
    }

    private static List<CustomCommand> getCommands() {
        ArrayList<CustomCommand> out = new ArrayList<CustomCommand>();
        File dir = new File(Main.instance.getDataFolder(), "commands");
        if (!dir.exists() || !dir.isDirectory()) {
            return out;
        }
        File[] files = dir.listFiles((d, name) -> name.endsWith(".yml") || name.endsWith(".yaml"));
        if (files == null) {
            return out;
        }
        for (File file : files) {
            YamlConfiguration config = new YamlConfiguration();
            try {
                config.load(file);
                for (String name2 : config.getKeys(false)) {
                    if (name2 == null) continue;
                    out.add(new CustomCommand(config, file, name2));
                }
            }
            catch (Exception e) {
                Log.error("+-+-+-+-+-+-+-+-+-+-+-+-CCMD-+-+-+-+-+-+-+-+-+-+-+-+-+", "  Couldn't load the commands file named '" + file.getName() + "'.", "  Look at the stack-trace below, so you can identify the error.", "  There is probably a syntax error in the yml.", "  Fix the error, then restart the server and it will work again.", "  The plugin will just continue without this file.", "+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+");
                e.printStackTrace();
            }
        }
        return out;
    }
}

