/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.execution;

import com.ontey.execution.Formattation;
import com.ontey.execution.Replacement;
import com.ontey.files.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.command.CommandSender;

public class Evaluation {
    public static boolean evalConditions(List<String> conditions, CommandSender sender, String[] args) {
        if (conditions.isEmpty()) {
            return true;
        }
        for (String str : conditions) {
            if (Evaluation.evalCondition(str, sender, args)) continue;
            return false;
        }
        return true;
    }

    public static boolean evalCondition(String str, CommandSender sender, String[] args) {
        if (str == null || str.isBlank()) {
            return true;
        }
        str = str.replace(" ", "");
        str = Replacement.replaceArgs(str, args);
        List<String> parts = Evaluation.splitOrParts(str = Formattation.replacePlaceholders(sender, str, args));
        if (parts.size() > 1) {
            for (String part : parts) {
                if (!Evaluation.evalCondition(part, sender, args)) continue;
                return true;
            }
            return false;
        }
        return Evaluation.evalSingle(parts.getFirst());
    }

    private static List<String> splitOrParts(String str) {
        ArrayList<String> parts = new ArrayList<String>();
        int last = 0;
        for (int i = 0; i < str.length() - 1; ++i) {
            if (str.charAt(i) != '|' || str.charAt(i + 1) != '|') continue;
            int bs = 0;
            for (int j = i - 1; j >= 0 && str.charAt(j) == '\\'; --j) {
                ++bs;
            }
            if (bs % 2 != 0) continue;
            parts.add(str.substring(last, i));
            last = i + 2;
            ++i;
        }
        parts.add(str.substring(last));
        return parts;
    }

    private static boolean evalSingle(String expr) {
        String[] ops;
        for (String op : ops = new String[]{"==", "=?=", "!=", "!?=", ">=", "<=", ">", "<"}) {
            Pattern pattern = Pattern.compile(Pattern.quote(op));
            Matcher matcher = pattern.matcher(expr);
            while (matcher.find()) {
                int idx = matcher.start();
                int bs = 0;
                for (int i = idx - 1; i >= 0 && expr.charAt(i) == '\\'; --i) {
                    ++bs;
                }
                if (bs % 2 == 1) continue;
                return Evaluation.findAndCompare(expr, idx, op);
            }
        }
        return Config.isTrue(expr.toLowerCase());
    }

    private static boolean findAndCompare(String expr, int idx, String op) {
        String left = expr.substring(0, idx);
        String right = expr.substring(idx + op.length());
        left = left.replace("\\\\" + op, op);
        right = right.replace("\\\\" + op, op);
        return Evaluation.compare(left, right, op);
    }

    private static boolean compare(String left, String right, String op) {
        boolean isNumber;
        boolean bl = isNumber = Evaluation.isNumeric(left) && Evaluation.isNumeric(right);
        if (isNumber) {
            double l = Double.parseDouble(left);
            double r = Double.parseDouble(right);
            return switch (op) {
                case "==", "=?=" -> {
                    if (l == r) {
                        yield true;
                    }
                    yield false;
                }
                case "!=", "!?=" -> {
                    if (l != r) {
                        yield true;
                    }
                    yield false;
                }
                case ">" -> {
                    if (l > r) {
                        yield true;
                    }
                    yield false;
                }
                case "<" -> {
                    if (l < r) {
                        yield true;
                    }
                    yield false;
                }
                case ">=" -> {
                    if (l >= r) {
                        yield true;
                    }
                    yield false;
                }
                case "<=" -> {
                    if (l <= r) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return switch (op) {
            case "==" -> left.equals(right);
            case "!=" -> {
                if (!left.equals(right)) {
                    yield true;
                }
                yield false;
            }
            case "=?=" -> left.equalsIgnoreCase(right);
            case "!?=" -> {
                if (!left.equalsIgnoreCase(right)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    static List<String> resolveConditions(CommandSender sender, String[] args, List<String> commands) {
        if (commands.isEmpty()) {
            return commands;
        }
        for (int i = 0; i < commands.size(); ++i) {
            String line = commands.get(i);
            if (line.startsWith(Config.ah("condition"))) {
                int start = i;
                boolean allTrue = true;
                while (i < commands.size() && commands.get(i).startsWith(Config.ah("condition"))) {
                    String condLine = commands.get(i).substring(Config.ah("condition").length());
                    boolean result = Evaluation.evalCondition(condLine, sender, args);
                    commands.remove(i);
                    if (result) continue;
                    allTrue = false;
                }
                if (!allTrue && i < commands.size()) {
                    commands.remove(i);
                }
                i = start - 1;
                continue;
            }
            if (!line.startsWith("\\" + Config.ah("condition"))) continue;
            commands.set(i, line.substring(1));
        }
        return commands;
    }

    static String str(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    private static boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        return str.matches("[+-]?\\d+(\\.\\d+)?");
    }
}

