/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.files;

import com.ontey.Main;
import com.ontey.files.Commands;
import com.ontey.holder.Paths;
import com.ontey.log.Log;
import com.ontey.tab.Tab;
import java.io.File;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;

public class Config {
    public static File file;
    public static YamlConfiguration config;
    public static String PREFIX;
    public static String DEFAULT_NAMESPACE;
    public static String PLACEHOLDER_FORMAT;
    public static String ACTIONHOLDER_FORMAT;
    public static List<String> BOOLEAN_TRUE;
    public static String DEFAULT_PERMISSION;
    public static String DEFAULT_USAGE;
    public static String DEFAULT_DESCRIPTION;
    public static boolean HOTSWAP;
    public static boolean REMOVE_NAMESPACED_PLUGIN_COMMANDS;
    public static boolean REMOVE_NAMESPACED_COMMANDS;
    public static boolean REMOVE_COLORS_IN_CONSOLE;
    private static String NO_TAB_PATH;

    private Config() {
    }

    public static void load() {
        Main main = Main.instance;
        file = new File(main.getDataFolder(), "config.yml");
        if (!file.exists()) {
            main.saveResource("config.yml", false);
        }
        config = new YamlConfiguration();
        config.options().parseComments(true);
        try {
            config.load(file);
        }
        catch (Exception e) {
            Log.error("+-+-+-+-+-+-+-+-+-+-+-+-CCMD-+-+-+-+-+-+-+-+-+-+-+-+-+", "  Couldn't load the config file.", "  Look at the stack-trace below, so you can identify the error.", "  There is probably a syntax error in the yml.", "  Fix the error, then restart the server and it will work again.", "+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+");
            e.printStackTrace();
            Main.disablePlugin();
            return;
        }
        Config.loadConstants();
        Paths.load();
    }

    public static void save() {
        try {
            config.save(file);
        }
        catch (Exception e) {
            Log.error("+-+-+-+-+-+-+-+-+-+-+-+-CCMD-+-+-+-+-+-+-+-+-+-+-+-+-+", "  Couldn't save the config file.", "  If the file doesn't exist anymore, restart the server", "+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+");
            e.printStackTrace();
        }
    }

    public static void set(String path, Object value) {
        config.set(path, value);
        Config.save();
    }

    public static Object get(String path) {
        return config.get(path);
    }

    public static String getString(String path) {
        if (!Config.isString(path)) {
            return null;
        }
        return config.getString(path);
    }

    public static List<?> getList(String path) {
        if (!Config.isList(path)) {
            return null;
        }
        return config.getList(path);
    }

    public static List<String> getStringList(String path) {
        if (!Config.isList(path)) {
            return null;
        }
        return config.getStringList(path);
    }

    public Boolean getBoolean(String path) {
        if (!Config.isBoolean(path)) {
            return null;
        }
        return config.getBoolean(path);
    }

    public static boolean isList(String path) {
        return config.isList(path);
    }

    public static boolean isString(String path) {
        return config.isString(path);
    }

    public static boolean isBoolean(String path) {
        return config.isBoolean(path);
    }

    public static <T> T getOrDefault(String path, T fallback) {
        if (Config.get(path) == null) {
            return fallback;
        }
        try {
            return (T)config.getObject(path, fallback.getClass());
        }
        catch (ClassCastException e) {
            return fallback;
        }
    }

    public static String ph(String str) {
        if (!Config.isString("placeholder-names." + str)) {
            return PLACEHOLDER_FORMAT.replace("%ph", str);
        }
        return PLACEHOLDER_FORMAT.replace("%ph", Config.getString("placeholder-names." + str));
    }

    public static String ah(String str) {
        return ACTIONHOLDER_FORMAT.replace("%ah", str);
    }

    public static boolean isTrue(String str) {
        return BOOLEAN_TRUE.contains(str);
    }

    public static String defaultPerm(String command) {
        return DEFAULT_PERMISSION.replace("%cmd", command);
    }

    public static NoTab getNoTab(String str) {
        if (str == null) {
            return null;
        }
        return switch (str.toLowerCase()) {
            case "none" -> NoTab.NONE;
            case "players" -> NoTab.PLAYERS;
            default -> null;
        };
    }

    public static List<String> noTab() {
        NoTab noTabMode;
        NoTab noTab = noTabMode = Config.getNoTab(config.getString(NO_TAB_PATH));
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"NONE", "PLAYERS"}, (NoTab)noTab, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> List.of();
            case 1 -> Tab.onlinePlayers();
            case -1 -> Commands.getField(config, NO_TAB_PATH);
        };
    }

    public static void loadConstants() {
        PREFIX = Config.getOrDefault("format.prefix", "[CCMD]");
        PLACEHOLDER_FORMAT = Config.getOrDefault("format.placeholder-format", "<%ph>");
        ACTIONHOLDER_FORMAT = Config.getOrDefault("format.actionholder-format", "<!%ah>");
        BOOLEAN_TRUE = Config.getOrDefault("boolean-true", new ArrayList<String>(List.of("true", "yes")));
        HOTSWAP = Config.getOrDefault("dev.hotswap", false);
        DEFAULT_PERMISSION = Config.getOrDefault("defaults.permission", "ccmd.command.%cmd");
        DEFAULT_USAGE = Config.getOrDefault("defaults.usage", "/<command>");
        DEFAULT_DESCRIPTION = Config.getOrDefault("defaults.description", "Server Command");
        DEFAULT_NAMESPACE = Config.getOrDefault("defaults.namespace", "customcommand");
        REMOVE_NAMESPACED_PLUGIN_COMMANDS = Config.getOrDefault("tab.remove-namespaced-plugin-commands", false);
        REMOVE_NAMESPACED_COMMANDS = Config.getOrDefault("tab.remove-namespaced-commands", false);
        REMOVE_COLORS_IN_CONSOLE = Config.getOrDefault("remove-colors-in-console", false);
        NO_TAB_PATH = "defaults.no-tab";
    }

    public static enum NoTab {
        NONE,
        PLAYERS;

    }
}

