/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.holder;

import com.ontey.Main;
import com.ontey.holder.Placeholder;
import com.ontey.holder.Placeholders;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.block.CommandBlock;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

class PlaceholderStorage {
    PlaceholderStorage() {
    }

    static List<Placeholder> getPlayerPlaceholders(Player p) {
        ArrayList<Placeholder> out = new ArrayList<Placeholder>();
        out.add(Placeholders.ph("player.isOp", p.isOp()));
        out.add(Placeholders.ph("player.isSleeping", p.isSleeping()));
        out.add(Placeholders.ph("player.hasEmptyInventory", p.getInventory().isEmpty()));
        out.add(Placeholders.ph("player.xp-levels", p.getLevel()));
        out.add(Placeholders.ph("player.xp-cooldown", p.getExpCooldown()));
        out.add(Placeholders.ph("player.xp-to-level", p.getExpToLevel()));
        out.add(Placeholders.ph("player.xp-total", p.getTotalExperience()));
        out.add(Placeholders.ph("player.xp", Float.valueOf(p.getExp())));
        out.add(Placeholders.ph("player.health", p.getHealth()));
        out.add(Placeholders.ph("player.max-health", Placeholders.safe(() -> p.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue())));
        out.add(Placeholders.ph("player.uuid", p.getUniqueId().toString()));
        out.add(Placeholders.ph("player.saturation", Float.valueOf(p.getSaturation())));
        out.add(Placeholders.ph("player.exhaustion", Float.valueOf(p.getExhaustion())));
        out.add(Placeholders.ph("player.world", p.getWorld().getName()));
        out.add(Placeholders.ph("player.biome", p.getWorld().getBiome(p.getLocation()).toString()));
        out.add(Placeholders.ph("player.flySpeed", Float.valueOf(p.getFlySpeed())));
        out.add(Placeholders.ph("player.flyingSpeed", Float.valueOf(p.getFlySpeed())));
        out.add(Placeholders.ph("player.walkSpeed", Float.valueOf(p.getWalkSpeed())));
        out.add(Placeholders.ph("player.walkingSpeed", Float.valueOf(p.getWalkSpeed())));
        out.add(Placeholders.ph("player.world-uuid", p.getWorld().getUID().toString()));
        out.add(Placeholders.ph("player.x-precise", p.getLocation().getX()));
        out.add(Placeholders.ph("player.y-precise", p.getLocation().getY()));
        out.add(Placeholders.ph("player.z-precise", p.getLocation().getZ()));
        out.add(Placeholders.ph("player.x", (int)p.getLocation().getX()));
        out.add(Placeholders.ph("player.y", (int)p.getLocation().getY()));
        out.add(Placeholders.ph("player.z", (int)p.getLocation().getZ()));
        Block target = p.getTargetBlockExact(100);
        if (target != null) {
            out.add(Placeholders.ph("player.target-x", target.getX()));
            out.add(Placeholders.ph("player.target-y", target.getY()));
            out.add(Placeholders.ph("player.target-z", target.getZ()));
            out.add(Placeholders.ph("player.target-name", target.getType().name()));
        } else {
            out.add(Placeholders.ph("player.target-x", "none"));
            out.add(Placeholders.ph("player.target-y", "none"));
            out.add(Placeholders.ph("player.target-z", "none"));
            out.add(Placeholders.ph("player.target-name", "AIR"));
        }
        out.add(Placeholders.ph("player.pitch", Float.valueOf(p.getLocation().getPitch())));
        out.add(Placeholders.ph("player.yaw", Float.valueOf(p.getLocation().getYaw())));
        out.add(Placeholders.ph("player.direction", Placeholders.getDirection(p.getLocation().getYaw())));
        out.add(Placeholders.ph("player", p.getName()));
        out.add(Placeholders.ph("sender.isPlayer", "true"));
        out.add(Placeholders.ph("sender.isConsole", "false"));
        out.add(Placeholders.ph("sender.isCommandBlock", "false"));
        PlaceholderStorage.addCommonPlaceholders(out, (CommandSender)p);
        return out;
    }

    static List<Placeholder> getConsolePlaceholders(CommandSender sender) {
        ArrayList<Placeholder> out = new ArrayList<Placeholder>();
        out.add(Placeholders.ph("player.isOp", "true"));
        out.add(Placeholders.ph("sender.isPlayer", "false"));
        out.add(Placeholders.ph("sender.isCommandBlock", sender instanceof CommandBlock));
        out.add(Placeholders.ph("sender.isConsole", sender instanceof ConsoleCommandSender));
        out.add(Placeholders.ph("player", "console"));
        PlaceholderStorage.addCommonPlaceholders(out, sender);
        return out;
    }

    static void addCommonPlaceholders(List<Placeholder> out, CommandSender sender) {
        out.add(Placeholders.ph("space", " "));
        out.add(Placeholders.ph("backslash", "\\"));
        out.add(Placeholders.ph("plugin.version", Main.version));
        out.add(Placeholders.ph("plugin.papi-active", Main.papi));
        out.add(Placeholders.ph("server-ip", sender.getServer().getIp()));
        out.add(Placeholders.ph("server", sender.getServer().getName()));
        out.add(Placeholders.ph("players-online-count", Bukkit.getOnlinePlayers().size()));
        out.add(Placeholders.ph("players-online", Placeholders.onlinePlayers(", ")));
    }
}

