/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.listeners;

import com.ontey.files.Config;
import com.ontey.files.TabRemoval;
import java.util.Collection;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandSendEvent;

public class TabRemovalListener
implements Listener {
    private Collection<String> commands;

    @EventHandler
    public void onTabComplete(PlayerCommandSendEvent event) {
        this.commands = event.getCommands();
        this.handleNamespacedRemoval();
        this.handleTabRemoval();
    }

    private void handleNamespacedRemoval() {
        if (Config.REMOVE_NAMESPACED_PLUGIN_COMMANDS) {
            this.removeNamespacedPluginCommands();
        }
        if (Config.REMOVE_NAMESPACED_COMMANDS) {
            this.removeNamespacedCommands();
        }
    }

    private void handleTabRemoval() {
        if (TabRemoval.getType() == TabRemoval.TabRemovalType.BLACKLIST) {
            this.setTabRemovalWhitelist();
        }
        if (TabRemoval.getType() == TabRemoval.TabRemovalType.WHITELIST) {
            this.removeTabRemovalBlacklist();
        }
    }

    private void removeNamespacedPluginCommands() {
        this.commands.removeIf(cmd -> cmd.startsWith(Config.DEFAULT_NAMESPACE + ":"));
    }

    private void removeNamespacedCommands() {
        this.commands.removeIf(cmd -> cmd.contains(":"));
    }

    private void removeTabRemovalBlacklist() {
        this.commands.clear();
        this.commands.addAll(TabRemoval.getTab());
    }

    private void setTabRemovalWhitelist() {
        this.commands.removeAll(TabRemoval.getTab());
    }
}

