/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.types;

import com.ontey.files.Commands;
import com.ontey.holder.Paths;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class Args {
    public final YamlConfiguration config;
    public final String path;

    public Args(YamlConfiguration config, String command) {
        this.config = config;
        this.path = Paths.args(command);
    }

    public int getLength() {
        int length = 0;
        while (this.config.isList(this.path + "." + (length + 1)) || this.config.isString(this.path + "." + (length + 1))) {
            ++length;
        }
        return length;
    }

    public boolean checkArgs(CommandSender sender, String[] args) {
        if (this.config.isList(this.path) && this.config.getList(this.path).isEmpty()) {
            return true;
        }
        if (this.getLength() != args.length) {
            sender.sendMessage("\u00a7cInvalid amount of arguments: " + args.length + ". Should be " + this.getLength());
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (this.checkArg(sender, args[i], i)) continue;
            return false;
        }
        return true;
    }

    private boolean checkArg(CommandSender sender, String arg, int i) {
        TypedArgsType type = TypedArgsType.getType(this.config.getString(this.path + "." + (i + 1)));
        if (type == null) {
            List<String> args = Commands.getList(this.config, this.path + "." + (i + 1));
            return this.checkListedArg(sender, args, arg, i);
        }
        return this.checkTypedArg(sender, type, arg, i);
    }

    private boolean checkTypedArg(CommandSender sender, @Nullable TypedArgsType type, String arg, int i) {
        if (type == null) {
            return false;
        }
        if (type.matches(arg)) {
            return true;
        }
        sender.sendMessage("\u00a7cArgument " + (i + 1) + " should be of type \u00a7e" + String.valueOf((Object)type) + "\u00a7c, but is not");
        return false;
    }

    private boolean checkListedArg(CommandSender sender, List<String> args, String arg, int i) {
        if (args.isEmpty() || args.contains(arg)) {
            return true;
        }
        sender.sendMessage("\u00a7cArgument " + (i + 1) + " is not allowed");
        sender.sendMessage("\u00a7eAllowed args:");
        sender.sendMessage("-\u00a7e " + String.join((CharSequence)"\u00a7r\n-\u00a7e ", args));
        return false;
    }

    private String str(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static enum TypedArgsType {
        STR,
        CHAR,
        NUM,
        INT_NUM,
        INT,
        DECIMAL,
        DOUBLE;


        public static TypedArgsType getType(@Nullable String str) {
            if (str == null) {
                return null;
            }
            return switch (str.toLowerCase()) {
                case "str", "string" -> STR;
                case "char", "character" -> CHAR;
                case "num", "number" -> NUM;
                case "int-num", "integer-number" -> INT_NUM;
                case "int", "integer" -> INT;
                case "decimal" -> DECIMAL;
                case "double" -> DOUBLE;
                default -> null;
            };
        }

        public boolean matches(String str) {
            if (str == null) {
                return false;
            }
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> {
                    if (str.length() == 1) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> str.matches("[+-]?\\d+(\\.\\d+)?");
                case 3 -> str.matches("[+-]?\\d+");
                case 4 -> this.test(() -> Integer.parseInt(str));
                case 5 -> str.matches("[+-]?\\d+\\.\\d+");
                case 6 -> this.test(() -> Double.parseDouble(str));
            };
        }

        private boolean test(Runnable run) {
            try {
                run.run();
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

