/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.execution;

import com.ontey.execution.ConditionParser;
import com.ontey.execution.Execution;
import com.ontey.files.Config;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;

public class MacroStringParser {
    public Execution exe;

    public String replaceMacroStrings(String str) {
        Pattern pattern = Pattern.compile("(?<!\\\\)\\$\\((.*?)(?<!\\\\)\\)");
        Matcher matcher = pattern.matcher(str);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            String rep = this.evalMacroStrings(matcher.group(1));
            rep = rep == null ? "" : rep;
            rep = rep.replace("\\)", ")");
            matcher.appendReplacement(sb, Matcher.quoteReplacement(rep));
        }
        matcher.appendTail(sb);
        return MacroStringParser.removeEscapedMacroStrings(sb.toString());
    }

    private static String removeEscapedMacroStrings(String str) {
        return str.replaceAll("\\\\(\\$\\((.*?)\\))", "$1");
    }

    private String evalMacroStrings(String str) {
        if (str.replace(" ", "").matches("[+-]?\\d+(\\.\\d+)?[*/%+^-][+-]?\\d+(\\.\\d+)?")) {
            return this.evalCalculation(str.replace(" ", ""));
        }
        if (str.matches("(.*?)\\?(.*?):(.*?)")) {
            return this.evalTernary(str);
        }
        return "" + ConditionParser.evalCondition(str, this.exe);
    }

    private String evalTernary(String str) {
        int idx = str.indexOf(63);
        String condition = str.substring(0, idx);
        String _true = str.substring(idx + 1, str.indexOf(58, idx));
        String _false = str.substring(str.indexOf(58, idx) + 1);
        boolean result = ConditionParser.evalCondition(condition, this.exe);
        return result ? this.tnSpace(_true.trim()) : this.tnSpace(_false.trim());
    }

    private String evalCalculation(String str) {
        int idx = this.indexOfOp(str, "*/%+^-");
        if (idx == -1) {
            return str;
        }
        double left = Double.parseDouble(str.substring(0, idx));
        double right = Double.parseDouble(str.substring(idx + 1));
        char op = str.charAt(idx);
        return this.trimDecimal(this.calculate(left, right, op));
    }

    private String tnSpace(String str) {
        return str.replace(Config.ph("tn.space"), " ");
    }

    private double calculate(double left, double right, char op) {
        return switch (op) {
            case '+' -> left + right;
            case '*' -> left * right;
            case '-' -> left - right;
            case '/' -> left / right;
            case '%' -> left % right;
            case '^' -> Math.pow(left, right);
            default -> throw new IllegalStateException("A number might be too high: " + left + op + right);
        };
    }

    private int indexOfOp(String str, String chars) {
        for (int i = 1; i < str.length(); ++i) {
            char c = str.charAt(i);
            for (char aChar : chars.toCharArray()) {
                if (aChar != c) continue;
                return i;
            }
        }
        return -1;
    }

    private String trimDecimal(double d) {
        String str = String.valueOf(d);
        if (str.endsWith(".0")) {
            return str.substring(0, str.length() - 2);
        }
        return str;
    }

    @Generated
    public MacroStringParser(Execution exe) {
        this.exe = exe;
    }
}

