/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.holder;

import com.ontey.execution.Formattation;
import com.ontey.files.Config;
import com.ontey.files.Files;
import net.kyori.adventure.text.Component;
import org.bukkit.configuration.ConfigurationSection;

public class LanguageStorage {
    public ConfigurationSection section;
    public String COMMAND_CONDITION_ERROR;
    private String TYPED_ARG_ERROR;
    private String LISTED_ARG_ERROR;
    private String ARGS_LENGTH_ERROR;
    private String LISTED_ARG_SUGGESTION_LINE;

    public LanguageStorage(ConfigurationSection section) {
        this.section = section;
    }

    public Component getTypedArgError(int arg, String type) {
        return Formattation.replaceMM(this.TYPED_ARG_ERROR.replace("%arg", "" + arg).replace("%type", type));
    }

    public Component getListedArgError(int arg) {
        return Formattation.replaceMM(this.LISTED_ARG_ERROR.replace("%arg", "" + arg));
    }

    public Component getArgsLengthError(int length, int required) {
        return Formattation.replaceMM(this.ARGS_LENGTH_ERROR.replace("%length", "" + length).replace("%required", "" + required));
    }

    public Component getListedArgSuggestionLine(String suggestion) {
        return Formattation.replaceMM(this.LISTED_ARG_SUGGESTION_LINE.replace("%suggestion", suggestion));
    }

    public void load() {
        this.COMMAND_CONDITION_ERROR = this.joined("command-condition-error", "&cCondition is not fulfilled, not running command");
        this.TYPED_ARG_ERROR = this.joined("typed-arg-error", "&cArgument %arg should be of type &e%type&c but is not!");
        this.LISTED_ARG_ERROR = this.joined("listed-arg-error", "Arg %arg is invalid. Valid args:");
        this.ARGS_LENGTH_ERROR = this.joined("args-length-error", "&cInvalid amount of arguments: &e%length&c. Should be &e%required");
        this.LISTED_ARG_SUGGESTION_LINE = this.joined("listed-args-suggestion-line", "- &e%suggestion");
    }

    private String joined(String path, String fallback) {
        return String.join((CharSequence)"\n", Files.getField(this.section, path, Config.singletonList(fallback)));
    }
}

