/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.tab;

import com.ontey.CustomCommand;
import com.ontey.execution.Formattation;
import com.ontey.files.Config;
import com.ontey.files.Files;
import com.ontey.holder.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class Tab {
    private final CustomCommand cmd;
    private final YamlConfiguration config;
    private final String path;

    public Tab(CustomCommand cmd) {
        this.cmd = cmd;
        this.config = cmd.config;
        this.path = Paths.tab(cmd.name);
    }

    private Map<Integer, List<String>> rawTabCompleter() {
        HashMap<Integer, List<String>> out = new HashMap<Integer, List<String>>();
        ConfigurationSection section = this.config.getConfigurationSection(this.path);
        if (section == null) {
            return out;
        }
        Set keys = section.getKeys(false);
        keys.removeIf(key -> !key.matches("\\d+"));
        AtomicInteger i = new AtomicInteger();
        keys.forEach(key -> out.put(Integer.parseInt(key), this.evalEscapes((String)key, section, i.getAndIncrement())));
        return out;
    }

    public List<String> getTabCompleter(String[] args) {
        if (this.config.getString(this.path, "").equals("args")) {
            return this.dynamic(args.length <= this.cmd.args.getRaw().size() ? this.cmd.args.getRaw().get(args.length - 1) : this.cmd.getNoTab(), args);
        }
        Map<Integer, List<String>> rawTab = this.rawTabCompleter();
        if (!rawTab.containsKey(args.length)) {
            return this.cmd.getNoTab();
        }
        return this.dynamic(rawTab.get(args.length), args);
    }

    public List<String> dynamic(List<String> available, String[] args) {
        ArrayList<String> list = new ArrayList<String>(available);
        list.removeIf(str -> !str.startsWith(Config.ph("static")) && !str.toLowerCase().startsWith(args[args.length - 1].toLowerCase()));
        Formattation.modify(list, this::evalStatic);
        return list;
    }

    private List<String> evalEscapes(String key, ConfigurationSection section, int i) {
        String str = section.getString(key, "");
        if (str.equals("players")) {
            return Tab.onlinePlayers();
        }
        if (str.equals("args")) {
            return this.cmd.args.getRaw().get(i);
        }
        return Files.getField(section, key);
    }

    private String evalStatic(String str) {
        return str.startsWith(Config.ph("static")) ? str.substring(Config.ph("static").length()) : (str.startsWith("\\" + Config.ph("static")) ? str.substring(1) : str);
    }

    private static String str(Object obj) {
        return obj.toString();
    }

    public static List<String> onlinePlayers() {
        ArrayList<String> out = new ArrayList<String>();
        for (Player player : Bukkit.getOnlinePlayers()) {
            out.add(player.getName());
        }
        return out;
    }
}

