/*
 * Decompiled with CFR 0.152.
 */
package com.ontey.types;

import com.ontey.CustomCommand;
import com.ontey.files.Config;
import com.ontey.files.Files;
import com.ontey.holder.Paths;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.Nullable;

public class Args {
    public final YamlConfiguration config;
    public final String path;

    public Args(CustomCommand cmd) {
        this.config = cmd.config;
        this.path = Paths.args(cmd.name);
    }

    public int getLength() {
        int length = 0;
        while (this.config.isList(this.path + "." + (length + 1)) || this.config.isString(this.path + "." + (length + 1))) {
            ++length;
        }
        return length;
    }

    public List<List<String>> getRaw() {
        ArrayList<List<String>> out = new ArrayList<List<String>>(this.getLength());
        int at = 1;
        while (this.config.isList(this.path + "." + at) || this.config.isString(this.path + "." + at)) {
            out.add(Files.getField((ConfigurationSection)this.config, this.path + "." + at));
            ++at;
        }
        return out;
    }

    public boolean checkArgs(CommandSender sender, String[] args) {
        if (this.config.isList(this.path) && this.config.getList(this.path).isEmpty()) {
            return true;
        }
        if (this.getLength() != args.length) {
            sender.sendMessage(Config.LANGUAGE.getArgsLengthError(args.length, this.getLength()));
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            if (this.checkArg(sender, args[i], i)) continue;
            return false;
        }
        return true;
    }

    private boolean checkArg(CommandSender sender, String arg, int i) {
        TypedArgsType type = TypedArgsType.getType(this.config.getString(this.path + "." + (i + 1)));
        if (type == null) {
            List<String> args = Files.getList((ConfigurationSection)this.config, this.path + "." + (i + 1));
            return this.checkListedArg(sender, args, arg, i);
        }
        return this.checkTypedArg(sender, type, arg, i);
    }

    private boolean checkTypedArg(CommandSender sender, @Nullable TypedArgsType type, String arg, int i) {
        if (type == null) {
            return false;
        }
        if (type.matches(arg)) {
            return true;
        }
        sender.sendMessage(Config.LANGUAGE.getTypedArgError(i, type.toString()));
        return false;
    }

    private boolean checkListedArg(CommandSender sender, List<String> args, String arg, int i) {
        if (args.isEmpty() || args.contains(arg)) {
            return true;
        }
        sender.sendMessage(Config.LANGUAGE.getListedArgError(i + 1));
        if (Config.SEND_ARGS_SUGGESTIONS) {
            for (String str : args) {
                sender.sendMessage(Config.LANGUAGE.getListedArgSuggestionLine(str));
            }
        }
        return false;
    }

    private String str(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    public static enum TypedArgsType {
        STR,
        CHAR,
        NUM,
        INT_NUM,
        INT,
        DECIMAL,
        DOUBLE,
        BOOLEAN,
        PLAYER,
        OFFLINE_PLAYER,
        SERVER_PLAYER;


        public static TypedArgsType getType(@Nullable String str) {
            if (str == null) {
                return null;
            }
            return switch (str.toLowerCase()) {
                case "str", "string", "any" -> STR;
                case "char", "character" -> CHAR;
                case "num", "number" -> NUM;
                case "int-num", "integer-number" -> INT_NUM;
                case "int", "integer" -> INT;
                case "decimal" -> DECIMAL;
                case "double" -> DOUBLE;
                case "bool", "boolean" -> BOOLEAN;
                case "player" -> PLAYER;
                case "offline-player", "off-player" -> OFFLINE_PLAYER;
                case "server-player" -> SERVER_PLAYER;
                default -> null;
            };
        }

        public boolean matches(String str) {
            if (str == null) {
                return false;
            }
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> {
                    if (str.length() == 1) {
                        yield true;
                    }
                    yield false;
                }
                case 2 -> str.matches("[+-]?\\d+(\\.\\d+)?");
                case 3 -> str.matches("[+-]?\\d+");
                case 4 -> this.test(() -> Integer.parseInt(str));
                case 5 -> str.matches("[+-]?\\d+\\.\\d+");
                case 6 -> this.test(() -> Double.parseDouble(str));
                case 7 -> {
                    if (str.equals("true") || str.equals("false")) {
                        yield true;
                    }
                    yield false;
                }
                case 8 -> {
                    if (Bukkit.getPlayer((String)str) != null) {
                        yield true;
                    }
                    yield false;
                }
                case 9 -> this.isValidOfflinePlayer(str);
                case 10 -> this.isValidServerPlayer(str);
            };
        }

        private boolean test(Runnable run) {
            try {
                run.run();
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        }

        private boolean isValidOfflinePlayer(String str) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((String)str);
            if (player.hasPlayedBefore() || player.isOnline()) {
                return true;
            }
            try {
                HttpURLConnection conn = (HttpURLConnection)new URI("https://api.mojang.com/users/profiles/minecraft/" + str).toURL().openConnection();
                conn.setRequestMethod("GET");
                conn.setConnectTimeout(3000);
                conn.setReadTimeout(3000);
                int code = conn.getResponseCode();
                return code == 200;
            }
            catch (Exception e) {
                return false;
            }
        }

        private boolean isValidServerPlayer(String str) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((String)str);
            return player.hasPlayedBefore() || player.isOnline();
        }
    }
}

