/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.events;

import java.util.HashSet;
import java.util.Set;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.util.Utils;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2488;
import net.minecraft.class_2537;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Matrix4f;

public class BlockLightOverlay {
    private final ConfigData.MiscFeatures.BlockLightOverlay config;
    private final class_310 client;
    private class_1937 lastWorld;
    private final long TICK_INTERVAL = 3L;
    private long lastUpdateTick;
    private final Set<class_2338> blocksToRender;

    public BlockLightOverlay() {
        this.config = Data.cfg.misc.blockOverlay;
        this.client = class_310.method_1551();
        this.lastWorld = null;
        this.TICK_INTERVAL = 3L;
        this.lastUpdateTick = 0L;
        this.blocksToRender = new HashSet<class_2338>();
    }

    public void registerEvent() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(this::renderBlockOverlay);
    }

    private void renderBlockOverlay(WorldRenderContext context) {
        long currentTick;
        if (!this.config.enabled || this.client.field_1724 == null || this.client.field_1687 == null || !Utils.isOverworld()) {
            return;
        }
        class_638 currentWorld = this.client.field_1687;
        if (currentWorld != this.lastWorld) {
            this.lastWorld = currentWorld;
            this.lastUpdateTick = 0L;
            this.blocksToRender.clear();
        }
        if ((currentTick = this.client.field_1687.method_8510()) - this.lastUpdateTick >= 3L) {
            this.lastUpdateTick = currentTick;
            this.updateBlocksToRender();
        }
        if (this.blocksToRender.isEmpty()) {
            return;
        }
        class_4587 matrices = context.matrixStack();
        class_4184 camera = this.client.field_1773.method_19418();
        class_243 camPos = camera.method_19326();
        class_4588 vc = context.consumers().getBuffer(class_1921.method_23594());
        for (class_2338 pos : this.blocksToRender) {
            this.drawCrosses(matrices, vc, pos, camPos);
        }
    }

    private void updateBlocksToRender() {
        this.blocksToRender.clear();
        class_638 world = this.client.field_1687;
        class_746 player = this.client.field_1724;
        class_2338 playerPos = player.method_24515();
        int radius = this.config.radius;
        int radiusSquared = class_3532.method_34954((int)radius);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    mutable.method_10103(playerPos.method_10263() + dx, playerPos.method_10264() + dy, playerPos.method_10260() + dz);
                    if (mutable.method_10262((class_2382)playerPos) > (double)radiusSquared || !this.isValidSpawnBlock((class_1937)world, (class_2338)mutable)) continue;
                    this.blocksToRender.add(new class_2338((class_2382)mutable));
                }
            }
        }
    }

    private boolean isValidSpawnBlock(class_1937 world, class_2338 pos) {
        class_2680 base = world.method_8320(pos);
        class_2338 above1 = pos.method_10084();
        class_2338 above2 = above1.method_10084();
        class_2680 state1 = world.method_8320(above1);
        class_2680 state2 = world.method_8320(above2);
        class_2248 block1 = state1.method_26204();
        int light = world.method_8314(class_1944.field_9282, above1);
        boolean excludedBlocks = block1 instanceof class_2269 || block1 instanceof class_2401 || block1 instanceof class_2537;
        boolean solidGround = base.method_26206((class_1922)world, pos, class_2350.field_11036) && base.method_26225();
        boolean thinSnow = block1 instanceof class_2488 && (Integer)state1.method_11654((class_2769)class_2741.field_12536) == 1;
        boolean noCollision1 = !excludedBlocks && (state1.method_26215() || state1.method_26220((class_1922)world, above1).method_1110() || state1.method_45474() || thinSnow);
        boolean noCollision2 = state2.method_26215() || state2.method_26220((class_1922)world, above2).method_1110() || state2.method_45474();
        boolean validAbove = noCollision1 && noCollision2;
        boolean darkEnough = light == 0;
        return solidGround && validAbove && darkEnough;
    }

    private void drawCrosses(class_4587 matrices, class_4588 vc, class_2338 pos, class_243 camPos) {
        class_2680 stateAbove = this.client.field_1687.method_8320(pos.method_10084());
        double offset = 1.001f;
        if (stateAbove.method_26204() instanceof class_2488 && (Integer)stateAbove.method_11654((class_2769)class_2741.field_12536) == 1) {
            offset = 1.125;
        }
        double x = (double)pos.method_10263() - camPos.field_1352;
        double y = (double)pos.method_10264() - camPos.field_1351 + offset;
        double z = (double)pos.method_10260() - camPos.field_1350;
        matrices.method_22903();
        matrices.method_22904(x, y, z);
        Matrix4f mat = matrices.method_23760().method_23761();
        int color = Utils.getColor(this.config.color);
        vc.method_22918(mat, 0.25f, 0.0f, 0.25f).method_39415(color).method_22914(0.0f, 1.0f, 0.0f);
        vc.method_22918(mat, 0.75f, 0.0f, 0.75f).method_39415(color).method_22914(0.0f, 1.0f, 0.0f);
        vc.method_22918(mat, 0.75f, 0.0f, 0.25f).method_39415(color).method_22914(0.0f, 1.0f, 0.0f);
        vc.method_22918(mat, 0.25f, 0.0f, 0.75f).method_39415(color).method_22914(0.0f, 1.0f, 0.0f);
        matrices.method_22909();
    }
}

