/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.hud;

import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5684;

public class HudTooltipComponent
implements class_5684 {
    private final List<class_2561> lines;
    private final boolean showIcon;
    private final class_327 font;
    private final BiConsumer<class_332, int[]> renderIcon;
    private final int iconSize = 16;
    private final int spacing = 2;
    private final int iconTextGap = 3;
    private final int lineHeight;

    public HudTooltipComponent(List<String> rawLines, boolean showIcon, class_327 font, BiConsumer<class_332, int[]> renderIcon) {
        this.lines = rawLines.stream().map(class_2561::method_43470).collect(Collectors.toList());
        this.showIcon = showIcon;
        this.font = font;
        this.renderIcon = renderIcon;
        Objects.requireNonNull(font);
        this.lineHeight = 9 - 1;
    }

    public int method_32664(class_327 textRenderer) {
        int textWidth = this.lines.stream().mapToInt(arg_0 -> ((class_327)this.font).method_27525(arg_0)).max().orElse(0);
        return this.lines.isEmpty() ? (this.showIcon ? 16 : 0) : (this.showIcon ? 19 + textWidth : textWidth + 1);
    }

    public int method_32661(class_327 textRenderer) {
        int textHeight;
        int n = textHeight = this.lines.isEmpty() ? 0 : this.lines.size() * this.lineHeight + (this.lines.size() - 1) * 2 + 3;
        if (!this.showIcon && this.lines.size() == 1) {
            return this.lineHeight + 4;
        }
        return Math.max(this.showIcon ? 16 : 0, textHeight);
    }

    public void method_32666(class_327 textRenderer, int x, int y, int width, int height, class_332 context) {
        int textX;
        int iconX = x;
        int n = textX = this.showIcon ? x + 16 + 3 : x;
        if (this.showIcon && this.renderIcon != null) {
            int iconY = y + (height - 16) / 2;
            this.renderIcon.accept(context, new int[]{iconX, iconY});
        }
        if (!this.lines.isEmpty()) {
            int textY = !this.showIcon && this.lines.size() == 1 ? y + 1 : (this.lines.size() == 1 ? y + 3 : y + 1);
            for (class_2561 line : this.lines) {
                context.method_27535(this.font, line, textX, textY, -1);
                textY += this.lineHeight + 2;
            }
        }
    }
}

