/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.hud;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.events.KeyBindings;
import lordrius.essentialgui.gui.hud.HudTooltipComponent;
import lordrius.essentialgui.mixin.AccessorClientPlayerInteractionManager;
import lordrius.essentialgui.util.Draw;
import lordrius.essentialgui.util.NbtUtils;
import lordrius.essentialgui.util.TextUtils;
import lordrius.essentialgui.util.Utils;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_10319;
import net.minecraft.class_10321;
import net.minecraft.class_10444;
import net.minecraft.class_10597;
import net.minecraft.class_10735;
import net.minecraft.class_10736;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_11540;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2190;
import net.minecraft.class_2195;
import net.minecraft.class_2202;
import net.minecraft.class_2211;
import net.minecraft.class_2217;
import net.minecraft.class_2221;
import net.minecraft.class_2222;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2260;
import net.minecraft.class_2266;
import net.minecraft.class_2272;
import net.minecraft.class_2275;
import net.minecraft.class_2279;
import net.minecraft.class_2281;
import net.minecraft.class_2282;
import net.minecraft.class_2286;
import net.minecraft.class_2297;
import net.minecraft.class_2298;
import net.minecraft.class_2299;
import net.minecraft.class_2302;
import net.minecraft.class_2320;
import net.minecraft.class_2331;
import net.minecraft.class_2333;
import net.minecraft.class_2334;
import net.minecraft.class_2336;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2360;
import net.minecraft.class_2362;
import net.minecraft.class_2372;
import net.minecraft.class_2377;
import net.minecraft.class_2381;
import net.minecraft.class_2386;
import net.minecraft.class_239;
import net.minecraft.class_2391;
import net.minecraft.class_2393;
import net.minecraft.class_2397;
import net.minecraft.class_2401;
import net.minecraft.class_2418;
import net.minecraft.class_2421;
import net.minecraft.class_2423;
import net.minecraft.class_2431;
import net.minecraft.class_2436;
import net.minecraft.class_2449;
import net.minecraft.class_2457;
import net.minecraft.class_2459;
import net.minecraft.class_2462;
import net.minecraft.class_2473;
import net.minecraft.class_2476;
import net.minecraft.class_2478;
import net.minecraft.class_2488;
import net.minecraft.class_2493;
import net.minecraft.class_2496;
import net.minecraft.class_2500;
import net.minecraft.class_2513;
import net.minecraft.class_2523;
import net.minecraft.class_2525;
import net.minecraft.class_2526;
import net.minecraft.class_2538;
import net.minecraft.class_2541;
import net.minecraft.class_2542;
import net.minecraft.class_2560;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2737;
import net.minecraft.class_2741;
import net.minecraft.class_2747;
import net.minecraft.class_2756;
import net.minecraft.class_2760;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3612;
import net.minecraft.class_3715;
import net.minecraft.class_3737;
import net.minecraft.class_3830;
import net.minecraft.class_3922;
import net.minecraft.class_3962;
import net.minecraft.class_3965;
import net.minecraft.class_4481;
import net.minecraft.class_4538;
import net.minecraft.class_4739;
import net.minecraft.class_4770;
import net.minecraft.class_4772;
import net.minecraft.class_4776;
import net.minecraft.class_4777;
import net.minecraft.class_4849;
import net.minecraft.class_4864;
import net.minecraft.class_4865;
import net.minecraft.class_4950;
import net.minecraft.class_4951;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5541;
import net.minecraft.class_5542;
import net.minecraft.class_5545;
import net.minecraft.class_5555;
import net.minecraft.class_5635;
import net.minecraft.class_5689;
import net.minecraft.class_5703;
import net.minecraft.class_5777;
import net.minecraft.class_5778;
import net.minecraft.class_5801;
import net.minecraft.class_5803;
import net.minecraft.class_5806;
import net.minecraft.class_5808;
import net.minecraft.class_5809;
import net.minecraft.class_5816;
import net.minecraft.class_5955;
import net.minecraft.class_6862;
import net.minecraft.class_7125;
import net.minecraft.class_7126;
import net.minecraft.class_7130;
import net.minecraft.class_7268;
import net.minecraft.class_746;
import net.minecraft.class_7714;
import net.minecraft.class_7923;
import net.minecraft.class_8001;
import net.minecraft.class_811;
import net.minecraft.class_8168;
import net.minecraft.class_8170;
import net.minecraft.class_8172;
import net.minecraft.class_8237;
import net.minecraft.class_8238;
import net.minecraft.class_8960;
import net.minecraft.class_9366;
import org.jetbrains.annotations.Nullable;

public class PointedBlock {
    private final ConfigData.PointedBlock config;
    private final class_310 client;
    private final class_746 player;
    private final class_327 font;
    private final int width;
    private final int height;
    private class_1937 world;
    private class_2338 pos;
    private class_2680 state;
    private class_2248 block;
    public static boolean isBlockPropertiesOpen;
    private boolean noItem;
    private final boolean coloredText;
    private int icons;
    private List<DyeMapping> DYE_MAPPINGS;
    private List<class_2769<Integer>> AGE_PROPERTIES;
    private List<class_6862<class_2248>> ORE_TAGS;
    private static final Set<class_2248> SPECIAL_ORES;
    private Set<Class<? extends class_2248>> SHEARABLE_BLOCK_CLASSES;
    private Set<Class<? extends class_2248>> SILK_TOUCHABLE_BLOCK_CLASSES;
    private Set<class_2248> SILK_TOUCHABLE_BLOCKS;
    private Set<Class<? extends class_2248>> UNOBTAINABLE_BLOCK_CLASSES;
    private Set<class_2248> UNOBTAINABLE_BLOCKS;

    public PointedBlock(class_310 client, class_332 context) {
        this.config = Data.cfg.block;
        this.icons = 0;
        this.DYE_MAPPINGS = List.of(new DyeMapping(Set.of(class_2246.field_10548, class_2246.field_10273), class_1767.field_7952, class_1802.field_8446), new DyeMapping(Set.of(class_2246.field_55060, class_2246.field_55062, class_2246.field_10048, class_2246.field_10249, class_2246.field_42734, class_2246.field_42741), class_1767.field_7946, class_1802.field_8492), new DyeMapping(Set.of(class_2246.field_10378, class_2246.field_10226, class_2246.field_10162), class_1767.field_7958, class_1802.field_8669), new DyeMapping(Set.of(class_2246.field_10086, class_2246.field_9981), class_1767.field_7951, class_1802.field_8273), new DyeMapping(Set.of(class_2246.field_10182, class_2246.field_10583, class_2246.field_10354, class_2246.field_55741), class_1767.field_7947, class_1802.field_8192), new DyeMapping(Set.of(class_2246.field_10476), class_1767.field_7961, class_1802.field_8131), new DyeMapping(Set.of(class_2246.field_56564, class_2246.field_10003, class_2246.field_42750, class_2246.field_10315, class_2246.field_10061), class_1767.field_7954, class_1802.field_8330), new DyeMapping(Set.of(class_2246.field_55061, class_2246.field_55063), class_1767.field_7944, class_1802.field_8298), new DyeMapping(Set.of(class_2246.field_10573, class_2246.field_10554, class_2246.field_10156, class_2246.field_10365, class_2246.field_10074, class_2246.field_10400), class_1767.field_7967, class_1802.field_8851), new DyeMapping(Set.of(class_2246.field_43229), class_1767.field_7955, class_1802.field_8632), new DyeMapping(Set.of(class_2246.field_9995, class_2246.field_10090, class_2246.field_29028, class_2246.field_10358), class_1767.field_7966, class_1802.field_8345), new DyeMapping(Set.of(class_2246.field_10302), class_1767.field_7957, class_1802.field_8099), new DyeMapping(Set.of(class_2246.field_10029, class_2246.field_10018), class_1767.field_7942, class_1802.field_8408), new DyeMapping(Set.of(class_2246.field_10449, class_2246.field_10430, class_2246.field_10270, class_2246.field_10341, class_2246.field_10151, class_2246.field_10598), class_1767.field_7964, class_1802.field_8264), new DyeMapping(Set.of(class_2246.field_10606, class_2246.field_9998), class_1767.field_7963, class_1802.field_8226));
        this.AGE_PROPERTIES = List.of(class_2741.field_12556, class_2741.field_12497, class_2741.field_37654, class_2741.field_12482, class_2741.field_12550, class_2741.field_12498, class_2741.field_12517);
        this.ORE_TAGS = List.of(class_3481.field_29193, class_3481.field_29195, class_3481.field_28991, class_3481.field_28988, class_3481.field_23062, class_3481.field_28990, class_3481.field_28989, class_3481.field_29194);
        this.SHEARABLE_BLOCK_CLASSES = Set.of(class_2560.class, class_10735.class, class_10321.class, class_2397.class, class_2476.class, class_4772.class, class_2525.class, class_2538.class);
        this.SILK_TOUCHABLE_BLOCK_CLASSES = Set.of(class_5542.class, class_4481.class, class_10735.class, class_3922.class, class_10319.class, class_2431.class, class_2336.class, class_2372.class, class_2397.class, class_2381.class, class_2418.class, class_4849.class, class_2449.class, class_2493.class, class_2542.class, class_4777.class, class_4776.class);
        this.SILK_TOUCHABLE_BLOCKS = Set.of(class_2246.field_10460, class_2246.field_23880, class_2246.field_46283);
        this.UNOBTAINABLE_BLOCK_CLASSES = Set.of(class_4770.class, class_2272.class, class_5545.class, class_2334.class, class_2333.class, class_2360.class, class_2423.class, class_2496.class, class_8960.class);
        this.UNOBTAINABLE_BLOCKS = Set.of(class_2246.field_38420, class_2246.field_9987);
        this.client = client;
        this.player = client.field_1724;
        this.font = client.field_1772;
        this.width = client.method_22683().method_4486();
        this.height = client.method_22683().method_4502();
        this.coloredText = this.config.colored;
        isBlockPropertiesOpen = false;
        if (client.field_1765 != null && client.field_1765.method_17783() == class_239.class_240.field_1332) {
            if (client.field_1690.field_1907.method_1434()) {
                return;
            }
            this.world = client.field_1687;
            this.pos = ((class_3965)client.field_1765).method_17777();
            this.state = this.world.method_8320(this.pos);
            this.block = this.state.method_26204();
            this.noItem = this.is3DBlock() || this.isBlockWithoutItem();
            this.drawPointedBlock(context);
        }
    }

    private void drawPointedBlock(class_332 context) {
        boolean leftAlt = KeyBindings.contextualMenu.method_1434();
        if (this.config.mainHud) {
            this.drawMainHud(context);
        }
        if (this.config.properties && leftAlt) {
            this.drawProperties(context);
        }
    }

    private void drawMainHud(class_332 context) {
        int contentWidth;
        int textHeight;
        boolean isTooltip = this.config.style.equals("tooltip");
        ArrayList<String> lines = new ArrayList<String>();
        boolean name = this.config.name;
        boolean coords = this.config.coords;
        boolean light = this.config.light && this.shouldShowLight();
        boolean mature = this.config.mature && this.isCrop();
        boolean modid = this.config.modid;
        if (name) {
            lines.add(this.getBlockName());
        }
        if (coords) {
            lines.add(this.getBlockCoordinates());
        }
        if (light) {
            lines.add(this.getBlockLight());
        }
        if (mature) {
            lines.add(this.getBlockMature());
        }
        if (modid) {
            lines.add(this.getBlockModId());
        }
        class_1799 stack = this.getBlockItemStack();
        int iconSize = 15;
        int padding = 2;
        int spacing = 2;
        int iconTextGap = this.isCustomTexture(stack) ? 5 : 4;
        Objects.requireNonNull(this.font);
        int lineHeight = 9 - 1;
        int textWidth = lines.stream().mapToInt(arg_0 -> ((class_327)this.font).method_1727(arg_0)).max().orElse(0);
        int n = textHeight = lines.isEmpty() ? 0 : lines.size() * lineHeight + (lines.size() - 1) * spacing + 2;
        int n2 = lines.isEmpty() ? (this.config.render ? iconSize : 0) : (contentWidth = this.config.render ? iconSize + iconTextGap + textWidth : textWidth);
        int contentHeight = !this.config.render && lines.size() == 1 ? lineHeight + 3 : Math.max(this.config.render ? iconSize : 0, textHeight);
        int totalWidth = contentWidth + padding * 2;
        int totalHeight = contentHeight + padding * 2;
        int x = (this.width - totalWidth + 2) / 2;
        int y = 3 + Utils.getBossBarsRendered() * 20;
        if (isTooltip) {
            HudTooltipComponent hudTooltip = new HudTooltipComponent(lines, this.config.render, this.font, (dc, pos) -> {
                dc.method_51427(stack, pos[0], pos[1]);
                if (this.config.render && class_7923.field_41175.method_10221((Object)this.block).method_12836().equalsIgnoreCase("minecraft") && this.noItem) {
                    this.drawBlockTextures((class_332)dc, pos[0], pos[1]);
                }
            });
            int tooltipWidth = hudTooltip.method_32664(this.font);
            int tooltipHeight = hudTooltip.method_32661(this.font) + 4;
            int tooltipX = (this.width - tooltipWidth - 24) / 2;
            totalHeight = tooltipHeight + 1;
            context.method_51435(this.font, List.of(hudTooltip), tooltipX, y + 14, class_8001.field_41687, null);
        } else {
            boolean borders = !this.config.style.equals("essgui_bless");
            Draw.drawCustomRectangle(context, x - padding, y - padding, totalWidth, totalHeight, borders);
            if (this.config.render) {
                int iconX = x;
                int iconY = y - padding + (totalHeight - iconSize) / 2;
                context.method_51427(stack, iconX, iconY);
                if (class_7923.field_41175.method_10221((Object)this.block).method_12836().equalsIgnoreCase("minecraft") && this.noItem) {
                    this.drawBlockTextures(context, iconX, iconY);
                }
            }
            if (!lines.isEmpty()) {
                int textX;
                int n3 = textX = this.config.render ? x + iconSize + iconTextGap : x + 1;
                int textY = !this.config.render && lines.size() == 1 ? y + (totalHeight - lineHeight) / 2 - 1 : (lines.size() == 1 ? y + padding + 2 : y + padding);
                for (String line : lines) {
                    context.method_25303(this.font, line, textX, textY, -1);
                    textY += lineHeight + spacing;
                }
            }
        }
        if (this.config.breakingBar.enabled) {
            int gap = 2;
            int barWidth = this.config.breakingBar.width;
            int barHeight = this.config.breakingBar.height;
            int barX = (this.width - barWidth - 1) / 2;
            int barY = y + (totalHeight + 1) + gap;
            int value = this.getBreakingProgressValue();
            if (value > 0) {
                Draw.drawBlockBreakingProgress(context, barX, barY, barWidth, barHeight, value);
            }
        }
    }

    private class_1799 getBlockItemStack() {
        boolean isLambdaBetterGrass = this.client.method_1541().method_3349(this.state).toString().contains("LBGBakedModel");
        class_1799 stack = this.state.method_65171((class_4538)this.world, this.pos, true);
        class_2586 blockEntity = this.world.method_8321(this.pos);
        if (this.noItem || isLambdaBetterGrass) {
            return class_1799.field_8037;
        }
        if (this.isSkull() || this.block instanceof class_8168) {
            return this.getBlockEntityRender(stack, blockEntity);
        }
        return stack;
    }

    private class_1799 getBlockEntityRender(class_1799 stack, class_2586 blockEntity) {
        class_11362 view = (class_11362)NbtUtils.createWriteView();
        blockEntity.method_71400((class_11372)view);
        class_1747.method_57338((class_1799)stack, (class_2591)blockEntity.method_11017(), (class_11362)view);
        stack.method_57365(blockEntity.method_57590());
        return stack;
    }

    private void drawBlockTextures(class_332 context, int x, int y) {
        String[] path = this.getBlockIdentifierAndPath();
        class_2960 texture = class_2960.method_60654((String)(path[0] + path[1] + ".png"));
        Draw.drawTexture(context, texture, x, y, 16);
    }

    private void drawIcons(class_332 context, int x, int y) {
        this.icons = 0;
        int currentX = x;
        DrawableIcon[] drawMethods = new DrawableIcon[]{this::drawHarvestIcon, this::drawProperToolIcon, this::drawSilkTouchIcon, this::drawLightIcon, this::drawEmittedPowerIcon, this::drawEmittedLightIcon, this::drawComparatorOutputIcon, this::drawDyeIcon, this::drawWaterloggableIcon};
        for (int i = 0; i < drawMethods.length; ++i) {
            int iconsBefore = this.icons;
            drawMethods[i].draw(context, currentX, y);
            if (this.icons <= iconsBefore) continue;
            currentX += 15;
        }
    }

    private void drawLightIcon(class_332 context, int x, int y) {
        boolean crops = this.block instanceof class_2302 || this.block instanceof class_2344 || this.block instanceof class_3830 || this.block instanceof class_2513 || this.block instanceof class_2473;
        int light = this.getBlockLightValue();
        int textureY = crops ? 128 : 64;
        for (int i = 0; i < light + 1; ++i) {
            Draw.drawTextureSprite(context, Draw.ICONS, x, y, 16 * i, textureY, 16, 16);
        }
        ++this.icons;
    }

    private void drawEmittedPowerIcon(class_332 context, int x, int y) {
        if (this.isBlockEmittingPower()) {
            for (int i = 0; i < this.getBlockPowerLevel() + 1; ++i) {
                Draw.drawTextureSprite(context, Draw.ICONS, x, y, 16 * i, 80.0f, 16, 16);
            }
            ++this.icons;
        }
    }

    private void drawEmittedLightIcon(class_332 context, int x, int y) {
        if (this.state.method_26213() > 0) {
            for (int i = 0; i < this.state.method_26213(); ++i) {
                Draw.drawTextureSprite(context, Draw.ICONS, x, y, 16 * i, 96.0f, 16, 16);
            }
            ++this.icons;
        }
    }

    private void drawComparatorOutputIcon(class_332 context, int x, int y) {
        if (this.state.method_26221() && this.state.method_26176(this.world, this.pos) > 0) {
            for (int i = 0; i < this.state.method_26176(this.world, this.pos) + 1; ++i) {
                Draw.drawTextureSprite(context, Draw.ICONS, x, y, 16 * i, 112.0f, 16, 16);
            }
            ++this.icons;
        }
    }

    private void drawDyeIcon(class_332 context, int x, int y) {
        for (DyeMapping mapping : this.DYE_MAPPINGS) {
            if (!mapping.blocks().contains(this.block)) continue;
            int color = mapping.color().method_7787();
            float[] rgb = Utils.getColorComponents(color);
            float a = 0.9019608f;
            int argb = new Color(rgb[0], rgb[1], rgb[2], a).getRGB();
            Draw.drawPropertiesIcon(context, mapping.dyeItem(), x, y, argb);
            ++this.icons;
            break;
        }
    }

    private void drawWaterloggableIcon(class_332 context, int x, int y) {
        if (this.block instanceof class_3737) {
            Draw.drawTextureSprite(context, Draw.ICONS, x, y, 112.0f, 32.0f, 16, 16);
            ++this.icons;
        }
    }

    private void drawHarvestIcon(class_332 context, int x, int y) {
        int[] age = this.getBlockAge();
        boolean disallowedBlocks = this.block instanceof class_4770;
        boolean allowedBlocks = this.block instanceof class_2279 || this.block instanceof class_5803 && (Boolean)this.state.method_11654((class_2769)class_2741.field_28716) != false || this.block instanceof class_2393 || this.block instanceof class_2523;
        boolean useFullHarvestIcon = false;
        useFullHarvestIcon = this.isAgeable() && !disallowedBlocks && age != null ? age[0] >= age[1] || allowedBlocks : this.playerCanHarvestBlock();
        int u = useFullHarvestIcon ? 32 : 48;
        Draw.drawTextureSprite(context, Draw.ICONS, x, y, u, 32.0f, 16, 16);
        ++this.icons;
    }

    private void drawProperToolIcon(class_332 context, int x, int y) {
        if (this.isUnobtainable()) {
            return;
        }
        Draw.drawTextureSprite(context, Draw.ICONS, x, y, 0.0f, 48.0f, 16, 16);
        if (this.block instanceof class_5635) {
            Draw.drawTextureSprite(context, Draw.ICONS, x, y, 128.0f, 48.0f, 16, 16);
        }
        if (this.isShearable()) {
            Draw.drawTextureSprite(context, Draw.ICONS, x, y, 144.0f, 48.0f, 16, 16);
        }
        if (this.state.method_26164(class_3481.field_33713)) {
            boolean shearables = this.block instanceof class_5777 || this.block instanceof class_5806 || this.block instanceof class_2526 || this.block instanceof class_5808 || this.block instanceof class_2320 || this.block instanceof class_4777 || this.block instanceof class_4950 || this.block instanceof class_4776 || this.block instanceof class_4951 || this.block instanceof class_2541;
            Draw.drawTextureSprite(context, Draw.ICONS, x, y, shearables ? 144.0f : 96.0f, 48.0f, 16, 16);
        }
        if (this.state.method_26164(class_3481.field_33716)) {
            boolean brushable = this.block instanceof class_8170;
            Draw.drawTextureSprite(context, Draw.ICONS, x, y, brushable ? 160.0f : 112.0f, 48.0f, 16, 16);
        }
        if (this.state.method_26164(class_3481.field_33714)) {
            boolean leaves = this.block instanceof class_2397;
            Draw.drawTextureSprite(context, Draw.ICONS, x, y, leaves ? 144.0f : 80.0f, 48.0f, 16, 16);
        }
        if (this.block instanceof class_2297 || this.block instanceof class_2299) {
            Draw.drawTextureSprite(context, Draw.ICONS, x, y, 16.0f, 48.0f, 16, 16);
        }
        if (this.state.method_26164(class_3481.field_33715) || this.block instanceof class_9366) {
            boolean stone = this.state.method_26164(class_3481.field_33719);
            boolean iron = this.state.method_26164(class_3481.field_33718);
            boolean diamond = this.state.method_26164(class_3481.field_33717);
            Draw.drawTextureSprite(context, Draw.ICONS, x, y, stone ? 32.0f : (iron ? 48.0f : (diamond ? 64.0f : 16.0f)), 48.0f, 16, 16);
        }
        ++this.icons;
    }

    private void drawSilkTouchIcon(class_332 context, int x, int y) {
        if (this.isSilkTouchable()) {
            Draw.drawTextureSprite(context, Draw.ICONS, x, y, 0.0f, 32.0f, 16, 16);
            ++this.icons;
        }
    }

    private void drawProperties(class_332 context) {
        int x = this.width / 2 + 70;
        int y = this.isOre() || this.block instanceof class_8168 ? this.height / 2 - 50 : this.height / 2 - 20;
        boolean isTooltip = this.config.propertiesStyle.equals("tooltip");
        boolean borders = !this.config.propertiesStyle.equals("essgui_bless");
        List<class_2561> list = this.getProperties();
        if (isTooltip) {
            Draw.drawTooltip(context, list, x, y);
        } else {
            Draw.drawPropertiesBox(context, x + 12, y - 13, list, borders);
        }
        if (this.block instanceof class_8168) {
            class_8172 pot = (class_8172)this.world.method_8321(this.pos);
            class_1799 stack = pot.method_54079();
            if (stack.method_7960()) {
                return;
            }
            int xPos = x + TextUtils.tooltipWidth(list) - 7;
            int yPos = y - 10;
            Draw.drawItemWithSlot(context, stack, xPos, yPos);
        }
        if (this.config.icons) {
            int iconsX = x + 9;
            int iconsY = y - 33;
            this.drawIcons(context, iconsX, iconsY);
        }
    }

    private List<class_2561> getProperties() {
        List<Object> ore;
        List<class_2561> extended;
        ArrayList list = Lists.newArrayList();
        List<class_2561> name = this.getBlockNameCoordsAndId();
        list.addAll(name);
        List<class_2561> base = this.getBlockBaseProperties();
        if (!base.isEmpty()) {
            list.add(TextUtils.separator());
            list.addAll(base);
        }
        if (!(extended = this.getExtendedProperties()).isEmpty()) {
            list.add(TextUtils.separator());
            list.addAll(extended);
        }
        List<Object> list2 = ore = this.isOre() ? this.getOreDistributionProperties() : List.of();
        if (!ore.isEmpty()) {
            list.add(TextUtils.separator());
            list.addAll(ore);
        }
        return list;
    }

    private List<class_2561> getBlockNameCoordsAndId() {
        ArrayList list = Lists.newArrayList((Object[])new class_2561[]{TextUtils.write(this.getBlockName()), TextUtils.write(this.getBlockCoordinates())});
        if (this.client.field_1690.field_1827) {
            list.add(this.getBlockIdText());
        }
        list.add(TextUtils.write(this.getBlockModId()));
        return list;
    }

    private List<class_2561> getBlockBaseProperties() {
        ArrayList list = Lists.newArrayList();
        class_5250 resistance = TextUtils.write(this.block.method_9520() + "f");
        class_5250 hardness = TextUtils.write(this.block.method_36555() + "f");
        list.add(TextUtils.blockLine("blast_resistance", (class_2561)resistance));
        list.add(TextUtils.blockLine("hardness", (class_2561)hardness));
        if (this.isFlammable()) {
            int burnChance = this.getBurnChance();
            int spreadChance = this.getSpreadChance();
            String flammability = "\u00a7c%d%% \u00a78| \u00a7c%d%%".formatted(burnChance, spreadChance);
            list.add(TextUtils.blockLine("flammability", flammability));
        }
        list.addAll(this.getBlockLightProperty());
        return list;
    }

    private List<class_2561> getExtendedProperties() {
        class_8172 pot;
        List<Optional> sherds;
        Collection collection = this.state.method_28501();
        ArrayList list = Lists.newArrayList();
        if (collection.contains(class_2741.field_12516)) {
            String leavesValue = ((class_2737)this.state.method_11654((class_2769)class_2741.field_12516)).method_15434();
            class_5250 leaves = TextUtils.translate("hud.block.properties.bamboo_leaves." + leavesValue);
            list.add(TextUtils.blockLine("bamboo_leaves", (class_2561)leaves));
        }
        if (this.block instanceof class_2331) {
            int maxLevel;
            int count = 0;
            for (class_2338 offset : class_2331.field_36535) {
                if (!class_2331.method_40445((class_1937)this.world, (class_2338)this.pos, (class_2338)offset)) continue;
                ++count;
            }
            String shelvesPrefix = (count = Math.min(count, 15)) < 15 ? "\u00a7c" : "\u00a72";
            String shelves = String.format(shelvesPrefix + "%d/15", count);
            String[] ranges = new String[]{"1\u20138", "2\u20139", "4\u201311", "6\u201312", "8\u201314", "10\u201315", "12\u201317", "14\u201318", "16\u201320", "18\u201321", "20\u201323", "22\u201324", "24\u201326", "26\u201327", "28\u201329", "30"};
            String range = ranges[count];
            int n = maxLevel = count == 15 ? 30 : Integer.parseInt(range.split("\u2013")[1]);
            String levelsPrefix = maxLevel <= 15 ? "\u00a7c" : (maxLevel <= 25 ? "\u00a76" : "\u00a72");
            String enchantmentLevel = String.format("%s", levelsPrefix + range);
            list.add(TextUtils.blockLine("bookshelves", shelves));
            list.add(TextUtils.blockLine("enchantment_level", enchantmentLevel));
        }
        if (this.isSpreadable()) {
            int spreadLight = this.getSpreadableLight();
            if (this.state.method_27852(class_2246.field_10566)) {
                boolean canBeSpread = spreadLight >= 4;
                list.add(TextUtils.blockLine("can_be_spread", (class_2561)TextUtils.trueFalse(canBeSpread, false)));
                if (!canBeSpread) {
                    list.add(TextUtils.transBlockProp("can_be_spread.msg"));
                }
            }
            if (this.block instanceof class_2500) {
                boolean canSpread = spreadLight >= 9;
                list.add(TextUtils.blockLine("can_spread", (class_2561)TextUtils.trueFalse(canSpread, false)));
                if (!canSpread) {
                    list.add(TextUtils.transBlockProp("can_grow.msg.1"));
                }
            }
        }
        if (collection.contains(class_2741.field_27220)) {
            int candlesValue = (Integer)this.state.method_11654((class_2769)class_2741.field_27220);
            String candles = String.format("\u00a77%d/4", candlesValue);
            list.add(TextUtils.blockLine("candles", candles));
        }
        if (collection.contains(class_2741.field_23187)) {
            int chargesValue = (Integer)this.state.method_11654((class_2769)class_2741.field_23187);
            String prefix = chargesValue >= 2 ? "\u00a72" : "\u00a7c";
            String charges = String.format(prefix + "%d/4", chargesValue);
            list.add(TextUtils.blockLine("charges", charges));
        }
        if (collection.contains(class_2741.field_46822)) {
            boolean crafting = (Boolean)this.state.method_11654((class_2769)class_2741.field_46822);
            list.add(TextUtils.blockLine("crafting", (class_2561)TextUtils.trueFalse(crafting, false)));
        }
        if (collection.contains(class_2741.field_12494)) {
            int delayValue = (Integer)this.state.method_11654((class_2769)class_2741.field_12494);
            String delay = String.format("\u00a77%d/4", delayValue);
            list.add(TextUtils.blockLine("delay", delay));
        }
        if (collection.contains(class_2741.field_12541)) {
            int distanceValue = (Integer)this.state.method_11654((class_2769)class_2741.field_12541);
            String distance = String.format("\u00a77%d/7", distanceValue);
            list.add(TextUtils.blockLine("distance", distance));
        }
        if (collection.contains(class_2741.field_42836)) {
            int dustedValue = (Integer)this.state.method_11654((class_2769)class_2741.field_42836);
            String dusted = String.format("\u00a77%d/3", dustedValue);
            list.add(TextUtils.blockLine("dusted", dusted));
        }
        if (collection.contains(class_2741.field_12509)) {
            int eggsValue = (Integer)this.state.method_11654((class_2769)class_2741.field_12509);
            String eggs = String.format("\u00a77%d/4", eggsValue);
            list.add(TextUtils.blockLine("eggs", eggs));
        }
        if (this.block instanceof class_10736) {
            boolean canEmitParticles = this.world.method_22339(this.pos) <= 13;
            list.add(TextUtils.blockLine("emits_particles", (class_2561)TextUtils.trueFalse(canEmitParticles, false)));
            if (!canEmitParticles) {
                list.add(TextUtils.transBlockProp("emits_particles.msg"));
            }
        }
        if (collection.contains(class_2741.field_12515)) {
            boolean enabled = (Boolean)this.state.method_11654((class_2769)class_2741.field_12515);
            list.add(TextUtils.blockLine("enabled", (class_2561)TextUtils.trueFalse(enabled, false)));
        }
        if (this.state.method_26164(class_3481.field_15460)) {
            list.add(TextUtils.blockLine("enderman_holdable", (class_2561)TextUtils.trueFalse(true, true)));
        }
        if (collection.contains(class_2741.field_12545)) {
            class_5250 facing = TextUtils.translate("hud.facing." + String.valueOf(this.state.method_11654((class_2769)class_2741.field_12545)));
            list.add(TextUtils.blockLine("facing", (class_2561)facing));
        }
        if (collection.contains(class_2741.field_42835)) {
            int flowersValue = (Integer)this.state.method_11654((class_2769)class_2741.field_42835);
            String flowers = String.format("\u00a77%d/4", flowersValue);
            list.add(TextUtils.blockLine("flowers", flowers));
        }
        if (this.isAgeable()) {
            boolean canGrow;
            int[] age = this.getBlockAge();
            if (age == null) {
                List.of();
            }
            boolean hasNeutralAgeProperty = collection.contains(class_2741.field_12498) || collection.contains(class_2741.field_12517);
            boolean neutralBlocks = this.block instanceof class_2279 || hasNeutralAgeProperty;
            boolean readyToHarvest = this.isMature();
            String prefix = neutralBlocks ? "\u00a77" : (readyToHarvest ? "\u00a72" : "\u00a7c");
            String growingAge = String.format("%s%d/%d", prefix, age[0], age[1]);
            int cropsLight = this.getCropsLight();
            int bushLight = this.getOthersLight();
            boolean growsWithoutLight = this.block instanceof class_2266 || this.block instanceof class_2279 || this.block instanceof class_2421 || this.block instanceof class_2523;
            boolean isCrops = this.block instanceof class_2302;
            boolean isBerries = this.block instanceof class_3830;
            boolean isStem = this.block instanceof class_2513;
            boolean bl = canGrow = !readyToHarvest && ((isCrops || isStem) && cropsLight >= 9 || isBerries && bushLight >= 9);
            if (!growsWithoutLight) {
                list.add(TextUtils.blockLine("can_grow", (class_2561)TextUtils.trueFalse(canGrow, false)));
                if (!canGrow) {
                    String message = readyToHarvest ? "can_grow.msg.2" : "can_grow.msg.1";
                    list.add(TextUtils.transBlockProp(message));
                }
            }
            list.add(TextUtils.blockLine("growing_age", growingAge));
        }
        if (collection.contains(class_2741.field_12549)) {
            boolean isSapling = this.block instanceof class_2473;
            int stageValue = (Integer)this.state.method_11654((class_2769)class_2741.field_12549);
            String prefix = isSapling ? (stageValue < 1 ? "\u00a7c" : "\u00a72") : "\u00a77";
            String stage = String.format(prefix + "%d/1", stageValue);
            if (isSapling) {
                int saplingLight = this.getSaplingLight();
                boolean canGrow = saplingLight >= 9;
                list.add(TextUtils.blockLine("can_grow", (class_2561)TextUtils.trueFalse(canGrow, false)));
                if (saplingLight < 9) {
                    list.add(TextUtils.transBlockProp("can_grow.msg.1"));
                }
            }
            list.add(TextUtils.blockLine("growing_stage", stage));
        }
        if (this.block instanceof class_2202) {
            int shootLight = this.getOthersLight();
            boolean canGrow = shootLight >= 9;
            list.add(TextUtils.blockLine("can_grow", (class_2561)TextUtils.trueFalse(canGrow, false)));
            if (!canGrow) {
                list.add(TextUtils.transBlockProp("can_grow.msg.1"));
            }
        }
        if (collection.contains(class_2741.field_12518)) {
            String halfValue = ((class_2760)this.state.method_11654((class_2769)class_2741.field_12518)).method_15434();
            class_5250 half = TextUtils.transBlockProp("half." + halfValue);
            list.add(TextUtils.blockLine("half", (class_2561)half));
        }
        if (collection.contains(class_2741.field_17393)) {
            boolean hasBook = (Boolean)this.state.method_11654((class_2769)class_2741.field_17393);
            list.add(TextUtils.blockLine("has_book", (class_2561)TextUtils.trueFalse(hasBook, false)));
        }
        if (collection.contains(class_2741.field_12554)) {
            class_5250 bottle0 = TextUtils.trueFalse((Boolean)this.state.method_11654((class_2769)class_2741.field_12554), false);
            class_5250 bottle1 = TextUtils.trueFalse((Boolean)this.state.method_11654((class_2769)class_2741.field_12500), false);
            class_5250 bottle2 = TextUtils.trueFalse((Boolean)this.state.method_11654((class_2769)class_2741.field_12531), false);
            list.addAll(List.of(TextUtils.blockLine("has_bottle_0", (class_2561)bottle0), TextUtils.blockLine("has_bottle_1", (class_2561)bottle1), TextUtils.blockLine("has_bottle_2", (class_2561)bottle2)));
        }
        if (collection.contains(class_2741.field_41317)) {
            class_5250 book0 = TextUtils.trueFalse((Boolean)this.state.method_11654((class_2769)class_2741.field_41317), false);
            class_5250 book1 = TextUtils.trueFalse((Boolean)this.state.method_11654((class_2769)class_2741.field_41318), false);
            class_5250 book2 = TextUtils.trueFalse((Boolean)this.state.method_11654((class_2769)class_2741.field_41319), false);
            class_5250 book3 = TextUtils.trueFalse((Boolean)this.state.method_11654((class_2769)class_2741.field_41320), false);
            class_5250 book4 = TextUtils.trueFalse((Boolean)this.state.method_11654((class_2769)class_2741.field_41321), false);
            class_5250 book5 = TextUtils.trueFalse((Boolean)this.state.method_11654((class_2769)class_2741.field_41322), false);
            list.addAll(List.of(TextUtils.blockLine("has_book_0", (class_2561)book0), TextUtils.blockLine("has_book_1", (class_2561)book1), TextUtils.blockLine("has_book_2", (class_2561)book2), TextUtils.blockLine("has_book_3", (class_2561)book3), TextUtils.blockLine("has_book_4", (class_2561)book4), TextUtils.blockLine("has_book_5", (class_2561)book5)));
        }
        if (collection.contains(class_2741.field_12488)) {
            boolean hasEye = (Boolean)this.state.method_11654((class_2769)class_2741.field_12488);
            list.add(TextUtils.blockLine("has_eye", (class_2561)TextUtils.trueFalse(hasEye, false)));
        }
        if (collection.contains(class_2741.field_12544)) {
            boolean hasRecord = (Boolean)this.state.method_11654((class_2769)class_2741.field_12544);
            list.add(TextUtils.blockLine("has_record", (class_2561)TextUtils.trueFalse(hasRecord, false)));
        }
        if (this.block instanceof class_8238) {
            boolean hatchBoost = class_8238.method_49826((class_1922)this.world, (class_2338)this.pos);
            list.add(TextUtils.blockLine("hatch_booster", (class_2561)TextUtils.trueFalse(hatchBoost, false)));
        }
        if (collection.contains(class_2741.field_12530)) {
            int hatchValue = (Integer)this.state.method_11654((class_2769)class_2741.field_12530);
            String prefix = hatchValue == 2 ? "\u00a72" : "\u00a7c";
            String hatchStage = String.format(prefix + "%d/2", hatchValue);
            list.add(TextUtils.blockLine("hatch_stage", hatchStage));
        }
        if (this.state.method_26164(class_3481.field_22466)) {
            list.add(TextUtils.blockLine("hoglin_repellent", (class_2561)TextUtils.trueFalse(true, false)));
        }
        if (collection.contains(class_2741.field_20432)) {
            int honeyValue = (Integer)this.state.method_11654((class_2769)class_2741.field_20432);
            String prefix = honeyValue >= 5 ? "\u00a72" : "\u00a7c";
            String honeyLevel = String.format(prefix + "%d/5", honeyValue);
            list.add(TextUtils.blockLine("honey_level", honeyLevel));
        }
        if (collection.contains(class_2741.field_59766)) {
            int hydrationValue = (Integer)this.state.method_11654((class_2769)class_2741.field_59766);
            String prefix = hydrationValue >= 3 ? "\u00a72" : "\u00a7c";
            String hydrationLevel = String.format(prefix + "%d/3", hydrationValue);
            list.add(TextUtils.blockLine("hydration_level", hydrationLevel));
        }
        if (collection.contains(class_2741.field_12499)) {
            int note = (Integer)this.state.method_11654((class_2769)class_2741.field_12524);
            String instrumentValue = ((class_2766)this.state.method_11654((class_2769)class_2741.field_12499)).method_15434();
            class_5250 instrument = TextUtils.transBlockProp("noteblock.instrument." + instrumentValue);
            class_5250 notes = TextUtils.transBlockProp("noteblock.note." + note % 12);
            class_5250 octave = TextUtils.write(" \u00a78(\u00a76" + (note > 12 ? "2" : "1") + "\u00a78)");
            class_5250 clicks = TextUtils.write("" + note);
            list.add(TextUtils.blockLine("noteblock.instrument", (class_2561)instrument));
            list.add(TextUtils.blockLine("noteblock.note", (class_2561)notes).method_10852((class_2561)octave));
            list.add(TextUtils.blockLine("noteblock.clicks", (class_2561)clicks));
        }
        if (collection.contains(class_2741.field_12501)) {
            boolean invertedValue = (Boolean)this.state.method_11654((class_2769)class_2741.field_12501);
            list.add(TextUtils.blockLine("inverted", (class_2561)TextUtils.trueFalse(invertedValue)));
        }
        if (collection.contains(class_2741.field_12536)) {
            int layersValue = (Integer)this.state.method_11654((class_2769)class_2741.field_12536);
            String layers = String.format("\u00a77%d/8", layersValue);
            list.add(TextUtils.blockLine("layers", layers));
        }
        if (collection.contains(class_2741.field_12513)) {
            int levelValue = (Integer)this.state.method_11654((class_2769)class_2741.field_12513);
            String prefix = levelValue > 0 ? "\u00a72" : "\u00a7c";
            String level = String.format(prefix + "%d/3", levelValue);
            list.add(TextUtils.blockLine("level", level));
        }
        if (collection.contains(class_2741.field_17586)) {
            int levelValue = (Integer)this.state.method_11654((class_2769)class_2741.field_17586);
            String prefix = levelValue >= 1 ? "\u00a72" : "\u00a7c";
            String level = String.format(prefix + "%d/8", levelValue);
            list.add(TextUtils.blockLine("level", level));
        }
        if (this.state.method_26213() > 0) {
            String luminance = "\u00a72" + this.state.method_26213() + "/15";
            list.add(TextUtils.blockLine("luminance", luminance));
        }
        if (this.block instanceof class_2423) {
            int z;
            int x;
            boolean isOverworld = this.world.method_8597().comp_642();
            boolean isNether = this.world.method_8597().comp_643();
            int n = isOverworld ? this.pos.method_10263() / 8 : (x = isNether ? this.pos.method_10263() * 8 : 0);
            int n2 = isOverworld ? this.pos.method_10260() / 8 : (z = isNether ? this.pos.method_10260() * 8 : 0);
            class_5250 dimension = TextUtils.shifted((class_2561)(isOverworld ? TextUtils.translate("hud.dimension.nether") : (isNether ? TextUtils.translate("hud.dimension.overworld") : TextUtils.translate("hud.dimension.unknown"))));
            String coordinates = String.format("\u00a7c%d \u00a79%d", x, z);
            list.add(TextUtils.blockLine("link_coordinates", (class_2561)TextUtils.empty()));
            list.add(dimension.method_27693(coordinates));
        }
        if (collection.contains(class_2741.field_12548)) {
            boolean lit = (Boolean)this.state.method_11654((class_2769)class_2741.field_12548);
            list.add(TextUtils.blockLine("lit", (class_2561)TextUtils.trueFalse(lit, false)));
        }
        if (collection.contains(class_2741.field_12502)) {
            boolean locked = (Boolean)this.state.method_11654((class_2769)class_2741.field_12502);
            list.add(TextUtils.blockLine("locked", (class_2561)TextUtils.trueFalse(locked, false)));
        }
        if (collection.contains(class_2741.field_12534)) {
            String modeValue = ((class_2747)this.state.method_11654((class_2769)class_2741.field_12534)).method_15434();
            class_5250 mode = TextUtils.transBlockProp("mode." + modeValue);
            list.add(TextUtils.blockLine("mode", (class_2561)mode));
        }
        if (collection.contains(class_2741.field_12510)) {
            int moistureLevel = (Integer)this.state.method_11654((class_2769)class_2741.field_12510);
            int blockLight = this.getOthersLight();
            boolean hasCrops = this.world.method_8320(this.pos.method_10084()).method_26204() != class_2246.field_10124;
            boolean hasLight = blockLight >= 8;
            boolean canPlant = hasLight && !hasCrops;
            boolean waterNearby = this.hasWaterSource();
            String prefix = moistureLevel >= 7 ? "\u00a72" : "\u00a7c";
            String moisture = String.format(prefix + "%d/7", moistureLevel);
            list.add(TextUtils.blockLine("can_plant", (class_2561)TextUtils.trueFalse(hasLight && !hasCrops, false)));
            if (!canPlant) {
                String message = hasCrops ? "can_plant.msg.2" : "can_plant.msg.1";
                list.add(TextUtils.transBlockProp(message));
            }
            list.add(TextUtils.blockLine("has_water", (class_2561)TextUtils.trueFalse(waterNearby, false)));
            list.add(TextUtils.blockLine("moisture", moisture));
        }
        if (this.isMushroomPlantableBlock()) {
            list.add(TextUtils.blockLine("mushroom_plantable", (class_2561)TextUtils.trueFalse(true, false)));
        }
        if (collection.contains(class_2741.field_55088)) {
            boolean natural = (Boolean)this.state.method_11654((class_2769)class_2741.field_55088);
            list.add(TextUtils.blockLine("natural", (class_2561)TextUtils.trueFalse(natural, false)));
        }
        if (this.block instanceof class_4739) {
            boolean obstructed;
            if (this.block instanceof class_2336) {
                class_2338 above = this.pos.method_10084();
                obstructed = this.world.method_8320(above).method_26212((class_1922)this.world, above);
            } else {
                obstructed = class_2281.method_9756((class_1936)this.world, (class_2338)this.pos);
            }
            list.add(TextUtils.blockLine("obstructed", (class_2561)TextUtils.trueFalse(obstructed, true)));
        }
        if (collection.contains(class_2741.field_12528)) {
            boolean occupied = (Boolean)this.state.method_11654((class_2769)class_2741.field_12528);
            list.add(TextUtils.blockLine("occupied", (class_2561)TextUtils.trueFalse(occupied, true)));
        }
        if (this.state.method_26221() && this.state.method_26176(this.world, this.pos) > 0) {
            int powerValue = this.state.method_26176(this.world, this.pos);
            String power = String.format("\u00a72%d/15", powerValue);
            list.add(TextUtils.blockLine("output_power", power));
        }
        if (this.block instanceof class_5955) {
            String oxidationValue = ((class_5955.class_5811)((class_5955)this.block).method_33622()).name().toLowerCase();
            class_5250 oxidation = TextUtils.transBlockProp("oxidation." + oxidationValue);
            list.add(TextUtils.blockLine("oxidation", (class_2561)oxidation));
        }
        if (collection.contains(class_2741.field_12514)) {
            boolean persistent = (Boolean)this.state.method_11654((class_2769)class_2741.field_12514);
            list.add(TextUtils.blockLine("persistent", (class_2561)TextUtils.trueFalse(persistent, false)));
        }
        if (collection.contains(class_2741.field_12543)) {
            int picklesValue = (Integer)this.state.method_11654((class_2769)class_2741.field_12543);
            String pickles = String.format("\u00a77%d/4", picklesValue);
            list.add(TextUtils.blockLine("pickles", pickles));
        }
        if (this.state.method_26164(class_3481.field_23800)) {
            list.add(TextUtils.blockLine("piglin_guarded", (class_2561)TextUtils.trueFalse(true, true)));
        }
        if (this.state.method_26164(class_3481.field_22465)) {
            list.add(TextUtils.blockLine("piglin_repellent", (class_2561)TextUtils.trueFalse(true, false)));
        }
        if (this.isBlockEmittingPower()) {
            int powerValue = this.getBlockPowerLevel();
            String prefix = powerValue <= 0 ? "\u00a7c" : "\u00a72";
            String power = String.format(prefix + "%d/15", powerValue);
            list.add(TextUtils.blockLine("power_level", power));
        }
        if (collection.contains(class_2741.field_12484)) {
            boolean powered = (Boolean)this.state.method_11654((class_2769)class_2741.field_12484);
            list.add(TextUtils.blockLine("powered", (class_2561)TextUtils.trueFalse(powered, false)));
        }
        if (collection.contains(class_2741.field_55829)) {
            int leafsValue = (Integer)this.state.method_11654((class_2769)class_2741.field_55829);
            String leafs = String.format("\u00a77%d/4", leafsValue);
            list.add(TextUtils.blockLine("segment_amount", leafs));
        }
        if (this.block instanceof class_8168 && (sherds = List.of((pot = (class_8172)this.world.method_8321(this.pos)).method_51511().comp_1490(), pot.method_51511().comp_1488(), pot.method_51511().comp_1489(), pot.method_51511().comp_1487())).stream().anyMatch(Optional::isPresent)) {
            list.add(TextUtils.blockLine("sherds", (class_2561)TextUtils.empty()));
            for (int i = 0; i < 4; ++i) {
                Optional opt = sherds.get(i);
                String key = opt.map(item -> item.method_7876().replace("item.minecraft.", "").replace("_pottery_sherd", "")).orElse("none");
                class_5250 label = TextUtils.write(" #" + (i + 1) + ": ", class_124.field_1063).method_10852((class_2561)TextUtils.transBlockProp("sherds." + key).method_27692(class_124.field_1080));
                list.add(label);
            }
        }
        if (collection.contains(class_2741.field_17394)) {
            boolean signal = (Boolean)this.state.method_11654((class_2769)class_2741.field_17394);
            list.add(TextUtils.blockLine("signal_fire", (class_2561)TextUtils.trueFalse(signal, false)));
        }
        if (!this.isUnobtainable()) {
            list.add(TextUtils.blockLine("silk_touchable", (class_2561)TextUtils.trueFalse(this.isSilkTouchable(), true)));
        }
        if (collection.contains(class_2741.field_12485)) {
            String typeValue = ((class_2771)this.state.method_11654((class_2769)class_2741.field_12485)).method_15434();
            class_5250 slabType = TextUtils.transBlockProp("slab_type." + typeValue);
            list.add(TextUtils.blockLine("slab_type", (class_2561)slabType));
        }
        if (collection.contains(class_2741.field_12505)) {
            int slicesValue = 7 - (Integer)this.state.method_11654((class_2769)class_2741.field_12505);
            String prefix = slicesValue < 4 ? "\u00a7c" : "\u00a72";
            String slices = String.format(prefix + "%d/7", slicesValue);
            list.add(TextUtils.blockLine("slices", slices));
        }
        if (collection.contains(class_2741.field_55830)) {
            String stateValue = ((class_10597)this.state.method_11654((class_2769)class_2741.field_55830)).toString();
            class_5250 creakingState = TextUtils.transBlockProp("creaking_heart.state." + stateValue);
            list.add(TextUtils.blockLine("creaking_heart.state", (class_2561)creakingState));
        }
        if (this.block instanceof class_5801) {
            String tiltValue = ((class_5816)this.state.method_11654((class_2769)class_2741.field_28717)).method_15434();
            class_5250 tilt = TextUtils.transBlockProp("tilt." + tiltValue);
            list.add(TextUtils.blockLine("tilt", (class_2561)tilt));
        }
        if (collection.contains(class_2741.field_12522)) {
            boolean triggered = (Boolean)this.state.method_11654((class_2769)class_2741.field_12522);
            list.add(TextUtils.blockLine("triggered", (class_2561)TextUtils.trueFalse(triggered, true)));
        }
        if (collection.contains(class_2741.field_12508)) {
            boolean isWaterlogged = (Boolean)this.state.method_11654((class_2769)class_2741.field_12508);
            list.add(TextUtils.blockLine("waterlogged", (class_2561)TextUtils.trueFalse(isWaterlogged, false)));
        }
        if (this.block instanceof class_2478) {
            boolean isWaxed = ((class_2625)this.world.method_8321(this.pos)).method_49855();
            list.add(TextUtils.blockLine("waxed", (class_2561)TextUtils.trueFalse(isWaxed, true)));
        }
        return list;
    }

    private List<class_2561> getOreDistributionProperties() {
        class_5250 biome;
        class_5250 abundance;
        ArrayList list = Lists.newArrayList();
        String key = "ore.distribution.";
        boolean isCoal = this.state.method_26164(class_3481.field_29193);
        boolean isCopper = this.state.method_26164(class_3481.field_29195);
        boolean isLapis = this.state.method_26164(class_3481.field_28991);
        boolean isIron = this.state.method_26164(class_3481.field_28988);
        boolean isGold = this.state.method_26164(class_3481.field_23062) && !this.state.method_26164(ConventionalBlockTags.ORES_IN_GROUND_NETHERRACK);
        boolean isRedstone = this.state.method_26164(class_3481.field_28990);
        boolean isDiamond = this.state.method_26164(class_3481.field_28989);
        boolean isEmerald = this.state.method_26164(class_3481.field_29194);
        boolean isQuartz = this.state.method_27852(class_2246.field_10213);
        boolean isGoldNether = this.state.method_26164(class_3481.field_23062) && this.state.method_26164(ConventionalBlockTags.ORES_IN_GROUND_NETHERRACK);
        boolean isAncient = this.state.method_27852(class_2246.field_22109);
        boolean isSpecial = isCopper || isGold;
        class_5250 common = TextUtils.transBlockProp(key + "abundance.common");
        class_5250 rare = TextUtils.transBlockProp(key + "abundance.rare");
        class_5250 uncommon = TextUtils.transBlockProp(key + "abundance.uncommon");
        class_5250 veryCommon = TextUtils.transBlockProp(key + "abundance.very_common");
        class_5250 veryRare = TextUtils.transBlockProp(key + "abundance.very_rare");
        class_5250 class_52502 = isCoal || isQuartz ? veryCommon : (isCopper || isIron || isGoldNether ? common : (isRedstone || isEmerald ? uncommon : (isLapis || isGold ? rare : (abundance = isDiamond || isAncient ? veryRare : TextUtils.dash()))));
        class_5250 abundance2 = isCopper ? veryCommon : (isGold ? common : TextUtils.dash());
        class_5250 anyBiome = TextUtils.transBlockProp(key + "biome.any");
        class_5250 badlands = TextUtils.translate("biome.minecraft.badlands");
        class_5250 dripstoneCaves = TextUtils.translate("biome.minecraft.dripstone_caves");
        class_5250 mountainous = TextUtils.transBlockProp(key + "biome.mountainous");
        class_5250 nether = TextUtils.transBlockProp(key + "biome.nether");
        class_5250 class_52503 = isCoal || isCopper || isLapis || isIron || isGold || isRedstone || isDiamond ? anyBiome : (isEmerald ? mountainous : (biome = isQuartz || isGoldNether || isAncient ? nether : TextUtils.dash()));
        class_5250 biome2 = isCopper ? dripstoneCaves : (isGold ? badlands : TextUtils.dash());
        class_5250 coalLayers = TextUtils.transBlockProp(key + "range.coal");
        class_5250 copperLayers = TextUtils.transBlockProp(key + "range.copper");
        class_5250 lapisLayers = TextUtils.transBlockProp(key + "range.lapis");
        class_5250 ironLayers = TextUtils.transBlockProp(key + "range.iron");
        class_5250 goldLayers = TextUtils.transBlockProp(key + "range.gold");
        class_5250 goldLayers2 = TextUtils.transBlockProp(key + "range.gold2");
        class_5250 redstoneLayers = TextUtils.transBlockProp(key + "range.redstone");
        class_5250 diamondLayers = TextUtils.transBlockProp(key + "range.diamond");
        class_5250 emeraldLayers = TextUtils.transBlockProp(key + "range.emerald");
        class_5250 quartzLayers = TextUtils.transBlockProp(key + "range.quartz");
        class_5250 goldNetherLayers = TextUtils.transBlockProp(key + "range.gold_nether");
        class_5250 ancientDebrisLayers = TextUtils.transBlockProp(key + "range.ancient_debris");
        class_5250 range = isCoal ? coalLayers : (isCopper ? copperLayers : (isLapis ? lapisLayers : (isIron ? ironLayers : (isGold ? goldLayers : (isRedstone ? redstoneLayers : (isDiamond ? diamondLayers : (isEmerald ? emeraldLayers : (isQuartz ? quartzLayers : (isGoldNether ? goldNetherLayers : (isAncient ? ancientDebrisLayers : TextUtils.dash()))))))))));
        class_5250 diamondTier = TextUtils.transBlockProp("ore.tier.diamond");
        class_5250 ironTier = TextUtils.transBlockProp("ore.tier.iron");
        class_5250 stoneTier = TextUtils.transBlockProp("ore.tier.stone");
        class_5250 tier = this.state.method_26164(class_3481.field_33717) ? diamondTier : (this.state.method_26164(class_3481.field_33718) ? ironTier : (this.state.method_26164(class_3481.field_33719) ? stoneTier : TextUtils.transBlockProp("ore.tier.wood")));
        list.add(TextUtils.blockLine(key + "biome", (class_2561)biome).method_10852((class_2561)abundance));
        if (isSpecial) {
            list.add(TextUtils.blockLine(key + "biome2", (class_2561)biome2).method_10852((class_2561)abundance2));
        }
        list.add(TextUtils.blockLine(key + "range", (class_2561)range));
        if (isGold) {
            list.add(TextUtils.blockLine(key + "range2", (class_2561)goldLayers2));
        }
        list.add(TextUtils.blockLine("ore.tier", (class_2561)tier));
        return list;
    }

    @Nullable
    private int[] getBlockAge() {
        for (class_2769<Integer> prop : this.AGE_PROPERTIES) {
            if (!this.state.method_28498(prop)) continue;
            int age = (Integer)this.state.method_11654(prop);
            int max = prop.method_11898().stream().max(Integer::compare).orElse(0);
            return new int[]{age, max};
        }
        return null;
    }

    private boolean isAgeable() {
        for (class_2769<Integer> prop : this.AGE_PROPERTIES) {
            if (!this.state.method_28498(prop) || prop == class_2741.field_12498 && this.state.method_26204() instanceof class_4770) continue;
            return true;
        }
        return false;
    }

    private int getBreakingProgressValue() {
        return (int)(((AccessorClientPlayerInteractionManager)this.client.field_1761).getCurrentBreakingProgress() * 100.0f);
    }

    private int getBurnChance() {
        return this.isWaterlogged() ? 0 : ((FlammableBlockRegistry.Entry)FlammableBlockRegistry.getDefaultInstance().get(this.block)).getBurnChance();
    }

    private int getSpreadChance() {
        return this.isWaterlogged() ? 0 : ((FlammableBlockRegistry.Entry)FlammableBlockRegistry.getDefaultInstance().get(this.block)).getSpreadChance();
    }

    private String[] getBlockIdentifierAndPath() {
        boolean tall_plants;
        Object id = "textures/block/";
        String id2 = "essentialgui:textures/block/" + (this.is3DBlock() ? "3d/" : "");
        Object path = this.client.method_1541().method_3349(this.state).method_68511().method_45851().method_45816().method_12832().substring(6);
        String path2 = class_7923.field_41175.method_10221((Object)this.state.method_26204()).method_12832();
        boolean customTexture = this.is3DBlock() || this.block instanceof class_4770 || this.block instanceof class_2195 || this.block instanceof class_2211 || this.block instanceof class_2260 || this.block instanceof class_3922 || this.block instanceof class_2334 || this.block instanceof class_2362 || this.block instanceof class_2457 || this.block instanceof class_5809 || this.block instanceof class_2513;
        boolean bl = tall_plants = this.state.method_27852(class_2246.field_10313) || this.state.method_27852(class_2246.field_43229) || this.state.method_27852(class_2246.field_10214) || this.block instanceof class_8237 || this.block instanceof class_2525;
        if (customTexture) {
            id = id2;
            path = path2;
            if (this.block instanceof class_2211) {
                path = path2 + "_leaves_" + ((class_2737)this.state.method_11654((class_2769)class_2741.field_12516)).method_15434();
            } else if (this.block instanceof class_2272) {
                path = path2 + "_bites" + String.valueOf(this.state.method_11654((class_2769)class_2741.field_12505));
            } else if (this.block instanceof class_3922) {
                path = (Boolean)this.state.method_11654((class_2769)class_2741.field_12548) != false ? path2 : "campfire_unlit";
            } else if (this.block instanceof class_2401) {
                path = (Boolean)this.state.method_11654((class_2769)class_2741.field_12484) != false ? path2 + "_powered" : path2;
            } else if (this.state.method_27852(class_2246.field_17563)) {
                int level = (Integer)this.state.method_11654((class_2769)class_2741.field_17586);
                path = path2 + "_level" + (level <= 3 ? 0 : (Integer)this.state.method_11654((class_2769)class_2741.field_17586));
            } else if (this.block instanceof class_2360) {
                path = path2 + "_age" + String.valueOf(this.state.method_11654((class_2769)class_2741.field_12497));
            } else if (this.block instanceof class_2377) {
                path = path2 + "_" + String.valueOf(this.state.method_11654((class_2769)class_2741.field_12545));
            } else if (this.state.method_27852(class_2246.field_27878) || this.state.method_27852(class_2246.field_27097)) {
                path = path2 + "_level" + String.valueOf(this.state.method_11654((class_2769)class_2741.field_12513));
            } else if (this.state.method_27852(class_2246.field_10377)) {
                path = path2 + "_" + String.valueOf(this.state.method_11654((class_2769)class_2741.field_12534)) + ((Boolean)this.state.method_11654((class_2769)class_2741.field_12484) != false ? "_powered" : "");
            } else if (this.state.method_27852(class_2246.field_10398)) {
                path = path2 + ((Boolean)this.state.method_11654((class_2769)class_2741.field_12488) != false ? "_eyed" : "");
            } else if (this.state.method_27852(class_2246.field_16330)) {
                path = path2 + ((Boolean)this.state.method_11654((class_2769)class_2741.field_17393) != false ? "_with_book" : "");
            } else if (this.state.method_27852(class_2246.field_10450)) {
                boolean locked = (Boolean)this.state.method_11654((class_2769)class_2741.field_12502);
                boolean powered = (Boolean)this.state.method_11654((class_2769)class_2741.field_12484);
                path = path2 + "_delay" + String.valueOf(this.state.method_11654((class_2769)class_2741.field_12494)) + (locked ? "_locked" : "") + (powered ? "_powered" : "");
            } else if (this.state.method_27852(class_2246.field_10333)) {
                boolean full;
                boolean has_bottle0 = (Boolean)this.state.method_11654((class_2769)class_2741.field_12554);
                boolean has_bottle1 = (Boolean)this.state.method_11654((class_2769)class_2741.field_12500);
                boolean has_bottle2 = (Boolean)this.state.method_11654((class_2769)class_2741.field_12531);
                boolean empty = !has_bottle0 && !has_bottle1 && !has_bottle2;
                boolean bl2 = full = has_bottle0 && has_bottle1 && has_bottle2 || has_bottle0 && has_bottle1 || has_bottle0 && has_bottle2 || has_bottle1 && has_bottle2;
                path = path2 + (full ? "_full" : (empty ? "_empty" : (has_bottle0 || has_bottle1 ? "_bottle1" : "_bottle2")));
            } else if (this.state.method_27852(class_2246.field_10091)) {
                path = path2 + ((Integer)this.state.method_11654((class_2769)class_2741.field_12511) > 0 ? "_power" : "");
            }
        } else if (this.block instanceof class_2282 || this.block instanceof class_2393 || this.block instanceof class_2391 || tall_plants) {
            id = id2;
            if (this.state.method_27852(class_2246.field_43229)) {
                path = ((String)path).replace("crop", "plant").replace("_stage_4", "");
            }
            if (this.block instanceof class_8237) {
                String half = ((class_2756)this.state.method_11654((class_2769)class_2741.field_12533)).method_15434() == "upper" ? "_top_" : "_bottom_";
                String stage = String.format("stage_%d", this.state.method_11654((class_2769)class_2741.field_37654));
                path = ((String)path).replace("_top", "") + half + stage;
            }
        }
        return new String[]{id, path};
    }

    private String getBlockName() {
        String name = this.state.method_26204().method_9518().getString();
        String color = "\u00a77";
        if (this.coloredText) {
            color = this.isWaterlogged() ? "\u00a79" : (this.isSkull() ? "\u00a7e" : "\u00a72");
        }
        return color + name;
    }

    private String getBlockCoordinates() {
        int x = this.pos.method_10263();
        int y = this.pos.method_10264();
        int z = this.pos.method_10260();
        if (this.coloredText) {
            return "\u00a7c" + x + " \u00a72" + y + " \u00a79" + z;
        }
        return "\u00a77" + x + " " + y + " " + z;
    }

    private String getBlockId() {
        return class_7923.field_41175.method_10221((Object)this.block).toString();
    }

    private class_2561 getBlockIdText() {
        return TextUtils.write(this.getBlockId()).method_27692(class_124.field_1063);
    }

    private String getBlockModId() {
        String color = this.coloredText ? "\u00a75" : "\u00a77";
        String id = ((class_5321)class_7923.field_41175.method_29113((Object)this.block).get()).method_29177().method_12836();
        String modName = ((ModContainer)FabricLoader.getInstance().getModContainer(id).get()).getMetadata().getName();
        return color + modName;
    }

    private String getBlockLight() {
        int value = this.getBlockLightValue();
        String valueColor = this.getValueColor(value > 0);
        String key = "hud.block.properties.light" + (this.isGrowingBlock() ? ".growth" : "");
        String light = TextUtils.translate(key).getString();
        return this.getHudPropColor() + light + valueColor + value;
    }

    private String getBlockMature() {
        boolean mature = this.isMature();
        String valueColor = this.getValueColor(mature);
        String value = mature ? "\u2714" : "\u274c";
        String key = TextUtils.translate("hud.block.properties.mature").getString();
        return this.getHudPropColor() + key + valueColor + value;
    }

    private boolean isGrowingBlock() {
        return this.block instanceof class_2202 || this.block instanceof class_2302 || this.block instanceof class_2344 || this.block instanceof class_2473 || this.block instanceof class_2513 || this.block instanceof class_3830;
    }

    private boolean isCrop() {
        return this.block instanceof class_2302 || this.block instanceof class_2421 || this.block instanceof class_3830;
    }

    private boolean shouldShowLight() {
        return this.isGrowingBlock() || this.isValidSpawnBlock();
    }

    private boolean isMature() {
        int[] age = this.getBlockAge();
        return age[0] >= age[1];
    }

    private boolean isSpreadable() {
        return this.block instanceof class_2500 || this.state.method_27852(class_2246.field_10566);
    }

    private boolean isValidSpawnBlock() {
        class_2338 basePos = this.pos;
        class_2680 baseState = this.state;
        if (!(this.block instanceof class_5803) && (this.state.method_26220((class_1922)this.world, this.pos).method_1110() || this.state.method_45474())) {
            basePos = this.pos.method_10074();
            baseState = this.world.method_8320(basePos);
        }
        class_2338 above1 = basePos.method_10084();
        class_2338 above2 = above1.method_10084();
        class_2680 state1 = this.world.method_8320(above1);
        class_2680 state2 = this.world.method_8320(above2);
        if (this.world.method_8316(above1).method_15772() != class_3612.field_15906) {
            return false;
        }
        boolean solidGround = baseState.method_26206((class_1922)this.world, basePos, class_2350.field_11036) && baseState.method_26225();
        boolean noCollision1 = state1.method_26215() || state1.method_26220((class_1922)this.world, above1).method_1110() || state1.method_45474();
        boolean noCollision2 = state2.method_26215() || state2.method_26220((class_1922)this.world, above2).method_1110() || state2.method_45474();
        boolean validAbove = noCollision1 && noCollision2;
        return solidGround && validAbove;
    }

    private int getBlockLightValue() {
        return this.block instanceof class_2302 || this.block instanceof class_2513 ? this.getCropsLight() : (this.block instanceof class_2202 || this.block instanceof class_2344 || this.block instanceof class_3830 ? this.getOthersLight() : (this.block instanceof class_2473 ? this.getSaplingLight() : (this.block instanceof class_10736 ? this.getFireflyBushLight() : this.getSpawnLight())));
    }

    private List<class_2561> getBlockLightProperty() {
        class_2338 pos1 = this.block instanceof class_2302 ? this.pos : this.pos.method_10084();
        int lightSubtracted = this.getBlockLightValue();
        int lightBlock = this.world.method_8314(class_1944.field_9282, pos1);
        int lightSkyAdjusted = Math.max(0, lightSubtracted - lightBlock);
        String lightSubtractedColor = lightSubtracted <= 0 ? "\u00a7c" : "\u00a7a";
        String lightSkyColor = lightSkyAdjusted <= 0 ? "\u00a7c" : "\u00a73";
        String lightBlockColor = lightBlock <= 0 ? "\u00a7c" : "\u00a76";
        String subtractedLight = lightSubtractedColor + lightSubtracted;
        String skyLight = lightSkyColor + lightSkyAdjusted;
        String blockLight = lightBlockColor + lightBlock;
        String lightText = " \u00a77(" + skyLight + " \u00a77| " + blockLight + "\u00a77)";
        String combined = subtractedLight + lightText;
        String key = this.isGrowingBlock() ? "light.growth" : "light";
        return List.of(TextUtils.blockLine(key, combined));
    }

    private String getValueColor(boolean ok) {
        return this.coloredText ? (ok ? "\u00a7a" : "\u00a7c") : "\u00a77";
    }

    private String getHudPropColor() {
        return this.coloredText ? "\u00a73" : "\u00a77";
    }

    private int getCropsLight() {
        return this.world.method_22335(this.pos, 0);
    }

    private int getFireflyBushLight() {
        return this.world.method_22339(this.pos);
    }

    private int getOthersLight() {
        return this.world.method_22335(this.pos.method_10084(), 0);
    }

    private int getSaplingLight() {
        return this.world.method_22339(this.pos.method_10084());
    }

    private int getSpawnLight() {
        return this.world.method_8314(class_1944.field_9282, this.pos.method_10084());
    }

    private int getSpreadableLight() {
        return this.getSaplingLight();
    }

    private int getBlockPowerLevel() {
        if (!this.isBlockEmittingPower()) {
            return 0;
        }
        if (this.state.method_28501().contains(class_2741.field_12511)) {
            return (Integer)this.state.method_11654((class_2769)class_2741.field_12511);
        }
        if (this.block instanceof class_2436 || this.block instanceof class_2459) {
            return 15;
        }
        return 0;
    }

    private boolean isBlockEmittingPower() {
        return this.state.method_28501().contains(class_2741.field_12511) || this.state.method_26204() instanceof class_2436 || this.state.method_26204() instanceof class_2459;
    }

    private boolean hasWaterSource() {
        if (this.world.method_8520(this.pos.method_10084())) {
            return true;
        }
        for (class_2338 blockPos : class_2338.method_10097((class_2338)this.pos.method_10069(-4, 0, -4), (class_2338)this.pos.method_10069(4, 1, 4))) {
            if (!this.world.method_8316(blockPos).method_15767(class_3486.field_15517)) continue;
            return true;
        }
        return false;
    }

    private boolean isFlammable() {
        return this.getBurnChance() > 0;
    }

    private boolean isOre() {
        if (!Utils.isVanillaBlock(this.block)) {
            return false;
        }
        boolean isTaggedOre = this.ORE_TAGS.stream().anyMatch(arg_0 -> ((class_2680)this.state).method_26164(arg_0));
        boolean isSpecialOre = SPECIAL_ORES.contains(this.state.method_26204());
        return isTaggedOre || isSpecialOre;
    }

    private boolean isShearable() {
        boolean inBlockClass = this.SHEARABLE_BLOCK_CLASSES.stream().anyMatch(c -> c.isInstance(this.state.method_26204()));
        boolean inBlockTags = this.state.method_26164(class_3481.field_15481);
        return inBlockClass || inBlockTags;
    }

    private boolean isSilkTouchable() {
        if (this.block instanceof class_7714 || this.state.method_27852(class_2246.field_10504)) {
            return true;
        }
        if (this.block instanceof class_2298 || this.block instanceof class_2217 || this.block instanceof class_2221 || this.block instanceof class_2222) {
            return true;
        }
        if (this.block instanceof class_2386 && !(this.block instanceof class_2360) || this.state.method_27852(class_2246.field_10384) || this.state.method_27852(class_2246.field_10225)) {
            return true;
        }
        if ((this.state.method_26164(ConventionalBlockTags.GLASS_BLOCKS) || this.state.method_26164(ConventionalBlockTags.GLASS_PANES) || this.state.method_27852(class_2246.field_10171) || this.state.method_27852(class_2246.field_10174)) && !(this.block instanceof class_5555)) {
            return true;
        }
        if (this.block instanceof class_7125 || this.block instanceof class_7126 || this.block instanceof class_5703 || this.block instanceof class_7268 || this.block instanceof class_7130) {
            return true;
        }
        if (this.block instanceof class_2488 || this.state.method_27852(class_2246.field_10491)) {
            return true;
        }
        if (this.SILK_TOUCHABLE_BLOCK_CLASSES.stream().anyMatch(c -> c.isInstance(this.block))) {
            return true;
        }
        return this.SILK_TOUCHABLE_BLOCKS.contains(this.block);
    }

    private boolean isUnobtainable() {
        if (this.block instanceof class_5541 && this.state.method_27852(class_2246.field_27160)) {
            return true;
        }
        if (this.block instanceof class_5803 && !((Boolean)this.state.method_11654((class_2769)class_2741.field_28716)).booleanValue()) {
            return true;
        }
        if (this.UNOBTAINABLE_BLOCK_CLASSES.stream().anyMatch(c -> c.isInstance(this.block))) {
            return true;
        }
        return this.UNOBTAINABLE_BLOCKS.contains(this.block);
    }

    private boolean isSkull() {
        return this.block instanceof class_2190;
    }

    private boolean isMushroomPlantableBlock() {
        class_2338 above = this.pos.method_10084();
        class_2680 aboveState = this.world.method_8320(above);
        return this.state.method_26164(class_3481.field_25739) || this.state.method_26216() && this.world.method_22335(above, 0) < 13 && aboveState.method_27852(class_2246.field_10124);
    }

    private boolean isWaterlogged() {
        return this.block instanceof class_3737 && (Boolean)this.state.method_11654((class_2769)class_2741.field_12508) != false;
    }

    private boolean playerCanHarvestBlock() {
        if (this.isUnobtainable()) {
            return false;
        }
        if (this.block instanceof class_5635 && !this.player.method_6047().method_31574(class_1802.field_8550)) {
            return false;
        }
        return this.player.method_7305(this.state);
    }

    private boolean is3DBlock() {
        return this.block instanceof class_2275 || this.block instanceof class_2272 || this.block instanceof class_5545 || this.block instanceof class_3922 || this.block instanceof class_2286 || this.block instanceof class_3962 || this.block instanceof class_2333 || this.block instanceof class_2362 || this.block instanceof class_2360 || this.block instanceof class_2377 || this.block instanceof class_3715 || this.block instanceof class_2401 || this.block instanceof class_2423 || this.block instanceof class_2462 || this.block instanceof class_5808;
    }

    private boolean isBlockWithoutItem() {
        return this.block instanceof class_4770 || this.block instanceof class_4864 || this.block instanceof class_4865 || this.block instanceof class_2195 || this.block instanceof class_2211 || this.block instanceof class_2202 || this.block instanceof class_2260 || this.block instanceof class_2282 || this.block instanceof class_2302 || this.block instanceof class_2334 || this.block instanceof class_5778 || this.block instanceof class_2421 || this.block instanceof class_5689 || this.block instanceof class_2457 || this.block instanceof class_5809 || this.block instanceof class_2513 || this.block instanceof class_2523 || this.block instanceof class_3830 || this.block instanceof class_2320;
    }

    private boolean isCustomTexture(class_1799 stack) {
        class_11540 keyedItemRenderState = new class_11540();
        this.client.method_65386().method_65598((class_10444)keyedItemRenderState, stack, class_811.field_4317, null, null, 0);
        return !keyedItemRenderState.method_65608() || this.noItem;
    }

    static {
        SPECIAL_ORES = Set.of(class_2246.field_22109, class_2246.field_10213);
    }

    private record DyeMapping(Set<class_2248> blocks, class_1767 color, class_1792 dyeItem) {
    }

    @FunctionalInterface
    private static interface DrawableIcon {
        public void draw(class_332 var1, int var2, int var3);
    }
}

