/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.screen;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.gui.screen.ScreenBase;
import lordrius.essentialgui.gui.widgets.ButtonWidgetRegular;
import lordrius.essentialgui.gui.widgets.ButtonWidgetToggle;
import lordrius.essentialgui.util.ScreenUtils;
import lordrius.essentialgui.util.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import org.jetbrains.annotations.Nullable;

public class ClientPlayerWorldScreen
extends ScreenBase {
    private final ConfigData.ClientPlayerWorld config;
    private OptionsListWidget optionsListWidget;
    private class_8132 layout;

    public ClientPlayerWorldScreen(class_437 parent) {
        super(parent, (class_2561)TextUtils.translate("screen.client.title"));
        this.config = Data.cfg.client;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.layout = new class_8132((class_437)this, 61, 33);
        this.optionsListWidget = new OptionsListWidget();
        this.layout.method_48999((class_8021)this.optionsListWidget);
        this.method_37063((class_364)this.optionsListWidget);
        this.layout.method_48222();
    }

    public class OptionsListWidget
    extends class_4265<OptionEntry> {
        public OptionsListWidget() {
            super(ClientPlayerWorldScreen.this.field_22787, ClientPlayerWorldScreen.this.field_22789, ClientPlayerWorldScreen.this.layout.method_57727() + 28, ClientPlayerWorldScreen.this.layout.method_48998(), 22);
            this.addEntries();
        }

        public int method_25322() {
            return 260;
        }

        public int method_25342() {
            return (this.field_22758 - this.method_25322()) / 2;
        }

        public void addEntries() {
            class_2561 tooltip;
            class_5250 label;
            this.method_25339();
            String key = "screen.client.";
            class_5250 HEADER = TextUtils.translate("screen.client.header");
            class_5250 PERFORMANCE_HEADER = TextUtils.translate("screen.client.performance");
            class_5250 POSITION_HEADER = TextUtils.translate("screen.client.position");
            class_5250 WORLD_HEADER = TextUtils.translate("screen.client.world");
            class_5250 COLORED = TextUtils.translate("screen.colored_text");
            List<BooleanOption> performance = List.of(new BooleanOption(this, "fps", () -> ClientPlayerWorldScreen.this.config.performance.fps, v -> {
                ClientPlayerWorldScreen.this.config.performance.fps = v;
            }), new BooleanOption(this, "cpu", () -> ClientPlayerWorldScreen.this.config.performance.cpu, v -> {
                ClientPlayerWorldScreen.this.config.performance.cpu = v;
            }), new BooleanOption(this, "memory", () -> ClientPlayerWorldScreen.this.config.performance.memory, v -> {
                ClientPlayerWorldScreen.this.config.performance.memory = v;
            }), new BooleanOption(this, "latency", () -> ClientPlayerWorldScreen.this.config.performance.latency, v -> {
                ClientPlayerWorldScreen.this.config.performance.latency = v;
            }), new BooleanOption(this, "packets", () -> ClientPlayerWorldScreen.this.config.performance.packets, v -> {
                ClientPlayerWorldScreen.this.config.performance.packets = v;
            }));
            List<BooleanOption> position = List.of(new BooleanOption(this, "coords", () -> ClientPlayerWorldScreen.this.config.position.coords, v -> {
                ClientPlayerWorldScreen.this.config.position.coords = v;
            }), new BooleanOption(this, "coords_dim", () -> ClientPlayerWorldScreen.this.config.position.coordsDim, v -> {
                ClientPlayerWorldScreen.this.config.position.coordsDim = v;
            }), new BooleanOption(this, "chunk", () -> ClientPlayerWorldScreen.this.config.position.chunk, v -> {
                ClientPlayerWorldScreen.this.config.position.chunk = v;
            }), new BooleanOption(this, "chunk_slime", () -> ClientPlayerWorldScreen.this.config.position.chunkSlime, v -> {
                ClientPlayerWorldScreen.this.config.position.chunkSlime = v;
            }), new BooleanOption(this, "facing", () -> ClientPlayerWorldScreen.this.config.position.facing, v -> {
                ClientPlayerWorldScreen.this.config.position.facing = v;
            }), new BooleanOption(this, "facing_axis", () -> ClientPlayerWorldScreen.this.config.position.facingAxis, v -> {
                ClientPlayerWorldScreen.this.config.position.facingAxis = v;
            }), new BooleanOption(this, "rotation", () -> ClientPlayerWorldScreen.this.config.position.rotation, v -> {
                ClientPlayerWorldScreen.this.config.position.rotation = v;
            }), new BooleanOption(this, "light", () -> ClientPlayerWorldScreen.this.config.position.light, v -> {
                ClientPlayerWorldScreen.this.config.position.light = v;
            }), new BooleanOption(this, "speed", () -> ClientPlayerWorldScreen.this.config.position.speed, v -> {
                ClientPlayerWorldScreen.this.config.position.speed = v;
            }));
            List<BooleanOption> world = List.of(new BooleanOption(this, "biome", () -> ClientPlayerWorldScreen.this.config.world.biome, v -> {
                ClientPlayerWorldScreen.this.config.world.biome = v;
            }), new BooleanOption(this, "entities", () -> ClientPlayerWorldScreen.this.config.world.entities, v -> {
                ClientPlayerWorldScreen.this.config.world.entities = v;
            }), new BooleanOption(this, "entities_block", () -> ClientPlayerWorldScreen.this.config.world.entitiesBlock, v -> {
                ClientPlayerWorldScreen.this.config.world.entitiesBlock = v;
            }), new BooleanOption(this, "time", () -> ClientPlayerWorldScreen.this.config.world.time, v -> {
                ClientPlayerWorldScreen.this.config.world.time = v;
            }), new BooleanOption(this, "time_days", () -> ClientPlayerWorldScreen.this.config.world.timeDays, v -> {
                ClientPlayerWorldScreen.this.config.world.timeDays = v;
            }), new BooleanOption(this, "days", () -> ClientPlayerWorldScreen.this.config.world.days, v -> {
                ClientPlayerWorldScreen.this.config.world.days = v;
            }));
            this.addStaticHeader((class_2561)HEADER);
            this.addBooleanOption((class_2561)COLORED, null, () -> ClientPlayerWorldScreen.this.config.colored, v -> {
                ClientPlayerWorldScreen.this.config.colored = v;
            });
            this.method_25321((class_350.class_351)new ToggleStringEntry());
            this.addCategoryHeader((class_2561)PERFORMANCE_HEADER, () -> ClientPlayerWorldScreen.this.config.performance.enabled, v -> {
                ClientPlayerWorldScreen.this.config.performance.enabled = v;
            });
            if (ClientPlayerWorldScreen.this.config.performance.enabled) {
                for (BooleanOption option : performance) {
                    label = TextUtils.translate("screen.client.performance." + option.key);
                    tooltip = this.safeTranslate("screen.client.performance." + option.key + ".tooltip");
                    this.addBooleanOption((class_2561)label, tooltip, option.getter, option.setter);
                }
            }
            this.addCategoryHeader((class_2561)POSITION_HEADER, () -> ClientPlayerWorldScreen.this.config.position.enabled, v -> {
                ClientPlayerWorldScreen.this.config.position.enabled = v;
            });
            if (ClientPlayerWorldScreen.this.config.position.enabled) {
                for (BooleanOption option : position) {
                    label = TextUtils.translate("screen.client.position." + option.key);
                    tooltip = this.safeTranslate("screen.client.position." + option.key + ".tooltip");
                    this.addBooleanOption((class_2561)label, tooltip, option.getter, option.setter);
                }
            }
            this.addCategoryHeader((class_2561)WORLD_HEADER, () -> ClientPlayerWorldScreen.this.config.world.enabled, v -> {
                ClientPlayerWorldScreen.this.config.world.enabled = v;
            });
            if (ClientPlayerWorldScreen.this.config.world.enabled) {
                for (BooleanOption option : world) {
                    label = TextUtils.translate("screen.client.world." + option.key);
                    tooltip = this.safeTranslate("screen.client.world." + option.key + ".tooltip");
                    this.addBooleanOption((class_2561)label, tooltip, option.getter, option.setter);
                }
                this.method_25321((class_350.class_351)new TimeStyleEntry());
            }
        }

        private class_2561 safeTranslate(String key) {
            class_5250 translated = TextUtils.translate(key);
            return translated == null || translated.getString().equals(key) ? null : translated;
        }

        public void addEntriesAndFixScroll() {
            double currentScroll = this.method_44387();
            this.method_25339();
            this.addEntries();
            this.method_65506();
            double maxScroll = this.method_44390();
            this.method_44382(Math.min(currentScroll, maxScroll));
        }

        public void method_57713(class_332 context) {
        }

        public void method_57715(class_332 context) {
        }

        private void addStaticHeader(class_2561 header) {
            this.method_25321((class_350.class_351)new StaticHeaderEntry(header));
        }

        private void addCategoryHeader(class_2561 categoryName, BooleanSupplier getter, Consumer<Boolean> setter) {
            this.method_25321((class_350.class_351)new CategoryHeaderEntry(categoryName, getter, setter));
        }

        private void addBooleanOption(class_2561 label, @Nullable class_2561 tooltip, BooleanSupplier getter, Consumer<Boolean> setter) {
            this.method_25321((class_350.class_351)new BooleanOptionEntry(label, tooltip, getter, setter));
        }

        public class BooleanOption {
            public final String key;
            public final BooleanSupplier getter;
            public final Consumer<Boolean> setter;

            public BooleanOption(OptionsListWidget this$1, String key, BooleanSupplier getter, Consumer<Boolean> setter) {
                this.key = key;
                this.getter = getter;
                this.setter = setter;
            }
        }

        public class ToggleStringEntry
        extends OptionEntry {
            private final String PREFIX_SHORTENED = "screen.hud_prefix_style.shortened";
            private final String PREFIX_NONE = "screen.hud_prefix_style.none";
            private final String PREFIX_COMPLETE = "screen.hud_prefix_style.complete";
            private final Supplier<class_2561> PREFIX_STYLE;
            private final ButtonWidgetRegular prefixStyleButton;

            public ToggleStringEntry() {
                super(OptionsListWidget.this);
                this.PREFIX_SHORTENED = "screen.hud_prefix_style.shortened";
                this.PREFIX_NONE = "screen.hud_prefix_style.none";
                this.PREFIX_COMPLETE = "screen.hud_prefix_style.complete";
                this.PREFIX_STYLE = () -> TextUtils.translate("screen.hud_prefix_style").method_10852((class_2561)TextUtils.translate(ClientPlayerWorldScreen.this.config.prefixStyle, class_124.field_1060));
                this.prefixStyleButton = ScreenUtils.toggleStringButton(0, 0, this.PREFIX_STYLE, btn -> {
                    ConfigData.ClientPlayerWorld clientPlayerWorld = ClientPlayerWorldScreen.this.config;
                    clientPlayerWorld.prefixStyle = switch (ClientPlayerWorldScreen.this.config.prefixStyle) {
                        case "screen.hud_prefix_style.shortened" -> "screen.hud_prefix_style.none";
                        case "screen.hud_prefix_style.none" -> "screen.hud_prefix_style.complete";
                        default -> "screen.hud_prefix_style.shortened";
                    };
                });
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
                int buttonWidth = this.prefixStyleButton.method_25368();
                int centerX = x + entryWidth / 2 - buttonWidth / 2;
                this.prefixStyleButton.method_46421(centerX);
                this.prefixStyleButton.method_46419(y);
                this.prefixStyleButton.method_25394(context, mouseX, mouseY, tickProgress);
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.prefixStyleButton);
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.prefixStyleButton);
            }
        }

        public class TimeStyleEntry
        extends OptionEntry {
            private final String TWELVE = "screen.time_style.12_hour";
            private final String TWENTYFOUR = "screen.time_style.24_hour";
            private final String TICKS = "screen.time_style.ticks";
            private final Supplier<class_2561> TIME_STYLE;
            private final ButtonWidgetRegular styleButton;

            public TimeStyleEntry() {
                super(OptionsListWidget.this);
                this.TWELVE = "screen.time_style.12_hour";
                this.TWENTYFOUR = "screen.time_style.24_hour";
                this.TICKS = "screen.time_style.ticks";
                this.TIME_STYLE = () -> TextUtils.translate("screen.time_style").method_10852((class_2561)TextUtils.translate(ClientPlayerWorldScreen.this.config.world.timeStyle, class_124.field_1060));
                this.styleButton = ScreenUtils.toggleStringButton(0, 0, this.TIME_STYLE, btn -> {
                    ConfigData.ClientPlayerWorld.WorldInfo worldInfo = ClientPlayerWorldScreen.this.config.world;
                    worldInfo.timeStyle = switch (ClientPlayerWorldScreen.this.config.world.timeStyle) {
                        case "screen.time_style.24_hour" -> "screen.time_style.12_hour";
                        case "screen.time_style.12_hour" -> "screen.time_style.ticks";
                        default -> "screen.time_style.24_hour";
                    };
                });
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
                int buttonWidth = this.styleButton.method_25368();
                int centerX = x + entryWidth / 2 - buttonWidth / 2;
                this.styleButton.method_46421(centerX);
                this.styleButton.method_46419(y);
                this.styleButton.field_22763 = ClientPlayerWorldScreen.this.config.world.time;
                this.styleButton.method_25394(context, mouseX, mouseY, tickProgress);
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.styleButton);
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.styleButton);
            }
        }

        public class StaticHeaderEntry
        extends OptionEntry {
            private final class_2561 categoryName;

            public StaticHeaderEntry(class_2561 categoryName) {
                super(OptionsListWidget.this);
                this.categoryName = categoryName;
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
                context.method_27534(ClientPlayerWorldScreen.this.field_22793, this.categoryName, x + entryWidth / 2, y + 6, -1);
            }

            public List<? extends class_364> method_25396() {
                return List.of();
            }

            public List<? extends class_6379> method_37025() {
                return List.of();
            }
        }

        public class CategoryHeaderEntry
        extends OptionEntry {
            private final class_2561 categoryName;
            private final ButtonWidgetToggle toggleButton;

            public CategoryHeaderEntry(class_2561 categoryName, BooleanSupplier getter, Consumer<Boolean> setter) {
                super(OptionsListWidget.this);
                this.categoryName = categoryName;
                this.toggleButton = new ButtonWidgetToggle(0, 0, getter.getAsBoolean(), onPress -> {
                    boolean newValue = !getter.getAsBoolean();
                    setter.accept(newValue);
                    ClientPlayerWorldScreen.this.optionsListWidget.addEntriesAndFixScroll();
                });
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
                context.method_27534(ClientPlayerWorldScreen.this.field_22793, this.categoryName, x + entryWidth / 2, y + 6, -1);
                this.toggleButton.method_46421(x + entryWidth - 20);
                this.toggleButton.method_46419(y);
                this.toggleButton.method_25394(context, mouseX, mouseY, tickProgress);
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.toggleButton);
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.toggleButton);
            }
        }

        public class BooleanOptionEntry
        extends OptionEntry {
            private final class_2561 optionName;
            @Nullable
            private final class_2561 tooltip;
            private final ButtonWidgetToggle toggleButton;

            public BooleanOptionEntry(@Nullable class_2561 label, class_2561 tooltip, BooleanSupplier getter, Consumer<Boolean> setter) {
                super(OptionsListWidget.this);
                this.optionName = label;
                this.tooltip = tooltip;
                this.toggleButton = new ButtonWidgetToggle(0, 0, getter.getAsBoolean(), button -> {
                    setter.accept(!getter.getAsBoolean());
                    ClientPlayerWorldScreen.this.optionsListWidget.addEntriesAndFixScroll();
                });
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
                context.method_27535(ClientPlayerWorldScreen.this.field_22793, this.optionName, x + 2, y + 6, -1);
                this.toggleButton.method_46421(x + entryWidth - 20);
                this.toggleButton.method_46419(y);
                this.toggleButton.method_25394(context, mouseX, mouseY, tickProgress);
                if (hovered && this.tooltip != null) {
                    List wrappedTooltip = ClientPlayerWorldScreen.this.field_22793.method_1728((class_5348)this.tooltip, 200);
                    context.method_71274(wrappedTooltip, mouseX, mouseY);
                }
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.toggleButton);
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.toggleButton);
            }
        }

        public abstract class OptionEntry
        extends class_4265.class_4266<OptionEntry> {
            public OptionEntry(OptionsListWidget this$1) {
            }
        }
    }
}

