/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.events.KeyBindings;
import lordrius.essentialgui.gui.screen.ScreenBase;
import lordrius.essentialgui.gui.widgets.ButtonWidgetRegular;
import lordrius.essentialgui.util.Draw;
import lordrius.essentialgui.util.TextUtils;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_10255;
import net.minecraft.class_10275;
import net.minecraft.class_11187;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1420;
import net.minecraft.class_1425;
import net.minecraft.class_1428;
import net.minecraft.class_1430;
import net.minecraft.class_1433;
import net.minecraft.class_1439;
import net.minecraft.class_1440;
import net.minecraft.class_1451;
import net.minecraft.class_1452;
import net.minecraft.class_1453;
import net.minecraft.class_1454;
import net.minecraft.class_1456;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1473;
import net.minecraft.class_1477;
import net.minecraft.class_1481;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1530;
import net.minecraft.class_1531;
import net.minecraft.class_1532;
import net.minecraft.class_1542;
import net.minecraft.class_1545;
import net.minecraft.class_1547;
import net.minecraft.class_1548;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1564;
import net.minecraft.class_1571;
import net.minecraft.class_1577;
import net.minecraft.class_1584;
import net.minecraft.class_1593;
import net.minecraft.class_1604;
import net.minecraft.class_1606;
import net.minecraft.class_1614;
import net.minecraft.class_1621;
import net.minecraft.class_1628;
import net.minecraft.class_1632;
import net.minecraft.class_1634;
import net.minecraft.class_1640;
import net.minecraft.class_1642;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3701;
import net.minecraft.class_3988;
import net.minecraft.class_4019;
import net.minecraft.class_437;
import net.minecraft.class_4466;
import net.minecraft.class_4760;
import net.minecraft.class_4985;
import net.minecraft.class_5136;
import net.minecraft.class_5250;
import net.minecraft.class_5418;
import net.minecraft.class_5762;
import net.minecraft.class_6053;
import net.minecraft.class_7102;
import net.minecraft.class_7110;
import net.minecraft.class_7260;
import net.minecraft.class_7298;
import net.minecraft.class_8113;
import net.minecraft.class_8153;
import net.minecraft.class_8949;
import net.minecraft.class_9069;
import net.minecraft.class_9848;

public class LoadedEntitiesScreen
extends class_437 {
    private final ConfigData.MiscFeatures config;
    private final Supplier<class_2561> SORTING_STYLE;
    private final Supplier<class_2561> TOOLTIP;
    private HashMap<String, List<class_1297>> passive;
    private HashMap<String, List<class_1297>> hostile;
    private HashMap<String, List<class_1297>> nonLiving;
    private int columnWidth;
    private int columnHeight;
    private int passiveX;
    private int passiveY;
    private int hostileX;
    private int hostileY;
    private int nonLivingX;
    private int nonLivingY;
    private int headerY;
    private int totalEntitiesX;

    public LoadedEntitiesScreen(class_437 screen) {
        super((class_2561)TextUtils.translate("screen.loaded_entities.title"));
        this.config = Data.cfg.misc;
        this.SORTING_STYLE = () -> TextUtils.translate("screen.sort_by").method_10852((class_2561)TextUtils.translate(this.config.debugEntities.sortStyle, class_124.field_1060));
        this.TOOLTIP = () -> TextUtils.translate("screen.loaded_entities.tooltip").method_10852(this.config.debugEntities.tooltip ? ScreenBase.ON_TEXT : ScreenBase.OFF_TEXT);
        this.passive = new HashMap();
        this.hostile = new HashMap();
        this.nonLiving = new HashMap();
    }

    public void method_25426() {
        this.columnWidth = 154;
        this.columnHeight = this.field_22790 - 22;
        this.passiveX = 5;
        this.passiveY = 20;
        this.hostileX = this.passiveX + this.columnWidth + 5;
        this.hostileY = this.passiveY;
        this.nonLivingX = this.hostileX + this.columnWidth + 5;
        this.nonLivingY = this.passiveY;
        this.headerY = this.passiveY - 15;
        this.totalEntitiesX = this.nonLivingX + this.columnWidth + 5;
        this.method_37063((class_364)new ButtonWidgetRegular(this.totalEntitiesX - 3, 17, 157, 20, this.SORTING_STYLE.get(), btn -> {
            this.config.debugEntities.sortStyle = this.config.debugEntities.sortStyle.contains("alphabetically") ? "screen.sort.top" : "screen.sort.alphabetically";
            btn.method_25355(this.SORTING_STYLE.get());
        }));
        this.method_37063((class_364)new ButtonWidgetRegular(this.totalEntitiesX - 3, 39, 157, 20, this.TOOLTIP.get(), btn -> {
            this.config.debugEntities.tooltip = !this.config.debugEntities.tooltip;
            btn.method_25355(this.TOOLTIP.get());
        }));
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25420(context, mouseX, mouseY, delta);
        class_5250 passiveTitle = TextUtils.translate("screen.loaded_entities.total.passive");
        class_5250 hostileTitle = TextUtils.translate("screen.loaded_entities.total.hostile");
        class_5250 nonLivingTitle = TextUtils.translate("screen.loaded_entities.total.non_living");
        class_5250 total = TextUtils.translate("screen.loaded_entities.total");
        this.countEntities();
        int totalEntities = this.getTotalPassive() + this.getTotalHostile() + this.getTotalNonLiving();
        this.drawColumn(context, this.passiveX, this.passiveY, this.columnWidth, this.columnHeight, this.headerY, (class_2561)passiveTitle, this.passive, this.getTotalPassive(), mouseX, mouseY);
        this.drawColumn(context, this.hostileX, this.hostileY, this.columnWidth, this.columnHeight, this.headerY, (class_2561)hostileTitle, this.hostile, this.getTotalHostile(), mouseX, mouseY);
        this.drawColumn(context, this.nonLivingX, this.nonLivingY, this.columnWidth, this.columnHeight, this.headerY, (class_2561)nonLivingTitle, this.nonLiving, this.getTotalNonLiving(), mouseX, mouseY);
        this.drawHeader(context, this.totalEntitiesX, this.headerY, this.columnWidth, (class_2561)total, totalEntities, Draw.GRAY);
    }

    private void drawColumn(class_332 context, int x, int y, int columnWidth, int columnHeight, int headerY, class_2561 title, HashMap<String, List<class_1297>> entities, int totalEntities, int mouseX, int mouseY) {
        LinkedList<Map.Entry<String, List<class_1297>>> entityList = new LinkedList<Map.Entry<String, List<class_1297>>>(entities.entrySet());
        if (this.config.debugEntities.sortStyle.contains("alphabetically")) {
            Collections.sort(entityList, (o1, o2) -> ((String)o1.getKey()).compareTo((String)o2.getKey()));
        } else {
            Collections.sort(entityList, (o1, o2) -> ((List)o2.getValue()).size() - ((List)o1.getValue()).size());
        }
        context.method_25294(x - 3, y - 3, x + columnWidth, y + columnHeight, class_9848.method_61330((int)120, (int)-16777216));
        this.drawHeader(context, x, headerY, columnWidth, title, totalEntities, Draw.GRAY);
        for (int i = 0; i < entityList.size(); ++i) {
            Map.Entry entry = (Map.Entry)entityList.get(i);
            String name = (String)entry.getKey();
            List entityListForName = (List)entry.getValue();
            int value = entityListForName.size();
            int valueWidth = this.field_22793.method_1727(String.valueOf(value));
            int valueX = x + columnWidth - 2 - valueWidth;
            int offsetY = y + 11 * i;
            int backgroundColor = i % 2 == 0 ? class_9848.method_61330((int)70, (int)-16777216) : class_9848.method_61330((int)110, (int)-16777216);
            context.method_25294(x - 2, offsetY - 2, x + columnWidth - 1, offsetY + 9, backgroundColor);
            context.method_25303(this.field_22793, name, x, offsetY, Draw.GRAY);
            int amountColor = value >= 15 ? Draw.RED : Draw.DARK_GREEN;
            context.method_25303(this.field_22793, String.valueOf(value), valueX, offsetY, amountColor);
            if (!this.config.debugEntities.tooltip || mouseX < x || mouseX > x + columnWidth || mouseY < offsetY || mouseY > offsetY + 8) continue;
            context.method_51434(this.field_22793, this.getEntityCoordinatesTooltip(entityListForName), mouseX, mouseY);
        }
    }

    private List<class_2561> getEntityCoordinatesTooltip(List<class_1297> entityListForName) {
        LinkedList<class_2561> tooltip = new LinkedList<class_2561>();
        LinkedHashMap<String, List> groupedEntities = new LinkedHashMap<String, List>();
        for (class_1297 entity : entityListForName) {
            Object name;
            String prefix = "\u00a77";
            if (entity instanceof class_1542) {
                class_1542 item = (class_1542)entity;
                class_1799 stack = item.method_6983();
                if (stack.method_65130() != null) {
                    prefix = "\u00a7e";
                }
                name = stack.method_7964().getString();
            } else {
                name = entity.method_5477().getString();
            }
            name = prefix + (String)name;
            groupedEntities.computeIfAbsent((String)name, k -> new ArrayList()).add(entity);
        }
        ArrayList sortedKeys = new ArrayList(groupedEntities.keySet());
        sortedKeys.sort(Comparator.naturalOrder());
        for (String groupName : sortedKeys) {
            List entities = (List)groupedEntities.get(groupName);
            tooltip.add(class_2561.method_30163((String)groupName));
            int totalEntities = entities.size();
            for (int i = 0; i < totalEntities; ++i) {
                tooltip.add(this.coordinates((class_1297)entities.get(i), totalEntities));
            }
        }
        return tooltip;
    }

    private class_2561 coordinates(class_1297 entity, int totalEntities) {
        String prefix = totalEntities > 1 ? "\u00a78\u00bb " : "";
        return class_2561.method_43470((String)"%s\u00a7c%d \u00a72%d \u00a79%d".formatted(prefix, (int)entity.method_23317(), (int)entity.method_23318(), (int)entity.method_23321()));
    }

    private void drawHeader(class_332 context, int x, int y, int width, class_2561 text, int amount, int textColor) {
        String s = String.valueOf(amount);
        int i = this.field_22793.method_1727(s);
        int j = x;
        int k = y;
        Objects.requireNonNull(this.field_22793);
        int l = k + 9 + 1;
        context.method_25294(j - 3, k - 3, j + width, l + 1, class_9848.method_61330((int)180, (int)-16777216));
        context.method_27535(this.field_22793, text, j, k, textColor);
        context.method_25303(this.field_22793, s, j + width - 2 - i, k, textColor);
    }

    private void countEntities() {
        this.passive.clear();
        this.hostile.clear();
        this.nonLiving.clear();
        for (class_1297 entity : this.field_22787.field_1687.method_18112()) {
            String name = entity.method_5864().method_5897().getString();
            if (entity instanceof class_1430) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1496) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_7298) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_9069) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_5762) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1420) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_4466) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1451) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1428) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1433) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_4019) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_7102) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_6053) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_11187) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1439) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_3988) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_3701) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1440) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1453) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1452) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1657) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1456) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1454) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1463) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1425) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1472) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_8153) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1473) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_4985) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1477) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_7110) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1481) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1493) {
                this.passive.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1547) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_5418) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1545) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_8949) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_10275) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1548) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1510) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1560) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1559) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1564) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1571) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1577) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_4760) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1593) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1604) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1584) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1606) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1614) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1621) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1628) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1634) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1632) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_7260) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1640) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1528) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_5136) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1642) {
                this.hostile.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_10255) {
                this.nonLiving.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1530) {
                this.nonLiving.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1688) {
                this.nonLiving.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1531) {
                this.nonLiving.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_8113) {
                this.nonLiving.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1303) {
                this.nonLiving.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_8113.class_8122) {
                this.nonLiving.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1542) {
                this.nonLiving.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (entity instanceof class_1532) {
                this.nonLiving.computeIfAbsent(name, k -> new LinkedList()).add(entity);
            }
            if (!(entity instanceof class_1676)) continue;
            this.nonLiving.computeIfAbsent(name, k -> new LinkedList()).add(entity);
        }
    }

    private int getTotalPassive() {
        return this.passive.values().stream().mapToInt(list -> list.size()).sum();
    }

    private int getTotalHostile() {
        return this.hostile.values().stream().mapToInt(list -> list.size()).sum();
    }

    private int getTotalNonLiving() {
        return this.nonLiving.values().stream().mapToInt(list -> list.size()).sum();
    }

    public boolean method_25421() {
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (super.method_25404(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == KeyBindingHelper.getBoundKeyOf((class_304)KeyBindings.debugEntitiesLoaded).method_1444()) {
            this.method_25419();
            return true;
        }
        return false;
    }

    public void method_25419() {
        Data.save();
        this.field_22787.method_1507(null);
    }
}

