/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.screen;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.gui.screen.ScreenBase;
import lordrius.essentialgui.gui.widgets.ButtonWidgetSmall;
import lordrius.essentialgui.gui.widgets.ButtonWidgetToggle;
import lordrius.essentialgui.util.ScreenUtils;
import lordrius.essentialgui.util.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import org.jetbrains.annotations.Nullable;

public class PointedEntityScreen
extends ScreenBase {
    private final ConfigData.PointedEntity config;
    private OptionsListWidget optionsListWidget;
    private class_8132 layout;

    public PointedEntityScreen(class_437 parent) {
        super(parent, (class_2561)TextUtils.translate("screen.entity.title"));
        this.config = Data.cfg.entity;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.layout = new class_8132((class_437)this, 61, 33);
        this.optionsListWidget = new OptionsListWidget();
        this.layout.method_48999((class_8021)this.optionsListWidget);
        this.method_37063((class_364)this.optionsListWidget);
        this.layout.method_48222();
    }

    public class OptionsListWidget
    extends class_4265<OptionEntry> {
        public OptionsListWidget() {
            super(PointedEntityScreen.this.field_22787, PointedEntityScreen.this.field_22789, PointedEntityScreen.this.layout.method_57727() + 28, PointedEntityScreen.this.layout.method_48998(), 22);
            this.addEntries();
        }

        public int method_25322() {
            return 260;
        }

        public int method_25342() {
            return (this.field_22758 - this.method_25322()) / 2;
        }

        public void addEntries() {
            this.method_25339();
            String key = "screen.entity.";
            String keyMain = "screen.entity.main_hud.";
            class_5250 MAIN_HUD_HEADER = TextUtils.translate("screen.entity.main_hud");
            class_5250 PROPERTIES_HEADER = TextUtils.translate("screen.entity.properties");
            class_5250 ARMOR_STAND = TextUtils.translate("screen.entity.main_hud.armor_stand");
            class_5250 SKIN = TextUtils.translate("screen.entity.main_hud.skin");
            class_5250 NAME = TextUtils.translate("screen.entity.main_hud.name");
            class_5250 COORDS = TextUtils.translate("screen.entity.main_hud.coords");
            class_5250 MODID = TextUtils.translate("screen.entity.main_hud.modid");
            class_5250 COLORED = TextUtils.translate("screen.colored_text");
            class_5250 STATS_BARS = TextUtils.translate("screen.entity.main_hud.stats_bars");
            class_5250 EQUIPMENT = TextUtils.translate("screen.entity.equipment");
            class_5250 EQUIPMENT_TIP = TextUtils.translate("screen.entity.equipment.tooltip", ScreenBase.CONTEXTUAL_MENU_KEY_TEXT);
            class_5250 PLAYERS_EQUIPMENT = TextUtils.translate("screen.entity.equipment_players");
            class_5250 PLAYERS_EQUIPMENT_TIP = TextUtils.translate("screen.entity.equipment_players.tooltip", ScreenBase.CONTEXTUAL_MENU_KEY_TEXT);
            class_5250 HEALTH_PLATE = TextUtils.translate("screen.entity.health_plate");
            class_5250 HEALTH_PLATE_TIP = TextUtils.translate("screen.entity.health_plate.tooltip");
            this.addCategoryHeader((class_2561)MAIN_HUD_HEADER, true, () -> PointedEntityScreen.this.config.mainHud, v -> {
                PointedEntityScreen.this.config.mainHud = v;
            }, () -> PointedEntityScreen.this.config.style, s -> {
                PointedEntityScreen.this.config.style = s;
            });
            this.addBooleanOption((class_2561)ARMOR_STAND, null, () -> PointedEntityScreen.this.config.armorStand, v -> {
                PointedEntityScreen.this.config.armorStand = v;
            });
            this.addBooleanOption((class_2561)SKIN, null, () -> PointedEntityScreen.this.config.skin, v -> {
                PointedEntityScreen.this.config.skin = v;
            });
            this.addBooleanOption((class_2561)NAME, null, () -> PointedEntityScreen.this.config.name, v -> {
                PointedEntityScreen.this.config.name = v;
            });
            this.addBooleanOption((class_2561)COORDS, null, () -> PointedEntityScreen.this.config.coords, v -> {
                PointedEntityScreen.this.config.coords = v;
            });
            this.addBooleanOption((class_2561)MODID, null, () -> PointedEntityScreen.this.config.modid, v -> {
                PointedEntityScreen.this.config.modid = v;
            });
            this.addBooleanOption((class_2561)COLORED, null, () -> PointedEntityScreen.this.config.colored, v -> {
                PointedEntityScreen.this.config.colored = v;
            });
            this.addBooleanOption((class_2561)STATS_BARS, null, () -> PointedEntityScreen.this.config.statsBars.enabled, v -> {
                PointedEntityScreen.this.config.statsBars.enabled = v;
            });
            this.addBooleanOption((class_2561)EQUIPMENT, (class_2561)EQUIPMENT_TIP, () -> PointedEntityScreen.this.config.equipment, v -> {
                PointedEntityScreen.this.config.equipment = v;
            });
            this.addBooleanOption((class_2561)PLAYERS_EQUIPMENT, (class_2561)PLAYERS_EQUIPMENT_TIP, () -> PointedEntityScreen.this.config.equipmentPlayers, v -> {
                PointedEntityScreen.this.config.equipmentPlayers = v;
            });
            this.addBooleanOption((class_2561)HEALTH_PLATE, (class_2561)HEALTH_PLATE_TIP, () -> PointedEntityScreen.this.config.healthPlate, v -> {
                PointedEntityScreen.this.config.healthPlate = v;
            });
            this.addCategoryHeader((class_2561)PROPERTIES_HEADER, true, () -> PointedEntityScreen.this.config.properties, v -> {
                PointedEntityScreen.this.config.properties = v;
            }, () -> PointedEntityScreen.this.config.propertiesStyle, s -> {
                PointedEntityScreen.this.config.propertiesStyle = s;
            });
        }

        public void addEntriesAndFixScroll() {
            double currentScroll = this.method_44387();
            this.method_25339();
            this.addEntries();
            this.method_65506();
            double maxScroll = this.method_44390();
            this.method_44382(Math.min(currentScroll, maxScroll));
        }

        public void method_57713(class_332 context) {
        }

        public void method_57715(class_332 context) {
        }

        private void addCategoryHeader(class_2561 categoryName, boolean moreButtons, BooleanSupplier getter, Consumer<Boolean> setter, Supplier<String> styleGetter, Consumer<String> styleSetter) {
            this.method_25321((class_350.class_351)new CategoryHeaderEntry(categoryName, moreButtons, getter, setter, styleGetter, styleSetter));
        }

        private void addBooleanOption(class_2561 label, @Nullable class_2561 tooltip, BooleanSupplier getter, Consumer<Boolean> setter) {
            this.method_25321((class_350.class_351)new BooleanOptionEntry(label, tooltip, getter, setter));
        }

        public class CategoryHeaderEntry
        extends OptionEntry {
            private final class_2561 categoryName;
            private final boolean moreButtons;
            private final ButtonWidgetToggle toggleButton;
            @Nullable
            private final ButtonWidgetSmall hudStyleButton;

            public CategoryHeaderEntry(class_2561 categoryName, BooleanSupplier getter, Consumer<Boolean> setter) {
                this(categoryName, false, getter, setter, null, null);
            }

            public CategoryHeaderEntry(class_2561 categoryName, boolean moreButtons, BooleanSupplier getter, Consumer<Boolean> setter, Supplier<String> styleGetter, Consumer<String> styleSetter) {
                super(OptionsListWidget.this);
                this.categoryName = categoryName;
                this.moreButtons = moreButtons;
                this.toggleButton = this.createToggleButton(getter, setter);
                this.hudStyleButton = moreButtons ? this.createHudStyleButton(styleGetter, styleSetter) : null;
            }

            private ButtonWidgetToggle createToggleButton(BooleanSupplier getter, Consumer<Boolean> setter) {
                return new ButtonWidgetToggle(0, 0, getter.getAsBoolean(), btn -> {
                    boolean newValue = !getter.getAsBoolean();
                    setter.accept(newValue);
                    PointedEntityScreen.this.optionsListWidget.addEntriesAndFixScroll();
                });
            }

            private ButtonWidgetSmall createHudStyleButton(Supplier<String> getter, Consumer<String> setter) {
                Supplier<class_2561> textureLabel = () -> TextUtils.translate((String)getter.get(), class_124.field_1060);
                return ScreenUtils.textureTypeButton(0, 0, textureLabel, btn -> {
                    String newStyle = switch ((String)getter.get()) {
                        case "essgui" -> "essgui_bless";
                        case "essgui_bless" -> "tooltip";
                        default -> "essgui";
                    };
                    setter.accept(newStyle);
                });
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
                context.method_27534(PointedEntityScreen.this.field_22793, this.categoryName, x + entryWidth / 2, y + 6, -1);
                int toggleX = x + entryWidth - 20;
                this.toggleButton.method_46421(toggleX);
                this.toggleButton.method_46419(y);
                this.toggleButton.method_25394(context, mouseX, mouseY, tickProgress);
                if (this.moreButtons && this.hudStyleButton != null) {
                    int textureX = toggleX - 21;
                    this.hudStyleButton.method_46421(textureX);
                    this.hudStyleButton.method_46419(y);
                    this.hudStyleButton.method_25394(context, mouseX, mouseY, tickProgress);
                }
            }

            public List<? extends class_364> method_25396() {
                return this.hudStyleButton != null ? List.of(this.toggleButton, this.hudStyleButton) : List.of(this.toggleButton);
            }

            public List<? extends class_6379> method_37025() {
                return this.hudStyleButton != null ? List.of(this.toggleButton, this.hudStyleButton) : List.of(this.toggleButton);
            }
        }

        public class BooleanOptionEntry
        extends OptionEntry {
            private final class_2561 optionName;
            @Nullable
            private final class_2561 tooltip;
            private final ButtonWidgetToggle toggleButton;

            public BooleanOptionEntry(@Nullable class_2561 label, class_2561 tooltip, BooleanSupplier getter, Consumer<Boolean> setter) {
                super(OptionsListWidget.this);
                this.optionName = label;
                this.tooltip = tooltip;
                this.toggleButton = new ButtonWidgetToggle(0, 0, getter.getAsBoolean(), button -> {
                    setter.accept(!getter.getAsBoolean());
                    PointedEntityScreen.this.optionsListWidget.addEntriesAndFixScroll();
                });
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
                context.method_27535(PointedEntityScreen.this.field_22793, this.optionName, x + 2, y + 6, -1);
                int toggleX = x + entryWidth - 20;
                this.toggleButton.method_46421(toggleX);
                this.toggleButton.method_46419(y);
                this.toggleButton.method_25394(context, mouseX, mouseY, tickProgress);
                if (hovered && this.tooltip != null) {
                    List wrappedTooltip = PointedEntityScreen.this.field_22793.method_1728((class_5348)this.tooltip, 200);
                    context.method_71274(wrappedTooltip, mouseX, mouseY);
                }
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.toggleButton);
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.toggleButton);
            }
        }

        public abstract class OptionEntry
        extends class_4265.class_4266<OptionEntry> {
            public OptionEntry(OptionsListWidget this$1) {
            }
        }
    }
}

