/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.screen.options;

import java.util.List;
import java.util.function.Consumer;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.gui.screen.ScreenBase;
import lordrius.essentialgui.gui.widgets.TextWidget;
import lordrius.essentialgui.util.ScreenUtils;
import lordrius.essentialgui.util.TextUtils;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import org.jetbrains.annotations.Nullable;

public class SettingsScreen
extends ScreenBase {
    private final ConfigData.ClientPlayerWorld clientPlayer;
    private final ConfigData.PlayerWarningArea warning;
    private final ConfigData.PlayerEquipment equipment;
    private final ConfigData.VanillaHudChanges vanilla;
    private final ConfigData.Settings settings;
    private OptionsListWidget optionsListWidget;
    private class_8132 layout;

    public SettingsScreen(class_437 parent) {
        super(parent, (class_2561)TextUtils.translate("screen.options.settings.title"));
        this.clientPlayer = Data.cfg.client;
        this.warning = Data.cfg.warning;
        this.equipment = Data.cfg.equipment;
        this.vanilla = Data.cfg.vanilla;
        this.settings = Data.cfg.settings;
    }

    @Override
    public void method_25426() {
        this.colorPickerButton();
        this.doneButton();
        this.layout = new class_8132((class_437)this, 61, 33);
        this.optionsListWidget = new OptionsListWidget();
        this.layout.method_48999((class_8021)this.optionsListWidget);
        this.method_37063((class_364)this.optionsListWidget);
        this.layout.method_48222();
    }

    public class OptionsListWidget
    extends class_4265<OptionEntry> {
        public OptionsListWidget() {
            super(SettingsScreen.this.field_22787, SettingsScreen.this.field_22789, SettingsScreen.this.layout.method_57727() + 28, SettingsScreen.this.layout.method_48998(), 22);
            this.addEntries();
        }

        public int method_25322() {
            return 260;
        }

        public int method_25342() {
            return (this.field_22758 - this.method_25322()) / 2;
        }

        public void addEntries() {
            this.method_25339();
            String key = "screen.options.settings.";
            class_5250 CLIENT_HEADER = TextUtils.translate(key + "client");
            class_5250 WARNING_AREA_HEADER = TextUtils.translate(key + "warning");
            class_5250 QUIVER_HEADER = TextUtils.translate(key + "equipment.quiver");
            class_5250 ITEM_STOCK_HEADER = TextUtils.translate(key + "equipment.item_stock");
            class_5250 SECTIONS_COLORS_HEADER = TextUtils.translate(key + "sections");
            class_5250 BLOCK_OUTLINE_HEADER = TextUtils.translate(key + "block_outline");
            class_5250 TOOLTIPS_HEADER = TextUtils.translate(key + "tooltips");
            class_5250 MISC_HEADER = TextUtils.translate(key + "misc");
            class_5250 CLIENT_PREFIX_COLOR = TextUtils.translate(key + "client.prefix_color");
            class_5250 WARNING_TEXT_COLOR = TextUtils.translate(key + "warning.text_color");
            class_5250 WARNING_BED_ITEM = TextUtils.translate(key + "warning.bed_item");
            class_5250 QUIVER_EMPTY = TextUtils.translate(key + "equipment.quiver.text_color.empty");
            class_5250 QUIVER_INFINITE = TextUtils.translate(key + "equipment.quiver.text_color.infinite");
            class_5250 QUIVER_LOW = TextUtils.translate(key + "equipment.quiver.text_color.low");
            class_5250 QUIVER_PLENTY = TextUtils.translate(key + "equipment.quiver.text_color.plenty");
            class_5250 ITEM_STOCK_ITEM = TextUtils.translate(key + "equipment.item_stock.item");
            class_5250 ITEM_STOCK_COLOR = TextUtils.translate(key + "equipment.item_stock.text_color");
            class_5250 SECTIONS_BACKGROUND = TextUtils.translate(key + "sections.background");
            class_5250 SECTIONS_BACKGROUND_TIP = TextUtils.translate("screen.default", "#000000B0");
            class_5250 SECTIONS_BORDERS = TextUtils.translate(key + "sections.borders");
            class_5250 SECTIONS_BORDERS_TIP = TextUtils.translate("screen.default", "#000000");
            class_5250 BLOCK_OUTLINE_COLOR = TextUtils.translate(key + "block_outline.color");
            class_5250 BLOCK_OUTLINE_TIP = TextUtils.translate(key + "block_outline.tooltip", "#FFFFFFCC", "#00000073");
            class_5250 BLOCK_OUTLINE_THICKNESS = TextUtils.translate(key + "block_outline.thickness");
            class_5250 BLOCK_OUTLINE_THICKNESS_TIP = TextUtils.translate("screen.default", "2");
            class_5250 BLOCK_TAG = TextUtils.translate(key + "tooltips.block");
            class_5250 ENTITY_TAG = TextUtils.translate(key + "tooltips.entity");
            class_5250 ITEM_TAG = TextUtils.translate(key + "tooltips.item");
            class_5250 TAG_TIP = TextUtils.translate("screen.default", "#00DBFF");
            class_5250 SEPARATOR = TextUtils.translate(key + "misc.separator");
            this.addStaticHeader((class_2561)CLIENT_HEADER);
            this.addTextField((class_2561)CLIENT_PREFIX_COLOR, SettingsScreen.this.clientPlayer.prefixColor, f -> {
                SettingsScreen.this.clientPlayer.prefixColor = f;
            });
            this.addStaticHeader((class_2561)WARNING_AREA_HEADER);
            this.addTextField((class_2561)WARNING_TEXT_COLOR, SettingsScreen.this.warning.textColor, f -> {
                SettingsScreen.this.warning.textColor = f;
            });
            this.addTextField((class_2561)WARNING_BED_ITEM, true, SettingsScreen.this.warning.bedItem, (String f) -> {
                SettingsScreen.this.warning.bedItem = f;
            });
            this.addStaticHeader((class_2561)QUIVER_HEADER);
            this.addTextField((class_2561)QUIVER_EMPTY, SettingsScreen.this.equipment.quiver.colorEmpty, f -> {
                SettingsScreen.this.equipment.quiver.colorEmpty = f;
            });
            this.addTextField((class_2561)QUIVER_INFINITE, SettingsScreen.this.equipment.quiver.colorInfinite, f -> {
                SettingsScreen.this.equipment.quiver.colorInfinite = f;
            });
            this.addTextField((class_2561)QUIVER_LOW, SettingsScreen.this.equipment.quiver.colorLow, f -> {
                SettingsScreen.this.equipment.quiver.colorLow = f;
            });
            this.addTextField((class_2561)QUIVER_PLENTY, SettingsScreen.this.equipment.quiver.colorPlenty, f -> {
                SettingsScreen.this.equipment.quiver.colorPlenty = f;
            });
            this.addStaticHeader((class_2561)ITEM_STOCK_HEADER);
            this.addTextField((class_2561)ITEM_STOCK_ITEM, true, SettingsScreen.this.equipment.stock.item, (String f) -> {
                SettingsScreen.this.equipment.stock.item = f;
            });
            this.addTextField((class_2561)ITEM_STOCK_COLOR, SettingsScreen.this.equipment.stock.textColor, f -> {
                SettingsScreen.this.equipment.stock.textColor = f;
            });
            this.addStaticHeader((class_2561)SECTIONS_COLORS_HEADER);
            this.addColorField((class_2561)SECTIONS_BACKGROUND, (class_2561)SECTIONS_BACKGROUND_TIP, SettingsScreen.this.settings.sectionsBackgroundColor, f -> {
                SettingsScreen.this.settings.sectionsBackgroundColor = f;
            });
            this.addColorField((class_2561)SECTIONS_BORDERS, (class_2561)SECTIONS_BORDERS_TIP, SettingsScreen.this.settings.sectionsBorderColor, f -> {
                SettingsScreen.this.settings.sectionsBorderColor = f;
            });
            this.addStaticHeader((class_2561)BLOCK_OUTLINE_HEADER);
            this.addColorField((class_2561)BLOCK_OUTLINE_COLOR, (class_2561)BLOCK_OUTLINE_TIP, SettingsScreen.this.vanilla.blockOutline.color, f -> {
                SettingsScreen.this.vanilla.blockOutline.color = f;
            });
            this.addNumericField((class_2561)BLOCK_OUTLINE_THICKNESS, (class_2561)BLOCK_OUTLINE_THICKNESS_TIP, SettingsScreen.this.vanilla.blockOutline.thickness, f -> {
                SettingsScreen.this.vanilla.blockOutline.thickness = f;
            });
            this.addStaticHeader((class_2561)TOOLTIPS_HEADER);
            this.addColorField((class_2561)BLOCK_TAG, (class_2561)TAG_TIP, SettingsScreen.this.settings.blockPropertiesTagColor, f -> {
                SettingsScreen.this.settings.blockPropertiesTagColor = f;
            });
            this.addColorField((class_2561)ENTITY_TAG, (class_2561)TAG_TIP, SettingsScreen.this.settings.entityPropertiesTagColor, f -> {
                SettingsScreen.this.settings.entityPropertiesTagColor = f;
            });
            this.addColorField((class_2561)ITEM_TAG, (class_2561)TAG_TIP, SettingsScreen.this.settings.itemTooltipsTagColor, f -> {
                SettingsScreen.this.settings.itemTooltipsTagColor = f;
            });
            this.addStaticHeader((class_2561)MISC_HEADER);
            this.addTextField((class_2561)SEPARATOR, SettingsScreen.this.settings.separator, f -> {
                SettingsScreen.this.settings.separator = f;
            });
        }

        public void method_57713(class_332 context) {
        }

        public void method_57715(class_332 context) {
        }

        private void addStaticHeader(class_2561 header) {
            this.method_25321((class_350.class_351)new StaticHeaderEntry(header));
        }

        private void addColorField(class_2561 label, @Nullable class_2561 tooltip, String initialText, Consumer<String> onChange) {
            this.method_25321((class_350.class_351)new ColorFieldEntry(label, tooltip, initialText, onChange));
        }

        private void addNumericField(class_2561 label, class_2561 tooltip, int initialValue, Consumer<Integer> onChange) {
            this.method_25321((class_350.class_351)new NumericFieldEntry(label, tooltip, initialValue, onChange));
        }

        private void addTextField(class_2561 label, boolean drawItemStack, String initialText, Consumer<String> onChange) {
            this.addTextField(label, (class_2561)class_2561.method_43473(), drawItemStack, initialText, onChange);
        }

        private void addTextField(class_2561 label, class_2561 tooltip, boolean drawItemStack, String initialText, Consumer<String> onChange) {
            this.method_25321((class_350.class_351)new TextFieldEntry(label, tooltip, drawItemStack, initialText, onChange));
        }

        private void addTextField(class_2561 label, String initialText, Consumer<String> onChange) {
            this.addTextField(label, (class_2561)class_2561.method_43473(), initialText, onChange);
        }

        private void addTextField(class_2561 label, class_2561 tooltip, String initialText, Consumer<String> onChange) {
            this.method_25321((class_350.class_351)new TextFieldEntry(label, tooltip, initialText, onChange));
        }

        public class StaticHeaderEntry
        extends OptionEntry {
            private final class_2561 categoryName;

            public StaticHeaderEntry(class_2561 categoryName) {
                super(OptionsListWidget.this);
                this.categoryName = categoryName;
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
                context.method_27534(SettingsScreen.this.field_22793, this.categoryName, x + entryWidth / 2, y + 4, -1);
            }

            public List<? extends class_364> method_25396() {
                return List.of();
            }

            public List<? extends class_6379> method_37025() {
                return List.of();
            }
        }

        public class ColorFieldEntry
        extends OptionEntry {
            private final class_2561 label;
            private final TextWidget textWidget;

            public ColorFieldEntry(@Nullable class_2561 label, class_2561 tooltip, String initialText, Consumer<String> onChange) {
                super(OptionsListWidget.this);
                this.label = label;
                this.textWidget = ScreenUtils.fieldColor(0, 0, null, tooltip, true, false, initialText, onChange);
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
                context.method_27535(SettingsScreen.this.field_22793, this.label, x + 2, y + 4, -1);
                this.textWidget.method_46421(x + entryWidth - 85);
                this.textWidget.method_46419(y);
                this.textWidget.method_25394(context, mouseX, mouseY, tickProgress);
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.textWidget);
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.textWidget);
            }
        }

        public class NumericFieldEntry
        extends OptionEntry {
            private final class_2561 label;
            private final TextWidget textWidget;

            public NumericFieldEntry(class_2561 label, class_2561 tooltip, int initialValue, Consumer<Integer> onChange) {
                super(OptionsListWidget.this);
                this.label = label;
                this.textWidget = ScreenUtils.fieldNumeric(0, 0, null, tooltip, initialValue, onChange);
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
                context.method_27535(SettingsScreen.this.field_22793, this.label, x + 2, y + 4, -1);
                this.textWidget.method_25358(30);
                this.textWidget.method_46421(x + entryWidth - 45);
                this.textWidget.method_46419(y);
                this.textWidget.method_25394(context, mouseX, mouseY, tickProgress);
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.textWidget);
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.textWidget);
            }
        }

        public class TextFieldEntry
        extends OptionEntry {
            private final class_2561 label;
            private final boolean drawItemStack;
            private final TextWidget textWidget;

            public TextFieldEntry(class_2561 label, class_2561 tooltip, String initialText, Consumer<String> onChange) {
                this(label, tooltip, false, initialText, onChange);
            }

            public TextFieldEntry(class_2561 label, class_2561 tooltip, boolean drawItemStack, String initialText, Consumer<String> onChange) {
                super(OptionsListWidget.this);
                this.label = label;
                this.drawItemStack = drawItemStack;
                this.textWidget = ScreenUtils.field(0, 0, null, tooltip, initialText, onChange);
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
                context.method_27535(SettingsScreen.this.field_22793, this.label, x + 2, y + 4, -1);
                int xPos = this.drawItemStack ? x + entryWidth - 115 : x + entryWidth - 85;
                this.textWidget.method_46421(xPos);
                this.textWidget.method_46419(y);
                this.textWidget.method_25394(context, mouseX, mouseY, tickProgress);
                if (this.drawItemStack) {
                    this.textWidget.method_25358(100);
                    if (!this.method_25370()) {
                        this.textWidget.method_1870(false);
                    }
                    class_1799 stack = Utils.getStackFromString(this.textWidget.method_1882());
                    context.method_51427(stack, this.textWidget.method_46426() + this.textWidget.method_25368() + 3, this.textWidget.method_46427());
                }
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.textWidget);
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.textWidget);
            }
        }

        public abstract class OptionEntry
        extends class_4265.class_4266<OptionEntry> {
            public OptionEntry(OptionsListWidget this$1) {
            }
        }
    }
}

