/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.screen.vanilla;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.gui.screen.ScreenBase;
import lordrius.essentialgui.gui.widgets.FloatWidget;
import lordrius.essentialgui.util.TextUtils;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ParticlesBehaviorScreen
extends ScreenBase {
    private final ConfigData.VanillaHudChanges config;
    private final Supplier<class_2561> CUSTOM_BEHAVIOR;
    private final Supplier<class_2561> MORE_WHEN_RAIN;
    private final List<String> PARTICLE_TYPES;
    private int widgetsX;
    private int widgetsY;

    public ParticlesBehaviorScreen(class_437 parent) {
        super(parent, (class_2561)TextUtils.translate("screen.vanilla.leaves_particles.behavior.title"));
        this.config = Data.cfg.vanilla;
        this.CUSTOM_BEHAVIOR = () -> TextUtils.translate("screen.custom_behavior").method_10852(this.config.leaf.customBehavior ? ON_TEXT : OFF_TEXT);
        this.MORE_WHEN_RAIN = () -> TextUtils.translate("screen.vanilla.leaves_particles.behavior.more_when_rain").method_10852(this.config.leaf.moreWhenRain ? ON_TEXT : OFF_TEXT);
        this.PARTICLE_TYPES = Arrays.asList("acacia", "azalea", "birch", "cherry", "darkOak", "floweringAzalea", "jungle", "mangrove", "oak", "pale", "spruce");
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.toggleButtonBig(this.field_22789 / 2 - 100, this.buttonsY() - 24, this.CUSTOM_BEHAVIOR, () -> this.config.leaf.customBehavior, v -> {
            this.config.leaf.customBehavior = v;
            this.method_37067();
            this.method_25426();
        });
        this.toggleButtonBig(this.field_22789 / 2 - 100, this.buttonsY(), this.MORE_WHEN_RAIN, () -> this.config.leaf.moreWhenRain, v -> {
            this.config.leaf.moreWhenRain = v;
        });
        this.widgetsX = this.field_22789 / 2 - 160;
        this.widgetsY = this.buttonsY() + 50;
        int itemsPerColumn = 4;
        int columnWidth = 140;
        int firstColumnX = this.widgetsX;
        int secondColumnX = this.widgetsX + columnWidth;
        int thirdColumnX = this.widgetsX + 2 * columnWidth;
        int yOffsetFirst = 0;
        int yOffsetSecond = 0;
        int yOffsetThird = 0;
        if (this.config.leaf.customBehavior) {
            for (int i = 0; i < this.PARTICLE_TYPES.size(); ++i) {
                int yOffset;
                int x;
                String type = this.PARTICLE_TYPES.get(i);
                if (i < itemsPerColumn) {
                    x = firstColumnX;
                    yOffset = yOffsetFirst;
                    yOffsetFirst += 32;
                } else if (i < 2 * itemsPerColumn) {
                    x = secondColumnX;
                    yOffset = yOffsetSecond;
                    yOffsetSecond += 32;
                } else {
                    x = thirdColumnX;
                    yOffset = yOffsetThird;
                    yOffsetThird += 32;
                }
                this.addFloatWidgets(type, x, this.widgetsY + yOffset);
            }
        }
    }

    private void addFloatWidgets(String type, int x, int y) {
        class_5250 CLEAR = TextUtils.translate("screen.vanilla.leaves_particles.behavior.chance_clear");
        class_5250 RAIN = TextUtils.translate("screen.vanilla.leaves_particles.behavior.chance_rain");
        FloatWidget clearWidget = (FloatWidget)this.method_37063((class_364)new FloatWidget(x, y, new class_1799((class_1935)this.getItem(type)), (class_2561)CLEAR));
        String fieldPathClear = "leaf." + type + "ClearChance";
        clearWidget.method_1852(Float.toString(this.getConfigValue(this.config, fieldPathClear)));
        clearWidget.method_1863(field -> {
            if (Utils.isParsableToFloat(field)) {
                this.setConfigValue(this.config, fieldPathClear, Float.parseFloat(field));
            }
        });
        if (this.config.leaf.moreWhenRain) {
            FloatWidget rainWidget = (FloatWidget)this.method_37063((class_364)new FloatWidget(x + 38, y, (class_2561)RAIN));
            String fieldPathRain = "leaf." + type + "RainChance";
            rainWidget.method_1852(Float.toString(this.getConfigValue(this.config, fieldPathRain)));
            rainWidget.method_1863(field -> {
                if (Utils.isParsableToFloat(field)) {
                    this.setConfigValue(this.config, fieldPathRain, Float.parseFloat(field));
                }
            });
        }
    }

    private float getConfigValue(Object rootInstance, String fieldPath) {
        try {
            String[] parts = fieldPath.split("\\.");
            Object current = rootInstance;
            for (int i = 0; i < parts.length - 1; ++i) {
                Field subField = current.getClass().getDeclaredField(parts[i]);
                subField.setAccessible(true);
                current = subField.get(current);
            }
            Field targetField = current.getClass().getDeclaredField(parts[parts.length - 1]);
            targetField.setAccessible(true);
            return targetField.getFloat(current);
        }
        catch (Exception e) {
            System.err.println("Error while accessing: " + fieldPath);
            e.printStackTrace();
            return 0.0f;
        }
    }

    private void setConfigValue(Object rootInstance, String fieldPath, float value) {
        try {
            String[] parts = fieldPath.split("\\.");
            Object current = rootInstance;
            for (int i = 0; i < parts.length - 1; ++i) {
                Field subField = current.getClass().getDeclaredField(parts[i]);
                subField.setAccessible(true);
                current = subField.get(current);
            }
            Field targetField = current.getClass().getDeclaredField(parts[parts.length - 1]);
            targetField.setAccessible(true);
            targetField.setFloat(current, value);
        }
        catch (Exception e) {
            System.err.println("Error while modifying: " + fieldPath);
            e.printStackTrace();
        }
    }

    private class_1792 getItem(String type) {
        switch (type) {
            case "acacia": {
                return class_1802.field_17507;
            }
            case "azalea": {
                return class_1802.field_28648;
            }
            case "birch": {
                return class_1802.field_17505;
            }
            case "cherry": {
                return class_1802.field_42694;
            }
            case "darkOak": {
                return class_1802.field_17508;
            }
            case "flowerAzalea": {
                return class_1802.field_28649;
            }
            case "jungle": {
                return class_1802.field_17506;
            }
            case "mangrove": {
                return class_1802.field_37511;
            }
            case "oak": {
                return class_1802.field_17503;
            }
            case "pale": {
                return class_1802.field_54605;
            }
            case "spruce": {
                return class_1802.field_17504;
            }
        }
        return class_1802.field_17503;
    }
}

