/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.config;

import com.google.gson.annotations.SerializedName;

public class ConfigData {
    public Global global = new Global();
    @SerializedName(value="clientPlayerWorld")
    public ClientPlayerWorld client = new ClientPlayerWorld();
    @SerializedName(value="playerWarningArea")
    public PlayerWarningArea warning = new PlayerWarningArea();
    @SerializedName(value="pointedBlock")
    public PointedBlock block = new PointedBlock();
    @SerializedName(value="pointedEntity")
    public PointedEntity entity = new PointedEntity();
    @SerializedName(value="playerEquipment")
    public PlayerEquipment equipment = new PlayerEquipment();
    @SerializedName(value="biomeWeatherTime")
    public BiomeWeatherTime biome = new BiomeWeatherTime();
    @SerializedName(value="advancedItemTooltips")
    public AdvancedItemTooltips tooltips = new AdvancedItemTooltips();
    @SerializedName(value="vanillaHudChanges")
    public VanillaHudChanges vanilla = new VanillaHudChanges();
    @SerializedName(value="miscFeatures")
    public MiscFeatures misc = new MiscFeatures();
    public Settings settings = new Settings();

    public static class Global {
        public boolean enabled = true;
    }

    public static class ClientPlayerWorld {
        public boolean enabled = true;
        public int x = -1;
        public int y = -1;
        public String style = "debug";
        public String prefixStyle = "screen.hud_prefix_style.complete";
        public String prefixColor = "\u00a78";
        public boolean colored = true;
        @SerializedName(value="performance")
        public ClientPerformanceInfo performance = new ClientPerformanceInfo();
        @SerializedName(value="position")
        public PlayerPositionInfo position = new PlayerPositionInfo();
        @SerializedName(value="world")
        public WorldInfo world = new WorldInfo();

        public static class ClientPerformanceInfo {
            public boolean enabled = true;
            public boolean fps = true;
            public boolean cpu = false;
            public boolean memory = false;
            public boolean latency = false;
            public boolean packets = false;
        }

        public static class PlayerPositionInfo {
            public boolean enabled = true;
            public boolean coords = true;
            public boolean coordsDim = false;
            public boolean chunk = false;
            public boolean chunkSlime = false;
            public boolean facing = false;
            public boolean facingAxis = true;
            public boolean rotation = false;
            public boolean light = false;
            public boolean speed = false;
        }

        public static class WorldInfo {
            public boolean enabled = true;
            public boolean biome = true;
            public boolean entities = false;
            public boolean entitiesBlock = false;
            public boolean time = true;
            public String timeStyle = "screen.time_style.24_hour";
            public boolean timeDays = true;
            public boolean days = false;
        }
    }

    public static class PlayerWarningArea {
        public boolean enabled = true;
        public String texture = "colored";
        public int statusX = -1;
        public int statusY = -1;
        public boolean equipment = true;
        public int equipmentX = -1;
        public int equipmentY = -1;
        public boolean awakeDays = true;
        public String bedItem = "minecraft:red_bed";
        public boolean health = true;
        public boolean hunger = true;
        public boolean oxygen = true;
        public boolean freeze = true;
        public boolean saturation = true;
        public String textColor = "\u00a7a";
        public OxygenBar oxygenBar = new OxygenBar();

        public static class OxygenBar {
            public boolean enabled = true;
            public int x = -1;
            public int y = -1;
            public int width = 120;
            public int height = 3;
        }
    }

    public static class PointedBlock {
        public boolean enabled = true;
        public boolean mainHud = true;
        public int x = -1;
        public int y = -1;
        public String style = "essgui_bless";
        public boolean render = true;
        public boolean name = true;
        public boolean coords = false;
        public boolean light = false;
        public boolean mature = false;
        public boolean modid = false;
        public boolean colored = true;
        public boolean properties = true;
        public String propertiesStyle = "essgui_bless";
        public boolean icons = true;
        @SerializedName(value="breakingProgressBar")
        public BreakingProgressBar breakingBar = new BreakingProgressBar();

        public static class BreakingProgressBar {
            public boolean enabled = true;
            public String style = "screen.hud_style.rectangular";
            public boolean value = false;
            public boolean shadow = false;
            public String baseColor = "#00BE00";
            public String shadowColor = "#007800";
            public int width = 50;
            public int height = 3;
        }
    }

    public static class PointedEntity {
        public boolean enabled = true;
        public boolean mainHud = true;
        public boolean armorStand = true;
        public int x = -1;
        public int y = -1;
        public String style = "essgui_bless";
        public boolean skin = true;
        public boolean name = true;
        public boolean coords = false;
        public boolean modid = false;
        public boolean colored = true;
        public boolean equipment = true;
        public boolean equipmentPlayers = true;
        public boolean properties = true;
        public String propertiesStyle = "essgui_bless";
        public boolean healthPlate = false;
        public StatsBars statsBars = new StatsBars();

        public static class StatsBars {
            public boolean enabled = true;
            public String style = "screen.hud_style.rectangular";
            public boolean icons = false;
            public boolean values = false;
            public boolean shadow = false;
            public int width = 50;
            public int height = 3;
            public String healthBaseColor = "#C10000";
            public String healthShadowColor = "#7C0000";
            public String oxygenBaseColor = "#017AD1";
            public String oxygenShadowColor = "#004678";
        }
    }

    public static class PlayerEquipment {
        public boolean enabled = true;
        public boolean foodStats = true;
        public boolean shulkerBox = true;
        public boolean bundle = true;
        public Quiver quiver = new Quiver();
        @SerializedName(value="itemStock")
        public ItemStock stock = new ItemStock();
        @SerializedName(value="onScreenEquipment")
        public OnScreenEquipment screen = new OnScreenEquipment();
        @SerializedName(value="playerStats")
        public PlayerStats stats = new PlayerStats();

        public static class Quiver {
            public boolean enabled = true;
            public int x = -1;
            public int y = -1;
            public String texture = "essgui";
            public String colorEmpty = "\u00a7c";
            public String colorInfinite = "\u00a7a\u221e";
            public String colorLow = "\u00a76";
            public String colorPlenty = "\u00a7a";
        }

        public static class ItemStock {
            public boolean enabled = false;
            public int x = -1;
            public int y = -1;
            public String texture = "vanilla";
            public String item = "minecraft:bundle";
            public String textColor = "\u00a7a";
        }

        public static class OnScreenEquipment {
            public boolean enabled = true;
            public int x = -1;
            public int y = -1;
            public String texture = "essgui";
            public boolean durability = true;
            public String durabilityStyle = "screen.hud_item_durability.style.background_borderless";
            public String durabilityFormat = "screen.hud_item_durability.format.damage";
        }

        public static class PlayerStats {
            public boolean enabled = true;
            public String texture = "screen.hud_texture_type.dark";
        }
    }

    public static class BiomeWeatherTime {
        public boolean enabled = true;
        public int x = -1;
        public int y = -1;
        public String texture = "essgui";
        public boolean time = false;
        public String timeStyle = "screen.time_style.24_hour";
    }

    public static class AdvancedItemTooltips {
        public boolean enabled = true;
        public boolean lodestoneCompass = true;
        public boolean salmonBucket = true;
        public boolean axolotlBucket = true;
        public boolean recoveryCompass = true;
        public boolean tropicalFishBucket = true;
        public boolean books = true;
        public boolean milkBucket = true;
        public boolean turtleHelmet = true;
        public boolean maps = true;
        public boolean fuelStats = true;
        public boolean discs = true;
        public boolean decoratedPots = true;
        public Damageables damageables = new Damageables();
        @SerializedName(value="foodStats")
        public FoodStats food = new FoodStats();
        @SerializedName(value="blockNbt")
        public BlockNbt nbt = new BlockNbt();
        @SerializedName(value="enhancedPatterns")
        public EnhancedPatterns patterns = new EnhancedPatterns();

        public static class Damageables {
            public boolean enabled = true;
            public boolean durability = true;
            public boolean durabilityColored = true;
            public boolean durabilityPercent = false;
            public boolean durabilityAlways = true;
            public boolean penalty = true;
            public boolean comparison = true;
            public boolean betterTooltip = false;
        }

        public static class FoodStats {
            public boolean enabled = true;
            public boolean simpleStyle = false;
            public boolean playerHunger = false;
            public boolean foodEffects = true;
            public boolean stewEffects = true;
        }

        public static class BlockNbt {
            public boolean enabled = true;
            public boolean beehive = true;
            public boolean lectern = true;
            public boolean jukebox = true;
            public boolean sign = true;
            public boolean beacon = true;
            public boolean spawner = true;
            public boolean containerItems = true;
        }

        public static class EnhancedPatterns {
            public boolean enabled = true;
            public boolean hideShieldPatterns = true;
            public boolean internalNames = true;
        }
    }

    public static class VanillaHudChanges {
        public boolean enabled = true;
        public boolean pumpkinOverlay = false;
        public boolean vigneteOverlay = false;
        public boolean witherDarkenSky = true;
        public boolean rainParticles = true;
        public boolean otherParticles = true;
        public boolean mountHealthCreative = false;
        public boolean signTextOutline = true;
        public boolean improvedHeldItemTooltip = true;
        public String heldItemTooltipStyle = "screen.hud_style.rounded";
        public boolean improvedOverlayMessage = true;
        public String overlayMessageStyle = "screen.hud_style.rounded";
        @SerializedName(value="fallingParticles")
        public LeavesParticles leaf = new LeavesParticles();
        @SerializedName(value="blockOutlineCustomization")
        public BlockOutline blockOutline = new BlockOutline();
        @SerializedName(value="crosshairCustomization")
        public Crosshair crosshair = new Crosshair();
        @SerializedName(value="playerStatusEffects")
        public StatusEffects effects = new StatusEffects();

        public static class LeavesParticles {
            public boolean enabled = true;
            public boolean customBehavior = true;
            public boolean moreWhenRain = true;
            public float acaciaClearChance = 0.003f;
            public float acaciaRainChance = 0.008f;
            public float azaleaClearChance = 0.003f;
            public float azaleaRainChance = 0.008f;
            public float birchClearChance = 0.003f;
            public float birchRainChance = 0.008f;
            public float cherryClearChance = 0.003f;
            public float cherryRainChance = 0.008f;
            public float darkOakClearChance = 0.003f;
            public float darkOakRainChance = 0.008f;
            public float floweringAzaleaClearChance = 0.003f;
            public float floweringAzaleaRainChance = 0.008f;
            public float jungleClearChance = 0.003f;
            public float jungleRainChance = 0.008f;
            public float mangroveClearChance = 0.003f;
            public float mangroveRainChance = 0.008f;
            public float oakClearChance = 0.003f;
            public float oakRainChance = 0.008f;
            public float paleClearChance = 0.003f;
            public float paleRainChance = 0.008f;
            public float spruceClearChance = 0.003f;
            public float spruceRainChance = 0.008f;
        }

        public static class BlockOutline {
            public boolean custom = true;
            public String color = "#FFFFFFCC";
            public int thickness = 2;
        }

        public static class Crosshair {
            public boolean custom = true;
            public boolean show = true;
            public int size = 15;
            public String color = "#FFFFFF";
            public boolean lowHealth = true;
            public String lowHealthColor = "#FF0000";
            public boolean outline = false;
            public String outlineColor = "#000000";
        }

        public static class StatusEffects {
            public boolean enabled = true;
            public boolean custom = true;
            public int x = -1;
            public int y = -1;
            public String texture = "colored";
            public boolean duration = true;
            public boolean durationColored = true;
            public boolean amplifier = true;
        }
    }

    public static class MiscFeatures {
        public boolean enabled = true;
        public boolean nightVision = true;
        public boolean smoothLighting = true;
        public boolean zoom = true;
        public boolean gamma = true;
        public boolean worldLoadingBar = true;
        @SerializedName(value="loadedEntitiesScreen")
        public DebugEntities debugEntities = new DebugEntities();
        public FurnaceStats furnaceStats = new FurnaceStats();
        @SerializedName(value="cropsReadyIndicator")
        public CropsReadyIndicator cropsReady = new CropsReadyIndicator();
        @SerializedName(value="blockLightOverlay")
        public BlockLightOverlay blockOverlay = new BlockLightOverlay();

        public static class DebugEntities {
            public boolean enabled = true;
            public String sortStyle = "screen.sort.alphabetically";
            public boolean tooltip = true;
        }

        public static class FurnaceStats {
            public boolean enabled = true;
            public String texture = "screen.hud_texture_type.vanilla";
        }

        public static class CropsReadyIndicator {
            public boolean enabled = false;
            public boolean item = true;
            public boolean bounce = true;
            public boolean particles = true;
            public int radius = 16;
        }

        public static class BlockLightOverlay {
            public boolean enabled = false;
            public int radius = 16;
            public String color = "#FF0000";
        }
    }

    public static class Settings {
        public String sectionsBackgroundColor = "#000000B0";
        public String sectionsBorderColor = "#000000";
        public String blockPropertiesTagColor = "#00DBFF";
        public String entityPropertiesTagColor = "#00DBFF";
        public String itemTooltipsTagColor = "#00DBFF";
        public String separator = "\u00a77\u2505\u2505\u2505\u2505";
    }
}

