/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.events;

import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.util.TextUtils;
import lordrius.essentialgui.util.Utils;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_10124;
import net.minecraft.class_10132;
import net.minecraft.class_10134;
import net.minecraft.class_10706;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1462;
import net.minecraft.class_1474;
import net.minecraft.class_1657;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1819;
import net.minecraft.class_1840;
import net.minecraft.class_1843;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2238;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2387;
import net.minecraft.class_2478;
import net.minecraft.class_2487;
import net.minecraft.class_2496;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2582;
import net.minecraft.class_2583;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3715;
import net.minecraft.class_4174;
import net.minecraft.class_4208;
import net.minecraft.class_437;
import net.minecraft.class_4481;
import net.minecraft.class_489;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5762;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_8168;
import net.minecraft.class_8526;
import net.minecraft.class_9209;
import net.minecraft.class_9275;
import net.minecraft.class_9279;
import net.minecraft.class_9288;
import net.minecraft.class_9291;
import net.minecraft.class_9292;
import net.minecraft.class_9295;
import net.minecraft.class_9298;
import net.minecraft.class_9301;
import net.minecraft.class_9302;
import net.minecraft.class_9307;
import net.minecraft.class_9334;
import net.minecraft.class_9793;
import org.jetbrains.annotations.Nullable;

public class ItemTooltip {
    private final ConfigData.AdvancedItemTooltips config;
    private class_310 client;
    private boolean isShiftDown;

    public ItemTooltip() {
        this.config = Data.cfg.tooltips;
        this.client = class_310.method_1551();
    }

    public void registerTooltips() {
        ItemTooltipCallback.EVENT.register((stack, context, type, lines) -> {
            if (!this.config.enabled) {
                return;
            }
            class_746 player = this.client.field_1724;
            this.isShiftDown = class_437.method_25442();
            class_1792 item = stack.method_7909();
            class_2248 block = class_2248.method_9503((class_1792)item);
            if (this.config.damageables.enabled) {
                boolean showPenaltyLevel;
                boolean showDurability = this.config.damageables.durability && stack.method_7963() && stack.method_7936() > 0 && (this.config.damageables.durabilityAlways || stack.method_7986());
                boolean bl = showPenaltyLevel = this.config.damageables.penalty && stack.method_31574(class_1802.field_8598) && Utils.getRepairCost(stack) > 0;
                if (showDurability || showPenaltyLevel) {
                    this.addDurabilityTooltip(stack, player, lines);
                }
            }
            if (this.config.lodestoneCompass && stack.method_31574(class_1802.field_8251)) {
                this.addLodestoneCompassTooltip(stack, lines);
            }
            if (this.config.recoveryCompass && stack.method_31574(class_1802.field_38747)) {
                this.addRecoveryCompassTooltip(stack, player, lines);
            }
            this.addBucketableTooltip(stack, lines);
            if (this.config.books && (stack.method_31574(class_1802.field_8674) || stack.method_31574(class_1802.field_8360))) {
                this.addEnhancedBooksTooltip(stack, lines);
            }
            if (this.config.milkBucket && stack.method_31574(class_1802.field_8103)) {
                this.addMilkBucketTooltip(stack, lines);
            }
            if (this.config.turtleHelmet && stack.method_31574(class_1802.field_8090)) {
                this.addTurtleHelmetTooltip(stack, lines);
            }
            if (this.config.maps && stack.method_31574(class_1802.field_8204)) {
                this.addFilledMapTooltip(stack, lines);
            }
            if (this.config.fuelStats && Utils.isFuel(stack) && !Utils.isToolOrArmor(stack) && this.client.field_1755 instanceof class_489) {
                this.addFuelStatsTooltip(stack, lines);
            }
            if (this.config.discs && Utils.isMusicDisc(stack) && Utils.isVanillaItem(item)) {
                this.addEnhancedDiscsTooltip(stack, lines);
            }
            if (this.config.patterns.enabled && (item instanceof class_1746 || item instanceof class_1819)) {
                this.addBannerTooltip(stack, lines);
            }
            if (this.config.decoratedPots && block instanceof class_8168) {
                this.addDecoratedPotTooltip(stack, lines);
            }
            if (this.config.food.enabled && !this.config.food.simpleStyle && Utils.isFood(stack) && player != null) {
                this.addFoodStatsTooltip(stack, player, lines);
            }
            if (this.config.nbt.enabled) {
                class_2487 compound;
                boolean needsBlockEntityData;
                boolean hasSpawnerNbt;
                boolean hasBeehive = this.config.nbt.beehive && block instanceof class_4481;
                boolean hasLecternBook = this.config.nbt.lectern && block instanceof class_3715;
                boolean hasJukeboxDisc = this.config.nbt.jukebox && block instanceof class_2387;
                boolean hasSignText = this.config.nbt.sign && block instanceof class_2478;
                boolean hasBeaconEffects = this.config.nbt.beacon && block instanceof class_2238;
                boolean bl = hasSpawnerNbt = this.config.nbt.spawner && block instanceof class_2496;
                if (hasBeehive) {
                    this.addBeehiveTooltip(stack, lines);
                }
                boolean bl2 = needsBlockEntityData = hasLecternBook || hasJukeboxDisc || hasSignText || hasBeaconEffects || hasSpawnerNbt;
                if (needsBlockEntityData && (compound = ((class_9279)stack.method_58695(class_9334.field_49611, (Object)class_9279.field_49302)).method_57461()) != null) {
                    if (hasLecternBook) {
                        this.addLecternTooltip(stack, compound, lines);
                    }
                    if (hasJukeboxDisc) {
                        this.addJukeboxTooltip(stack, compound, lines);
                    }
                    if (hasSignText) {
                        this.addSignTooltip(stack, compound, lines);
                    }
                    if (hasBeaconEffects) {
                        this.addBeaconTooltip(stack, compound, lines);
                    }
                    if (hasSpawnerNbt) {
                        this.addSpawnerTooltip(stack, compound, lines);
                    }
                }
            }
        });
    }

    private void addDurabilityTooltip(class_1799 stack, class_746 player, List<class_2561> lines) {
        boolean isBook = stack.method_31574(class_1802.field_8598);
        this.removeText(lines, "item.durability");
        String key = isBook ? "hud.item_tooltip.penalty" : "hud.item_tooltip.durability";
        class_2561 value = isBook ? Utils.getPenaltyLevel(stack) : Utils.getDurabilityTooltip(stack);
        this.insert(stack, lines, TextUtils.shiftedTooltip(key, value, lines, !isBook));
        if (this.config.damageables.comparison && player != null && Utils.isPlayerItemComparable(stack, (class_1657)player) && !this.isShiftDown) {
            class_5250 text = TextUtils.translate("hud.item_tooltip.item_comparison.tooltip");
            this.insert(stack, lines, List.of(TextUtils.separator(), text));
        }
    }

    private void addLodestoneCompassTooltip(class_1799 stack, List<class_2561> lines) {
        class_9291 tracker = (class_9291)stack.method_58694(class_9334.field_49614);
        if (tracker == null || tracker.comp_2402().isEmpty()) {
            return;
        }
        this.addCompassTooltip((class_4208)tracker.comp_2402().get(), stack, lines);
    }

    private void addRecoveryCompassTooltip(class_1799 stack, class_746 player, List<class_2561> lines) {
        if (player.method_43122().isEmpty()) {
            return;
        }
        this.addCompassTooltip((class_4208)player.method_43122().get(), stack, lines);
    }

    private void addCompassTooltip(class_4208 globalPos, class_1799 stack, List<class_2561> lines) {
        class_2338 pos = globalPos.comp_2208();
        class_5321 dimKey = globalPos.comp_2207();
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        String dimId = dimKey.method_29177().method_12832();
        String nonVanillaDim = "\u00a7d- " + TextUtils.capTitle(dimId.replace("_", " ")) + " -";
        class_5250 coordinates = TextUtils.write(String.format("\u00a7c%d \u00a72%d \u00a79%d", x, y, z));
        class_5250 dimension = class_2561.method_48321((String)("hud.item_tooltip.dimension." + dimId), (String)nonVanillaDim);
        this.insert(stack, lines, List.of(coordinates, dimension));
    }

    private void addBucketableTooltip(class_1799 stack, List<class_2561> lines) {
        class_2487 data = ((class_9279)stack.method_58695(class_9334.field_49610, (Object)class_9279.field_49302)).method_57461();
        if (data.method_33133()) {
            return;
        }
        ArrayList list = Lists.newArrayList();
        int healthRaw = Math.round(data.method_10583("Health").orElse(Float.valueOf(0.0f)).floatValue());
        if (this.config.salmonBucket && stack.method_31574(class_1802.field_8714)) {
            String sizeValue = ((class_1462.class_9869)stack.method_58694(class_9334.field_56149)).method_15434();
            String health = healthRaw + "/3";
            class_5250 size = TextUtils.translate("hud.entity.properties.salmon.variant." + sizeValue);
            list.add(TextUtils.tooltipLine("hud.entity.properties.health", (class_2561)class_2561.method_43470((String)health)));
            list.add(TextUtils.tooltipLine("hud.entity.properties.variant", (class_2561)size));
        } else if (this.config.axolotlBucket && stack.method_31574(class_1802.field_28354)) {
            boolean isBaby = data.method_10550("Age").orElse(0) < 0;
            String variantValue = ((class_5762.class_5767)stack.method_58694(class_9334.field_56140)).method_15434();
            String health = healthRaw + "/14";
            class_5250 age = TextUtils.translate(isBaby ? "hud.item_tooltip.age.baby" : "hud.item_tooltip.age.adult");
            class_5250 variant = TextUtils.translate("hud.entity.properties.axolotl.variant." + variantValue);
            list.add(TextUtils.tooltipLine("hud.entity.properties.health", (class_2561)class_2561.method_43470((String)health)));
            list.add(TextUtils.itemTooltipLine("age", (class_2561)age));
            list.add(TextUtils.tooltipLine("hud.entity.properties.variant", (class_2561)variant));
        } else if (stack.method_31574(class_1802.field_8478)) {
            this.removeText(lines, "entity.minecraft.tropical_fish.predefined.", "entity.minecraft.tropical_fish.type.", "color.minecraft.");
            class_1474.class_7992 fishVariant = new class_1474.class_7992((class_1474.class_1475)stack.method_58694(class_9334.field_56151), (class_1767)stack.method_58694(class_9334.field_56152), (class_1767)stack.method_58694(class_9334.field_56132));
            int variantValue = fishVariant.method_47872();
            int baseColorValue = class_1474.method_6652((int)variantValue).method_16357();
            int patternColorValue = class_1474.method_6651((int)variantValue).method_16357();
            String variety = class_1474.method_47864((int)variantValue).method_47871().getString();
            String health = healthRaw + "/3";
            class_5250 name = TextUtils.dash();
            class_5250 type = TextUtils.translate(variety);
            class_5250 baseColor = TextUtils.write("\u2588 ", baseColorValue);
            class_5250 patternColor = TextUtils.write("\u2588", patternColorValue);
            class_5250 color = class_2561.method_43473().method_10852((class_2561)baseColor).method_10852((class_2561)patternColor);
            class_124 formatting = class_124.field_1076;
            for (int i = 0; i < class_1474.field_41573.size(); ++i) {
                if (variantValue != ((class_1474.class_7992)class_1474.field_41573.get(i)).method_47872()) continue;
                name = TextUtils.translate(class_1474.method_6649((int)i));
                formatting = class_124.field_1080;
                break;
            }
            class_5250 variant = TextUtils.write(TextUtils.str(variantValue), formatting);
            list.addAll(List.of(TextUtils.itemTooltipLine("name", (class_2561)name), TextUtils.tooltipLine("hud.entity.properties.health", class_2561.method_30163((String)health)), TextUtils.tooltipLine("hud.entity.properties.tropical_fish.type", (class_2561)type), TextUtils.tooltipLine("hud.entity.properties.tropical_fish.color", (class_2561)color), TextUtils.tooltipLine("hud.entity.properties.variant", (class_2561)variant)));
        }
        this.insert(stack, lines, list);
    }

    private void addEnhancedBooksTooltip(class_1799 stack, List<class_2561> lines) {
        this.removeText(lines, "book.byAuthor", "book.generation");
        this.insert(stack, lines, this.bookInfo(stack, lines));
    }

    private void addLecternTooltip(class_1799 stack, class_2487 lectern, List<class_2561> lines) {
        if (!lectern.method_10545("Book")) {
            return;
        }
        this.removeText(lines, "op_warning");
        class_2487 bookNbt = (class_2487)lectern.method_10562("Book").get();
        if (!bookNbt.method_10545("components")) {
            return;
        }
        class_1799 book = class_1799.field_24671.parse((DynamicOps)class_2509.field_11560, (Object)bookNbt).result().orElse(class_1799.field_8037);
        if (book.method_7960()) {
            return;
        }
        class_5250 bookId = TextUtils.translate(book.method_7909().method_7876()).method_27692(class_124.field_1063);
        ArrayList combined = Lists.newArrayList();
        combined.add(TextUtils.tooltipLine("hud.item_tooltip.book", (class_2561)bookId));
        combined.addAll(this.bookInfo(book, lines));
        this.insert(stack, lines, combined);
    }

    private List<class_2561> bookInfo(class_1799 book, List<class_2561> lines) {
        class_9301 content;
        ArrayList list = Lists.newArrayList();
        class_1792 item = book.method_7909();
        if (item instanceof class_1843) {
            class_9302 content2 = (class_9302)book.method_58694(class_9334.field_49606);
            if (content2 != null) {
                boolean isRead = content2.comp_2423();
                class_5250 title = TextUtils.write((String)content2.comp_2419().comp_2369(), class_124.field_1054);
                class_5250 read = TextUtils.trueFalse(isRead, true);
                class_5250 author = TextUtils.write(content2.comp_2420(), class_124.field_1076);
                class_5250 pages = TextUtils.write(String.valueOf(content2.comp_2422().size()));
                class_124 tomeColor = content2.comp_2421() > 0 ? class_124.field_1061 : class_124.field_1060;
                class_5250 tome = TextUtils.translate("book.generation." + content2.comp_2421(), tomeColor);
                list.addAll(List.of(TextUtils.itemTooltipLine("book.title", (class_2561)title), TextUtils.itemTooltipLine("book.author", (class_2561)author), TextUtils.itemTooltipLine("book.tome", (class_2561)tome), TextUtils.itemTooltipLine("book.read", (class_2561)read), TextUtils.itemTooltipLine("book.pages", (class_2561)pages)));
            }
        } else if (item instanceof class_1840 && !(content = (class_9301)book.method_58694(class_9334.field_49653)).comp_2422().isEmpty()) {
            class_5250 pages = TextUtils.write(String.valueOf(content.comp_2422().size()));
            list.add(TextUtils.itemTooltipLine("book.pages", (class_2561)pages));
        }
        return list;
    }

    private void addMilkBucketTooltip(class_1799 stack, List<class_2561> lines) {
        class_5250 text = TextUtils.translate("hud.item_tooltip.food.milk_effects");
        this.insert(stack, lines, (class_2561)text);
    }

    private void addTurtleHelmetTooltip(class_1799 stack, List<class_2561> lines) {
        class_5250 text = TextUtils.translate("hud.item_tooltip.turtle_helmet.effects");
        for (int i = 0; i < lines.size(); ++i) {
            if (!lines.get(i).toString().contains("attribute.name.armor")) continue;
            lines.add(i + 1, (class_2561)text);
            break;
        }
    }

    private void addFilledMapTooltip(class_1799 stack, List<class_2561> lines) {
        int z;
        int x;
        class_2338 blockPos;
        Map decorations;
        class_9292.class_9293 dec;
        class_22 mapState;
        ArrayList list = Lists.newArrayList();
        class_9209 mapIdComponent = (class_9209)stack.method_58694(class_9334.field_49646);
        if (mapIdComponent == null) {
            return;
        }
        class_22 class_222 = mapState = this.client.field_1687 == null ? null : class_1806.method_7997((class_9209)mapIdComponent, (class_1937)this.client.field_1687);
        if (mapState == null) {
            return;
        }
        class_9295 mapPostProcessingComponent = (class_9295)stack.method_58694(class_9334.field_49648);
        this.removeText(lines, "filled_map.id", "filled_map.scale", "filled_map.level");
        if (mapPostProcessingComponent == null) {
            class_5250 id = TextUtils.write("#" + mapIdComponent.comp_2315());
            list.add(TextUtils.itemTooltipLine("id", (class_2561)id));
        }
        byte i = mapPostProcessingComponent != null && mapPostProcessingComponent == class_9295.field_49354 ? (byte)1 : 0;
        int j = Math.min(mapState.field_119 + i, 4);
        int scaleValue = 1 << j;
        boolean isLocked = mapState.field_17403 || mapPostProcessingComponent != null && mapPostProcessingComponent == class_9295.field_49353;
        class_5250 scale = TextUtils.write("1:" + scaleValue);
        class_5250 zoom = TextUtils.write(j + "/4");
        class_5250 area = TextUtils.translate("hud.item_tooltip.map.scale." + j);
        class_5250 chunks = TextUtils.translate("hud.item_tooltip.map.chunks." + j);
        class_5250 locked = TextUtils.trueFalse(isLocked, true);
        list.addAll(List.of(TextUtils.itemTooltipLine("map.scale", (class_2561)scale), TextUtils.itemTooltipLine("map.zoom", (class_2561)zoom), TextUtils.itemTooltipLine("map.blocks", (class_2561)area), TextUtils.itemTooltipLine("map.chunks", (class_2561)chunks), TextUtils.itemTooltipLine("map.locked", (class_2561)locked)));
        class_9292 mapDecorationsComponent = (class_9292)stack.method_58694(class_9334.field_49647);
        if (mapDecorationsComponent != null && (dec = (class_9292.class_9293)(decorations = mapDecorationsComponent.comp_2404()).get("+")) != null && !(blockPos = new class_2338(x = (int)dec.comp_2406(), 0, z = (int)dec.comp_2407())).method_23854().contains("0, 0, 0")) {
            class_5250 coordinates = TextUtils.write(String.format("\u00a7c%d \u00a79%d", x, z));
            list.addAll(TextUtils.shiftedTooltip("hud.item_tooltip.map.structure", (class_2561)coordinates, lines));
        }
        this.insert(stack, lines, list);
    }

    private void addFuelStatsTooltip(class_1799 stack, List<class_2561> lines) {
        long ticks = Utils.fuel().method_61755(stack);
        int count = stack.method_7947();
        long totalTicks = ticks * (long)count;
        long operationsCount = totalTicks / 200L;
        class_5250 time = TextUtils.write(Utils.ticksToHours(totalTicks));
        class_5250 operations = TextUtils.write(String.format(Locale.GERMAN, "%,d", operationsCount));
        this.insert(stack, lines, List.of(TextUtils.itemTooltipLine("fuel.time", (class_2561)time), TextUtils.itemTooltipLine("fuel.items", (class_2561)operations)));
    }

    private void addEnhancedDiscsTooltip(class_1799 stack, List<class_2561> lines) {
        this.removeText(lines, "jukebox_song.");
        this.insert(stack, lines, this.recordInfo(stack));
    }

    private void addJukeboxTooltip(class_1799 stack, class_2487 jukebox, List<class_2561> lines) {
        if (!jukebox.method_10545("RecordItem")) {
            return;
        }
        class_2487 recordNbt = (class_2487)jukebox.method_10562("RecordItem").get();
        class_1799 record = class_1799.field_24671.parse((DynamicOps)class_2509.field_11560, (Object)recordNbt).result().orElse(class_1799.field_8037);
        if (record.method_7960()) {
            return;
        }
        long ticksSinceStarted = jukebox.method_10537("ticks_since_song_started").orElse(0L);
        boolean isPlaying = ticksSinceStarted > 0L;
        String ticks = " (" + Utils.formatTicks((int)ticksSinceStarted) + ")";
        class_5250 time = isPlaying ? TextUtils.write(ticks, class_124.field_1063) : class_2561.method_43473();
        class_5250 playing = TextUtils.trueFalse(isPlaying).method_10852((class_2561)time);
        ArrayList combined = Lists.newArrayList();
        combined.addAll(this.recordInfo(record));
        combined.add(TextUtils.itemTooltipLine("jukebox.playing", (class_2561)playing));
        this.insert(stack, lines, combined);
    }

    private List<class_2561> recordInfo(class_1799 record) {
        ArrayList list = Lists.newArrayList();
        class_5455 manager = this.client.field_1687.method_30349();
        class_9793 song = (class_9793)((class_6880)class_9793.method_60753((class_7225.class_7874)manager, (class_1799)record).get()).comp_349();
        String desc = song.comp_2836().getString();
        if (desc.isEmpty()) {
            return List.of();
        }
        String[] separators = new String[]{"\u2010", "\u2011", "\u2012", "\u2013", "\u2014", "\u2015", "\u2212", "-", "\ufe63", "\uff0d"};
        String separator = Arrays.stream(separators).filter(desc::contains).findFirst().orElse("");
        String[] parts = desc.split("\\s*" + Pattern.quote(separator) + "\\s*", 2);
        class_5250 title = TextUtils.write(parts[1].trim(), class_124.field_1054);
        class_5250 composer = TextUtils.write(parts[0].trim(), class_124.field_1076);
        class_5250 length = TextUtils.write(Utils.formatTicks(song.method_60750()));
        class_5250 output = TextUtils.write(song.comp_2838() + "/15");
        list.addAll(List.of(TextUtils.itemTooltipLine("record.title", (class_2561)title), TextUtils.itemTooltipLine("record.composer", (class_2561)composer), TextUtils.itemTooltipLine("record.length", (class_2561)length), TextUtils.itemTooltipLine("record.output", (class_2561)output)));
        return list;
    }

    private void addBannerTooltip(class_1799 stack, List<class_2561> lines) {
        class_9307 patterns = (class_9307)stack.method_58694(class_9334.field_49619);
        if (patterns == null) {
            return;
        }
        List layers = patterns.comp_2428();
        boolean isShield = stack.method_7909() instanceof class_1819;
        boolean hideShieldPatterns = this.config.patterns.hideShieldPatterns && isShield;
        boolean useInternalNames = this.config.patterns.internalNames;
        int maxLayers = Math.min(layers.size(), 6);
        for (int i = 0; i < maxLayers; ++i) {
            class_5250 patternText;
            class_9307.class_9308 layer = (class_9307.class_9308)layers.get(i);
            class_2960 id = ((class_2582)layer.comp_2429().comp_349()).comp_2456();
            class_1767 color = layer.comp_2430();
            String path = id.method_12832();
            class_5250 prefix = TextUtils.write("#" + (i + 1) + ":");
            class_5250 colorBox = TextUtils.write(" \u2588 ", color.method_16357());
            if (useInternalNames) {
                String readableName = TextUtils.capTitle(path.replace("_", " "));
                patternText = TextUtils.write(readableName, class_124.field_1080);
            } else {
                String key = id.method_43903();
                patternText = TextUtils.translate("block.minecraft.banner." + key + "." + color.method_7792(), class_124.field_1080);
            }
            this.removeText(lines, path);
            if (hideShieldPatterns) continue;
            class_5250 line = TextUtils.tooltipLine((class_2561)prefix).method_10852((class_2561)colorBox).method_10852((class_2561)patternText);
            this.insert(stack, lines, (class_2561)line);
        }
    }

    private void addDecoratedPotTooltip(class_1799 stack, List<class_2561> lines) {
        ArrayList list = Lists.newArrayList();
        class_9288 container = (class_9288)stack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        class_1799 item = container.method_58114();
        class_8526 sherds = (class_8526)stack.method_58695(class_9334.field_49621, (Object)class_8526.field_44707);
        List<Optional> sherdList = List.of(sherds.comp_1490(), sherds.comp_1488(), sherds.comp_1489(), sherds.comp_1487());
        boolean emptySherds = sherdList.stream().allMatch(Optional::isEmpty);
        if (emptySherds && item.method_7960()) {
            return;
        }
        lines.removeIf(text -> text.getString().isBlank());
        for (Optional optional : sherdList) {
            optional.ifPresent(itemStack -> this.removeText(lines, itemStack.method_7876()));
        }
        this.removeText(lines, "item.minecraft.brick", "item.container.item_count");
        if (!emptySherds) {
            List<String> keys = sherdList.stream().map(opt -> opt.map(i -> i.method_7876().replace("item.minecraft.", "").replace("_pottery_sherd", "")).orElse("none")).toList();
            List<class_5250> sherdTexts = List.of(TextUtils.transBlockProp("sherds." + keys.get(0)), TextUtils.transBlockProp("sherds." + keys.get(1)), TextUtils.transBlockProp("sherds." + keys.get(2)), TextUtils.transBlockProp("sherds." + keys.get(3)));
            for (int i = 0; i < 4; ++i) {
                class_5250 prefix = TextUtils.write("#" + (i + 1) + ": ");
                class_5250 label = ((class_2561)sherdTexts.get(i)).method_27661().method_27692(class_124.field_1080);
                list.add(TextUtils.tooltipLine((class_2561)prefix).method_10852((class_2561)label));
            }
        }
        if (!item.method_7960()) {
            class_5250 name = item.method_7964().method_27661().method_27692(class_124.field_1060);
            class_5250 amount = TextUtils.write(" (x" + item.method_7947() + ")", class_124.field_1063);
            class_5250 text2 = TextUtils.itemTooltipLine("item", (class_2561)name).method_10852((class_2561)amount);
            list.add(text2);
        }
        this.insert(stack, lines, list);
    }

    private void addFoodStatsTooltip(class_1799 stack, class_746 player, List<class_2561> lines) {
        boolean hasEffects;
        class_4174 food = (class_4174)stack.method_58694(class_9334.field_50075);
        class_10124 consumable = (class_10124)stack.method_58694(class_9334.field_53964);
        int hungerValue = food.comp_2491();
        float saturationRestored = food.comp_2492();
        float saturationRatio = saturationRestored / (float)hungerValue;
        class_124 saturationColor = this.getSaturationColor(saturationRatio);
        class_2561 nourishment = this.getNourishmentText(saturationRatio);
        class_5250 hunger = TextUtils.write(String.valueOf(hungerValue), class_124.field_1060);
        class_5250 saturation = TextUtils.write(String.format(Locale.ROOT, "%.1f", Float.valueOf(saturationRestored)), class_124.field_1077).method_10852((class_2561)TextUtils.write(" (", class_124.field_1063)).method_10852((class_2561)TextUtils.write(String.format(Locale.ROOT, "%.1f", Float.valueOf(saturationRatio)), saturationColor)).method_10852((class_2561)TextUtils.write(")", class_124.field_1063));
        this.insert(stack, lines, List.of(TextUtils.itemTooltipLine("food.hunger", (class_2561)hunger), TextUtils.itemTooltipLine("food.saturation", (class_2561)saturation), TextUtils.itemTooltipLine("food.nourishment", nourishment)));
        boolean isStew = stack.method_31574(class_1802.field_8766);
        boolean bl = hasEffects = !consumable.comp_3089().isEmpty();
        if (this.config.food.stewEffects && isStew) {
            class_9298 stew = (class_9298)stack.method_58694(class_9334.field_49652);
            List<class_1293> stewEffects = stew.comp_2416().stream().map(class_9298.class_8751::method_53247).toList();
            this.removeText(lines, "potion.withDuration", "effect.minecraft.");
            this.addEffectsTooltip(stack, lines, stewEffects, null, false);
        }
        if (this.config.food.foodEffects && hasEffects) {
            for (class_10134 effect : consumable.comp_3089()) {
                if (!(effect instanceof class_10132)) continue;
                class_10132 applyEffect = (class_10132)effect;
                float chance = applyEffect.comp_3095();
                this.addEffectsTooltip(stack, lines, applyEffect.comp_3094(), Float.valueOf(chance), true);
            }
        }
        if (this.config.food.playerHunger) {
            this.addPlayerHungerText(stack, (class_1657)player, lines);
        }
    }

    private class_124 getSaturationColor(float ratio) {
        if (ratio == 2.4f) {
            return class_124.field_1060;
        }
        if (ratio >= 1.6f && ratio < 2.4f) {
            return class_124.field_1077;
        }
        if (ratio == 1.2f) {
            return class_124.field_1054;
        }
        if (ratio == 0.6f) {
            return class_124.field_1061;
        }
        return class_124.field_1079;
    }

    private class_2561 getNourishmentText(float ratio) {
        if (ratio == 2.4f) {
            return TextUtils.itemTooltipLine("food.nourishment.super", (class_2561)TextUtils.empty());
        }
        if (ratio >= 1.6f && ratio < 2.4f) {
            return TextUtils.itemTooltipLine("food.nourishment.good", (class_2561)TextUtils.empty());
        }
        if (ratio == 1.2f) {
            return TextUtils.itemTooltipLine("food.nourishment.normal", (class_2561)TextUtils.empty());
        }
        if (ratio == 0.6f) {
            return TextUtils.itemTooltipLine("food.nourishment.low", (class_2561)TextUtils.empty());
        }
        return TextUtils.itemTooltipLine("food.nourishment.poor", (class_2561)TextUtils.empty());
    }

    private void addEffectsTooltip(class_1799 stack, List<class_2561> lines, List<class_1293> effects, @Nullable Float chance, boolean showChance) {
        if (effects.isEmpty()) {
            return;
        }
        class_5250 title = TextUtils.itemTooltipLine("effects", (class_2561)TextUtils.empty());
        ArrayList effectLines = Lists.newArrayList((Object[])new class_2561[]{title});
        for (class_1293 instance : effects) {
            class_1291 effect = (class_1291)instance.method_5579().comp_349();
            class_2561 name = effect.method_5560();
            class_5250 duration = Utils.getStatusEffectDurationText(instance).method_27661().method_27692(class_124.field_1063);
            class_124 color = Utils.getStatusEffectFormatting(effect);
            if (instance.method_5578() >= 1 && instance.method_5578() <= 9) {
                int amp = instance.method_5578() + 1;
                class_5250 amplifier = TextUtils.shifted((class_2561)TextUtils.translate("enchantment.level." + amp));
                name = name.method_27661().method_10852((class_2561)amplifier);
            }
            class_5250 chanceText = class_2561.method_43473();
            if (showChance && chance != null && chance.floatValue() < 1.0f) {
                String formatted = String.format("\u00a7c[%.0f%%]", Float.valueOf(chance.floatValue() * 100.0f));
                chanceText = TextUtils.shifted(formatted);
            }
            class_5250 line = TextUtils.shifted(name).method_10852((class_2561)duration).method_10852((class_2561)chanceText).method_27692(color);
            effectLines.add(line);
        }
        this.insert(stack, lines, effectLines);
    }

    private void addPlayerHungerText(class_1799 stack, class_1657 player, List<class_2561> lines) {
        int hunger = player.method_7344().method_7586();
        float saturation = player.method_7344().method_7589();
        class_124 hungerFormat = hunger <= 7 ? class_124.field_1061 : (hunger <= 14 ? class_124.field_1065 : class_124.field_1060);
        class_124 saturationColor = saturation > 0.0f ? class_124.field_1077 : class_124.field_1061;
        class_5250 hungerText = TextUtils.write(String.valueOf(hunger), hungerFormat).method_10852((class_2561)TextUtils.write("/", class_124.field_1063)).method_10852((class_2561)TextUtils.write("20", hungerFormat));
        class_5250 saturationText = TextUtils.write(String.format(Locale.ROOT, "(%.1f)", Float.valueOf(saturation)), saturationColor);
        class_5250 finalText = class_2561.method_43469((String)"hud.item_tooltip.food.hunger_stats", (Object[])new Object[]{hungerText, saturationText});
        this.insert(stack, lines, List.of(TextUtils.separator(), finalText));
    }

    private void addBeehiveTooltip(class_1799 stack, List<class_2561> lines) {
        this.removeText(lines, "container.beehive.bees", "container.beehive.honey");
        int beeCount = ((class_10706)stack.method_58694(class_9334.field_49624)).comp_3585().size();
        class_9275 state = (class_9275)stack.method_58694(class_9334.field_49623);
        int honeyCount = Objects.requireNonNullElse((Integer)state.method_57418((class_2769)class_2741.field_20432), 0);
        class_5250 beeLevel = TextUtils.write(beeCount + "/3");
        class_5250 honeyLevel = TextUtils.write(honeyCount + "/5");
        if (beeCount == 0 && honeyCount == 0) {
            return;
        }
        this.insert(stack, lines, List.of(TextUtils.itemTooltipLine("beehive.bees", (class_2561)beeLevel), TextUtils.itemTooltipLine("beehive.honey", (class_2561)honeyLevel)));
    }

    private void addSignTooltip(class_1799 stack, class_2487 sign, List<class_2561> lines) {
        if (sign.method_33133()) {
            return;
        }
        this.removeText(lines, "op_warning");
        String sideKey = this.isShiftDown ? "back_text" : "front_text";
        Optional sideOpt = sign.method_10562(sideKey);
        if (sideOpt.isEmpty()) {
            return;
        }
        class_2487 sideNbt = (class_2487)sideOpt.get();
        Optional messagesOpt = sideNbt.method_10554("messages");
        if (messagesOpt.isEmpty()) {
            return;
        }
        ArrayList combined = Lists.newArrayList();
        combined.addAll(this.getSignMessageLines((class_2499)messagesOpt.get()));
        combined.addAll(this.getSignMetadata(sideNbt, sign));
        this.insert(stack, lines, combined);
    }

    private List<class_2561> getSignMessageLines(class_2499 messages) {
        ArrayList parsedLines = Lists.newArrayList();
        for (int i = 0; i < 4; ++i) {
            class_5250 lineText = class_2561.method_43473();
            boolean hasContent = false;
            if (i < messages.size()) {
                class_2520 element = (class_2520)messages.get(i);
                String text = "";
                class_124 color = null;
                if (element instanceof class_2519) {
                    class_2519 nbtStr = (class_2519)element;
                    text = (String)nbtStr.method_68658().get();
                } else if (element instanceof class_2487) {
                    class_2487 message = (class_2487)element;
                    text = message.method_10558("text").orElse("");
                    color = message.method_10558("color").map(class_124::method_533).orElse(class_124.field_1068);
                }
                if (!text.isEmpty()) {
                    hasContent = true;
                    lineText = class_2561.method_43470((String)text);
                    if (color != null) {
                        lineText.method_10862(lineText.method_10866().method_10977(color));
                    }
                }
            }
            class_2583 style = hasContent ? class_2583.field_24360.method_36139(TextUtils.tooltipTagColor()) : class_2583.field_24360.method_10977(class_124.field_1063);
            class_5250 linePrefix = class_2561.method_43470((String)("#" + (i + 1) + ": ")).method_10862(style);
            parsedLines.add(class_2561.method_43473().method_10852((class_2561)linePrefix).method_10852((class_2561)lineText));
        }
        return parsedLines;
    }

    private List<class_2561> getSignMetadata(class_2487 side, class_2487 sign) {
        ArrayList metadata = Lists.newArrayList();
        class_5250 glowing = side.method_10545("has_glowing_text") ? TextUtils.trueFalse((Boolean)side.method_10577("has_glowing_text").get()) : TextUtils.dash();
        class_5250 color = side.method_10545("color") ? TextUtils.write(TextUtils.capTitle((String)side.method_10558("color").get())) : TextUtils.dash();
        class_5250 waxed = sign.method_10545("is_waxed") ? TextUtils.trueFalse((Boolean)sign.method_10577("is_waxed").get(), true) : TextUtils.dash();
        class_5250 shift = TextUtils.translate(this.isShiftDown ? "hud.item_tooltip.sign.tooltip.front" : "hud.item_tooltip.sign.tooltip.back");
        metadata.add(TextUtils.separator());
        metadata.add(TextUtils.itemTooltipLine("sign.nbt.glowing", (class_2561)glowing));
        metadata.add(TextUtils.itemTooltipLine("sign.nbt.color", (class_2561)color));
        metadata.add(TextUtils.itemTooltipLine("sign.nbt.waxed", (class_2561)waxed));
        if (sign.method_10562("back_text").isPresent()) {
            metadata.add(TextUtils.separator());
            metadata.add(shift);
        }
        return metadata;
    }

    private void addBeaconTooltip(class_1799 stack, class_2487 beacon, List<class_2561> lines) {
        if (beacon.method_33133()) {
            return;
        }
        int levels = beacon.method_10545("Levels") ? (Integer)beacon.method_10550("Levels").get() : 0;
        class_2561 primary = this.getBeaconEffectText(beacon, "primary_effect");
        class_2561 secondary = this.getBeaconEffectText(beacon, "secondary_effect");
        class_5250 pyramydLevel = TextUtils.write(levels + "/4");
        class_5250 effectsHeader = TextUtils.itemTooltipLine("effects", (class_2561)TextUtils.empty());
        class_5250 effect1 = TextUtils.tooltipLine((class_2561)TextUtils.write("#1: ")).method_10852(primary);
        class_5250 effect2 = TextUtils.tooltipLine((class_2561)TextUtils.write("#2: ")).method_10852(secondary);
        ArrayList list = Lists.newArrayList(List.of(TextUtils.itemTooltipLine("beacon.level", (class_2561)pyramydLevel), effectsHeader, effect1));
        if (levels >= 4) {
            list.add(effect2);
        }
        this.insert(stack, lines, list);
    }

    private class_2561 getBeaconEffectText(class_2487 beacon, String effectKey) {
        class_5250 slash = TextUtils.dash();
        if (!beacon.method_10545(effectKey)) {
            return slash;
        }
        return beacon.method_10558(effectKey).map(arg_0 -> ItemTooltip.lambda$getBeaconEffectText$5((class_2561)slash, effectKey, arg_0)).orElse((class_2561)slash);
    }

    private void addSpawnerTooltip(class_1799 stack, class_2487 spawner, List<class_2561> lines) {
        if (spawner.method_33133() || !spawner.method_10562("SpawnData").isPresent()) {
            return;
        }
        this.removeText(lines, "op_warning", "entity.");
        ArrayList list = Lists.newArrayList();
        class_2487 spawnData = (class_2487)((class_2487)spawner.method_10562("SpawnData").get()).method_10562("entity").get();
        String spawnDataId = (String)spawnData.method_10558("id").get();
        String entityId = ((class_1299)class_7923.field_41177.method_63535(class_2960.method_60654((String)spawnDataId))).method_5882();
        class_5250 entityName = TextUtils.translate(entityId).method_27692(class_124.field_1076);
        list.addAll(TextUtils.shiftedTooltip("hud.item_tooltip.spawner.entity", (class_2561)entityName, lines));
        if (this.isShiftDown) {
            Function<String, class_2561> shortValue = key -> spawner.method_10568(key).map(s -> TextUtils.write(String.valueOf(s))).orElse((class_2561)TextUtils.write("-"));
            class_2561 spawnCount = shortValue.apply("SpawnCount");
            class_2561 spawnRange = shortValue.apply("SpawnRange");
            class_2561 spawnDelay = shortValue.apply("Delay");
            class_2561 spawnMinDelay = shortValue.apply("MinSpawnDelay");
            class_2561 spawnMaxDelay = shortValue.apply("MaxSpawnDelay");
            class_2561 maxNearbyEntities = shortValue.apply("MaxNearbyEntities");
            class_2561 requiredPlayerRange = shortValue.apply("RequiredPlayerRange");
            list.addAll(List.of(TextUtils.itemTooltipLine("spawner.spawn_count", spawnCount), TextUtils.itemTooltipLine("spawner.spawn_range", spawnRange), TextUtils.itemTooltipLine("spawner.spawn_delay", spawnDelay), TextUtils.itemTooltipLine("spawner.min_spawn_delay", spawnMinDelay), TextUtils.itemTooltipLine("spawner.max_spawn_delay", spawnMaxDelay), TextUtils.itemTooltipLine("spawner.max_nearby_entities", maxNearbyEntities), TextUtils.itemTooltipLine("spawner.required_player_range", requiredPlayerRange)));
            list.addAll(this.getSpawnPotentialsTexts(spawner));
        } else {
            list.addAll(List.of(TextUtils.separator(), TextUtils.translate("hud.item_tooltip.shift_tags")));
        }
        this.insert(stack, lines, list);
    }

    private List<class_2561> getSpawnPotentialsTexts(class_2487 spawner) {
        int i;
        ArrayList list = Lists.newArrayList();
        Optional potentialNbtOpt = spawner.method_10554("SpawnPotentials");
        if (potentialNbtOpt.isEmpty() || ((class_2499)potentialNbtOpt.get()).isEmpty()) {
            return list;
        }
        class_2499 potentialNbt = (class_2499)potentialNbtOpt.get();
        int totalWeight = 0;
        ArrayList weights = Lists.newArrayList((Object[])new Integer[]{potentialNbt.size()});
        for (i = 0; i < potentialNbt.size(); ++i) {
            Optional weightOpt = Optional.ofNullable(potentialNbt.method_10602(i).orElse(null)).flatMap(entry -> entry.method_10550("weight"));
            int w = weightOpt.orElse(0);
            weights.add(w);
            totalWeight += w;
        }
        list.add(TextUtils.itemTooltipLine("spawner.spawn_potentials", (class_2561)TextUtils.empty()));
        for (i = 0; i < potentialNbt.size(); ++i) {
            Optional<String> entityKeyOpt;
            Optional<class_2487> entryOpt = Optional.ofNullable(potentialNbt.method_10602(i).orElse(null));
            if (entryOpt.isEmpty() || (entityKeyOpt = entryOpt.flatMap(entry -> entry.method_10562("data")).flatMap(data -> data.method_10562("entity")).flatMap(entity -> entity.method_10558("id")).map(id -> ((class_1299)class_7923.field_41177.method_63535(class_2960.method_60654((String)id))).method_5882())).isEmpty()) continue;
            String entityKey = entityKeyOpt.get();
            int weightValue = (Integer)weights.get(i);
            String percentage = totalWeight > 0 ? String.format("%.1f%%", (double)weightValue * 100.0 / (double)totalWeight) : "-";
            String weight = String.valueOf(weightValue);
            class_5250 weightText = class_2561.method_43469((String)"hud.item_tooltip.spawner.spawn_potentials.weight", (Object[])new Object[]{weight, percentage}).method_27692(class_124.field_1063);
            class_5250 name = class_5244.method_48320().method_10852((class_2561)TextUtils.translate(entityKey, class_124.field_1076)).method_10852((class_2561)weightText);
            list.add(name);
        }
        return list;
    }

    private int getLinePos(class_1799 stack, List<class_2561> lines) {
        String itemId = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
        for (int i = lines.size() - 1; i >= 0; --i) {
            if (!lines.get(i).getString().contains(itemId)) continue;
            return i;
        }
        return lines.size();
    }

    private void removeText(List<class_2561> tooltipLines, String ... texts) {
        List<String> targets = List.of(texts);
        tooltipLines.removeIf(line -> targets.stream().anyMatch(line.toString()::contains));
    }

    private void insert(class_1799 stack, List<class_2561> tooltipLines, class_2561 text) {
        this.insert(stack, tooltipLines, List.of(text));
    }

    private void insert(class_1799 stack, List<class_2561> tooltipLines, List<class_2561> insertLines) {
        int pos = this.getLinePos(stack, tooltipLines);
        tooltipLines.addAll(pos, insertLines);
    }

    private static /* synthetic */ class_2561 lambda$getBeaconEffectText$5(class_2561 slash, String effectKey, String effectId) {
        try {
            class_1291 effect = (class_1291)class_7923.field_41174.method_63535(class_2960.method_60654((String)effectId));
            if (effect == null) {
                return slash;
            }
            class_124 format = Utils.getStatusEffectFormatting(effect);
            class_5250 text = TextUtils.translate(effect.method_5567(), format);
            class_1291 regeneration = (class_1291)class_7923.field_41174.method_29107((class_5321)class_1294.field_5924.method_40230().get());
            if (effectKey.equals("secondary_effect") && effect != regeneration) {
                text.method_27693(" II");
            }
            return text;
        }
        catch (Exception e) {
            return TextUtils.write("! Invalid ID", class_124.field_1061);
        }
    }
}

