/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.events;

import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.gui.screen.CustomizeSectionScreen;
import lordrius.essentialgui.gui.screen.LoadedEntitiesScreen;
import lordrius.essentialgui.gui.screen.MainMenuScreen;
import lordrius.essentialgui.gui.screen.ScreenBase;
import lordrius.essentialgui.util.TextUtils;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.impl.client.keybinding.KeyBindingRegistryImpl;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7172;
import net.minecraft.class_746;

public class KeyBindings {
    private static final ConfigData.MiscFeatures config = Data.cfg.misc;
    public static final String CATEGORY = "key.category.essentialgui";
    public static class_304 configurationMenu;
    public static class_304 debugEntitiesLoaded;
    public static class_304 toggleLighting;
    public static class_304 increaseGamma;
    public static class_304 decreaseGamma;
    public static class_304 zoomIn;
    public static class_304 contextualMenu;
    public static class_304 toggleNightVision;
    public static class_304 toggleBlockLightOverlay;

    public static void registerKeyBindings() {
        KeyBindingRegistryImpl.addCategory((String)CATEGORY);
        configurationMenu = KeyBindings.register("main_menu", 301);
        debugEntitiesLoaded = KeyBindings.register("debug_entities", 299);
        toggleLighting = KeyBindings.register("toggle_lighting", 298);
        increaseGamma = KeyBindings.register("increase_gamma", 334);
        decreaseGamma = KeyBindings.register("decrease_gamma", 333);
        zoomIn = KeyBindings.register("zoom_in", 90);
        contextualMenu = KeyBindings.register("contextual_menu", 342);
        toggleNightVision = KeyBindings.register("toggle_night_vision", 297);
        toggleBlockLightOverlay = KeyBindings.register("toggle_block_light_overlay", 296);
        ClientTickEvents.END_CLIENT_TICK.register(client -> KeyBindings.handleKeyPresses(client));
    }

    private static class_304 register(String name, int key) {
        return KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.essentialgui." + name, class_3675.class_307.field_1668, key, CATEGORY));
    }

    private static void handleKeyPresses(class_310 client) {
        while (configurationMenu.method_1436()) {
            boolean ctrl = class_437.method_25441();
            client.method_1507(ctrl ? new CustomizeSectionScreen(null) : new MainMenuScreen(null));
        }
        if (!KeyBindings.config.enabled) {
            return;
        }
        if (KeyBindings.config.debugEntities.enabled) {
            while (debugEntitiesLoaded.method_1436()) {
                client.method_1507((class_437)new LoadedEntitiesScreen(null));
            }
        }
        if (KeyBindings.config.smoothLighting) {
            while (toggleLighting.method_1436()) {
                KeyBindings.toggleSmoothLighting(client);
            }
        }
        if (KeyBindings.config.gamma) {
            while (increaseGamma.method_1436()) {
                KeyBindings.changeGamma(client, 0.25);
            }
            while (decreaseGamma.method_1436()) {
                KeyBindings.changeGamma(client, -0.25);
            }
        }
        if (KeyBindings.config.nightVision) {
            while (toggleNightVision.method_1436()) {
                KeyBindings.toggleNightVision(client.field_1724);
            }
        }
        while (toggleBlockLightOverlay.method_1436()) {
            KeyBindings.toggleBlockLight(client.field_1724);
        }
    }

    private static void toggleSmoothLighting(class_310 client) {
        class_7172 aoOption;
        boolean enabled = (Boolean)(aoOption = client.field_1690.method_41792()).method_41753();
        aoOption.method_41748((Object)(!enabled ? 1 : 0));
        client.field_1724.method_7353((class_2561)TextUtils.translate("options.smooth_lightning").method_10852(enabled ? ScreenBase.OFF_TEXT : ScreenBase.ON_TEXT), true);
        client.field_1690.method_1640();
        client.field_1769.method_3279();
    }

    private static void changeGamma(class_310 client, double delta) {
        class_7172 gamma = client.field_1690.method_42473();
        double current = (Double)gamma.method_41753();
        double newValue = Math.max(0.0, Math.min(1.0, current + delta));
        if (newValue != current) {
            gamma.method_41748((Object)newValue);
            String percent = String.format("%.0f%%", newValue * 100.0);
            class_5250 label = switch ((int)Math.round(newValue * 100.0)) {
                case 0 -> TextUtils.write(" (").method_10852((class_2561)TextUtils.translate("options.gamma.min").method_27693(")"));
                case 50 -> TextUtils.write(" (").method_10852((class_2561)TextUtils.translate("options.gamma.default").method_27693(")"));
                case 100 -> TextUtils.write(" (").method_10852((class_2561)TextUtils.translate("options.gamma.max").method_27693(")"));
                default -> class_2561.method_43473();
            };
            client.field_1724.method_7353((class_2561)TextUtils.translate("options.gamma_level").method_27693(percent).method_10852((class_2561)label).method_27692(class_124.field_1060), true);
            client.field_1690.method_1640();
        }
    }

    private static void toggleNightVision(class_746 player) {
        class_5250 statusText;
        class_1293 nightVisionEffect = player.method_6112(class_1294.field_5925);
        if (nightVisionEffect != null) {
            if (nightVisionEffect.method_48559()) {
                player.method_6016(class_1294.field_5925);
                statusText = ScreenBase.OFF_TEXT.method_27661();
            } else {
                statusText = TextUtils.translate("options.night_vision.active");
            }
        } else {
            player.method_6092(new class_1293(class_1294.field_5925, -1));
            statusText = ScreenBase.ON_TEXT.method_27661();
        }
        player.method_7353((class_2561)TextUtils.translate("options.night_vision").method_10852((class_2561)statusText), true);
    }

    private static void toggleBlockLight(class_746 player) {
        boolean newState;
        KeyBindings.config.blockOverlay.enabled = newState = !KeyBindings.config.blockOverlay.enabled;
        class_2561 statusText = newState ? ScreenBase.ON_TEXT : ScreenBase.OFF_TEXT;
        class_5250 message = TextUtils.translate("options.block_light_overlay").method_10852(statusText);
        player.method_7353((class_2561)message, true);
    }
}

