/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.hud;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.events.UpdateAwakeDays;
import lordrius.essentialgui.gui.hud.PlayerStatsHud;
import lordrius.essentialgui.util.Draw;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;

public class PlayerWarningArea {
    private static final class_1304[] EQUIPMENT_SLOTS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166, class_1304.field_6171, class_1304.field_6173};
    private static final int WARNING_SEPARATION = 23;
    private static final int MIN_DURABILITY = 10;
    private static final int MIN_HEALTH_FOOD = 10;
    private final ConfigData.PlayerWarningArea config;
    private final class_327 textRenderer;
    private final class_746 player;
    private final int width;
    private final int height;
    private final boolean isDarkTexture;
    private final int health;
    private final int hunger;
    private final int saturation;
    private final int oxygen;
    private final int oxygenMax;
    private final int frozenTicks;
    private final int awakeDays;
    private final int[] oxygenData;
    private final class_1799 bed;

    public PlayerWarningArea(class_310 client, class_332 context) {
        this.config = Data.cfg.warning;
        this.bed = Utils.getStackFromString(this.config.bedItem);
        this.textRenderer = client.field_1772;
        this.player = client.field_1724;
        this.width = client.method_22683().method_4486();
        this.height = client.method_22683().method_4502();
        this.health = class_3532.method_15386((float)this.player.method_6032());
        this.hunger = this.player.method_7344().method_7586();
        this.saturation = (int)this.player.method_7344().method_7589();
        this.oxygenData = PlayerStatsHud.getPlayerOxygen((class_1657)this.player);
        this.oxygen = this.oxygenData[0];
        this.oxygenMax = this.oxygenData[1];
        this.frozenTicks = this.player.method_32312() / 20;
        this.awakeDays = UpdateAwakeDays.getAwakeDays();
        this.isDarkTexture = this.config.texture.contains("dark") || this.config.texture.contains("colored");
        this.drawWarningArea(context);
    }

    private void drawWarningArea(class_332 context) {
        List<WarningDrawer> statusWarnings = this.createStatusWarnings();
        List<WarningDrawer> equipmentWarnings = this.createEquipmentWarnings();
        if (!statusWarnings.isEmpty()) {
            this.drawWarningList(context, statusWarnings, this.config.statusX, this.config.statusY, true);
        }
        if (!equipmentWarnings.isEmpty()) {
            this.drawWarningList(context, equipmentWarnings, this.config.equipmentX, this.config.equipmentY, false);
        }
        if (this.shouldShowSaturation()) {
            Draw.drawTexture(context, Draw.PLUS, this.width / 2 + 10, this.height - 35, 5);
        }
    }

    private List<WarningDrawer> createStatusWarnings() {
        ArrayList<WarningDrawer> warnings = new ArrayList<WarningDrawer>(5);
        if (this.shouldShowRestWarning()) {
            warnings.add((ctx, x, y) -> this.drawRestWarning(ctx, x, y));
        }
        if (this.shouldShowHealthWarning()) {
            warnings.add((ctx, x, y) -> this.drawHealthWarning(ctx, x, y));
        }
        if (this.shouldShowHungerWarning()) {
            warnings.add((ctx, x, y) -> this.drawHungerWarning(ctx, x, y));
        }
        if (this.shouldShowOxygenWarning()) {
            warnings.add((ctx, x, y) -> this.drawOxygenWarning(ctx, x, y));
        }
        if (this.shouldShowFreezeWarning()) {
            warnings.add((ctx, x, y) -> this.drawFreezeWarning(ctx, x, y));
        }
        return warnings;
    }

    private List<WarningDrawer> createEquipmentWarnings() {
        if (!this.config.equipment) {
            return List.of();
        }
        ArrayList<WarningDrawer> warnings = new ArrayList<WarningDrawer>(EQUIPMENT_SLOTS.length);
        for (class_1304 slot : EQUIPMENT_SLOTS) {
            class_1799 stack = this.player.method_6118(slot);
            if (!this.isDamagedEquipment(stack)) continue;
            int durability = stack.method_7936() - stack.method_7919();
            warnings.add((ctx, x, y) -> this.drawDamagedEquipmentWarning(ctx, x, y, stack, durability));
        }
        return warnings;
    }

    private void drawWarningList(class_332 context, List<WarningDrawer> warnings, int configX, int configY, boolean isStatus) {
        int baseX = Utils.resolveRenderCoord(configX, isStatus ? 2 : this.width - 22, this.width);
        int baseY = Utils.resolveRenderCoord(configY, this.height - 22, this.height);
        int direction = baseX > this.width / 2 ? -1 : 1;
        for (int i = 0; i < warnings.size(); ++i) {
            int x = baseX + direction * 23 * i;
            warnings.get(i).draw(context, x, baseY);
        }
    }

    private boolean shouldShowRestWarning() {
        return this.config.awakeDays && this.player.method_37908().method_8597().comp_642() && this.awakeDays > 0;
    }

    private boolean shouldShowHealthWarning() {
        return this.config.health && this.health <= 10;
    }

    private boolean shouldShowHungerWarning() {
        return this.config.hunger && this.hunger <= 10;
    }

    private boolean shouldShowOxygenWarning() {
        return this.config.oxygen && this.player.method_33190() && (this.player.method_5869() || this.oxygen < this.oxygenMax);
    }

    private boolean shouldShowFreezeWarning() {
        return this.config.freeze && this.frozenTicks > 0 && this.player.method_33190();
    }

    private boolean shouldShowSaturation() {
        return this.config.saturation && this.saturation > 0 && this.player.method_33190() && !(this.player.method_5854() instanceof class_1309);
    }

    private boolean isDamagedEquipment(class_1799 stack) {
        return !stack.method_7960() && stack.method_7963() && stack.method_7936() - stack.method_7919() <= 10;
    }

    private void drawRestWarning(class_332 context, int x, int y) {
        this.drawWarning(context, x, y, String.valueOf(this.awakeDays), (xPos, yPos) -> context.method_51427(this.bed, xPos - 1, yPos - 1));
    }

    private void drawHealthWarning(class_332 context, int x, int y) {
        this.drawWarning(context, x, y, String.valueOf(this.health), (xPos, yPos) -> Draw.drawTexture(context, Draw.HEART_HALF, xPos, yPos, 13));
    }

    private void drawHungerWarning(class_332 context, int x, int y) {
        this.drawWarning(context, x, y, String.valueOf(this.hunger), (xPos, yPos) -> Draw.drawTexture(context, Draw.HUNGER_HALF, xPos, yPos, 13));
    }

    private void drawOxygenWarning(class_332 context, int x, int y) {
        String counter = String.valueOf((this.oxygen + 19) / 20);
        this.drawWarning(context, x, y, counter, (xPos, yPos) -> Draw.drawTexture(context, Draw.OXYGEN, xPos, yPos, 13));
        if (this.config.oxygenBar.enabled) {
            this.drawOxygenBar(context, counter);
        }
    }

    private void drawOxygenBar(class_332 context, String counter) {
        int barWidth = this.config.oxygenBar.width;
        int barHeight = this.config.oxygenBar.height;
        int oxygenX = Utils.resolveRenderCoord(this.config.oxygenBar.x, (this.width - barWidth - 2) / 2, this.width);
        int oxygenY = Utils.resolveRenderCoord(this.config.oxygenBar.y, this.height - 80, this.height);
        int value = this.oxygen * barWidth / this.oxygenMax;
        Draw.drawOxygenBar(context, oxygenX, oxygenY - 3, barWidth, barHeight, value, counter);
    }

    private void drawFreezeWarning(class_332 context, int x, int y) {
        this.drawWarning(context, x, y, this.frozenTicks + "/7", (xPos, yPos) -> Draw.drawTexture(context, Draw.FREEZE, xPos, yPos, 13));
    }

    private void drawDamagedEquipmentWarning(class_332 context, int x, int y, class_1799 stack, int durability) {
        this.drawWarning(context, x, y, String.valueOf(durability), (xPos, yPos) -> context.method_51427(stack, xPos.intValue(), yPos - 1));
    }

    private void drawWarning(class_332 context, int x, int y, String counter, BiConsumer<Integer, Integer> drawIcon) {
        int xPos = x + 3;
        int yPos = y + 3;
        String formattedCounter = this.config.textColor + counter;
        int textWidth = this.textRenderer.method_1727(formattedCounter);
        if (this.isDarkTexture) {
            int u = this.config.texture.contains("dark") ? 23 : 46;
            Draw.drawTextureSprite(context, Draw.WIDGETS, x, y, u, 41.0f, 22, 22);
        } else {
            int color = new Color(127, 0, 0, 200).getRGB();
            Draw.drawCustomRectangle(context, x, y, 21, 21, color);
        }
        drawIcon.accept(xPos, yPos);
        context.method_25303(this.textRenderer, formattedCounter, x + 21 - textWidth, y + 13, -1);
    }

    @FunctionalInterface
    private static interface WarningDrawer {
        public void draw(class_332 var1, int var2, int var3);
    }
}

