/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.screen;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.gui.screen.BiomeWeatherTimeScreen;
import lordrius.essentialgui.gui.screen.ClientPlayerWorldScreen;
import lordrius.essentialgui.gui.screen.PlayerEquipmentScreen;
import lordrius.essentialgui.gui.screen.PlayerWarningAreaScreen;
import lordrius.essentialgui.gui.screen.options.EntityStatsBarsScreen;
import lordrius.essentialgui.gui.screen.vanilla.StatusEffectsScreen;
import lordrius.essentialgui.util.Draw;
import lordrius.essentialgui.util.TextUtils;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.lwjgl.glfw.GLFW;

public class CustomizeSectionScreen
extends class_437 {
    private static final ConfigData config = Data.cfg;
    private static HudSection lastSection = HudSection.CLIENT_PLAYER_WORLD;
    private HudSection section = lastSection;
    private static final String LANG_PREFIX = "screen.hud_location.custom.";
    private int prevMouseX = -1;
    private int prevMouseY = -1;
    private final class_2561[] MESSAGES = new class_2561[]{TextUtils.translate("screen.hud_location.custom.message.1"), TextUtils.translate("screen.hud_location.custom.message.2"), TextUtils.translate("screen.hud_location.custom.message.3"), TextUtils.translate("screen.hud_location.custom.message.4"), TextUtils.translate("screen.hud_location.custom.message.5"), TextUtils.translate("screen.hud_location.custom.message.6"), TextUtils.translate("screen.hud_location.custom.message.7")};

    public CustomizeSectionScreen(class_437 parent) {
        super((class_2561)class_2561.method_43473());
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.isLeftMousePressed()) {
            if (this.prevMouseX != -1 && this.prevMouseY != -1) {
                if (this.section.getCoords()[0] == -1 && this.section.getCoords()[1] == -1) {
                    this.section.setInitialCoords();
                }
                int deltaX = mouseX - this.prevMouseX;
                int deltaY = mouseY - this.prevMouseY;
                this.section.applyDelta(deltaX, deltaY, this.field_22789, this.field_22790);
            }
            this.prevMouseX = mouseX;
            this.prevMouseY = mouseY;
        } else {
            this.prevMouseX = -1;
            this.prevMouseY = -1;
        }
        int baseX = this.field_22789 / 2 - 59;
        int baseY = this.field_22790 / 2 - 40;
        int lineHeight = 14;
        class_5250 currentSection = TextUtils.translate("screen.hud_location.custom.section", this.section.getTranslatedTitle());
        Draw.drawCenteredTextWithBackground(context, this.field_22789 / 2, 4, (class_2561)currentSection);
        for (int i = 0; i < this.MESSAGES.length; ++i) {
            Draw.drawTextWithBackground(context, baseX, baseY + lineHeight * i, this.MESSAGES[i]);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.section.onClick(mouseX, mouseY, button);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.section = this.section.cycleSections(verticalAmount);
        return true;
    }

    public boolean isLeftMousePressed() {
        long handle = class_310.method_1551().method_22683().method_4490();
        return GLFW.glfwGetMouseButton((long)handle, (int)0) == 1;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        switch (keyCode) {
            case 258: {
                this.section.toggleHudStyle();
                return true;
            }
            case 82: {
                this.section.resetCoords();
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        Data.save();
        lastSection = this.section;
        this.field_22787.method_1507(null);
    }

    public static enum HudSection {
        CLIENT_PLAYER_WORLD("screen.hud_location.custom.section.0", new String[]{"debug", "individual", "individual_borderless", "compact_block", "compact_block_borderless", "compact_blocks", "compact_blocks_borderless", "simple", "simple_borderless"}, v -> {
            CustomizeSectionScreen.config.client.style = v;
        }, () -> CustomizeSectionScreen.config.client.style, (dx, dy) -> {
            CustomizeSectionScreen.config.client.x += dx.intValue();
            CustomizeSectionScreen.config.client.y += dy.intValue();
        }, (x, y) -> {
            CustomizeSectionScreen.config.client.x = x;
            CustomizeSectionScreen.config.client.y = y;
        }),
        STATUS_WARNINGS("screen.hud_location.custom.section.1.0", new String[]{"dark", "colored", "essgui"}, v -> {
            CustomizeSectionScreen.config.warning.texture = v;
        }, () -> CustomizeSectionScreen.config.warning.texture, (dx, dy) -> {
            CustomizeSectionScreen.config.warning.statusX += dx.intValue();
            CustomizeSectionScreen.config.warning.statusY += dy.intValue();
        }, (x, y) -> {
            CustomizeSectionScreen.config.warning.statusX = x;
            CustomizeSectionScreen.config.warning.statusY = y;
        }),
        EQUIPMENT_WARNINGS("screen.hud_location.custom.section.1.1", new String[]{"dark", "colored", "essgui"}, v -> {
            CustomizeSectionScreen.config.warning.texture = v;
        }, () -> CustomizeSectionScreen.config.warning.texture, (dx, dy) -> {
            CustomizeSectionScreen.config.warning.equipmentX += dx.intValue();
            CustomizeSectionScreen.config.warning.equipmentY += dy.intValue();
        }, (x, y) -> {
            CustomizeSectionScreen.config.warning.equipmentX = x;
            CustomizeSectionScreen.config.warning.equipmentY = y;
        }),
        OXYGEN_BAR("screen.hud_location.custom.section.1.2", new String[]{"screen.hud_style.rounded", "screen.hud_style.rectangular"}, v -> {
            CustomizeSectionScreen.config.entity.statsBars.style = v;
        }, () -> CustomizeSectionScreen.config.entity.statsBars.style, (dx, dy) -> {
            CustomizeSectionScreen.config.warning.oxygenBar.x += dx.intValue();
            CustomizeSectionScreen.config.warning.oxygenBar.y += dy.intValue();
        }, (x, y) -> {
            CustomizeSectionScreen.config.warning.oxygenBar.x = x;
            CustomizeSectionScreen.config.warning.oxygenBar.y = y;
        }),
        QUIVER("screen.hud_location.custom.section.4.0", new String[]{"essgui", "vanilla", "dark", "colored", "none"}, v -> {
            CustomizeSectionScreen.config.equipment.quiver.texture = v;
        }, () -> CustomizeSectionScreen.config.equipment.quiver.texture, (dx, dy) -> {
            CustomizeSectionScreen.config.equipment.quiver.x += dx.intValue();
            CustomizeSectionScreen.config.equipment.quiver.y += dy.intValue();
        }, (x, y) -> {
            CustomizeSectionScreen.config.equipment.quiver.x = x;
            CustomizeSectionScreen.config.equipment.quiver.y = y;
        }),
        ITEM_STOCK("screen.hud_location.custom.section.4.1", new String[]{"essgui", "vanilla", "dark", "none"}, v -> {
            CustomizeSectionScreen.config.equipment.stock.texture = v;
        }, () -> CustomizeSectionScreen.config.equipment.stock.texture, (dx, dy) -> {
            CustomizeSectionScreen.config.equipment.stock.x += dx.intValue();
            CustomizeSectionScreen.config.equipment.stock.y += dy.intValue();
        }, (x, y) -> {
            CustomizeSectionScreen.config.equipment.stock.x = x;
            CustomizeSectionScreen.config.equipment.stock.y = y;
        }),
        SCREEN_EQUIPMENT("screen.hud_location.custom.section.4.2", new String[]{"essgui", "essgui_bless", "vanilla", "none"}, v -> {
            CustomizeSectionScreen.config.equipment.screen.texture = v;
        }, () -> CustomizeSectionScreen.config.equipment.screen.texture, (dx, dy) -> {
            CustomizeSectionScreen.config.equipment.screen.x += dx.intValue();
            CustomizeSectionScreen.config.equipment.screen.y += dy.intValue();
        }, (x, y) -> {
            CustomizeSectionScreen.config.equipment.screen.x = x;
            CustomizeSectionScreen.config.equipment.screen.y = y;
        }),
        BIOME_WEATHER_TIME("screen.hud_location.custom.section.5", new String[]{"dark", "essgui", "essgui_bless"}, v -> {
            CustomizeSectionScreen.config.biome.texture = v;
        }, () -> CustomizeSectionScreen.config.biome.texture, (dx, dy) -> {
            CustomizeSectionScreen.config.biome.x += dx.intValue();
            CustomizeSectionScreen.config.biome.y += dy.intValue();
        }, (x, y) -> {
            CustomizeSectionScreen.config.biome.x = x;
            CustomizeSectionScreen.config.biome.y = y;
        }),
        STATUS_EFFECTS("screen.hud_location.custom.section.6", new String[]{"colored", "vanilla"}, v -> {
            CustomizeSectionScreen.config.vanilla.effects.texture = v;
        }, () -> CustomizeSectionScreen.config.vanilla.effects.texture, (dx, dy) -> {
            CustomizeSectionScreen.config.vanilla.effects.x += dx.intValue();
            CustomizeSectionScreen.config.vanilla.effects.y += dy.intValue();
        }, (x, y) -> {
            CustomizeSectionScreen.config.vanilla.effects.x = x;
            CustomizeSectionScreen.config.vanilla.effects.y = y;
        });

        private final String titleKey;
        private final String[] styles;
        private final Consumer<String> setter;
        private final Supplier<String> getter;
        private final BiConsumer<Integer, Integer> coordSetter;
        private final BiConsumer<Integer, Integer> coordResetter;

        private HudSection(String titleKey, String[] styles, Consumer<String> setter, Supplier<String> getter, BiConsumer<Integer, Integer> coordSetter, BiConsumer<Integer, Integer> coordResetter) {
            this.titleKey = titleKey;
            this.styles = styles;
            this.setter = setter;
            this.getter = getter;
            this.coordSetter = coordSetter;
            this.coordResetter = coordResetter;
        }

        public class_2561 getTranslatedTitle() {
            return TextUtils.translate(this.titleKey);
        }

        public void resetCoords() {
            this.coordResetter.accept(-1, -1);
        }

        public void setInitialCoords() {
            int width = class_310.method_1551().method_22683().method_4486();
            int height = class_310.method_1551().method_22683().method_4502();
            switch (this.ordinal()) {
                case 0: {
                    int x = 5;
                    int y = 28;
                    CustomizeSectionScreen.config.client.x = Utils.toRelative(x, width);
                    CustomizeSectionScreen.config.client.y = Utils.toRelative(y, height);
                    break;
                }
                case 1: {
                    int x = 2;
                    int y = height - 22;
                    CustomizeSectionScreen.config.warning.statusX = Utils.toRelative(x, width);
                    CustomizeSectionScreen.config.warning.statusY = Utils.toRelative(y, height);
                    break;
                }
                case 2: {
                    int x = width - 22;
                    int y = height - 22;
                    CustomizeSectionScreen.config.warning.equipmentX = Utils.toRelative(x, width);
                    CustomizeSectionScreen.config.warning.equipmentY = Utils.toRelative(y, height);
                    break;
                }
                case 3: {
                    int barWidth = CustomizeSectionScreen.config.warning.oxygenBar.width;
                    int x = (width - barWidth - 2) / 2;
                    int y = height - 80;
                    CustomizeSectionScreen.config.warning.oxygenBar.x = Utils.toRelative(x, width);
                    CustomizeSectionScreen.config.warning.oxygenBar.y = Utils.toRelative(y, height);
                    break;
                }
                case 4: {
                    int x = width - 22;
                    int y = height / 2 - 81;
                    CustomizeSectionScreen.config.equipment.quiver.x = Utils.toRelative(x, width);
                    CustomizeSectionScreen.config.equipment.quiver.y = Utils.toRelative(y, height);
                    break;
                }
                case 5: {
                    int x = width / 2 + 100;
                    int y = height - 21;
                    CustomizeSectionScreen.config.equipment.stock.x = Utils.toRelative(x, width);
                    CustomizeSectionScreen.config.equipment.stock.y = Utils.toRelative(y, height);
                    break;
                }
                case 6: {
                    int x = width - 20;
                    int y = height / 2 - 56;
                    CustomizeSectionScreen.config.equipment.screen.x = Utils.toRelative(x, width);
                    CustomizeSectionScreen.config.equipment.screen.y = Utils.toRelative(y, height);
                    break;
                }
                case 7: {
                    int x = 2;
                    int y = 2;
                    CustomizeSectionScreen.config.biome.x = Utils.toRelative(x, width);
                    CustomizeSectionScreen.config.biome.y = Utils.toRelative(y, height);
                    break;
                }
                case 8: {
                    int x = width - 25;
                    int y = 2;
                    CustomizeSectionScreen.config.vanilla.effects.x = Utils.toRelative(x, width);
                    CustomizeSectionScreen.config.vanilla.effects.y = Utils.toRelative(y, height);
                }
            }
        }

        public int[] getCoords() {
            int[] nArray;
            switch (this.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    int[] nArray2 = new int[2];
                    nArray2[0] = CustomizeSectionScreen.config.client.x;
                    nArray = nArray2;
                    nArray2[1] = CustomizeSectionScreen.config.client.y;
                    break;
                }
                case 1: {
                    int[] nArray3 = new int[2];
                    nArray3[0] = CustomizeSectionScreen.config.warning.statusX;
                    nArray = nArray3;
                    nArray3[1] = CustomizeSectionScreen.config.warning.statusY;
                    break;
                }
                case 2: {
                    int[] nArray4 = new int[2];
                    nArray4[0] = CustomizeSectionScreen.config.warning.equipmentX;
                    nArray = nArray4;
                    nArray4[1] = CustomizeSectionScreen.config.warning.equipmentY;
                    break;
                }
                case 3: {
                    int[] nArray5 = new int[2];
                    nArray5[0] = CustomizeSectionScreen.config.warning.oxygenBar.x;
                    nArray = nArray5;
                    nArray5[1] = CustomizeSectionScreen.config.warning.oxygenBar.y;
                    break;
                }
                case 4: {
                    int[] nArray6 = new int[2];
                    nArray6[0] = CustomizeSectionScreen.config.equipment.quiver.x;
                    nArray = nArray6;
                    nArray6[1] = CustomizeSectionScreen.config.equipment.quiver.y;
                    break;
                }
                case 5: {
                    int[] nArray7 = new int[2];
                    nArray7[0] = CustomizeSectionScreen.config.equipment.stock.x;
                    nArray = nArray7;
                    nArray7[1] = CustomizeSectionScreen.config.equipment.stock.y;
                    break;
                }
                case 6: {
                    int[] nArray8 = new int[2];
                    nArray8[0] = CustomizeSectionScreen.config.equipment.screen.x;
                    nArray = nArray8;
                    nArray8[1] = CustomizeSectionScreen.config.equipment.screen.y;
                    break;
                }
                case 7: {
                    int[] nArray9 = new int[2];
                    nArray9[0] = CustomizeSectionScreen.config.biome.x;
                    nArray = nArray9;
                    nArray9[1] = CustomizeSectionScreen.config.biome.y;
                    break;
                }
                case 8: {
                    int[] nArray10 = new int[2];
                    nArray10[0] = CustomizeSectionScreen.config.vanilla.effects.x;
                    nArray = nArray10;
                    nArray10[1] = CustomizeSectionScreen.config.vanilla.effects.y;
                }
            }
            return nArray;
        }

        public HudSection cycleSections(double verticalAmount) {
            HudSection[] sections = HudSection.values();
            int ordinal = this.ordinal();
            if (verticalAmount > 0.0) {
                ordinal = (ordinal + 1) % sections.length;
            } else if (verticalAmount < 0.0) {
                ordinal = (ordinal - 1 + sections.length) % sections.length;
            }
            return sections[ordinal];
        }

        public void toggleHudStyle() {
            String current = this.getter.get();
            int index = -1;
            for (int i = 0; i < this.styles.length; ++i) {
                if (!this.styles[i].equals(current)) continue;
                index = i;
                break;
            }
            if (index >= 0) {
                int newIndex = (index + 1) % this.styles.length;
                this.setter.accept(this.styles[newIndex]);
            }
        }

        public void applyDelta(int dx, int dy, int width, int height) {
            int relDx = dx * 1000 / width;
            int relDy = dy * 1000 / height;
            this.coordSetter.accept(relDx, relDy);
        }

        public void onClick(double mouseX, double mouseY, int button) {
            class_310 client = class_310.method_1551();
            class_437 currentScreen = client.field_1755;
            boolean middleButton = button == 2;
            boolean rightButton = button == 1;
            switch (this.ordinal()) {
                case 0: {
                    if (!middleButton) break;
                    client.method_1507((class_437)new ClientPlayerWorldScreen(currentScreen));
                    break;
                }
                case 1: 
                case 2: {
                    if (!middleButton) break;
                    client.method_1507((class_437)new PlayerWarningAreaScreen(currentScreen));
                    break;
                }
                case 3: {
                    if (rightButton) {
                        boolean bl = CustomizeSectionScreen.config.entity.statsBars.values = !CustomizeSectionScreen.config.entity.statsBars.values;
                    }
                    if (!middleButton) break;
                    client.method_1507((class_437)new EntityStatsBarsScreen(currentScreen));
                    break;
                }
                case 4: 
                case 5: {
                    if (!middleButton) break;
                    client.method_1507((class_437)new PlayerEquipmentScreen(currentScreen));
                    break;
                }
                case 6: {
                    if (rightButton) {
                        boolean bl = CustomizeSectionScreen.config.equipment.screen.durability = !CustomizeSectionScreen.config.equipment.screen.durability;
                    }
                    if (!middleButton) break;
                    client.method_1507((class_437)new PlayerEquipmentScreen(currentScreen));
                    break;
                }
                case 7: {
                    if (rightButton) {
                        boolean bl = CustomizeSectionScreen.config.biome.time = !CustomizeSectionScreen.config.biome.time;
                    }
                    if (!middleButton) break;
                    client.method_1507((class_437)new BiomeWeatherTimeScreen(currentScreen));
                    break;
                }
                case 8: {
                    if (rightButton) {
                        boolean bl = CustomizeSectionScreen.config.vanilla.effects.duration = !CustomizeSectionScreen.config.vanilla.effects.duration;
                    }
                    if (!middleButton) break;
                    client.method_1507((class_437)new StatusEffectsScreen(currentScreen));
                    break;
                }
            }
        }
    }
}

