/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.screen;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.gui.screen.ScreenBase;
import lordrius.essentialgui.gui.widgets.ButtonWidgetToggle;
import lordrius.essentialgui.util.TextUtils;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import org.jetbrains.annotations.Nullable;

public class ItemTooltipsScreen
extends ScreenBase {
    private final ConfigData.AdvancedItemTooltips config;
    private OptionsListWidget optionsListWidget;
    private class_8132 layout;

    public ItemTooltipsScreen(class_437 parent) {
        super(parent, (class_2561)TextUtils.translate("screen.tooltips.title"));
        this.config = Data.cfg.tooltips;
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.layout = new class_8132((class_437)this, 61, 33);
        this.optionsListWidget = new OptionsListWidget();
        this.layout.method_48999((class_8021)this.optionsListWidget);
        this.method_37063((class_364)this.optionsListWidget);
        this.layout.method_48222();
    }

    public class OptionsListWidget
    extends class_4265<OptionEntry> {
        public OptionsListWidget() {
            super(ItemTooltipsScreen.this.field_22787, ItemTooltipsScreen.this.field_22789, ItemTooltipsScreen.this.layout.method_57727() + 28, ItemTooltipsScreen.this.layout.method_48998(), 22);
            this.addEntries();
        }

        public int method_25322() {
            return 260;
        }

        public int method_25342() {
            return (this.field_22758 - this.method_25322()) / 2;
        }

        public void addEntries() {
            class_2561 tooltip;
            class_5250 label;
            this.method_25339();
            String keyPrefix = "screen.tooltips.";
            class_5250 TOOLTIPS_HEADER = TextUtils.translate("screen.tooltips.header");
            class_5250 DAMAGEABLES_HEADER = TextUtils.translate("screen.tooltips.damageables.header");
            class_5250 FOOD_HEADER = TextUtils.translate("screen.tooltips.food.header");
            class_5250 NBT_HEADER = TextUtils.translate("screen.tooltips.nbt.header");
            class_5250 PATTERNS_HEADER = TextUtils.translate("screen.tooltips.patterns.header");
            List<BooleanOption> tooltips = List.of(new BooleanOption(this, "lodestone_compass", () -> ItemTooltipsScreen.this.config.lodestoneCompass, v -> {
                ItemTooltipsScreen.this.config.lodestoneCompass = v;
            }), new BooleanOption(this, "salmon_bucket", () -> ItemTooltipsScreen.this.config.salmonBucket, v -> {
                ItemTooltipsScreen.this.config.salmonBucket = v;
            }), new BooleanOption(this, "axolotl_bucket", () -> ItemTooltipsScreen.this.config.axolotlBucket, v -> {
                ItemTooltipsScreen.this.config.axolotlBucket = v;
            }), new BooleanOption(this, "recovery_compass", () -> ItemTooltipsScreen.this.config.recoveryCompass, v -> {
                ItemTooltipsScreen.this.config.recoveryCompass = v;
            }), new BooleanOption(this, "tropical_fish_bucket", () -> ItemTooltipsScreen.this.config.tropicalFishBucket, v -> {
                ItemTooltipsScreen.this.config.tropicalFishBucket = v;
            }), new BooleanOption(this, "books", () -> ItemTooltipsScreen.this.config.books, v -> {
                ItemTooltipsScreen.this.config.books = v;
            }), new BooleanOption(this, "milk_bucket", () -> ItemTooltipsScreen.this.config.milkBucket, v -> {
                ItemTooltipsScreen.this.config.milkBucket = v;
            }), new BooleanOption(this, "turtle_helmet", () -> ItemTooltipsScreen.this.config.turtleHelmet, v -> {
                ItemTooltipsScreen.this.config.turtleHelmet = v;
            }), new BooleanOption(this, "maps", () -> ItemTooltipsScreen.this.config.maps, v -> {
                ItemTooltipsScreen.this.config.maps = v;
            }), new BooleanOption(this, "fuel_stats", () -> ItemTooltipsScreen.this.config.fuelStats, v -> {
                ItemTooltipsScreen.this.config.fuelStats = v;
            }), new BooleanOption(this, "discs", () -> ItemTooltipsScreen.this.config.discs, v -> {
                ItemTooltipsScreen.this.config.discs = v;
            }), new BooleanOption(this, "decorated_pots", () -> ItemTooltipsScreen.this.config.decoratedPots, v -> {
                ItemTooltipsScreen.this.config.decoratedPots = v;
            }));
            List<BooleanOption> damageables = List.of(new BooleanOption(this, "durability", () -> ItemTooltipsScreen.this.config.damageables.durability, v -> {
                ItemTooltipsScreen.this.config.damageables.durability = v;
            }), new BooleanOption(this, "durability_colored", () -> ItemTooltipsScreen.this.config.damageables.durabilityColored, v -> {
                ItemTooltipsScreen.this.config.damageables.durabilityColored = v;
            }), new BooleanOption(this, "durability_percent", () -> ItemTooltipsScreen.this.config.damageables.durabilityPercent, v -> {
                ItemTooltipsScreen.this.config.damageables.durabilityPercent = v;
            }), new BooleanOption(this, "durability_always", () -> ItemTooltipsScreen.this.config.damageables.durabilityAlways, v -> {
                ItemTooltipsScreen.this.config.damageables.durabilityAlways = v;
            }), new BooleanOption(this, "penalty", () -> ItemTooltipsScreen.this.config.damageables.penalty, v -> {
                ItemTooltipsScreen.this.config.damageables.penalty = v;
            }), new BooleanOption(this, "comparison", () -> ItemTooltipsScreen.this.config.damageables.comparison, v -> {
                ItemTooltipsScreen.this.config.damageables.comparison = v;
            }), new BooleanOption(this, "better_tooltip", () -> ItemTooltipsScreen.this.config.damageables.betterTooltip, v -> {
                ItemTooltipsScreen.this.config.damageables.betterTooltip = v;
            }));
            List<BooleanOption> food = List.of(new BooleanOption(this, "simple_style", () -> ItemTooltipsScreen.this.config.food.simpleStyle, v -> {
                ItemTooltipsScreen.this.config.food.simpleStyle = v;
            }), new BooleanOption(this, "player_hunger", () -> ItemTooltipsScreen.this.config.food.playerHunger, v -> {
                ItemTooltipsScreen.this.config.food.playerHunger = v;
            }), new BooleanOption(this, "food_effects", () -> ItemTooltipsScreen.this.config.food.foodEffects, v -> {
                ItemTooltipsScreen.this.config.food.foodEffects = v;
            }), new BooleanOption(this, "stew_effects", () -> ItemTooltipsScreen.this.config.food.stewEffects, v -> {
                ItemTooltipsScreen.this.config.food.stewEffects = v;
            }));
            List<BooleanOption> nbt = List.of(new BooleanOption(this, "beehive", () -> ItemTooltipsScreen.this.config.nbt.beehive, v -> {
                ItemTooltipsScreen.this.config.nbt.beehive = v;
            }), new BooleanOption(this, "lectern", () -> ItemTooltipsScreen.this.config.nbt.lectern, v -> {
                ItemTooltipsScreen.this.config.nbt.lectern = v;
            }), new BooleanOption(this, "jukebox", () -> ItemTooltipsScreen.this.config.nbt.jukebox, v -> {
                ItemTooltipsScreen.this.config.nbt.jukebox = v;
            }), new BooleanOption(this, "sign", () -> ItemTooltipsScreen.this.config.nbt.sign, v -> {
                ItemTooltipsScreen.this.config.nbt.sign = v;
            }), new BooleanOption(this, "beacon", () -> ItemTooltipsScreen.this.config.nbt.beacon, v -> {
                ItemTooltipsScreen.this.config.nbt.beacon = v;
            }), new BooleanOption(this, "spawner", () -> ItemTooltipsScreen.this.config.nbt.spawner, v -> {
                ItemTooltipsScreen.this.config.nbt.spawner = v;
            }), new BooleanOption(this, "container_items", () -> ItemTooltipsScreen.this.config.nbt.containerItems, v -> {
                ItemTooltipsScreen.this.config.nbt.containerItems = v;
            }));
            List<BooleanOption> patterns = List.of(new BooleanOption(this, "hide_in_shield", () -> ItemTooltipsScreen.this.config.patterns.hideShieldPatterns, v -> {
                ItemTooltipsScreen.this.config.patterns.hideShieldPatterns = v;
            }), new BooleanOption(this, "internal_names", () -> ItemTooltipsScreen.this.config.patterns.internalNames, v -> {
                ItemTooltipsScreen.this.config.patterns.internalNames = v;
            }));
            this.addStaticHeader((class_2561)TOOLTIPS_HEADER);
            for (BooleanOption option : tooltips) {
                label = TextUtils.translate("screen.tooltips." + option.key);
                tooltip = this.safeTranslate("screen.tooltips." + option.key + ".tooltip");
                this.addBooleanOption((class_2561)label, tooltip, option.getter, option.setter);
            }
            this.addCategoryHeader((class_2561)DAMAGEABLES_HEADER, () -> ItemTooltipsScreen.this.config.damageables.enabled, v -> {
                ItemTooltipsScreen.this.config.damageables.enabled = v;
            });
            if (ItemTooltipsScreen.this.config.damageables.enabled) {
                for (BooleanOption option : damageables) {
                    label = TextUtils.translate("screen.tooltips.damageables." + option.key);
                    tooltip = this.safeTranslate("screen.tooltips.damageables." + option.key + ".tooltip");
                    this.addBooleanOption((class_2561)label, tooltip, option.getter, option.setter);
                }
            }
            this.addCategoryHeader((class_2561)FOOD_HEADER, () -> ItemTooltipsScreen.this.config.food.enabled, v -> {
                ItemTooltipsScreen.this.config.food.enabled = v;
            });
            if (ItemTooltipsScreen.this.config.food.enabled) {
                for (BooleanOption option : food) {
                    label = TextUtils.translate("screen.tooltips.food." + option.key);
                    tooltip = this.safeTranslate("screen.tooltips.food." + option.key + ".tooltip");
                    this.addBooleanOption((class_2561)label, tooltip, option.getter, option.setter);
                }
            }
            this.addCategoryHeader((class_2561)NBT_HEADER, () -> ItemTooltipsScreen.this.config.nbt.enabled, v -> {
                ItemTooltipsScreen.this.config.nbt.enabled = v;
            });
            if (ItemTooltipsScreen.this.config.nbt.enabled) {
                for (BooleanOption option : nbt) {
                    label = TextUtils.translate("screen.tooltips.nbt." + option.key);
                    tooltip = this.safeTranslate("screen.tooltips.nbt." + option.key + ".tooltip");
                    this.addBooleanOption((class_2561)label, tooltip, option.getter, option.setter);
                }
            }
            this.addCategoryHeader((class_2561)PATTERNS_HEADER, () -> ItemTooltipsScreen.this.config.patterns.enabled, v -> {
                ItemTooltipsScreen.this.config.patterns.enabled = v;
            });
            if (ItemTooltipsScreen.this.config.patterns.enabled) {
                for (BooleanOption option : patterns) {
                    label = TextUtils.translate("screen.tooltips.patterns." + option.key);
                    tooltip = this.safeTranslate("screen.tooltips.patterns." + option.key + ".tooltip");
                    this.addBooleanOption((class_2561)label, tooltip, option.getter, option.setter);
                }
            }
        }

        private class_2561 safeTranslate(String key) {
            class_5250 translated = TextUtils.translate(key);
            return translated == null || translated.getString().equals(key) ? null : translated;
        }

        public void addEntriesAndFixScroll() {
            double currentScroll = this.method_44387();
            this.method_25339();
            this.addEntries();
            this.method_65506();
            double maxScroll = this.method_44390();
            this.method_44382(Math.min(currentScroll, maxScroll));
        }

        public void method_57713(class_332 context) {
        }

        public void method_57715(class_332 context) {
        }

        private void addStaticHeader(class_2561 header) {
            this.method_25321((class_350.class_351)new StaticHeaderEntry(header));
        }

        private void addCategoryHeader(class_2561 categoryName, BooleanSupplier getter, Consumer<Boolean> setter) {
            this.method_25321((class_350.class_351)new CategoryHeaderEntry(categoryName, getter, setter));
        }

        private void addBooleanOption(class_2561 label, class_2561 tooltip, BooleanSupplier getter, Consumer<Boolean> setter) {
            this.addBooleanOption(label, tooltip, getter, setter, () -> true);
        }

        private void addBooleanOption(class_2561 label, @Nullable class_2561 tooltip, BooleanSupplier getter, Consumer<Boolean> setter, BooleanSupplier activeCondition) {
            this.method_25321((class_350.class_351)new BooleanOptionEntry(label, tooltip, getter, setter, activeCondition));
        }

        public class BooleanOption {
            public final String key;
            public final BooleanSupplier getter;
            public final Consumer<Boolean> setter;

            public BooleanOption(OptionsListWidget this$1, String key, BooleanSupplier getter, Consumer<Boolean> setter) {
                this.key = key;
                this.getter = getter;
                this.setter = setter;
            }
        }

        public class StaticHeaderEntry
        extends OptionEntry {
            private final class_2561 categoryName;

            public StaticHeaderEntry(class_2561 categoryName) {
                super(OptionsListWidget.this);
                this.categoryName = categoryName;
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
                context.method_27534(ItemTooltipsScreen.this.field_22793, this.categoryName, x + entryWidth / 2, y + 6, -1);
            }

            public List<? extends class_364> method_25396() {
                return List.of();
            }

            public List<? extends class_6379> method_37025() {
                return List.of();
            }
        }

        public class CategoryHeaderEntry
        extends OptionEntry {
            private final class_2561 categoryName;
            private final ButtonWidgetToggle toggleButton;

            public CategoryHeaderEntry(class_2561 categoryName, BooleanSupplier getter, Consumer<Boolean> setter) {
                super(OptionsListWidget.this);
                this.categoryName = categoryName;
                this.toggleButton = new ButtonWidgetToggle(0, 0, getter.getAsBoolean(), onPress -> {
                    boolean newValue = !getter.getAsBoolean();
                    setter.accept(newValue);
                    ItemTooltipsScreen.this.optionsListWidget.addEntriesAndFixScroll();
                });
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
                context.method_27534(ItemTooltipsScreen.this.field_22793, this.categoryName, x + entryWidth / 2, y + 6, -1);
                this.toggleButton.method_46421(x + entryWidth - 20);
                this.toggleButton.method_46419(y);
                this.toggleButton.method_25394(context, mouseX, mouseY, tickProgress);
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.toggleButton);
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.toggleButton);
            }
        }

        public class BooleanOptionEntry
        extends OptionEntry {
            private final class_2561 optionName;
            @Nullable
            private final class_2561 tooltip;
            private final ButtonWidgetToggle toggleButton;
            private final BooleanSupplier activeCondition;

            public BooleanOptionEntry(@Nullable class_2561 label, class_2561 tooltip, BooleanSupplier getter, Consumer<Boolean> setter, BooleanSupplier activeCondition) {
                super(OptionsListWidget.this);
                this.optionName = label;
                this.tooltip = tooltip;
                this.activeCondition = activeCondition;
                this.toggleButton = new ButtonWidgetToggle(0, 0, getter.getAsBoolean(), button -> {
                    setter.accept(!getter.getAsBoolean());
                    ItemTooltipsScreen.this.optionsListWidget.addEntriesAndFixScroll();
                });
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickProgress) {
                context.method_27535(ItemTooltipsScreen.this.field_22793, this.optionName, x + 2, y + 6, -1);
                this.toggleButton.method_46421(x + entryWidth - 20);
                this.toggleButton.method_46419(y);
                this.toggleButton.field_22763 = this.activeCondition.getAsBoolean();
                this.toggleButton.method_25394(context, mouseX, mouseY, tickProgress);
                if (hovered && this.tooltip != null) {
                    List wrappedTooltip = ItemTooltipsScreen.this.field_22793.method_1728((class_5348)this.tooltip, 200);
                    context.method_71274(wrappedTooltip, mouseX, mouseY);
                }
            }

            public List<? extends class_364> method_25396() {
                return List.of(this.toggleButton);
            }

            public List<? extends class_6379> method_37025() {
                return List.of(this.toggleButton);
            }
        }

        public abstract class OptionEntry
        extends class_4265.class_4266<OptionEntry> {
            public OptionEntry(OptionsListWidget this$1) {
            }
        }
    }
}

