/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.screen;

import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.gui.screen.BiomeWeatherTimeScreen;
import lordrius.essentialgui.gui.screen.ClientPlayerWorldScreen;
import lordrius.essentialgui.gui.screen.ItemTooltipsScreen;
import lordrius.essentialgui.gui.screen.MiscFeaturesScreen;
import lordrius.essentialgui.gui.screen.PlayerEquipmentScreen;
import lordrius.essentialgui.gui.screen.PlayerWarningAreaScreen;
import lordrius.essentialgui.gui.screen.PointedBlockScreen;
import lordrius.essentialgui.gui.screen.PointedEntityScreen;
import lordrius.essentialgui.gui.screen.ScreenBase;
import lordrius.essentialgui.gui.screen.options.CrosshairCustomScreen;
import lordrius.essentialgui.gui.screen.options.OptionsScreen;
import lordrius.essentialgui.gui.screen.options.SettingsScreen;
import lordrius.essentialgui.gui.screen.vanilla.VanillaHudScreen;
import lordrius.essentialgui.gui.widgets.ClickableTextWidget;
import lordrius.essentialgui.util.ScreenUtils;
import lordrius.essentialgui.util.TextUtils;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7417;
import net.minecraft.class_7919;
import net.minecraft.class_9848;

public class MainMenuScreen
extends ScreenBase {
    private final ConfigData config = Data.cfg;
    private final String ESSGUI_URL = "https://www.reddit.com/r/EssentialGUI";
    private final String PAYPAL_URL = "https://www.paypal.me/lordrius";
    private final String MESSAGES_KEY = "screen.main_menu.messages.";
    private ClickableTextWidget rotatingMessage;
    private int tickCounter = 0;
    private final int changeInterval = 1200;
    private final int TOTAL_MESSAGES = 11;
    private final Map<String, class_4185.class_4241> messageActions = IntStream.rangeClosed(0, 11).boxed().collect(Collectors.toMap(i -> "screen.main_menu.messages." + i, i -> switch (i) {
        case 0 -> btn -> this.openScreen(new CrosshairCustomScreen(this));
        case 1, 8 -> btn -> this.openScreen(new SettingsScreen(this));
        case 2 -> btn -> this.openScreen(new ItemTooltipsScreen(this));
        case 3 -> btn -> this.openUrl("https://www.reddit.com/r/EssentialGUI");
        case 4 -> btn -> this.openUrl("https://www.paypal.me/lordrius");
        case 5, 9 -> btn -> this.openScreen(new MiscFeaturesScreen(this));
        case 6 -> btn -> this.openScreen(new VanillaHudScreen(this));
        case 11 -> btn -> this.openScreen(new PointedEntityScreen(this));
        default -> btn -> {};
    }));

    public MainMenuScreen(class_437 parent) {
        super(parent, (class_2561)TextUtils.translate("screen.main_menu.title"));
    }

    @Override
    public void method_25426() {
        this.addMessagesButton();
        this.addSideButtons();
        this.addBodyButtons();
    }

    private void addSideButtons() {
        class_2960 WIKI_TEXTURE = class_2960.method_60654((String)"essentialgui:textures/gui/buttons/world.png");
        class_2960 MCSTACKER_TEXTURE = class_2960.method_60654((String)"essentialgui:textures/gui/buttons/mcstacker.png");
        String WIKI_URL = "https://minecraft.wiki";
        String MCSTACKER_URL = "https://mcstacker.net";
        class_5250 WIKI_TIP = TextUtils.translate("screen.main_menu.buttons.wiki");
        class_5250 MCSTACKER_TIP = TextUtils.translate("screen.main_menu.buttons.mcstacker");
        class_5250 OPTIONS_TIP = TextUtils.translate("screen.main_menu.buttons.options");
        this.addToggleModButton(this.iconsX(), this.iconsY());
        this.texturedButton(this.iconsX(), this.field_22790 - 76 - 20, WIKI_TEXTURE, (class_2561)WIKI_TIP, () -> class_156.method_668().method_670("https://minecraft.wiki"));
        this.texturedButton(this.iconsX(), this.field_22790 - 55 - 20, MCSTACKER_TEXTURE, (class_2561)MCSTACKER_TIP, () -> class_156.method_668().method_670("https://mcstacker.net"));
        this.optionsButton(this.iconsX(), this.field_22790 - 34 - 20, (class_2561)OPTIONS_TIP, () -> this.field_22787.method_1507((class_437)new OptionsScreen(this)));
    }

    private void addBodyButtons() {
        this.sectionButton(this.field_22789 / 2 - 155, this.buttonsY(), class_1802.field_8251, this.CLIENT_PLAYER_WORLD, false, () -> this.field_22787.method_1507((class_437)new ClientPlayerWorldScreen(this)), () -> this.config.client.enabled, v -> {
            this.config.client.enabled = v;
        });
        this.sectionButton(this.field_22789 / 2 + 5, this.buttonsY(), class_1802.field_40229, this.PLAYER_WARNING_AREA, true, () -> this.field_22787.method_1507((class_437)new PlayerWarningAreaScreen(this)), () -> this.config.warning.enabled, v -> {
            this.config.warning.enabled = v;
        });
        this.sectionButton(this.field_22789 / 2 - 155, this.buttonsY() + 24, class_1802.field_8583, this.POINTED_BLOCK, false, () -> this.field_22787.method_1507((class_437)new PointedBlockScreen(this)), () -> this.config.block.enabled, v -> {
            this.config.block.enabled = v;
        });
        this.sectionButton(this.field_22789 / 2 + 5, this.buttonsY() + 24, class_1802.field_8694, this.POINTED_ENTITY, true, () -> this.field_22787.method_1507((class_437)new PointedEntityScreen(this)), () -> this.config.entity.enabled, v -> {
            this.config.entity.enabled = v;
        });
        this.sectionButton(this.field_22789 / 2 - 155, this.buttonsY() + 48, class_1802.field_27023, this.PLAYER_EQUIPMENT, false, () -> this.field_22787.method_1507((class_437)new PlayerEquipmentScreen(this)), () -> this.config.equipment.enabled, v -> {
            this.config.equipment.enabled = v;
        });
        this.sectionButton(this.field_22789 / 2 + 5, this.buttonsY() + 48, class_1802.field_8557, this.BIOME_WEATHER_TIME, true, () -> this.field_22787.method_1507((class_437)new BiomeWeatherTimeScreen(this)), () -> this.config.biome.enabled, v -> {
            this.config.biome.enabled = v;
        });
        this.sectionButton(this.field_22789 / 2 - 155, this.buttonsY() + 72, class_1802.field_8448, this.ADVANCED_TOOLTIPS, false, () -> this.field_22787.method_1507((class_437)new ItemTooltipsScreen(this)), () -> this.config.tooltips.enabled, v -> {
            this.config.tooltips.enabled = v;
        });
        this.sectionButton(this.field_22789 / 2 + 5, this.buttonsY() + 72, class_1802.field_8892, this.VANILLA_HUD_CHANGES, true, () -> this.field_22787.method_1507((class_437)new VanillaHudScreen(this)), () -> this.config.vanilla.enabled, v -> {
            this.config.vanilla.enabled = v;
        });
        this.sectionButton(this.field_22789 / 2 - 75, this.buttonsY() + 96, class_1802.field_8536, this.MISC_FEATURES, false, () -> this.field_22787.method_1507((class_437)new MiscFeaturesScreen(this)), () -> this.config.misc.enabled, v -> {
            this.config.misc.enabled = v;
        });
        this.addVersionButton();
        this.doneButton();
    }

    private void addMessagesButton() {
        class_2561 message = this.getDynamicMessage();
        class_4185.class_4241 action = this.getMessageAction(message);
        this.rotatingMessage = (ClickableTextWidget)this.method_37063((class_364)new ClickableTextWidget(this.iconsY() + 3, message, ClickableTextWidget.WidgetStyle.INFORMATIVE, action));
    }

    private class_2561 getDynamicMessage() {
        if (Utils.isHalloween()) {
            return TextUtils.translate("screen.main_menu.messages.halloween", class_124.field_1065);
        }
        if (Utils.isChristmas()) {
            return TextUtils.translate("screen.main_menu.messages.christmas", class_124.field_1077);
        }
        if (Utils.isNewYear()) {
            return TextUtils.translate("screen.main_menu.messages.new_year", class_124.field_1064);
        }
        List<class_5250> list = IntStream.rangeClosed(0, 11).mapToObj(i -> TextUtils.translate("screen.main_menu.messages." + i)).toList();
        return list.get(ThreadLocalRandom.current().nextInt(list.size())).method_27661().method_27694(s -> s.method_36139(-13312));
    }

    private void openScreen(class_437 screen) {
        this.field_22787.method_1507(screen);
    }

    private void openUrl(String url) {
        class_156.method_668().method_670(url);
    }

    private class_4185.class_4241 getMessageAction(class_2561 message) {
        class_7417 class_74172 = message.method_10851();
        if (!(class_74172 instanceof class_2588)) {
            return btn -> {};
        }
        class_2588 content = (class_2588)class_74172;
        return this.messageActions.getOrDefault(content.method_11022(), btn -> {});
    }

    private void addVersionButton() {
        class_5250 VERSION = class_2561.method_43470((String)"v2.0.0");
        class_5250 TOOLTIP = class_2561.method_43470((String)"\u00a7eBuild 251006");
        ClickableTextWidget widget = new ClickableTextWidget(this.field_22789 - this.field_22793.method_27525((class_5348)VERSION) - 2, this.field_22790 - 42, (class_2561)VERSION, ClickableTextWidget.WidgetStyle.VERSION, btn -> class_156.method_668().method_670("https://www.reddit.com/r/EssentialGUI"));
        widget.method_47400(class_7919.method_47407((class_2561)TOOLTIP));
        widget.method_47402(Duration.ofSeconds(1L));
        this.method_37063((class_364)widget);
    }

    private void addToggleModButton(int x, int y) {
        class_2960 TEXTURE = class_2960.method_60654((String)"essentialgui:textures/gui/buttons/toggle/toggle_bulb.png");
        Supplier<class_2561> TIP = () -> TextUtils.translate("screen.main_menu.buttons.toggle");
        this.method_37063((class_364)ScreenUtils.switchButton(x, y, TEXTURE, TIP, () -> Data.cfg.global.enabled, v -> {
            Data.cfg.global.enabled = v;
        }, () -> {
            Data.toggleMod();
            this.method_37067();
            this.method_25426();
        }));
    }

    public void method_25393() {
        ++this.tickCounter;
        if (this.tickCounter >= 1200) {
            this.tickCounter = 0;
            this.method_37066((class_364)this.rotatingMessage);
            this.addMessagesButton();
        }
    }

    @Override
    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25420(context, mouseX, mouseY, delta);
        context.method_51738(4, 19, this.field_22790 - 99, class_9848.method_61330((int)100, (int)-1));
    }
}

