/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_10799;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1819;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import net.minecraft.class_8002;
import net.minecraft.class_9848;
import org.joml.Vector2ic;

public class Draw {
    private static final ConfigData config = Data.cfg;
    private static final class_310 client = class_310.method_1551();
    private static final class_327 textRenderer = Draw.client.field_1772;
    public static final int BLACK_BACKGROUND = new Color(0, 0, 0, 180).getRGB();
    public static final int TEXT_BACKGROUND = new Color(0, 0, 0, 150).getRGB();
    public static final int BLACK = new Color(0, 0, 0).getRGB();
    public static final int DARK_BLUE = new Color(0, 0, 170).getRGB();
    public static final int DARK_GREEN = new Color(0, 170, 0).getRGB();
    public static final int DARK_AQUA = new Color(0, 170, 170).getRGB();
    public static final int DARK_RED = new Color(170, 0, 0).getRGB();
    public static final int DARK_PURPLE = new Color(170, 0, 170).getRGB();
    public static final int GOLD = new Color(255, 170, 0).getRGB();
    public static final int GRAY = new Color(170, 170, 170).getRGB();
    public static final int DARK_GRAY = new Color(85, 85, 85).getRGB();
    public static final int BLUE = new Color(85, 85, 255).getRGB();
    public static final int GREEN = new Color(85, 255, 85).getRGB();
    public static final int AQUA = new Color(85, 255, 255).getRGB();
    public static final int RED = new Color(255, 85, 85).getRGB();
    public static final int LIGHT_PURPLE = new Color(255, 85, 255).getRGB();
    public static final int YELLOW = new Color(255, 255, 85).getRGB();
    public static final int WHITE = new Color(255, 255, 255).getRGB();
    public static final int AQUA_BORDER = new Color(87, 255, 255).getRGB();
    public static final int AQUA_BACKGROUND = new Color(13, 64, 57).getRGB();
    public static final class_2960 ICONS = class_2960.method_60654((String)"essentialgui:textures/icons.png");
    public static final class_2960 EQUIPMENT = class_2960.method_60654((String)"essentialgui:textures/gui/equipment.png");
    public static final class_2960 EQUIPMENT_DARK = class_2960.method_60654((String)"essentialgui:textures/gui/equipment_dark.png");
    public static final class_2960 EQUIPMENT_MULTIPLAYER = class_2960.method_60654((String)"essentialgui:textures/gui/equipment_multiplayer.png");
    public static final class_2960 WIDGETS = class_2960.method_60654((String)"essentialgui:textures/gui/widgets.png");
    public static final class_2960 SHULKER_HUD = class_2960.method_60654((String)"essentialgui:textures/gui/shulker_box.png");
    public static final class_2960 BUNDLE_HUD = class_2960.method_60654((String)"essentialgui:textures/gui/bundle.png");
    public static final class_2960 ATTACK = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/attack.png");
    public static final class_2960 ATTACK_SPEED = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/attack_speed.png");
    public static final class_2960 DURABILITY = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/anvil.png");
    public static final class_2960 ARMOR = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/armor.png");
    public static final class_2960 ARMOR_TOUGHNESS = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/armor_toughness.png");
    public static final class_2960 HEART_FULL = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/heart_full.png");
    public static final class_2960 HEART_HALF = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/heart_half.png");
    public static final class_2960 HUNGER_FULL = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/hunger_full.png");
    public static final class_2960 HUNGER_HALF = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/hunger_half.png");
    public static final class_2960 SATURATION = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/saturation.png");
    public static final class_2960 OXYGEN = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/oxygen.png");
    public static final class_2960 FREEZE = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/freeze.png");
    public static final class_2960 PLUS = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/plus.png");
    public static final class_2960 CROSSHAIR = class_2960.method_60656((String)"hud/crosshair");
    public static final class_2960 INVENTORY_SLOT = class_2960.method_60656((String)"container/slot");
    public static final class_2960 QUIVER = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/quiver.png");
    public static final class_2960 EMPTY_SLOT_SWORD = class_2960.method_60654((String)"minecraft:textures/gui/sprites/container/slot/sword.png");
    public static final class_2960 EMPTY_SLOT_QUIVER = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/empty_slot_quiver.png");
    public static final class_2960 EMPTY_SLOT_TOTEM = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/empty_slot_totem.png");
    public static final class_2960 EMPTY_ARMOR_SLOT_HELMET = class_2960.method_60654((String)"minecraft:textures/gui/sprites/container/slot/helmet.png");
    public static final class_2960 EMPTY_ARMOR_SLOT_CHESTPLATE = class_2960.method_60654((String)"minecraft:textures/gui/sprites/container/slot/chestplate.png");
    public static final class_2960 EMPTY_ARMOR_SLOT_LEGGINGS = class_2960.method_60654((String)"minecraft:textures/gui/sprites/container/slot/leggings.png");
    public static final class_2960 EMPTY_ARMOR_SLOT_BOOTS = class_2960.method_60654((String)"minecraft:textures/gui/sprites/container/slot/boots.png");
    public static final class_2960 EMPTY_ARMOR_SLOT_SHIELD = class_2960.method_60654((String)"minecraft:textures/gui/sprites/container/slot/shield.png");
    public static final class_2960 HELMET = class_2960.method_60654((String)"minecraft:textures/item/iron_helmet.png");
    public static final class_2960 CHESTPLATE = class_2960.method_60654((String)"minecraft:textures/item/iron_chestplate.png");
    public static final class_2960 LEGGINGS = class_2960.method_60654((String)"minecraft:textures/item/iron_leggings.png");
    public static final class_2960 BOOTS = class_2960.method_60654((String)"minecraft:textures/item/iron_boots.png");
    public static final class_2960 SWORD = class_2960.method_60654((String)"minecraft:textures/item/iron_sword.png");
    public static final class_2960 SHIELD = class_2960.method_60654((String)"essentialgui:textures/gui/sprites/shield.png");

    public static void drawBlockBreakingProgress(class_332 context, int x, int y, int sizeX, int sizeY, int percentage) {
        ConfigData.PointedBlock config = Data.cfg.block;
        if (percentage > 100) {
            percentage = 100;
        }
        int scaled = percentage * sizeX / 100;
        boolean rounded = config.breakingBar.style.contains("rounded");
        boolean useShadow = config.breakingBar.shadow;
        int base = Utils.getColor(config.breakingBar.baseColor);
        int shadow = Utils.getColor(config.breakingBar.shadowColor);
        if (rounded) {
            Draw.drawRoundedRectangle(context, x, y - 3, sizeX, sizeY);
        } else {
            Draw.drawCustomRectangle(context, x, y - 3, sizeX, sizeY);
        }
        if (scaled > 0) {
            context.method_25294(x + 1, y - 2, x + scaled, y + sizeY - 3, base);
        }
        if (scaled > 1 && useShadow) {
            Draw.drawCustomRectangle(context, x + 1, y - 2, scaled - 2, sizeY - 2, 0, shadow);
        }
        if (config.breakingBar.value) {
            context.method_25300(textRenderer, percentage + "%", x + sizeX / 2 + 1, y + sizeY / 2 - 6, -1);
        }
    }

    public static void drawBoxItem(class_332 context, int x, int y, boolean withBorders) {
        context.method_25294(x, y, x + 18, y + 18, Draw.getSectionBackgroundColor());
        if (withBorders) {
            context.method_51738(x, x + 17, y, Draw.getSectionBorderColor());
            context.method_51738(x, x + 17, y + 17, Draw.getSectionBorderColor());
            context.method_51742(x, y, y + 17, Draw.getSectionBorderColor());
            context.method_51742(x + 17, y, y + 17, Draw.getSectionBorderColor());
        }
    }

    public static void drawBoxText(class_332 context, int x, int y, String text) {
        Draw.drawBoxText(context, x, y, class_2561.method_30163((String)text), true, true, GRAY);
    }

    public static void drawBoxText(class_332 context, int x, int y, String text, boolean withBorders) {
        Draw.drawBoxText(context, x, y, class_2561.method_30163((String)text), withBorders, true, GRAY);
    }

    public static void drawBoxText(class_332 context, int x, int y, class_2561 title, boolean withBorders) {
        Draw.drawBoxText(context, x, y, title, withBorders, true, GRAY);
    }

    public static void drawBoxText(class_332 context, int x, int y, String text, boolean withBorders, boolean withBackground, int textColor) {
        Draw.drawBoxText(context, x, y, class_2561.method_30163((String)text), withBorders, withBackground, textColor);
    }

    public static void drawBoxText(class_332 context, int x, int y, class_2561 text, boolean withBorders, boolean withBackground, int textColor) {
        int stringWidth = textRenderer.method_27525((class_5348)text);
        if (withBackground) {
            context.method_25294(x - 3, y - 3, x + stringWidth + 2, y + 10, Draw.getSectionBackgroundColor());
        }
        if (withBorders) {
            context.method_51738(x - 2, x + stringWidth, y - 3, Draw.getSectionBorderColor());
            context.method_51738(x - 2, x + stringWidth, y + 9, Draw.getSectionBorderColor());
            context.method_51742(x - 3, y - 4, y + 10, Draw.getSectionBorderColor());
            context.method_51742(x + stringWidth + 1, y - 4, y + 10, Draw.getSectionBorderColor());
        }
        context.method_27535(textRenderer, text, x, y, textColor | 0xFF000000);
    }

    public static void drawBoxTextCenter(class_332 context, int x, int y, int stringWidth, String text, int textColor) {
        Draw.drawBoxTextCenter(context, x, y, stringWidth, text, true, Draw.getSectionBackgroundColor(), textColor);
    }

    public static void drawBoxTextCenter(class_332 context, int x, int y, class_2561 text, boolean withBorders) {
        Draw.drawBoxTextCenter(context, x, y, textRenderer.method_27525((class_5348)text), text, withBorders, Draw.getSectionBackgroundColor(), GRAY);
    }

    public static void drawBoxTextCenter(class_332 context, int x, int y, int stringWidth, String text, boolean withBorders) {
        Draw.drawBoxTextCenter(context, x, y, stringWidth, text, withBorders, Draw.getSectionBackgroundColor(), GRAY);
    }

    public static void drawBoxTextCenter(class_332 context, int x, int y, int stringWidth, String text, boolean withBorders, int backgroundColor, int textColor) {
        Draw.drawBoxTextCenter(context, x, y, stringWidth, class_2561.method_30163((String)text), withBorders, backgroundColor, textColor);
    }

    public static void drawBoxTextCenter(class_332 context, int x, int y, int stringWidth, class_2561 text, boolean withBorders, int backgroundColor, int textColor) {
        context.method_25294(x - 3, y - 3, x + stringWidth + 2, y + 10, backgroundColor);
        if (withBorders) {
            context.method_51738(x - 2, x + stringWidth, y - 3, Draw.getSectionBorderColor());
            context.method_51738(x - 2, x + stringWidth, y + 9, Draw.getSectionBorderColor());
            context.method_51742(x - 3, y - 4, y + 10, Draw.getSectionBorderColor());
            context.method_51742(x + stringWidth + 1, y - 4, y + 10, Draw.getSectionBorderColor());
        }
        context.method_27534(textRenderer, text, x + stringWidth / 2, y, textColor);
    }

    public static void drawBoxTextRight(class_332 context, int x, int y, String text, boolean withBorders) {
        int stringWidth = textRenderer.method_1727(text);
        context.method_25294(x - stringWidth - 6, y - 3, x, y + 10, Draw.getSectionBackgroundColor());
        if (withBorders) {
            context.method_51738(x - stringWidth - 5, x - 2, y - 3, Draw.getSectionBorderColor());
            context.method_51738(x - stringWidth - 5, x - 2, y + 9, Draw.getSectionBorderColor());
            context.method_51742(x - stringWidth - 6, y - 4, y + 10, Draw.getSectionBorderColor());
            context.method_51742(x - 1, y - 4, y + 10, Draw.getSectionBorderColor());
        }
        context.method_25303(textRenderer, text, x - stringWidth - 3, y, GRAY);
    }

    public static void drawBoxTextDynamicString(class_332 context, int x, int y, List<String> strings, boolean alignRight, boolean withBorders) {
        if (strings.isEmpty()) {
            return;
        }
        ArrayList<class_2561> texts = new ArrayList<class_2561>();
        for (String s : strings) {
            texts.add((class_2561)class_2561.method_43470((String)(Draw.config.client.prefixColor + s)));
        }
        Draw.drawBoxTextDynamic(context, x, y, texts, alignRight, withBorders);
    }

    public static void drawBoxTextDynamic(class_332 context, int x, int y, List<class_2561> texts, boolean alignRight, boolean withBorders) {
        if (texts.isEmpty()) {
            return;
        }
        int maxWidth = texts.stream().mapToInt(arg_0 -> ((class_327)textRenderer).method_27525(arg_0)).max().orElse(0);
        int fontSep = 11;
        int left = alignRight ? x - maxWidth - 6 : x - 3;
        int right = alignRight ? x : x + maxWidth + 3;
        int top = y - 3;
        int bottom = y + fontSep * texts.size();
        context.method_25294(left, top, right, bottom, Draw.getSectionBackgroundColor());
        if (withBorders) {
            context.method_51738(left + 1, right - 2, top, Draw.getSectionBorderColor());
            context.method_51738(left + 1, right - 2, bottom - 1, Draw.getSectionBorderColor());
            context.method_51742(left, top - 1, bottom, Draw.getSectionBorderColor());
            context.method_51742(right - 1, top - 1, bottom, Draw.getSectionBorderColor());
        }
        for (int i = 0; i < texts.size(); ++i) {
            int textX = alignRight ? x - maxWidth - 3 : x;
            context.method_27535(textRenderer, texts.get(i), textX, y + fontSep * i, GRAY);
        }
    }

    public static void drawPropertiesBox(class_332 context, int x, int y, List<class_2561> texts, boolean withBorders) {
        if (texts.isEmpty()) {
            return;
        }
        int maxWidth = texts.stream().mapToInt(arg_0 -> ((class_327)textRenderer).method_27525(arg_0)).max().orElse(0);
        int fontSep = 10;
        int left = x - 3;
        int right = x + maxWidth + 3;
        int top = y - 3;
        int bottom = y + fontSep * texts.size();
        context.method_25294(left, top, right, bottom, Draw.getSectionBackgroundColor());
        if (withBorders) {
            context.method_51738(left + 1, right - 2, top, Draw.getSectionBorderColor());
            context.method_51738(left + 1, right - 2, bottom - 1, Draw.getSectionBorderColor());
            context.method_51742(left, top - 1, bottom, Draw.getSectionBorderColor());
            context.method_51742(right - 1, top - 1, bottom, Draw.getSectionBorderColor());
        }
        for (int i = 0; i < texts.size(); ++i) {
            int textX = x;
            context.method_27535(textRenderer, texts.get(i), textX, y + fontSep * i, GRAY);
        }
    }

    public static void drawTextWithBackground(class_332 context, int x, int y, class_2561 text) {
        int i = textRenderer.method_27525((class_5348)text);
        Objects.requireNonNull(textRenderer);
        int l = y + 9 + 1;
        context.method_25294(x - 3, y - 3, x + i + 3, l + 1, TEXT_BACKGROUND);
        context.method_27535(textRenderer, text, x, y, WHITE);
    }

    public static void drawCenteredTextWithBackground(class_332 context, int x, int y, class_2561 text) {
        Draw.drawCenteredTextWithBackground(context, x, y, text, false, TEXT_BACKGROUND, TEXT_BACKGROUND, WHITE);
    }

    public static void drawCenteredTextWithBackground(class_332 context, int x, int y, class_2561 text, int backgroundColor) {
        Draw.drawCenteredTextWithBackground(context, x, y, text, false, backgroundColor, backgroundColor, WHITE);
    }

    public static void drawCenteredTextWithBackgroundF(class_332 context, int x, int y, class_2561 text, int textColor) {
        Draw.drawCenteredTextWithBackground(context, x, y, text, false, Utils.getBackgroundOpacity(), Utils.getBackgroundOpacity(), textColor);
    }

    public static void drawCenteredTextWithBackground(class_332 context, int x, int y, class_2561 text, boolean border, int borderColor, int backgroundColor, int textColor) {
        int i = textRenderer.method_27525((class_5348)text);
        int j = (context.method_51421() - i) / 2;
        int k = y;
        Objects.requireNonNull(textRenderer);
        int l = k + 9 + 1;
        context.method_25294(j - 3, k - 3, j + i + 3, l + 1, backgroundColor);
        if (border) {
            context.method_51738(j - 3, j + i + 2, k - 3, borderColor);
            context.method_51738(j - 3, j + i + 2, l, borderColor);
            context.method_51742(j - 3, k - 3, l, borderColor);
            context.method_51742(j + i + 2, k - 3, l, borderColor);
        }
        context.method_27535(textRenderer, text, j, y, textColor);
    }

    public static void drawCenteredTextWithBackgroundRounded(class_332 context, int x, int y, class_2561 text) {
        Draw.drawCenteredTextWithBackgroundRounded(context, x, y, text, false, TEXT_BACKGROUND, TEXT_BACKGROUND, WHITE);
    }

    public static void drawCenteredTextWithBackgroundRoundedF(class_332 context, int x, int y, class_2561 text, int textColor) {
        Draw.drawCenteredTextWithBackgroundRounded(context, x, y, text, false, Utils.getBackgroundOpacity(), Utils.getBackgroundOpacity(), textColor);
    }

    public static void drawCenteredTextWithBackgroundRounded(class_332 context, int x, int y, class_2561 text, boolean border, int borderColor, int backgroundColor, int textColor) {
        int i = textRenderer.method_27525((class_5348)text);
        int j = (context.method_51421() - i) / 2;
        int k = y;
        Objects.requireNonNull(textRenderer);
        int l = k + 9 + 1;
        context.method_25294(j - 2, k - 3, j + i + 2, l + 1, backgroundColor);
        context.method_51742(j - 3, k - 3, l, backgroundColor);
        context.method_51742(j + i + 2, k - 3, l, backgroundColor);
        if (border) {
            context.method_51738(j - 2, j + i + 1, k - 3, borderColor);
            context.method_51738(j - 2, j + i + 1, l, borderColor);
            context.method_51742(j - 3, k - 3, l, borderColor);
            context.method_51742(j + i + 2, k - 3, l, borderColor);
        }
        context.method_27535(textRenderer, text, j, y, textColor);
    }

    public static void drawCustomRectangle(class_332 context, int x, int y, int sizeX, int sizeY) {
        Draw.drawCustomRectangle(context, x, y, sizeX, sizeY, true, Draw.getSectionBackgroundColor(), Draw.getSectionBorderColor());
    }

    public static void drawCustomRectangle(class_332 context, int x, int y, int sizeX, int sizeY, int backgroundColor) {
        Draw.drawCustomRectangle(context, x, y, sizeX, sizeY, true, backgroundColor, Draw.getSectionBorderColor());
    }

    public static void drawCustomRectangle(class_332 context, int x, int y, int sizeX, int sizeY, int backgroundColor, int borderColor) {
        Draw.drawCustomRectangle(context, x, y, sizeX, sizeY, true, backgroundColor, borderColor);
    }

    public static void drawCustomRectangle(class_332 context, int x, int y, int sizeX, int sizeY, boolean withBorders) {
        Draw.drawCustomRectangle(context, x, y, sizeX, sizeY, withBorders, Draw.getSectionBackgroundColor(), Draw.getSectionBorderColor());
    }

    public static void drawCustomRectangle(class_332 context, int x, int y, int sizeX, int sizeY, boolean withBorders, int backgroundColor, int borderColor) {
        context.method_25294(x, y, x + sizeX + 1, y + sizeY + 1, backgroundColor);
        if (withBorders) {
            context.method_51738(x, x + sizeX, y, borderColor);
            context.method_51738(x, x + sizeX, y + sizeY, borderColor);
            context.method_51742(x, y, y + sizeY, borderColor);
            context.method_51742(x + sizeX, y, y + sizeY, borderColor);
        }
    }

    public static void drawIconHealth(class_332 context, int x, int y, boolean drawBackground, boolean roundedBackground, int backgroundColor) {
        if (drawBackground) {
            if (!roundedBackground) {
                Draw.drawCustomRectangle(context, x - 2, y - 3, 12, 12, backgroundColor);
            } else {
                Draw.drawRoundedRectangle(context, x - 2, y - 3, 12, 12, backgroundColor);
            }
        }
        Draw.drawTexture(context, HEART_FULL, x, y - 1, 9);
    }

    public static void drawIconOxygen(class_332 context, int x, int y, boolean drawBackground, boolean roundedBackground, int backgroundColor) {
        if (drawBackground) {
            if (!roundedBackground) {
                Draw.drawCustomRectangle(context, x - 2, y - 3, 12, 12, backgroundColor);
            } else {
                Draw.drawRoundedRectangle(context, x - 2, y - 3, 12, 12, backgroundColor);
            }
        }
        Draw.drawTexture(context, OXYGEN, x, y - 1, 9);
    }

    public static void drawInformationBar(class_332 context, int x, int y, class_2561 text) {
        context.method_25294(x, y, context.method_51421() - 1, y + 14, class_9848.method_61330((int)120, (int)-16777216));
        Draw.drawTexture(context, class_2960.method_60654((String)"essentialgui:textures/gui/sprites/info.png"), x + 2, y + 1, 0.0f, 0.0f, 9, 12, 9, 12);
        context.method_27535(textRenderer, text, x + 14, y + 3, -1);
    }

    public static void drawInformationBox(class_332 context, class_5348 text, int x, int y, int width, int color) {
        List wrappedLines = textRenderer.method_1728(text, width);
        int textHeight = wrappedLines.size() * 9;
        int initialY = y;
        context.method_25294(x - 2, y - 2, x + width + 2, initialY + textHeight + 2, Integer.MIN_VALUE);
        Draw.drawTexture(context, class_2960.method_60654((String)"essentialgui:textures/gui/sprites/info.png"), x - 2, y - 15, 0.0f, 0.0f, 9, 12, 9, 12);
        int currentY = initialY;
        for (class_5481 line : wrappedLines) {
            context.method_35720(textRenderer, line, x, currentY, color);
            currentY += 10;
        }
    }

    public static void drawInventorySlot(class_332 context, int x, int y) {
        context.method_52706(class_10799.field_56883, INVENTORY_SLOT, x, y, 18, 18);
    }

    public static void drawItemWithSlot(class_332 context, class_1799 stack, int x, int y) {
        Draw.drawInventorySlot(context, x - 1, y - 1);
        Draw.drawItem(context, stack, x, y);
    }

    public static void drawItemScaled(class_332 context, class_1799 stack, int x, int y, float scale) {
        int i = Math.round((float)x / scale);
        int j = Math.round((float)y / scale);
        context.method_51448().pushMatrix();
        context.method_51448().scale(scale, scale);
        Draw.drawItem(context, stack, i, j);
        context.method_51448().popMatrix();
    }

    public static void drawItem(class_332 context, class_1799 stack, int x, int y) {
        Draw.drawItem(context, stack, x, y, true);
    }

    public static void drawItem(class_332 context, class_1799 stack, int x, int y, boolean withOverlay) {
        boolean isShield = stack.method_7909() instanceof class_1819;
        context.method_51427(stack, isShield ? x + 1 : x, y);
        if (withOverlay) {
            context.method_51431(textRenderer, stack, x, y);
        }
    }

    public static void drawHealthBar(class_332 context, int x, int y, int sizeX, int sizeY, int value, String text) {
        ConfigData.PointedEntity config = Data.cfg.entity;
        boolean showIcon = config.statsBars.icons;
        boolean rounded = config.statsBars.style.contains("rounded");
        boolean useShadow = config.statsBars.shadow;
        int base = Utils.getColor(config.statsBars.healthBaseColor);
        int shadow = Utils.getColor(config.statsBars.healthShadowColor);
        if (showIcon) {
            Draw.drawIconHealth(context, x - 12, y + 3, showIcon, rounded, base);
        }
        if (!rounded) {
            Draw.drawCustomRectangle(context, x, y, sizeX, sizeY);
        } else {
            Draw.drawRoundedRectangle(context, x, y, sizeX, sizeY);
        }
        context.method_25294(x + 1, y + 1, x + value, y + sizeY, base);
        if (useShadow) {
            Draw.drawCustomRectangle(context, x + 1, y + 1, value - 2, sizeY - 2, 0, shadow);
        }
        if (config.statsBars.values) {
            context.method_25300(textRenderer, text, x + sizeX / 2 + 1, y + sizeY / 2 - 3, -1);
        }
    }

    public static void drawOffHandSlot(class_332 context, int x, int y) {
        Draw.drawTextureSprite(context, WIDGETS, x, y, 0.0f, 118.0f, 22, 22);
    }

    public static void drawOxygenBar(class_332 context, int x, int y, int sizeX, int sizeY, int value, String text) {
        ConfigData.PointedEntity config = Data.cfg.entity;
        boolean showIcon = config.statsBars.icons;
        boolean rounded = config.statsBars.style.contains("rounded");
        boolean useShadow = config.statsBars.shadow;
        int base = Utils.getColor(config.statsBars.oxygenBaseColor);
        int shadow = Utils.getColor(config.statsBars.oxygenShadowColor);
        if (showIcon) {
            Draw.drawIconOxygen(context, x - 12, y + 3, showIcon, rounded, base);
        }
        if (rounded) {
            Draw.drawRoundedRectangle(context, x, y, sizeX, sizeY);
        } else {
            Draw.drawCustomRectangle(context, x, y, sizeX, sizeY);
        }
        if (value > 0) {
            context.method_25294(x + 1, y + 1, x + value, y + sizeY, base);
            if (value > 1 && useShadow) {
                Draw.drawCustomRectangle(context, x + 1, y + 1, value - 2, sizeY - 2, 0, shadow);
            }
        }
        if (config.statsBars.values) {
            context.method_25300(textRenderer, text, x + sizeX / 2 + 1, y + sizeY / 2 - 3, -1);
        }
    }

    public static void drawPropertiesIcon(class_332 context, class_1792 item, int x, int y, int backgroundColor) {
        Draw.drawPropertiesIcon(context, item, x, y, 0, 0, 1.0f, backgroundColor);
    }

    public static void drawPropertiesIcon(class_332 context, class_1792 item, int x, int y, int offsetX, int offsetY, int backgroundColor) {
        Draw.drawPropertiesIcon(context, item, x, y, offsetX, offsetY, 1.0f, backgroundColor);
    }

    public static void drawPropertiesIcon(class_332 context, class_1792 item, int x, int y, int offsetX, int offsetY, float scale, int backgroundColor) {
        Draw.drawPropertiesIcon(context, item, x, y, offsetX, offsetY, scale, backgroundColor, false);
    }

    public static void drawPropertiesIcon(class_332 context, class_1792 item, int x, int y, int offsetX, int offsetY, float scale, int backgroundColor, boolean multiple) {
        Draw.drawCustomRectangle(context, x, y, 15, 15, backgroundColor);
        if (multiple) {
            context.method_25303(textRenderer, "+", x + 2, y + 1, YELLOW);
        }
        context.method_51448().pushMatrix();
        context.method_51448().scale(scale, scale);
        int i = Math.round((float)x / scale + (float)offsetX);
        int j = Math.round((float)y / scale + (float)offsetY);
        context.method_51427(new class_1799((class_1935)item), i, j);
        context.method_51448().popMatrix();
    }

    public static void drawRoundedRectangle(class_332 context, int x, int y, int sizeX, int sizeY) {
        Draw.drawRoundedRectangle(context, x, y, sizeX, sizeY, Draw.getSectionBackgroundColor());
    }

    public static void drawRoundedRectangle(class_332 context, int x, int y, int sizeX, int sizeY, int backgroundColor) {
        Draw.drawRoundedRectangle(context, x, y, sizeX, sizeY, Draw.getSectionBorderColor(), backgroundColor);
    }

    public static void drawRoundedRectangle(class_332 context, int x, int y, int sizeX, int sizeY, int borderColor, int backgroundColor) {
        context.method_25294(x + 1, y, x + sizeX, y + sizeY + 1, backgroundColor);
        context.method_51738(x + 1, x + sizeX - 1, y, borderColor);
        context.method_51738(x + 1, x + sizeX - 1, y + sizeY, borderColor);
        context.method_51742(x, y, y + sizeY, borderColor);
        context.method_51742(x + sizeX, y, y + sizeY, borderColor);
    }

    public static void drawRoundedRectangleBorderless(class_332 context, int x, int y, int sizeX, int sizeY, int backgroundColor) {
        context.method_25294(x, y - 1, x + sizeX + 2, y + sizeY + 3, backgroundColor);
        context.method_51742(x - 1, y - 1, y + sizeY + 2, backgroundColor);
        context.method_51742(x + sizeX + 2, y - 1, y + sizeY + 2, backgroundColor);
    }

    public static void drawRectangleBorderless(class_332 context, int x, int y, int sizeX, int sizeY, int backgroundColor) {
        context.method_25294(x - 1, y - 1, x + sizeX + 3, y + sizeY + 3, backgroundColor);
    }

    public static void drawTooltip(class_332 context, List<class_2561> text, int x, int y) {
        Draw.drawTooltipImmediately(context, text.stream().map(class_2561::method_30937).map(class_5684::method_32662).toList(), x, y, class_8001.field_41687);
    }

    public static void drawTooltipImmediately(class_332 context, List<class_5684> components, int x, int y, class_8000 positioner) {
        class_5684 tooltipComponent2;
        int q;
        int i = 0;
        int j = components.size() == 1 ? -2 : 0;
        for (class_5684 tooltipComponent : components) {
            int k = tooltipComponent.method_32664(textRenderer);
            if (k > i) {
                i = k;
            }
            j += tooltipComponent.method_32661(textRenderer);
        }
        int l = i;
        int m = j;
        Vector2ic vector2ic = positioner.method_47944(context.method_51421(), context.method_51443(), x, y, i, j);
        int n = vector2ic.x();
        int o = vector2ic.y();
        context.method_51448().pushMatrix();
        class_8002.method_47946((class_332)context, (int)n, (int)o, (int)i, (int)j, null);
        int p = o;
        for (q = 0; q < components.size(); ++q) {
            tooltipComponent2 = components.get(q);
            tooltipComponent2.method_32665(context, textRenderer, n, p);
            p += tooltipComponent2.method_32661(textRenderer) + (q == 0 ? 2 : 0);
        }
        p = o;
        for (q = 0; q < components.size(); ++q) {
            tooltipComponent2 = components.get(q);
            tooltipComponent2.method_32666(textRenderer, n, p, l, m, context);
            p += tooltipComponent2.method_32661(textRenderer) + (q == 0 ? 2 : 0);
        }
        context.method_51448().popMatrix();
    }

    public static void drawTextureSprite(class_332 context, class_2960 texture, int x, int y, float u, float v, int textureWidth, int textureHeigh) {
        Draw.drawTextureSpriteTinted(context, texture, x, y, u, v, textureWidth, textureHeigh, -1);
    }

    public static void drawTextureSpriteZ(class_332 context, class_2960 texture, int x, int y, float u, float v, int textureWidth, int textureHeigh) {
        Draw.drawTextureSpriteTinted(context, texture, x, y, u, v, textureWidth, textureHeigh, -1);
    }

    public static void drawTextureSpriteTinted(class_332 context, class_2960 texture, int x, int y, float u, float v, int width, int heigh, int shaderColor) {
        context.method_25291(class_10799.field_56883, texture, x, y, u, v, width, heigh, 256, 256, shaderColor);
    }

    public static void drawTextureSpriteScaled(class_332 context, class_2960 texture, int x, int y, float u, float v, int scaleSize, int textureSize) {
        context.method_25302(class_10799.field_56883, texture, x, y, u, v, scaleSize, scaleSize, textureSize, textureSize, 256, 256);
    }

    public static void drawTexture(class_332 context, class_2960 texture, int x, int y, int textureSize) {
        Draw.drawTexture(context, texture, x, y, 0.0f, 0.0f, textureSize, textureSize, textureSize, textureSize);
    }

    public static void drawTextureTinted(class_332 context, class_2960 texture, int x, int y, int textureSize, int shaderColor) {
        Draw.drawTexture(context, texture, x, y, 0.0f, 0.0f, textureSize, textureSize, textureSize, textureSize, shaderColor);
    }

    public static void drawTexture(class_332 context, class_2960 texture, int x, int y, float u, float v, int sizeX, int sizeY, int textureWidth, int textureHeight) {
        Draw.drawTexture(context, texture, x, y, u, v, sizeX, sizeY, textureWidth, textureHeight, -1);
    }

    public static void drawTexture(class_332 context, class_2960 texture, int x, int y, float u, float v, int sizeX, int sizeY, int textureWidth, int textureHeight, int shaderColor) {
        context.method_25291(class_10799.field_56883, texture, x, y, u, v, sizeX, sizeY, textureWidth, textureHeight, shaderColor);
    }

    public static int getSectionBackgroundColor() {
        return Utils.getColor(Data.cfg.settings.sectionsBackgroundColor);
    }

    public static int getSectionBorderColor() {
        return Utils.getColor(Data.cfg.settings.sectionsBorderColor);
    }
}

