/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lordrius.essentialgui.config.ConfigData;

public class Data {
    private static final Path CONFIG_PATH = Paths.get("config/essentialgui.json", new String[0]);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static ConfigData cfg = new ConfigData();
    private static Map<String, Boolean> originalState = null;
    private static final List<SectionToggle> toggles = List.of(new SectionToggle("client", () -> Data.cfg.client.enabled, value -> {
        Data.cfg.client.enabled = value;
    }), new SectionToggle("warning", () -> Data.cfg.warning.enabled, value -> {
        Data.cfg.warning.enabled = value;
    }), new SectionToggle("block", () -> Data.cfg.block.enabled, value -> {
        Data.cfg.block.enabled = value;
    }), new SectionToggle("entity", () -> Data.cfg.entity.enabled, value -> {
        Data.cfg.entity.enabled = value;
    }), new SectionToggle("equipment", () -> Data.cfg.equipment.enabled, value -> {
        Data.cfg.equipment.enabled = value;
    }), new SectionToggle("biome", () -> Data.cfg.biome.enabled, value -> {
        Data.cfg.biome.enabled = value;
    }), new SectionToggle("tooltips", () -> Data.cfg.tooltips.enabled, value -> {
        Data.cfg.tooltips.enabled = value;
    }), new SectionToggle("vanilla", () -> Data.cfg.vanilla.enabled, value -> {
        Data.cfg.vanilla.enabled = value;
    }), new SectionToggle("misc", () -> Data.cfg.misc.enabled, value -> {
        Data.cfg.misc.enabled = value;
    }));

    public static void load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                ConfigData loaded = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                if (loaded != null) {
                    cfg = loaded;
                }
            }
            catch (IOException e) {
                System.out.println("[EssentialGUI] Error while loading config file: " + e.getMessage());
            }
            catch (Exception e) {
                System.out.println("[EssentialGUI] Invalid config file, resetting to default.");
                Data.save();
            }
        } else {
            Data.save();
        }
    }

    public static void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)cfg, (Appendable)writer);
            }
        }
        catch (IOException e) {
            System.out.println("[EssentialGUI] Error while saving config file: " + e.getMessage());
        }
    }

    public static void toggleMod() {
        if (originalState == null) {
            originalState = new HashMap<String, Boolean>();
            for (SectionToggle toggle : toggles) {
                originalState.put(toggle.name, toggle.getter.get());
                toggle.setter.accept(false);
            }
        } else {
            for (SectionToggle toggle : toggles) {
                toggle.setter.accept(originalState.get(toggle.name));
            }
            originalState = null;
        }
        Data.save();
    }

    public static class SectionToggle {
        public final String name;
        public final Supplier<Boolean> getter;
        public final Consumer<Boolean> setter;

        public SectionToggle(String name, Supplier<Boolean> getter, Consumer<Boolean> setter) {
            this.name = name;
            this.getter = getter;
            this.setter = setter;
        }
    }
}

