/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.events;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2421;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3830;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_761;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class CropsReadyIndicator {
    private final ConfigData.MiscFeatures.CropsReadyIndicator config;
    private final class_310 client;
    private final int UPDATE_INTERVAL = 20;
    private final class_2960 DEFAULT_ICON;
    private final Set<class_2338> harvestableBlocks;
    private class_2338 lastPlayerBlockPos;
    private long lastUpdateTick;
    public static final CropsReadyIndicator INSTANCE = new CropsReadyIndicator();
    private final Map<class_2248, class_2960> VANILLA_CROPS;

    public CropsReadyIndicator() {
        this.config = Data.cfg.misc.cropsReady;
        this.client = class_310.method_1551();
        this.UPDATE_INTERVAL = 20;
        this.DEFAULT_ICON = class_2960.method_60654((String)"minecraft:textures/item/wooden_hoe.png");
        this.harvestableBlocks = new HashSet<class_2338>();
        this.lastPlayerBlockPos = class_2338.field_10980;
        this.lastUpdateTick = 0L;
        this.VANILLA_CROPS = Map.of(class_2246.field_10293, class_2960.method_60654((String)"minecraft:textures/item/wheat.png"), class_2246.field_10609, class_2960.method_60654((String)"minecraft:textures/item/carrot.png"), class_2246.field_10247, class_2960.method_60654((String)"minecraft:textures/item/potato.png"), class_2246.field_10341, class_2960.method_60654((String)"minecraft:textures/item/beetroot.png"), class_2246.field_16999, class_2960.method_60654((String)"minecraft:textures/item/sweet_berries.png"), class_2246.field_9974, class_2960.method_60654((String)"minecraft:textures/item/nether_wart.png"));
    }

    public void render(class_4587 matrices) {
        if (!this.config.enabled || this.client.field_1724 == null || this.client.field_1687 == null) {
            return;
        }
        long currentTick = this.client.field_1687.method_8510();
        class_2338 playerPos = this.client.field_1724.method_24515();
        if (currentTick - this.lastUpdateTick >= 20L || !playerPos.equals((Object)this.lastPlayerBlockPos)) {
            this.lastUpdateTick = currentTick;
            this.lastPlayerBlockPos = playerPos;
            this.updateHarvestableBlocks(playerPos);
        }
        if (this.harvestableBlocks.isEmpty()) {
            return;
        }
        class_4184 camera = this.client.field_1773.method_19418();
        class_243 camPos = camera.method_19326();
        for (class_2338 pos : this.harvestableBlocks) {
            if (this.config.item) {
                this.drawHarvestIcon(matrices, this.client.field_1687.method_8320(pos), pos, camPos, camera.method_23767());
            }
            if (!this.config.particles || currentTick % 101L != 0L) continue;
            this.emitHarvestParticles(pos, 1);
        }
    }

    private void updateHarvestableBlocks(class_2338 playerPos) {
        this.harvestableBlocks.clear();
        class_243 centerVec = playerPos.method_46558();
        int radius = this.config.radius;
        for (class_2338 pos : class_2338.method_25996((class_2338)playerPos, (int)radius, (int)radius, (int)radius)) {
            class_2680 state;
            if (!pos.method_19769((class_2374)centerVec, (double)radius) || !this.isHarvestable(state = this.client.field_1687.method_8320(pos))) continue;
            this.harvestableBlocks.add(new class_2338((class_2382)pos));
        }
    }

    private void drawHarvestIcon(class_4587 matrices, class_2680 state, class_2338 pos, class_243 camPos, Quaternionf rotation) {
        float time = (float)this.client.field_1687.method_8510() + this.client.method_61966().method_60636();
        double rawBounce = Math.sin((double)time * 0.1) * 0.5;
        double bounce = this.config.bounce ? rawBounce * rawBounce * 0.5 : 0.0;
        double x = (double)pos.method_10263() - camPos.field_1352 + 0.5;
        double y = (double)pos.method_10264() - camPos.field_1351 + 1.5 + bounce;
        double z = (double)pos.method_10260() - camPos.field_1350 + 0.5;
        matrices.method_22903();
        matrices.method_22904(x, y, z);
        matrices.method_22907((Quaternionfc)rotation);
        float scale = 0.015f;
        matrices.method_22905(scale, -scale, scale);
        class_2960 icon = this.getHarvestIcon(state);
        class_4588 vc = this.client.method_22940().method_23000().method_73477(class_1921.method_23028((class_2960)icon));
        Matrix4f matrix = matrices.method_23760().method_23761();
        float halfSize = 16.0f;
        int light = class_761.method_23794((class_1920)this.client.field_1687, (class_2338)pos);
        vc.method_22918(matrix, -halfSize, halfSize, 0.0f).method_22913(0.0f, 1.0f).method_60803(light).method_1336(255, 255, 255, 255);
        vc.method_22918(matrix, halfSize, halfSize, 0.0f).method_22913(1.0f, 1.0f).method_60803(light).method_1336(255, 255, 255, 255);
        vc.method_22918(matrix, halfSize, -halfSize, 0.0f).method_22913(1.0f, 0.0f).method_60803(light).method_1336(255, 255, 255, 255);
        vc.method_22918(matrix, -halfSize, -halfSize, 0.0f).method_22913(0.0f, 0.0f).method_60803(light).method_1336(255, 255, 255, 255);
        matrices.method_22909();
    }

    private class_2960 getHarvestIcon(class_2680 state) {
        return this.VANILLA_CROPS.getOrDefault(state.method_26204(), this.DEFAULT_ICON);
    }

    private boolean isHarvestable(class_2680 state) {
        class_2248 block = state.method_26204();
        if (block instanceof class_2302) {
            class_2302 crop = (class_2302)block;
            return crop.method_9825(state);
        }
        if ((block instanceof class_3830 || block instanceof class_2421) && state.method_28498((class_2769)class_2741.field_12497)) {
            return (Integer)state.method_11654((class_2769)class_2741.field_12497) >= 3;
        }
        return false;
    }

    private void emitHarvestParticles(class_2338 pos, int amount) {
        double baseX = (double)pos.method_10263() + 0.5;
        double baseY = (double)pos.method_10264() + 1.0;
        double baseZ = (double)pos.method_10260() + 0.5;
        for (int i = 0; i < amount; ++i) {
            double ox = ThreadLocalRandom.current().nextDouble(-0.2, 0.2);
            double oz = ThreadLocalRandom.current().nextDouble(-0.2, 0.2);
            this.client.field_1687.method_8406((class_2394)class_2398.field_11211, baseX + ox, baseY, baseZ + oz, 0.0, 0.0, 0.0);
        }
    }
}

