/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.events;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.util.TextUtils;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_640;

public class UpdatePerfStrings {
    private static final ConfigData.ClientPlayerWorld config = Data.cfg.client;
    private static boolean isComplete;
    private static boolean isShortened;
    private static boolean isColoredText;
    private static int tickCounter;
    private static volatile String cpuUsage;
    private static volatile String memoryUsage;
    private static volatile String clientLatency;
    private static volatile String networkStats;
    private static float packetsSent;
    private static float packetsReceived;

    public static void registerEvent() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null || client.method_1562() == null) {
                return;
            }
            if (!UpdatePerfStrings.config.enabled || !UpdatePerfStrings.config.performance.enabled) {
                return;
            }
            isComplete = UpdatePerfStrings.config.prefixStyle.contains("complete");
            isShortened = UpdatePerfStrings.config.prefixStyle.contains("shortened");
            isColoredText = UpdatePerfStrings.config.colored;
            if (++tickCounter >= 20) {
                tickCounter = 0;
                if (UpdatePerfStrings.config.performance.cpu) {
                    UpdatePerfStrings.updateCpuUsage();
                }
                if (UpdatePerfStrings.config.performance.memory) {
                    UpdatePerfStrings.updateMemoryUsage();
                }
                if (UpdatePerfStrings.config.performance.latency) {
                    UpdatePerfStrings.updateClientLatency(client);
                }
                if (UpdatePerfStrings.config.performance.packets) {
                    UpdatePerfStrings.updateNetworkStats(client);
                }
            }
        });
    }

    private static void updateCpuUsage() {
        OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        int cpu = (int)(osBean.getCpuLoad() * 100.0);
        String header = "";
        if (isComplete) {
            header = TextUtils.transClientProp("cpu").getString();
        } else if (isShortened) {
            header = TextUtils.transClientProp("cpu_prefix").getString();
        }
        String prefix = "\u00a77";
        if (isColoredText) {
            prefix = cpu < 46 ? "\u00a72" : (cpu < 76 ? "\u00a76" : "\u00a7c");
        }
        cpuUsage = "%s\u00a7r%s%%".formatted(header, prefix + cpu);
    }

    private static void updateMemoryUsage() {
        long maxMemory = Runtime.getRuntime().maxMemory();
        long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        long usagePercent = usedMemory * 100L / maxMemory;
        String usedMemoryGB = UpdatePerfStrings.toOneDecimalGB(usedMemory);
        String maxMemoryGB = UpdatePerfStrings.toOneDecimalGB(maxMemory);
        String header = "";
        if (isComplete) {
            header = TextUtils.transClientProp("memory").getString();
        } else if (isShortened) {
            header = TextUtils.transClientProp("memory_prefix").getString();
        }
        String color = "\u00a77";
        if (isColoredText) {
            color = usagePercent < 46L ? "\u00a72" : (usagePercent < 76L ? "\u00a76" : "\u00a7c");
        }
        memoryUsage = "%s\u00a7r%s%d%%\u00a7r (%s/%sGB)".formatted(header, color, usagePercent, usedMemoryGB, maxMemoryGB);
    }

    private static String toOneDecimalGB(long bytes) {
        double gb = (double)bytes / 1024.0 / 1024.0 / 1024.0;
        return String.valueOf((double)Math.round(gb * 10.0) / 10.0);
    }

    private static void updateClientLatency(class_310 client) {
        class_634 handler = client.field_1724.field_3944;
        class_640 playerListEntry = handler.method_2871(client.field_1724.method_5667());
        int latency = playerListEntry != null ? playerListEntry.method_2959() : 0;
        String header = "";
        if (isComplete) {
            header = TextUtils.transClientProp("latency").getString();
        } else if (isShortened) {
            header = TextUtils.transClientProp("latency_prefix").getString();
        }
        String prefix = "\u00a77";
        if (isColoredText) {
            prefix = latency <= 179 ? "\u00a72" : "\u00a7c";
        }
        String suffix = TextUtils.transClientProp("latency_suffix").getString();
        clientLatency = "%s\u00a7r%s%d%s".formatted(header, prefix, latency, suffix);
    }

    private static void updateNetworkStats(class_310 client) {
        class_634 handler = client.method_1562();
        packetsSent = handler.method_48296().method_10745();
        packetsReceived = handler.method_48296().method_10762();
        String header = "";
        if (isComplete) {
            header = TextUtils.transClientProp("network").getString();
        } else if (isShortened) {
            header = TextUtils.transClientProp("network_prefix").getString();
        }
        String arrowUp = isColoredText ? "\u00a7c\u2191\u00a7r" : "\u2191";
        String arrowDown = isColoredText ? "\u00a72\u2193\u00a7r" : "\u2193";
        String packets = "%.0f %s %.0f %s".formatted(Float.valueOf(packetsSent), arrowUp, Float.valueOf(packetsReceived), arrowDown);
        networkStats = "%s\u00a7r%s".formatted(header, packets);
    }

    public static String getCpuUsage() {
        return cpuUsage;
    }

    public static String getMemoryUsage() {
        return memoryUsage;
    }

    public static String getClientLatency() {
        return clientLatency;
    }

    public static String getNetworkStats() {
        return networkStats;
    }

    static {
        tickCounter = 0;
        cpuUsage = "";
        memoryUsage = "";
        clientLatency = "";
        networkStats = "";
        packetsSent = 0.0f;
        packetsReceived = 0.0f;
    }
}

