/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.hud;

import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.util.Draw;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5321;

public class BiomeWeatherTime {
    private final ConfigData.BiomeWeatherTime config;
    private final class_2960 TEXTURE;
    private final class_327 textRenderer;
    private class_1937 world;
    private class_2338 blockPos;
    private class_2791 chunk;
    private int width;
    private int height;

    public BiomeWeatherTime(class_310 client, class_332 context) {
        this.config = Data.cfg.biome;
        this.TEXTURE = class_2960.method_60654((String)"essentialgui:textures/gui/biome_weather_time.png");
        this.textRenderer = client.field_1772;
        this.world = client.field_1687;
        this.blockPos = client.method_1560().method_24515();
        this.chunk = client.field_1687.method_22350(this.blockPos);
        this.width = client.method_22683().method_4486();
        this.height = client.method_22683().method_4502();
        this.drawBiomeWeatherTime(context);
    }

    private void drawBiomeWeatherTime(class_332 context) {
        int x = Utils.resolveRenderCoord(this.config.x, 2, this.width);
        int y = Utils.resolveRenderCoord(this.config.y, 2, this.height);
        int iconsX = x + 2;
        int iconsY = y + 3;
        String style = this.config.texture;
        boolean dark = style.equals("dark");
        boolean borders = this.config.borders;
        if (dark) {
            Draw.drawTextureSprite(context, this.TEXTURE, x, y, 0.0f, 0.0f, 64, 22);
        } else {
            Draw.drawCustomRectangle(context, x, y, 59, 21, borders);
            for (int i = 0; i < 3; ++i) {
                Draw.drawCustomRectangle(context, iconsX + 19 * i, iconsY - 1, 17, 17, borders);
            }
        }
        int BIOME_ICON_X_OFFSET = dark ? 22 : 20;
        int WEATHER_ICON_X_OFFSET = dark ? 43 : 39;
        this.drawDayTimeSprite(context, iconsX + 1, iconsY);
        this.drawBiomeSprite(context, iconsX + BIOME_ICON_X_OFFSET, iconsY);
        this.drawWeatherSprite(context, iconsX + WEATHER_ICON_X_OFFSET, iconsY);
        this.drawTimePlate(context, dark, borders, x, y);
    }

    private void drawDayTimeSprite(class_332 context, int x, int y) {
        Object id = this.world.method_8597().comp_642() ? (Utils.isSunrise() ? "sunrise" : (Utils.isMorning() ? "morning" : (Utils.isDay() ? "day" : (Utils.isNoon() ? "noon" : (Utils.isSunset() ? "sunset" : "moon_phase" + this.world.method_30273()))))) : (Utils.isNether() ? "nether_day" : "end_day");
        class_2960 identifier = class_2960.method_60654((String)("essentialgui:textures/environment/" + (String)id + ".png"));
        Draw.drawTexture(context, identifier, x, y, 16);
    }

    private void drawBiomeSprite(class_332 context, int x, int y) {
        if (this.chunk == null) {
            return;
        }
        boolean isVanilla = ((class_5321)this.world.method_23753(this.blockPos).method_40229().left().get()).method_29177().method_12836().contains("minecraft");
        String name = (String)this.world.method_23753(this.blockPos).method_40229().map(biomeKey -> biomeKey.method_29177().method_12832(), biome_ -> "[unregistered " + String.valueOf(biome_) + "]");
        class_2960 identifier = class_2960.method_60654((String)("essentialgui:textures/biome/" + (isVanilla ? name : "none") + ".png"));
        Draw.drawTexture(context, identifier, x, y, 16);
    }

    private void drawWeatherSprite(class_332 context, int x, int y) {
        boolean coldBiome = ((class_1959)this.world.method_23753(this.blockPos).comp_349()).method_33599(this.blockPos, this.world.method_8615());
        String id = this.world.method_8597().comp_642() ? (this.world.method_8419() ? (this.world.method_8546() ? "thunder" : (coldBiome ? "snow" : "rain")) : (Utils.isNight() ? "clear_night" : "clear")) : (Utils.isNether() ? "nether_weather" : "end_weather");
        class_2960 identifier = class_2960.method_60654((String)("essentialgui:textures/environment/" + id + ".png"));
        Draw.drawTexture(context, identifier, x, y, 16);
    }

    private void drawTimePlate(class_332 context, boolean darkTexture, boolean borders, int x, int y) {
        boolean drawUp;
        if (!this.config.time) {
            return;
        }
        boolean bl = drawUp = y > this.height / 2;
        int offset = drawUp ? (darkTexture ? 39 : 37) : 0;
        String time = this.getWorldTime(false);
        if (darkTexture) {
            Draw.drawTextureSprite(context, this.TEXTURE, x, y + 23 - offset, 0.0f, 22.0f, 64, 15);
            context.method_25300(this.textRenderer, time, x + 33, y + 27 - offset, Draw.GRAY);
        } else {
            Draw.drawBoxTextCenter(context, x + 3, y + 26 - offset, 55, time, borders);
        }
    }

    private String getWorldTime(boolean showDays) {
        String days = "";
        if (showDays) {
            days = " \u00a7r(%s)".formatted(Utils.worldDaysString());
        }
        return "%s%s".formatted(Utils.timeString(this.config.timeFormat), days);
    }
}

