/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.hud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.events.UpdatePerfStrings;
import lordrius.essentialgui.util.Draw;
import lordrius.essentialgui.util.TextUtils;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2919;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_6880;

public class ClientPlayerWorld {
    private final ConfigData.ClientPlayerWorld config;
    private final class_310 client;
    private final class_327 textRenderer;
    private class_1297 entity;
    private class_1937 world;
    private class_2338 blockPos;
    private class_2791 chunk;
    private final int width;
    private final int height;
    private final boolean isComplete;
    private final boolean isShortened;
    private final boolean isColoredText;

    public ClientPlayerWorld(class_310 client, class_332 context) {
        this.config = Data.cfg.client;
        this.client = client;
        this.textRenderer = client.field_1772;
        this.entity = client.method_1560();
        this.world = client.field_1687;
        this.blockPos = this.entity.method_24515();
        this.chunk = this.world.method_22350(this.blockPos);
        this.width = client.method_22683().method_4486();
        this.height = client.method_22683().method_4502();
        this.isComplete = this.config.prefixStyle.contains("complete");
        this.isShortened = this.config.prefixStyle.contains("short");
        this.isColoredText = this.config.colored;
        this.drawClientPlayerWorld(context);
    }

    private void drawClientPlayerWorld(class_332 context) {
        int x = Utils.resolveRenderCoord(this.config.x, 5, this.width);
        int y = Utils.resolveRenderCoord(this.config.y, 28, this.height);
        boolean right = x > this.width / 2;
        boolean borders = this.config.borders;
        switch (this.config.style) {
            case "debug": {
                this.drawDebugTextHud(context, this.individual(), x, y, right);
                break;
            }
            case "individual": {
                this.drawIndividualHud(context, this.individual(), x, y, right, borders);
                break;
            }
            case "block": {
                Draw.drawBoxTextDynamicString(context, x, y, this.compact(), right, borders);
                break;
            }
            case "blocks": {
                this.drawCompactBlocksHud(context, x, y, right, borders);
                break;
            }
            case "simple": {
                this.drawSimpleHud(context, x, y, borders);
                break;
            }
            default: {
                this.drawDebugTextHud(context, this.individual(), x, y, right);
            }
        }
    }

    private List<String> individual() {
        return Stream.of(this.performanceStrings(), this.positionStrings(), this.worldStrings()).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<String> compact() {
        ArrayList<String> list = new ArrayList<String>();
        List<String> performance = this.performanceStrings();
        List<String> position = this.positionStrings();
        List<String> world = this.worldStrings();
        list.addAll(performance);
        if (!(performance.isEmpty() || position.isEmpty() && world.isEmpty())) {
            list.add(TextUtils.separator().getString());
        }
        list.addAll(position);
        if (!(world.isEmpty() || position.isEmpty() && !performance.isEmpty())) {
            list.add(TextUtils.separator().getString());
        }
        list.addAll(world);
        return list;
    }

    private List<String> performanceStrings() {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.config.performance.enabled) {
            return list;
        }
        boolean isIntegratedServer = this.client.method_1496();
        if (this.config.performance.fps) {
            list.add(this.fps());
        }
        if (this.config.performance.cpu) {
            list.add(UpdatePerfStrings.getCpuUsage());
        }
        if (this.config.performance.memory) {
            list.add(UpdatePerfStrings.getMemoryUsage());
        }
        if (this.config.performance.latency && !isIntegratedServer) {
            list.add(UpdatePerfStrings.getClientLatency());
        }
        if (this.config.performance.packets && !isIntegratedServer) {
            list.add(UpdatePerfStrings.getNetworkStats());
        }
        return list;
    }

    private List<String> positionStrings() {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.config.position.enabled) {
            return list;
        }
        if (this.config.position.coords) {
            list.add(this.playerCoordinates(true));
        }
        if (this.config.position.chunk) {
            list.add(this.playerChunkPosition());
        }
        if (this.config.position.facing) {
            list.add(this.playerFacing(true));
        }
        if (this.config.position.rotation) {
            list.add(this.playerRotation());
        }
        if (this.config.position.light) {
            list.add(this.playerLight());
        }
        if (this.config.position.speed) {
            list.add(this.playerSpeed());
        }
        return list;
    }

    private List<String> worldStrings() {
        ArrayList<String> list = new ArrayList<String>();
        if (!this.config.world.enabled) {
            return list;
        }
        if (this.config.world.biome) {
            list.add(this.biomeName());
        }
        if (this.config.world.entities) {
            list.add(this.debugEntities());
        }
        if (this.config.world.entitiesBlock) {
            list.add(this.debugTileEntities());
        }
        if (this.config.world.time) {
            list.add(this.worldTime(true, this.config.world.timeDays));
        }
        if (this.config.world.days) {
            list.add(this.worldDays(true));
        }
        return list;
    }

    private String fps() {
        boolean hasVsync = (Boolean)this.client.field_1690.method_42433().method_41753();
        int refreshRate = this.client.method_22683().method_22092();
        int maxFps = (Integer)this.client.field_1690.method_42524().method_41753();
        boolean unlimited = maxFps == 260;
        String header = "";
        if (this.isComplete) {
            header = TextUtils.transClientProp("fps").getString();
        } else if (this.isShortened) {
            header = TextUtils.transClientProp("fps_prefix").getString();
        }
        String fps = Integer.toString(this.client.method_47599());
        String suffix = TextUtils.transClientProp("fps_suffix").getString();
        Object value = hasVsync ? "%s\u00a7r%s/%s".formatted(header, fps, refreshRate) : (!unlimited ? "%s\u00a7r%s/%s".formatted(header, fps, maxFps) : "%s\u00a7r%s".formatted(header, fps));
        if (header.isEmpty()) {
            value = (String)value + suffix;
        }
        return value;
    }

    private String playerCoordinates(boolean showHeader) {
        String header = "";
        if (showHeader) {
            if (this.isComplete) {
                header = TextUtils.transClientProp("coordinates").getString();
            } else if (this.isShortened) {
                header = TextUtils.transClientProp("coordinates_prefix").getString();
            }
        }
        int blockX = this.entity.method_31477();
        int blockY = this.entity.method_31478();
        int blockZ = this.entity.method_31479();
        String coords = this.isColoredText ? "%s\u00a7c%d \u00a72%d \u00a79%d".formatted(header, blockX, blockY, blockZ) : "%s\u00a7r%d %d %d".formatted(header, blockX, blockY, blockZ);
        return coords + this.dimensionalCoords();
    }

    private String dimensionalCoords() {
        if (!this.config.position.coordsDim || Utils.isEnd()) {
            return "";
        }
        int blockX = this.entity.method_31477();
        int blockZ = this.entity.method_31479();
        boolean isNether = Utils.isNether();
        int dimX = isNether ? blockX * 8 : blockX / 8;
        int dimZ = isNether ? blockZ * 8 : blockZ / 8;
        String coords = this.isColoredText ? " \u00a7r[\u00a7c%d \u00a79%d\u00a7r]".formatted(dimX, dimZ) : " \u00a7r[%d %d]".formatted(dimX, dimZ);
        return coords;
    }

    private String playerChunkPosition() {
        String header = "";
        if (this.isComplete) {
            header = TextUtils.transClientProp("chunk").getString();
        } else if (this.isShortened) {
            header = TextUtils.transClientProp("chunk_prefix").getString();
        }
        int chunkX = this.blockPos.method_10263() & 0xF;
        int chunkY = this.blockPos.method_10264() & 0xF;
        int chunkZ = this.blockPos.method_10260() & 0xF;
        Object chunkFormat = this.isColoredText ? "%s\u00a7c%d \u00a72%d \u00a79%d" : "%s\u00a7r%d %d %d";
        String slimeChunkIndicator = "";
        if (this.config.position.chunkSlime && this.isSlimeChunk()) {
            slimeChunkIndicator = TextUtils.transClientProp("slime_chunk_indicator").getString();
            chunkFormat = (String)chunkFormat + (this.isColoredText ? " \u00a7a%s" : " %s");
        }
        return slimeChunkIndicator.isEmpty() ? ((String)chunkFormat).formatted(header, chunkX, chunkY, chunkZ) : ((String)chunkFormat).formatted(header, chunkX, chunkY, chunkZ, slimeChunkIndicator);
    }

    private boolean isSlimeChunk() {
        if (!this.client.method_1496() || this.world.method_8407() == class_1267.field_5801) {
            return false;
        }
        long seed = this.client.method_1576().method_27728().method_28057().method_28028();
        class_1923 chunkPos = this.chunk.method_12004();
        return class_2919.method_12662((int)chunkPos.field_9181, (int)chunkPos.field_9180, (long)seed, (long)987234911L).method_43048(10) == 0;
    }

    private String playerFacing(boolean showHeader) {
        String header = "";
        if (showHeader) {
            if (this.isComplete) {
                header = class_2561.method_43471((String)"hud.facing").getString();
            } else if (this.isShortened) {
                header = class_2561.method_43471((String)"hud.facing.prefix").getString();
            }
        }
        boolean axisInfo = this.config.position.facingAxis;
        int yaw = (int)this.client.field_1724.method_36454();
        if ((yaw = (yaw + 22) % 360) < 0) {
            yaw += 360;
        }
        int facingValue = yaw / 45;
        String[] directions = new String[]{"hud.facing.south", "hud.facing.south-west", "hud.facing.west", "hud.facing.north-west", "hud.facing.north", "hud.facing.north-east", "hud.facing.east", "hud.facing.south-east"};
        String[] axesColored = new String[]{"(\u00a79+Z\u00a7r)", "(\u00a79+Z\u00a7r)", "(\u00a7c-X\u00a7r)", "(\u00a79-Z\u00a7r)", "(\u00a79-Z\u00a7r)", "(\u00a79-Z\u00a7r)", "(\u00a7c+X\u00a7r)", "(\u00a79+Z\u00a7r)"};
        String[] axesPlain = new String[]{"(+Z)", "(+Z)", "(-X)", "(-Z)", "(-Z)", "(-Z)", "(+X)", "(+Z)"};
        class_5250 facingPoint = class_2561.method_43471((String)directions[facingValue]);
        String axis = this.isColoredText ? axesColored[facingValue] : axesPlain[facingValue];
        return "%s\u00a7r%s \u00a7r%s".formatted(header, facingPoint.getString(), axisInfo ? axis : "");
    }

    private String playerRotation() {
        float degreesYaw = class_3532.method_15393((float)this.entity.method_36454());
        float degreesPitch = class_3532.method_15393((float)this.entity.method_36455());
        String header = "";
        if (this.isComplete) {
            header = TextUtils.transClientProp("rotation").getString();
        } else if (this.isShortened) {
            header = TextUtils.transClientProp("rotation_prefix").getString();
        }
        float roundedPitch = (float)Math.round(degreesPitch * 10.0f) / 10.0f;
        String pitchText = roundedPitch == -2.1f ? "\u00a7e%.1f\u00a7r".formatted(Float.valueOf(degreesPitch)) : "%.1f".formatted(Float.valueOf(degreesPitch));
        return "%s\u00a7r%.1f/%s".formatted(header, Float.valueOf(degreesYaw), pitchText);
    }

    private String playerLight() {
        String lightSkyPrefix;
        String lightSubtractedPrefix;
        if (this.chunk == null) {
            return "";
        }
        int lightSubtracted = this.world.method_8398().method_12130().method_22363(this.blockPos, 0);
        int lightSky = this.world.method_8314(class_1944.field_9284, this.blockPos);
        int lightBlock = this.world.method_8314(class_1944.field_9282, this.blockPos);
        String string = this.isColoredText ? (lightSubtracted <= 0 ? "\u00a7c" : "\u00a72") : (lightSubtractedPrefix = "\u00a77");
        String string2 = this.isColoredText ? (lightSky <= 0 ? "\u00a7c" : "\u00a73") : (lightSkyPrefix = "\u00a77");
        String lightBlockPrefix = this.isColoredText ? (lightBlock <= 0 ? "\u00a7c" : "\u00a76") : "\u00a77";
        String header = "";
        if (this.isComplete) {
            header = TextUtils.transClientProp("light").getString();
        } else if (this.isShortened) {
            header = TextUtils.transClientProp("light_prefix").getString();
        }
        return "%s\u00a7r%s%d\u00a7r (%s%d \u00a7r| %s%d\u00a7r)".formatted(header, lightSubtractedPrefix, lightSubtracted, lightSkyPrefix, lightSky, lightBlockPrefix, lightBlock);
    }

    private String playerSpeed() {
        class_243 lastPos = new class_243(this.client.field_1724.field_6038, this.client.field_1724.field_5971, this.client.field_1724.field_5989);
        class_243 pos = new class_243(this.client.field_1724.method_23317(), this.client.field_1724.method_23318(), this.client.field_1724.method_23321());
        double speed = Math.abs(lastPos.method_1022(pos) * 20.0);
        String header = "";
        if (this.isComplete) {
            header = TextUtils.transClientProp("speed").getString();
        } else if (this.isShortened) {
            TextUtils.transClientProp("speed_prefix").getString();
        }
        String suffix = TextUtils.transClientProp("speed_suffix").getString();
        return "%s\u00a7r%.1f%s".formatted(header, speed, suffix);
    }

    private String biomeName() {
        if (this.chunk == null) {
            return "";
        }
        class_6880 biomeEntry = this.world.method_23753(this.blockPos);
        class_1959 biomeData = (class_1959)biomeEntry.comp_349();
        boolean coldBiome = biomeData.method_33599(this.blockPos, this.world.method_8615());
        boolean hotBiome = biomeData.method_8712() > 1.0f;
        Optional biomeKeyOpt = biomeEntry.method_40229().left();
        String biomeId = biomeKeyOpt.map(key -> key.method_29177().toString()).orElse("[unregistered biome]");
        String biomePath = biomeId.replace(':', '.');
        boolean isVanillaBiome = biomeId.contains("minecraft");
        String header = "";
        if (this.isComplete) {
            header = TextUtils.transClientProp("biome").getString();
        } else if (this.isShortened) {
            header = TextUtils.transClientProp("biome_prefix").getString();
        }
        String nonVanillaBiome = biomeKeyOpt.map(key -> TextUtils.capTitle(key.method_29177().method_12832().replace('_', ' '))).orElse("[Unknown Biome]");
        String prefix = this.isColoredText ? (isVanillaBiome ? (coldBiome ? "\u00a73" : (hotBiome ? "\u00a76" : "\u00a72")) : "\u00a75") : "\u00a77";
        String biomeName = isVanillaBiome ? class_2561.method_43471((String)("biome." + biomePath)).getString() : nonVanillaBiome;
        return "%s\u00a7r%s%s".formatted(header, prefix, biomeName);
    }

    private String debugEntities() {
        String entitiesString = this.client.field_1769.method_3272().replaceFirst("E: ", "").replaceFirst(",.*", "");
        String header = "";
        if (this.isComplete) {
            header = TextUtils.transClientProp("entities").getString();
        } else if (this.isShortened) {
            header = TextUtils.transClientProp("entities_prefix").getString();
        }
        return "%s\u00a7r%s".formatted(header, entitiesString);
    }

    private String debugTileEntities() {
        String header = "";
        if (this.isComplete) {
            header = TextUtils.transClientProp("tiles").getString();
        } else if (this.isShortened) {
            header = TextUtils.transClientProp("tiles_prefix").getString();
        }
        class_2818 chunk = this.world.method_8500(this.blockPos);
        int tileCount = chunk != null ? chunk.method_12214().size() : 0;
        return "%s\u00a7r%d".formatted(header, tileCount);
    }

    private String worldTime(boolean showHeader, boolean showDays) {
        String header = "";
        if (showHeader) {
            if (this.isComplete) {
                header = TextUtils.transClientProp("time").getString();
            } else if (this.isShortened) {
                header = TextUtils.transClientProp("time_prefix").getString();
            }
        }
        String days = "";
        if (showDays) {
            days = " \u00a7r(%s)".formatted(Utils.worldDaysString());
        }
        return "%s\u00a7r%s%s".formatted(header, Utils.timeString(this.config.world.timeFormat), days);
    }

    private String worldDays(boolean showHeader) {
        String header = "";
        if (showHeader) {
            if (this.isComplete) {
                header = TextUtils.transClientProp("days").getString();
            } else if (this.isShortened) {
                header = TextUtils.transClientProp("days_prefix").getString();
            }
        }
        return "%s\u00a7r%s".formatted(header, Utils.worldDaysString());
    }

    private void drawIndividualHud(class_332 context, List<String> strings, int x, int y, boolean right, boolean borders) {
        for (int i = 0; i < strings.size(); ++i) {
            String text = this.config.prefixColor + strings.get(i);
            int posY = 14 * i + y;
            if (right) {
                Draw.drawBoxTextRight(context, x, posY, text, borders);
                continue;
            }
            Draw.drawBoxText(context, x, posY, text, borders);
        }
    }

    private void drawCompactBlocksHud(class_332 context, int x, int y, boolean right, boolean borders) {
        List<String> performance = this.performanceStrings();
        List<String> position = this.positionStrings();
        List<String> world = this.worldStrings();
        int lineHeight = 11;
        int separation = 4;
        int performanceY = y;
        int positionY = performance.size() > 0 ? performanceY + lineHeight * performance.size() + separation : performanceY;
        int worldY = position.size() > 0 ? positionY + lineHeight * position.size() + separation : positionY;
        Draw.drawBoxTextDynamicString(context, x, performanceY, performance, right, borders);
        Draw.drawBoxTextDynamicString(context, x, positionY, position, right, borders);
        Draw.drawBoxTextDynamicString(context, x, worldY, world, right, borders);
    }

    private void drawDebugTextHud(class_332 context, List<String> strings, int x, int y, boolean right) {
        Objects.requireNonNull(this.textRenderer);
        int lineHeight = 9;
        for (int i = 0; i < strings.size(); ++i) {
            String text = this.config.prefixColor + strings.get(i);
            int textWidth = this.textRenderer.method_1727(text);
            int posX = right ? x - textWidth : x;
            int posY = y + 10 * i;
            context.method_25294(posX - 3, posY - 3, posX + textWidth - 1, posY + lineHeight - 2, Draw.getSectionBackgroundColor());
            context.method_25303(this.textRenderer, text, posX - 2, posY - 2, Draw.GRAY);
        }
    }

    private void drawSimpleHud(class_332 context, int x, int y, boolean borders) {
        String coordinates = this.playerCoordinates(false);
        String facing = this.playerFacing(false);
        String time = this.worldTime(false, this.config.world.timeDays);
        String text = "%s \u00a7r\u00b7 %s \u00a7r\u00b7 %s".formatted(coordinates, facing, time);
        int textWidth = this.textRenderer.method_1727(text);
        Draw.drawBoxTextCenter(context, x, y, textWidth, text, borders);
    }
}

