/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.hud;

import com.mojang.brigadier.Message;
import java.util.List;
import java.util.Objects;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.events.KeyBindings;
import lordrius.essentialgui.gui.hud.PlayerStatsHud;
import lordrius.essentialgui.gui.screen.ScreenBase;
import lordrius.essentialgui.util.Draw;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_239;
import net.minecraft.class_2480;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5537;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import net.minecraft.class_9848;

public class PlayerEquipment {
    private final ConfigData.PlayerEquipment config;
    private final class_310 client;
    private final class_746 player;
    private final class_327 textRenderer;
    private int width;
    private int height;
    private final class_1799 bundle;
    private final class_1799 mainHand;
    private final class_1799 offHand;
    public static boolean isHudOpen;

    public PlayerEquipment(class_310 client, class_332 context) {
        this.config = Data.cfg.equipment;
        this.bundle = Utils.getStackFromString(this.config.stock.item);
        this.client = client;
        this.player = client.field_1724;
        this.textRenderer = client.field_1772;
        this.width = client.method_22683().method_4486();
        this.height = client.method_22683().method_4502();
        this.mainHand = client.field_1724.method_6047();
        this.offHand = client.field_1724.method_6079();
        isHudOpen = false;
        if (!this.client.field_1724.method_7325()) {
            this.drawPlayerEquipment(context);
        }
    }

    private void drawPlayerEquipment(class_332 context) {
        class_1792 item = this.mainHand.method_7909();
        boolean isAltPressed = KeyBindings.contextualMenu.method_1434();
        boolean isPointingAir = this.client.field_1765 != null && this.client.field_1765.method_17783() != class_239.class_240.field_1332 && this.client.field_1765.method_17783() != class_239.class_240.field_1331;
        boolean shulkerInHand = this.config.shulkerBox && class_2248.method_9503((class_1792)item) instanceof class_2480 && isPointingAir;
        boolean bundleInHand = this.config.bundle && item instanceof class_5537 && isPointingAir;
        boolean showStatsHud = this.config.stats.enabled && isPointingAir && isAltPressed && !shulkerInHand && !bundleInHand;
        boolean showQuiverHud = this.config.quiver.enabled;
        boolean showFoodStatsHud = this.config.foodStats;
        if (showQuiverHud) {
            this.drawQuiverHud(context);
        }
        if (showFoodStatsHud) {
            this.drawFoodStatsHud(context);
        }
        if (shulkerInHand) {
            this.drawShulkerBoxHud(context, isAltPressed);
        }
        if (bundleInHand) {
            this.drawBundleHud(context, isAltPressed);
        }
        if (showStatsHud) {
            isHudOpen = true;
            PlayerStatsHud.drawPlayerEquipmentHud(context, (class_1657)this.player);
        }
        if (this.config.stock.enabled) {
            this.drawItemStockHud(context);
        }
        if (this.config.screen.enabled) {
            this.drawScreenEquipment(context);
        }
    }

    private void drawQuiverHud(class_332 context) {
        Object arrows;
        boolean infinite;
        int x = Utils.resolveRenderCoord(this.config.quiver.x, this.width - 22, this.width);
        int y = Utils.resolveRenderCoord(this.config.quiver.y, this.height / 2 - 81, this.height);
        int arrowsValue = PlayerStatsHud.getArrowCount((class_1657)this.player);
        boolean hasEnchantments = (Utils.hasInfinity(this.mainHand) || Utils.hasInfinity(this.offHand)) && arrowsValue > 0;
        boolean bl = infinite = this.player.method_68878() || hasEnchantments;
        if (infinite) {
            arrows = this.config.quiver.colorInfinite;
        } else {
            String color = arrowsValue <= 0 ? this.config.quiver.colorEmpty : (arrowsValue < 10 ? this.config.quiver.colorLow : this.config.quiver.colorPlenty);
            arrows = color + arrowsValue;
        }
        int textWidth = this.textRenderer.method_1727((String)arrows);
        String style = this.config.quiver.texture;
        boolean borders = this.config.quiver.borders;
        switch (style) {
            case "essgui": {
                Draw.drawCustomRectangle(context, x, y, 21, 21, borders);
                Draw.drawBoxItem(context, x + 2, y + 2, borders);
                break;
            }
            case "vanilla": {
                Draw.drawOffHandSlot(context, x, y);
                break;
            }
            case "dark": 
            case "colored": {
                int u = style.equals("dark") ? 23 : (infinite || arrowsValue >= 10 ? 69 : 46);
                Draw.drawTextureSprite(context, Draw.WIDGETS, x, y, u, 41.0f, 22, 22);
            }
        }
        Draw.drawTexture(context, Draw.QUIVER, x + 2, y + 3, 16);
        context.method_25303(this.textRenderer, (String)arrows, x + 21 - textWidth, y + 13, -1);
    }

    private void drawFoodStatsHud(class_332 context) {
        class_4174 foodComponent = this.getHeldFoodComponent();
        if (foodComponent != null && Utils.canRenderTooltipText()) {
            this.drawFoodTooltip(context, foodComponent);
        }
    }

    private class_4174 getHeldFoodComponent() {
        if (!this.mainHand.method_7960() && Utils.isFood(this.mainHand)) {
            return (class_4174)this.mainHand.method_58694(class_9334.field_50075);
        }
        if (!this.offHand.method_7960() && Utils.isFood(this.offHand)) {
            return (class_4174)this.offHand.method_58694(class_9334.field_50075);
        }
        return null;
    }

    private void drawFoodTooltip(class_332 context, class_4174 foodComponent) {
        int hungerValue = foodComponent.comp_2491();
        class_2561 hunger = class_2561.method_30163((String)(" \u00a77(\u00a7a" + hungerValue + "\u00a77)"));
        int hungerWidth = this.textRenderer.method_27525((class_5348)hunger);
        int sizeX = this.getFoodBarWidth(hungerValue) + hungerWidth;
        Objects.requireNonNull(this.textRenderer);
        int sizeY = 9;
        int xPos = (this.width - sizeX) / 2;
        int yPos = Utils.getHeldItemTooltipY() - 16;
        int iconsY = yPos - 1;
        int backgroundColor = Utils.getBackgroundOpacity();
        Draw.drawRoundedRectangleBorderless(context, xPos - 2, yPos - 2, sizeX + 2, sizeY + 1, backgroundColor);
        Draw.drawTexture(context, Draw.HUNGER_FULL, xPos, iconsY, 10);
        context.method_27535(this.textRenderer, class_2561.method_30163((String)" \u00a77\u2192 "), xPos + 9, yPos, -1);
        context.method_27535(this.textRenderer, class_2561.method_54155((Message)hunger), xPos + sizeX - hungerWidth, yPos, -1);
        for (int i = 0; i < hungerValue; ++i) {
            class_2960 texture;
            int iconX = xPos + i * 8 + 23;
            Object object = i * 2 + 1 < hungerValue ? Draw.HUNGER_FULL : (texture = i * 2 + 1 == hungerValue ? Draw.HUNGER_HALF : null);
            if (texture == null) continue;
            Draw.drawTexture(context, texture, iconX, iconsY, 10);
        }
    }

    private int getFoodBarWidth(int hungerValue) {
        if (hungerValue <= 2) {
            return 32;
        }
        if (hungerValue <= 4) {
            return 40;
        }
        if (hungerValue <= 6) {
            return 48;
        }
        if (hungerValue <= 8) {
            return 56;
        }
        return 64;
    }

    private void drawItemStockHud(class_332 context) {
        if (this.mainHand.method_7960()) {
            return;
        }
        int x = Utils.resolveRenderCoord(this.config.stock.x, this.width / 2 + 100, this.width);
        int y = Utils.resolveRenderCoord(this.config.stock.y, this.height - 21, this.height);
        boolean borders = this.config.stock.borders;
        switch (this.config.stock.texture) {
            case "vanilla": {
                Draw.drawOffHandSlot(context, x, y);
                break;
            }
            case "dark": {
                Draw.drawTextureSprite(context, Draw.WIDGETS, x, y, 23.0f, 41.0f, 22, 22);
                break;
            }
            case "essgui": {
                Draw.drawCustomRectangle(context, x, y, 21, 21, borders);
                Draw.drawBoxItem(context, x + 2, y + 2, borders);
            }
        }
        int countValue = PlayerStatsHud.getInventoryCount((class_1657)this.player, this.mainHand.method_7909());
        String count = this.config.stock.textColor + countValue;
        int iconX = x + 3;
        int iconY = y + 3;
        Draw.drawItem(context, this.bundle, iconX, iconY);
        context.method_51432(this.textRenderer, this.bundle, iconX + 1, iconY + 1, count);
    }

    private void drawShulkerBoxHud(class_332 context, boolean isAltPressed) {
        class_9288 container = (class_9288)this.mainHand.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        if (container.method_57489().findAny().isPresent()) {
            this.drawEquipmentMessage(context);
            if (isAltPressed) {
                isHudOpen = true;
                class_2480 shulkerBoxBlock = (class_2480)class_2248.method_9503((class_1792)this.mainHand.method_7909());
                class_2371 defaultedList = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
                container.method_57492(defaultedList);
                int shulkerX = (this.width - 178) / 2;
                int shulkerY = (this.height - 90) / 2;
                int shulkerColor = shulkerBoxBlock.method_10528() != null ? shulkerBoxBlock.method_10528().method_7787() : -6853993;
                Draw.drawTextureSpriteTinted(context, Draw.SHULKER_HUD, shulkerX, shulkerY, 0.0f, 0.0f, 176, 81, shulkerColor);
                context.method_27535(this.textRenderer, this.mainHand.method_7964(), shulkerX + 7, shulkerY + 6, -1);
                for (int i = 0; i < 27; ++i) {
                    int row = i / 9;
                    int col = i % 9;
                    Draw.drawItem(context, (class_1799)defaultedList.get(i), shulkerX + 18 * col + 8, shulkerY + 18 * row + 18);
                }
            }
        }
    }

    private void drawBundleHud(class_332 context, boolean isAltPressed) {
        class_9276 contents = (class_9276)this.mainHand.method_58695(class_9334.field_49650, (Object)class_9276.field_49289);
        if (!contents.method_57429()) {
            this.drawEquipmentMessage(context);
            if (isAltPressed) {
                isHudOpen = true;
                int bundleX = (this.width - 158) / 2;
                int bundleY = (this.height - 200) / 2;
                int percent = (int)(class_5537.method_31561((class_1799)this.mainHand) * 100.0f);
                class_124 formatting = this.getBundleFillColor(percent);
                class_5250 text = class_2561.method_43470((String)(percent + "%")).method_27692(formatting);
                int textWidth = this.textRenderer.method_27525((class_5348)text);
                Draw.drawTextureSpriteTinted(context, Draw.BUNDLE_HUD, bundleX, bundleY, 0.0f, 0.0f, 158, 171, this.getBundleColor(this.mainHand));
                context.method_27535(this.textRenderer, this.bundle.method_7964(), bundleX + 7, bundleY + 6, -1);
                context.method_27535(this.textRenderer, (class_2561)text, bundleX + 148 - textWidth, bundleY + 6, -1);
                int[] xOffsets = new int[]{8, -136, -280, -424, -568, -712, -856, -1000};
                class_2371 defaultedList = class_2371.method_10213((int)64, (Object)class_1799.field_8037);
                int i = 0;
                for (class_1799 stack : contents.method_57421()) {
                    if (i >= defaultedList.size()) break;
                    defaultedList.set(i, (Object)stack.method_7972());
                    int row = i / 8;
                    int drawX = bundleX + 18 * i + xOffsets[row];
                    int drawY = bundleY + 18 + row * 18;
                    Draw.drawItem(context, (class_1799)defaultedList.get(i), drawX, drawY);
                    ++i;
                }
            }
        }
    }

    private class_124 getBundleFillColor(int percent) {
        if (percent <= 15) {
            return class_124.field_1060;
        }
        if (percent <= 40) {
            return class_124.field_1077;
        }
        if (percent <= 65) {
            return class_124.field_1065;
        }
        return class_124.field_1061;
    }

    private int getBundleColor(class_1799 bundle) {
        String name = class_7923.field_41178.method_10221((Object)bundle.method_7909()).method_12832();
        for (class_1767 color : class_1767.values()) {
            if (!name.startsWith(color.method_15434())) continue;
            return color.method_7787();
        }
        return -1;
    }

    private void drawEquipmentMessage(class_332 context) {
        if (Utils.canRenderTooltipText()) {
            class_5250 message = class_2561.method_43469((String)"hud.player_equipment.message", (Object[])new Object[]{ScreenBase.CONTEXTUAL_MENU_KEY_TEXT});
            boolean rounded = Data.cfg.vanilla.heldItemTooltipStyle.contains("rounded");
            int yPos = Utils.getHeldItemTooltipY() - 16;
            if (rounded) {
                Draw.drawCenteredTextWithBackgroundRoundedF(context, this.width, yPos, (class_2561)message, Utils.getTooltipFadeTransition());
            } else {
                Draw.drawCenteredTextWithBackgroundF(context, this.width, yPos, (class_2561)message, Utils.getTooltipFadeTransition());
            }
        }
    }

    private void drawScreenEquipment(class_332 context) {
        boolean bottom;
        int x = Utils.resolveRenderCoord(this.config.screen.x, this.width - 20, this.width);
        int y = Utils.resolveRenderCoord(this.config.screen.y, this.height / 2 - 56, this.height);
        String style = this.config.screen.texture;
        boolean vanilla = style.equals("vanilla");
        boolean essgui = style.equals("essgui");
        boolean borders = this.config.screen.borders;
        boolean bl = bottom = y > this.height / 2 + 10;
        if (vanilla) {
            this.drawTextureVanilla(context, x, y, bottom);
        } else if (essgui) {
            this.drawTextureEssGui(context, x, y, bottom, borders);
        }
        this.drawSlots(context, x, y, bottom);
    }

    private void drawTextureEssGui(class_332 context, int x, int y, boolean bottom, boolean borders) {
        if (bottom) {
            Draw.drawCustomRectangle(context, x - 8, y - 23, 21, 59, borders);
            Draw.drawCustomRectangle(context, x + 210, y - 23, 21, 59, borders);
            for (int i = 0; i < 3; ++i) {
                Draw.drawBoxItem(context, x - 6, y - 19 * i + 17, borders);
                Draw.drawBoxItem(context, x + 212, y - 19 * i + 17, borders);
            }
        } else {
            Draw.drawCustomRectangle(context, x - 2, y - 2, 21, 116, borders);
            for (int i = 0; i < 6; ++i) {
                Draw.drawBoxItem(context, x, y + 19 * i, borders);
            }
        }
    }

    private void drawTextureVanilla(class_332 context, int x, int y, boolean bottom) {
        if (bottom) {
            Draw.drawTextureSprite(context, Draw.WIDGETS, x - 8, y - 23, 0.0f, 0.0f, 22, 39);
            Draw.drawTextureSprite(context, Draw.WIDGETS, x - 8, y + 16, 0.0f, 96.0f, 22, 21);
            Draw.drawTextureSprite(context, Draw.WIDGETS, x + 210, y - 23, 0.0f, 0.0f, 22, 39);
            Draw.drawTextureSprite(context, Draw.WIDGETS, x + 210, y + 16, 0.0f, 96.0f, 22, 21);
        } else {
            Draw.drawTextureSprite(context, Draw.WIDGETS, x - 2, y - 2, 0.0f, 0.0f, 22, 117);
        }
    }

    private void drawSlots(class_332 context, int x, int y, boolean bottom) {
        boolean right = x > this.width / 2;
        List<HudSlot> slots = bottom ? List.of(new HudSlot(this, x - 5, y - 20, class_1304.field_6171), new HudSlot(this, x - 5, y - 1, class_1304.field_6169), new HudSlot(this, x - 5, y + 18, class_1304.field_6174), new HudSlot(this, x + 213, y - 20, class_1304.field_6173), new HudSlot(this, x + 213, y - 1, class_1304.field_6172), new HudSlot(this, x + 213, y + 18, class_1304.field_6166)) : List.of(new HudSlot(this, x + 1, y + 1, class_1304.field_6169), new HudSlot(this, x + 1, y + 20, class_1304.field_6174), new HudSlot(this, x + 1, y + 39, class_1304.field_6172), new HudSlot(this, x + 1, y + 58, class_1304.field_6166), new HudSlot(this, x + 1, y + 77, class_1304.field_6173), new HudSlot(this, x + 1, y + 96, class_1304.field_6171));
        for (HudSlot slot : slots) {
            this.renderSlot(context, slot, (class_1657)this.player, bottom, right);
        }
    }

    private void renderSlot(class_332 context, HudSlot slot, class_1657 player, boolean bottom, boolean right) {
        class_1799 stack = slot.getStack(player);
        if (stack.method_7960()) {
            this.drawSlotTexture(context, slot.x, slot.y, slot.slotType);
        } else {
            Draw.drawItem(context, stack, slot.x, slot.y);
            if (this.config.screen.durability && stack.method_7963()) {
                boolean borders = this.config.screen.durabilityBorders;
                boolean background = this.config.screen.durabilityBackground;
                boolean textToLeft = this.durabilityToLeft(slot, bottom, right);
                String durabilityText = this.getStackDurability(stack);
                int durabilityWidth = this.textRenderer.method_1727(durabilityText);
                int textX = textToLeft ? slot.x - durabilityWidth - 6 : slot.x + 23;
                int textY = slot.y + 5;
                Draw.drawBoxText(context, textX, textY, durabilityText, borders, background, stack.method_31580());
            }
        }
    }

    private void drawSlotTexture(class_332 context, int x, int y, class_1304 slotType) {
        class_2960 texture = this.getSlotTexture(slotType);
        if (texture != null) {
            Draw.drawTextureTinted(context, texture, x, y, 16, class_9848.method_61330((int)30, (int)-1));
        }
    }

    private class_2960 getSlotTexture(class_1304 slotType) {
        return switch (slotType) {
            case class_1304.field_6169 -> Draw.HELMET;
            case class_1304.field_6174 -> Draw.CHESTPLATE;
            case class_1304.field_6172 -> Draw.LEGGINGS;
            case class_1304.field_6166 -> Draw.BOOTS;
            case class_1304.field_6173 -> Draw.SWORD;
            case class_1304.field_6171 -> Draw.SHIELD;
            default -> null;
        };
    }

    private String getStackDurability(class_1799 stack) {
        boolean percent = this.config.screen.durabilityFormat.contains("percent");
        int maxDamage = stack.method_7936();
        int durability = maxDamage - stack.method_7919();
        return percent ? durability * 100 / maxDamage + "%" : String.valueOf(durability);
    }

    private boolean durabilityToLeft(HudSlot slot, boolean bottom, boolean right) {
        class_1304 type = slot.slotType;
        if (bottom) {
            return type == class_1304.field_6169 || type == class_1304.field_6174 || type == class_1304.field_6171;
        }
        return right;
    }

    private class HudSlot {
        public final int x;
        public final int y;
        public final class_1304 slotType;

        public HudSlot(PlayerEquipment playerEquipment, int x, int y, class_1304 slotType) {
            this.x = x;
            this.y = y;
            this.slotType = slotType;
        }

        public class_1799 getStack(class_1657 player) {
            return player.method_6118(this.slotType);
        }
    }
}

