/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.hud;

import java.util.Locale;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.util.Draw;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_490;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PlayerStatsHud {
    private static final ConfigData.PlayerEquipment.PlayerStats config = Data.cfg.equipment.stats;
    private static final class_310 client = class_310.method_1551();
    private static final class_327 font = PlayerStatsHud.client.field_1772;
    private static class_2960 EQUIPMENT;

    public static void drawPlayerEquipmentHud(class_332 context, class_1657 player) {
        EQUIPMENT = PlayerStatsHud.config.texture.contains("dark") ? Draw.EQUIPMENT_DARK : Draw.EQUIPMENT;
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int x = (screenWidth - 101) / 2;
        int y = (screenHeight - 86) / 2;
        int armorStatsX = x - 95;
        int armorStatsY = y;
        int playerStatsX = x + 102;
        int playerStatsY = y;
        int xpBarX = x;
        int xpBarY = y - 24;
        PlayerStatsHud.drawEquipmentSlots(context, player, x, y);
        PlayerStatsHud.drawPlayerEntity(context, player, x, y);
        PlayerStatsHud.drawArmorStats(context, player, armorStatsX, armorStatsY);
        PlayerStatsHud.drawPlayerStats(context, player, playerStatsX, playerStatsY);
        PlayerStatsHud.drawXpBar(context, player, xpBarX, xpBarY);
    }

    private static void drawEquipmentSlots(class_332 context, class_1657 player, int x, int y) {
        Draw.drawTextureSprite(context, EQUIPMENT, x, y, 0.0f, 0.0f, 101, 86);
        PlayerStatsHud.drawSlot(context, player.method_6118(class_1304.field_6169), Draw.EMPTY_ARMOR_SLOT_HELMET, x + 8, y + 8);
        PlayerStatsHud.drawSlot(context, player.method_6118(class_1304.field_6174), Draw.EMPTY_ARMOR_SLOT_CHESTPLATE, x + 8, y + 26);
        PlayerStatsHud.drawSlot(context, player.method_6118(class_1304.field_6172), Draw.EMPTY_ARMOR_SLOT_LEGGINGS, x + 8, y + 44);
        PlayerStatsHud.drawSlot(context, player.method_6118(class_1304.field_6166), Draw.EMPTY_ARMOR_SLOT_BOOTS, x + 8, y + 62);
        PlayerStatsHud.drawSlot(context, player.method_6047(), Draw.EMPTY_SLOT_SWORD, x + 77, y + 8);
        PlayerStatsHud.drawSlot(context, player.method_6079(), Draw.EMPTY_ARMOR_SLOT_SHIELD, x + 77, y + 26);
        PlayerStatsHud.drawArrowSlot(context, player, x + 77, y + 44);
        PlayerStatsHud.drawTotemSlot(context, player, x + 77, y + 62);
    }

    private static void drawSlot(class_332 context, class_1799 stack, class_2960 emptySlot, int x, int y) {
        if (stack.method_7960()) {
            Draw.drawTexture(context, emptySlot, x, y, 16);
        } else {
            Draw.drawItem(context, stack, x, y);
        }
    }

    private static void drawArrowSlot(class_332 context, class_1657 player, int x, int y) {
        int count = PlayerStatsHud.getArrowCount(player);
        if (count <= 0) {
            Draw.drawTexture(context, Draw.EMPTY_SLOT_QUIVER, x, y, 16);
        } else {
            Draw.drawTexture(context, Draw.QUIVER, x, y, 16);
            String text = String.valueOf(count);
            int width = font.method_1727(text);
            context.method_25303(font, text, x + 17 - width, y + 9, -1);
        }
    }

    private static void drawTotemSlot(class_332 context, class_1657 player, int x, int y) {
        int count = PlayerStatsHud.getInventoryCount(player, class_1802.field_8288);
        if (count <= 0) {
            Draw.drawTexture(context, Draw.EMPTY_SLOT_TOTEM, x, y, 16);
        } else {
            Draw.drawItem(context, new class_1799((class_1935)class_1802.field_8288), x, y);
            String text = String.valueOf(count);
            int width = font.method_1727(text);
            context.method_25303(font, "\u00a76" + text, x + 17 - width, y + 9, -1);
        }
    }

    public static int getInventoryCount(class_1657 player, class_1792 item) {
        class_1661 inventory = player.method_31548();
        int itemCount = 0;
        for (int slot = 0; slot < inventory.method_5439(); ++slot) {
            class_1799 stack = inventory.method_5438(slot);
            if (stack.method_7960() || stack.method_7909() != item) continue;
            itemCount += stack.method_7947();
        }
        return itemCount;
    }

    private static void drawPlayerEntity(class_332 context, class_1657 player, int x, int y) {
        int renderX = x + 20;
        int renderY = y + 10;
        int mouseX = x + 80;
        int mouseY = y + 140;
        float size = 32.0f;
        Vector3f translation = new Vector3f(0.0f, 0.0f, 0.0f);
        Quaternionf rotation = new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)Math.PI);
        class_490.method_48472((class_332)context, (int)renderX, (int)renderY, (int)mouseX, (int)mouseY, (float)size, (Vector3f)translation, (Quaternionf)rotation, null, (class_1309)player);
    }

    private static void drawArmorStats(class_332 context, class_1657 player, int x, int y) {
        int separationX = 26;
        int separationY = 19;
        int baseX = x + 34;
        int baseY = y + 11;
        class_1799[] armor = new class_1799[]{player.method_6118(class_1304.field_6169), player.method_6118(class_1304.field_6174), player.method_6118(class_1304.field_6172), player.method_6118(class_1304.field_6166)};
        Draw.drawTextureSprite(context, EQUIPMENT, x, y, 0.0f, 86.0f, 94, 86);
        for (int i = 0; i < armor.length; ++i) {
            int offsetY = baseY + i * separationY;
            String[] stats = PlayerStatsHud.getArmorStats(armor[i]);
            context.method_25300(font, stats[0], baseX, offsetY, -1);
            context.method_25300(font, stats[1], baseX + separationX, offsetY, -1);
        }
        int topY = y - 24;
        int textY = topY + 8;
        Draw.drawTextureSprite(context, EQUIPMENT, x, topY, 94.0f, 132.0f, 94, 23);
        context.method_25300(font, PlayerStatsHud.getPlayerArmorText(player), baseX, textY, -1);
        context.method_25300(font, PlayerStatsHud.getPlayerArmorToughnessText(player), baseX + separationX, textY, -1);
    }

    private static void drawXpBar(class_332 context, class_1657 player, int x, int y) {
        int textX = x + 25;
        int textY = y + 8;
        String xpText = "\u00a7a" + String.valueOf(player.field_7495);
        String levelText = "\u00a7a" + String.valueOf(player.field_7520);
        Draw.drawTextureSprite(context, EQUIPMENT, x, y, 94.0f, 86.0f, 101, 23);
        context.method_25303(font, xpText, textX, textY, -1);
        context.method_25300(font, levelText, textX + 61, textY, -1);
    }

    private static String[] getArmorStats(class_1799 stack) {
        Object defense = "\u00a7c-";
        Object toughness = "\u00a7b-";
        if (!stack.method_7960() && Utils.isArmor(stack)) {
            int def = 0;
            int tough = 0;
            class_9285 modifiers = (class_9285)stack.method_58695(class_9334.field_49636, (Object)class_9285.field_49326);
            for (class_9285.class_9287 entry : modifiers.comp_2393()) {
                if (entry.comp_2395().method_40225((class_5321)class_5134.field_23724.method_40230().get())) {
                    def = (int)entry.comp_2396().comp_2449();
                }
                if (!entry.comp_2395().method_40225((class_5321)class_5134.field_23725.method_40230().get())) continue;
                tough = (int)entry.comp_2396().comp_2449();
            }
            defense = "\u00a7a+" + def;
            toughness = "\u00a7b" + (tough > 0 ? "\u00a7b+" : "") + tough;
        }
        return new String[]{defense, toughness};
    }

    private static String getPlayerArmorText(class_1657 player) {
        int value = player.method_6096();
        return (value > 0 ? "\u00a7a" : "\u00a7c") + value;
    }

    private static String getPlayerArmorToughnessText(class_1657 player) {
        int value = (int)player.method_45325(class_5134.field_23725);
        return "\u00a7b" + value;
    }

    private static void drawPlayerStats(class_332 context, class_1657 player, int x, int y) {
        int separationX = 26;
        int separationY = 19;
        int baseX = x + 34;
        int baseY = y + 11;
        int health = (int)Math.ceil(player.method_6032());
        int absorption = (int)player.method_6067();
        int hunger = player.method_7344().method_7586();
        int saturation = (int)player.method_7344().method_7589();
        int oxygen = PlayerStatsHud.getPlayerOxygen(player)[0] / 20;
        int oxygenBonus = (int)player.method_45325(class_5134.field_51583);
        String age = "\u00a7e" + Utils.formatTicks(player.field_6012, true);
        String healthText = (health <= 7 ? "\u00a7c" : (health <= 14 ? "\u00a76" : "\u00a7a")) + health;
        String absorptionText = "\u00a76" + String.valueOf(absorption > 0 ? "+" + absorption : Integer.valueOf(absorption));
        String hungerText = (hunger <= 7 ? "\u00a7c" : (hunger <= 14 ? "\u00a76" : "\u00a7a")) + hunger;
        String saturationText = "\u00a76" + saturation;
        String oxygenText = "\u00a7a" + oxygen;
        String oxygenBonusText = "\u00a76" + oxygenBonus;
        Draw.drawTextureSprite(context, EQUIPMENT, x, y, 101.0f, 0.0f, 94, 86);
        context.method_25300(font, healthText, baseX, baseY, -1);
        context.method_25300(font, absorptionText, baseX + separationX, baseY, -1);
        context.method_25300(font, hungerText, baseX, baseY + separationY, -1);
        context.method_25300(font, saturationText, baseX + separationX, baseY + separationY, -1);
        context.method_25300(font, oxygenText, baseX, baseY + separationY * 2, -1);
        context.method_25300(font, oxygenBonusText, baseX + separationX, baseY + separationY * 2, -1);
        context.method_25300(font, age, x + 47, baseY + separationY * 3, -1);
        int topY = y - 24;
        int textY = topY + 8;
        Draw.drawTextureSprite(context, EQUIPMENT, x, topY, 94.0f, 155.0f, 94, 23);
        context.method_25300(font, PlayerStatsHud.getPlayerAttackText(player), baseX, textY, -1);
        context.method_25300(font, PlayerStatsHud.getPlayerAttackSpeedText(player), baseX + separationX, textY, -1);
    }

    private static String getPlayerAttackText(class_1657 player) {
        double value = PlayerStatsHud.getPlayerAttack(player);
        String prefix = value > 0.0 ? "\u00a7a" : "\u00a7c";
        return String.format(Locale.ROOT, prefix + "%.1f", value);
    }

    private static String getPlayerAttackSpeedText(class_1657 player) {
        double value = player.method_45325(class_5134.field_23723);
        return String.format(Locale.ROOT, "\u00a7a%.1f", value);
    }

    private static double getPlayerAttack(class_1657 player) {
        class_1799 mainHand = player.method_6047();
        double base = player.method_45325(class_5134.field_23721);
        if (!mainHand.method_7960()) {
            class_9285 modifiers = (class_9285)mainHand.method_58695(class_9334.field_49636, (Object)class_9285.field_49326);
            for (class_9285.class_9287 entry : modifiers.comp_2393()) {
                if (entry.comp_2395() != class_5134.field_23721 || entry.comp_2397() != class_9274.field_49217) continue;
                base += entry.comp_2396().comp_2449();
            }
            if (mainHand.method_7942()) {
                class_9304 enchants = mainHand.method_58657();
                for (class_6880 entry : enchants.method_57534()) {
                    if (!entry.method_40225(class_1893.field_9118)) continue;
                    base += (double)(0.5f * (float)enchants.method_57536(entry) + 0.5f);
                }
            }
        }
        for (class_1293 effect : player.method_6026()) {
            if (effect.method_5579() == class_1294.field_5910) {
                base += (double)(3 * (effect.method_5578() + 1));
                continue;
            }
            if (effect.method_5579() != class_1294.field_5911) continue;
            base -= (double)(4 * (effect.method_5578() + 1));
        }
        return base;
    }

    public static int[] getPlayerOxygen(class_1657 player) {
        class_1293 effect = player.method_6112(class_1294.field_5923);
        int oxygen = player.method_5669();
        int max = player.method_5748();
        if (effect != null) {
            oxygen += effect.method_5584();
            max += effect.method_5584();
        }
        return new int[]{oxygen, max};
    }

    public static int getArrowCount(class_1657 player) {
        return PlayerStatsHud.getInventoryCount(player, class_1802.field_8107);
    }
}

