/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.hud;

import com.google.common.collect.Lists;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.events.KeyBindings;
import lordrius.essentialgui.gui.hud.HudTooltipComponent;
import lordrius.essentialgui.gui.hud.PlayerStatsHud;
import lordrius.essentialgui.mixin.AccessorFoxEntity;
import lordrius.essentialgui.mixin.AccessorMannequinEntity;
import lordrius.essentialgui.mixin.AccessorOcelotEntity;
import lordrius.essentialgui.mixin.AccessorWolfEntity;
import lordrius.essentialgui.util.Draw;
import lordrius.essentialgui.util.NbtUtils;
import lordrius.essentialgui.util.TextUtils;
import lordrius.essentialgui.util.Utils;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_10192;
import net.minecraft.class_10255;
import net.minecraft.class_10275;
import net.minecraft.class_10583;
import net.minecraft.class_10730;
import net.minecraft.class_10799;
import net.minecraft.class_11187;
import net.minecraft.class_11573;
import net.minecraft.class_11890;
import net.minecraft.class_11891;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1428;
import net.minecraft.class_1433;
import net.minecraft.class_1438;
import net.minecraft.class_1439;
import net.minecraft.class_1440;
import net.minecraft.class_1451;
import net.minecraft.class_1452;
import net.minecraft.class_1453;
import net.minecraft.class_1462;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1473;
import net.minecraft.class_1474;
import net.minecraft.class_1481;
import net.minecraft.class_1493;
import net.minecraft.class_1495;
import net.minecraft.class_1496;
import net.minecraft.class_1498;
import net.minecraft.class_1500;
import net.minecraft.class_1501;
import net.minecraft.class_1511;
import net.minecraft.class_1531;
import net.minecraft.class_1533;
import net.minecraft.class_1534;
import net.minecraft.class_1535;
import net.minecraft.class_1540;
import net.minecraft.class_1571;
import net.minecraft.class_1588;
import net.minecraft.class_1606;
import net.minecraft.class_1621;
import net.minecraft.class_1634;
import net.minecraft.class_1641;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1674;
import net.minecraft.class_1688;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3701;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3966;
import net.minecraft.class_4019;
import net.minecraft.class_4466;
import net.minecraft.class_4760;
import net.minecraft.class_4985;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5354;
import net.minecraft.class_5761;
import net.minecraft.class_5762;
import net.minecraft.class_6053;
import net.minecraft.class_6880;
import net.minecraft.class_7102;
import net.minecraft.class_7298;
import net.minecraft.class_7689;
import net.minecraft.class_7917;
import net.minecraft.class_7923;
import net.minecraft.class_8001;
import net.minecraft.class_8685;
import net.minecraft.class_9282;
import net.minecraft.class_9296;
import net.minecraft.class_9298;
import net.minecraft.class_9334;
import net.minecraft.class_9848;

public class PointedEntity {
    private final ConfigData.PointedEntity config;
    private final class_310 client;
    private final class_327 font;
    private class_1297 entity;
    private final int width;
    private final int height;
    private final boolean coloredText;
    public static boolean isEntityPropertiesOpen;
    public static boolean isMultiplayerEquipmentOpen;

    public PointedEntity(class_310 client, class_332 context) {
        this.config = Data.cfg.entity;
        this.client = client;
        this.font = client.field_1772;
        this.width = client.method_22683().method_4486();
        this.height = client.method_22683().method_4502();
        this.coloredText = this.config.colored;
        isEntityPropertiesOpen = false;
        isMultiplayerEquipmentOpen = false;
        if (client.field_1765 != null && client.field_1765.method_17783() == class_239.class_240.field_1331) {
            class_1309 living;
            this.entity = ((class_3966)client.field_1765).method_17782();
            class_1297 class_12972 = this.entity;
            if (class_12972 instanceof class_1309 && (living = (class_1309)class_12972).method_6032() <= 0.0f) {
                return;
            }
            if (this.entity instanceof class_1540) {
                return;
            }
            if (client.field_1690.field_1907.method_1434()) {
                return;
            }
            if (client.field_1724.method_5765()) {
                if (this.entity == client.field_1724.method_5854()) {
                    return;
                }
                if (client.field_1724.method_5854().method_5782()) {
                    for (class_1297 passengers : client.field_1724.method_5854().method_5685()) {
                        if (this.entity != passengers) continue;
                        return;
                    }
                }
            }
            this.drawPointedEntity(context);
        }
    }

    private void drawPointedEntity(class_332 context) {
        class_1297 class_12972;
        boolean leftAlt = KeyBindings.contextualMenu.method_1434();
        boolean showProperties = this.config.properties && leftAlt;
        boolean showEquipment = this.config.equipment && leftAlt;
        boolean showPlayerEquip = this.config.equipmentPlayers && leftAlt;
        int propertiesX = this.width / 2 + 70;
        int propertiesY = this.height / 2 - 20;
        int equipmentX = propertiesX - 14;
        int equipmentY = propertiesY - 14;
        if (this.config.mainHud) {
            this.drawMainHud(context);
        }
        if (showProperties) {
            isEntityPropertiesOpen = true;
            this.drawProperties(context, propertiesX, propertiesY);
        }
        if (showEquipment) {
            this.drawEntityEquipment(context, equipmentX, equipmentY);
        }
        if (showPlayerEquip && (class_12972 = this.entity) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            isMultiplayerEquipmentOpen = true;
            PlayerStatsHud.drawPlayerEquipmentHud(context, player);
        }
    }

    private void drawMainHud(class_332 context) {
        int contentWidth;
        if (!this.config.armorStand) {
            return;
        }
        boolean showName = this.config.name;
        boolean showCoords = this.config.coords;
        boolean showModID = this.config.modid;
        ArrayList<String> lines = new ArrayList<String>();
        if (showName) {
            lines.add(this.getEntityName());
        }
        if (showCoords) {
            lines.add(this.getEntityCoordinates());
        }
        if (showModID) {
            lines.add(this.getEntityModId());
        }
        int iconSize = 15;
        int padding = 2;
        int spacing = 2;
        int iconTextGap = 5;
        Objects.requireNonNull(this.font);
        int lineHeight = 9 - 1;
        int textWidth = lines.stream().mapToInt(arg_0 -> ((class_327)this.font).method_1727(arg_0)).max().orElse(0);
        int textHeight = lines.isEmpty() ? 0 : lines.size() * lineHeight + (lines.size() - 1) * spacing + 2;
        int extraRight = 2;
        if (lines.isEmpty()) {
            contentWidth = this.config.skin ? iconSize : 0;
        } else if (this.config.skin && lines.size() == 1) {
            contentWidth = iconSize + iconTextGap + textWidth;
        } else {
            contentWidth = textWidth + extraRight;
            if (this.config.skin) {
                contentWidth += iconSize + iconTextGap;
            }
        }
        int contentHeight = !this.config.skin && lines.size() == 1 ? lineHeight + 3 : Math.max(this.config.skin ? iconSize : 0, textHeight);
        int totalWidth = contentWidth + padding * 2;
        int totalHeight = contentHeight + padding * 2;
        int x = (this.width - totalWidth + 2) / 2;
        int y = 3 + Utils.getBossBarsRendered() * 20;
        if (this.config.style.equals("tooltip")) {
            HudTooltipComponent hudTooltip = new HudTooltipComponent(lines, this.config.skin, this.font, (dc, pos) -> this.renderEntitySkin((class_332)dc, pos[0], pos[1]));
            int tooltipWidth = hudTooltip.method_32664(this.font);
            int tooltipHeight = hudTooltip.method_32661(this.font) + 4;
            int tooltipX = (this.width - tooltipWidth - 24) / 2;
            totalHeight = tooltipHeight + 1;
            context.method_51435(this.font, List.of(hudTooltip), tooltipX, y + 14, class_8001.field_41687, null);
        } else {
            Draw.drawCustomRectangle(context, x - padding, y - padding, totalWidth, totalHeight, this.config.borders);
            if (this.config.skin) {
                int skinX = x;
                int skinY = y - padding + (totalHeight - iconSize) / 2;
                this.renderEntitySkin(context, skinX, skinY);
            }
            if (!lines.isEmpty()) {
                int textX;
                int n = textX = this.config.skin ? x + iconSize + iconTextGap : x + 1;
                int textY = !this.config.skin && lines.size() == 1 ? y + (totalHeight - lineHeight) / 2 - 1 : (lines.size() == 1 ? y + padding + 2 : y + padding);
                for (String line : lines) {
                    context.method_25303(this.font, line, textX, textY, -1);
                    textY += lineHeight + spacing;
                }
            }
        }
        if (this.config.statsBars.enabled) {
            int barWidth = this.config.statsBars.width;
            int barHeight = this.config.statsBars.height;
            int barX = (this.width - barWidth - 2) / 2;
            this.drawEntityHealthBar(context, barX, y + totalHeight + 3, barWidth, barHeight);
            this.drawEntityOxygenBar(context, barX, y + totalHeight + barHeight + 5, barWidth, barHeight);
        }
    }

    private void renderEntitySkin(class_332 context, int x, int y) {
        class_1297 class_12972 = this.entity;
        if (!(class_12972 instanceof class_1309)) {
            return;
        }
        class_1309 living = (class_1309)class_12972;
        if (!(this.entity instanceof class_1531)) {
            this.drawEntitySkin(context, x, y);
        }
        this.drawEntityHelmetOverlay(context, living, x, y);
    }

    private void drawEntitySkin(class_332 context, int x, int y) {
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_11890) {
            class_11890 player = (class_11890)class_12972;
            class_9296 profileComponent = this.extractProfile((class_1297)player);
            class_8685 skinTextures = this.client.method_73362().method_73495(profileComponent).method_73503();
            class_2960 skin = skinTextures.comp_1626().comp_3627();
            context.method_25302(class_10799.field_56883, skin, x, y, 8.0f, 8.0f, 16, 16, 8, 8, 64, 64);
            context.method_25302(class_10799.field_56883, skin, x, y, 40.0f, 8.0f, 16, 16, 8, 8, 64, 64);
        } else {
            String[] path = this.getEntityGroupAndPath();
            class_2960 texture = class_2960.method_60654((String)("essentialgui:textures/entity/" + path[0] + path[1] + ".png"));
            Draw.drawTexture(context, texture, x, y, 16);
        }
    }

    private class_9296 extractProfile(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return class_9296.method_73312((UUID)player.method_5667());
        }
        if (entity instanceof class_11891) {
            class_11891 mannequin = (class_11891)entity;
            return ((AccessorMannequinEntity)mannequin).mannequinProfile();
        }
        return null;
    }

    private void drawEntityHelmetOverlay(class_332 context, class_1309 entity, int x, int y) {
        class_1799 helmet = entity.method_6118(class_1304.field_6169);
        if (entity instanceof class_1531) {
            if (helmet.method_7960() || helmet.method_31573(class_3489.field_48297)) {
                class_2960 texture = class_2960.method_60654((String)"essentialgui:textures/entity/armor_stand.png");
                Draw.drawTexture(context, texture, x, y, 16);
            } else {
                context.method_51427(helmet, x - 1, y - 1);
            }
        }
        if (helmet.method_31573(class_3489.field_48297) && Utils.isVanillaItem(helmet.method_7909())) {
            if (helmet.method_31573(class_3489.field_48803)) {
                int helmetColor = class_9282.method_57470((class_1799)helmet, (int)-6265536);
                class_2960 overlay_0 = class_2960.method_60654((String)"essentialgui:textures/entity/overlay/leather_0.png");
                class_2960 overlay_1 = class_2960.method_60654((String)"essentialgui:textures/entity/overlay/leather_1.png");
                Draw.drawTextureTinted(context, overlay_0, x, y, 16, helmetColor);
                Draw.drawTexture(context, overlay_1, x, y, 16);
            } else {
                class_10192 equippable = (class_10192)helmet.method_58694(class_9334.field_54196);
                String material = ((class_5321)equippable.comp_3176().get()).method_29177().method_12832();
                class_2960 overlay = class_2960.method_60654((String)("essentialgui:textures/entity/overlay/" + material + ".png"));
                Draw.drawTexture(context, overlay, x, y, 16);
            }
        }
    }

    private void drawEntityHealthBar(class_332 context, int x, int y, int barWidth, int barHeight) {
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1309) {
            int healthMaxValue;
            class_1309 living = (class_1309)class_12972;
            int healthValue = class_3532.method_15386((float)living.method_6032());
            if (healthValue > (healthMaxValue = class_3532.method_15386((float)living.method_6063()))) {
                healthValue = healthMaxValue;
            }
            int value = healthValue * barWidth / healthMaxValue;
            String health = healthValue + "/" + healthMaxValue;
            Draw.drawHealthBar(context, x, y - 3, barWidth, barHeight, value, health);
        }
    }

    private void drawEntityOxygenBar(class_332 context, int x, int y, int barWidth, int barHeight) {
        int oxygen;
        if (!(this.entity instanceof class_1309)) {
            return;
        }
        boolean isDolphin = this.entity instanceof class_1433;
        boolean isAxolotl = this.entity instanceof class_5762;
        int n = oxygen = isDolphin ? ((class_1433)this.entity).method_6491() : this.entity.method_5669();
        int oxygenMax = isDolphin ? 2400 : (isAxolotl ? 6000 : this.entity.method_5748());
        int value = oxygen * barWidth / oxygenMax;
        if (oxygen < oxygenMax) {
            Draw.drawOxygenBar(context, x, y - 3, barWidth, barHeight, value, Utils.ticksToMinutes(oxygen + 19));
        }
    }

    private void drawEntityEquipment(class_332 context, int x, int y) {
        if (this.entity instanceof class_1657) {
            return;
        }
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            class_1799[] equipment = new class_1799[]{living.method_6118(class_1304.field_6169), living.method_6118(class_1304.field_6174), living.method_6118(class_1304.field_6172), living.method_6118(class_1304.field_6166), living.method_6118(class_1304.field_6173), living.method_6118(class_1304.field_6171)};
            boolean allEmpty = true;
            for (class_1799 stack : equipment) {
                if (stack.method_7960()) continue;
                allEmpty = false;
                break;
            }
            if (allEmpty) {
                return;
            }
            int separation = 19;
            int startX = x + 1;
            int startY = y + 1;
            Draw.drawCustomRectangle(context, x - 2, y - 2, 21, 116);
            for (int i = 0; i < 6; ++i) {
                Draw.drawBoxItem(context, x, y + separation * i, true);
            }
            class_2960[] textures = new class_2960[]{Draw.HELMET, Draw.CHESTPLATE, Draw.LEGGINGS, Draw.BOOTS, Draw.SWORD, Draw.SHIELD};
            for (int i = 0; i < equipment.length; ++i) {
                int itemX = startX;
                int itemY = startY + separation * i;
                class_1799 stack = equipment[i];
                class_2960 texture = textures[i];
                if (stack.method_7960()) {
                    Draw.drawTextureTinted(context, texture, itemX, itemY, 16, class_9848.method_61330((int)30, (int)-1));
                    continue;
                }
                Draw.drawItem(context, stack, itemX, itemY);
            }
        }
    }

    private void drawProperties(class_332 context, int x, int y) {
        class_1493 wolf;
        if (this.entity instanceof class_1657) {
            return;
        }
        boolean isTooltip = this.config.propertiesStyle.equals("tooltip");
        boolean borders = this.config.propertiesBorders;
        List<class_2561> list = this.getProperties();
        if (isTooltip) {
            Draw.drawTooltip(context, list, x, y);
        } else {
            Draw.drawPropertiesBox(context, x + 12, y - 13, list, borders);
        }
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1493 && (wolf = (class_1493)class_12972).method_56677()) {
            class_1799 armor = wolf.method_56676();
            int xPos = x + TextUtils.tooltipWidth(list) - 7;
            int yPos = y - 10;
            Draw.drawItemWithSlot(context, armor, xPos, yPos);
        }
    }

    private List<class_2561> getProperties() {
        List<class_2561> extended;
        ArrayList list = Lists.newArrayList();
        List<class_2561> name = this.getEntityNameCordsAndId();
        list.addAll(name);
        List<class_2561> base = this.getBaseProperties();
        if (!base.isEmpty()) {
            list.add(TextUtils.separator());
            list.addAll(base);
        }
        if (!(extended = this.getEntityExtendedProperties()).isEmpty()) {
            list.add(TextUtils.separator());
            list.addAll(extended);
        }
        return list;
    }

    private List<class_2561> getEntityNameCordsAndId() {
        ArrayList list = Lists.newArrayList((Object[])new class_2561[]{TextUtils.write(this.getEntityName()), TextUtils.write(this.getEntityCoordinates())});
        if (this.client.field_1690.field_1827) {
            list.add(this.getEntityIdText());
        }
        list.add(TextUtils.write(this.getEntityModId()));
        return list;
    }

    private List<class_2561> getBaseProperties() {
        class_1297 class_12972;
        ArrayList list = Lists.newArrayList();
        boolean hasHealth = this.entityHasHealth();
        if (hasHealth) {
            list.add(TextUtils.entityLine("health", this.getEntityHealth()));
        }
        if ((class_12972 = this.entity) instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            int armorValue = (int)living.method_45325(class_5134.field_23724);
            String armor = String.format("%d/20", armorValue);
            boolean hasFollowRange = living.method_6127().method_45331(class_5134.field_23717);
            if (armorValue > 0) {
                list.add(TextUtils.entityLine("armor", armor));
            }
            if (hasHealth && hasFollowRange) {
                int range = (int)living.method_45325(class_5134.field_23717);
                list.add(TextUtils.entityLine("follow_range", TextUtils.str(range)));
            }
        }
        return list;
    }

    private List<class_2561> getEntityExtendedProperties() {
        class_1297 isTamed3;
        class_1297 mainGene;
        class_1297 variant;
        class_1297 rotationValue2;
        Object crackLevelValue;
        Object passengers;
        class_1297 isScreaming2;
        class_1297 hasFish2;
        class_1297 home;
        Object oxidationValue;
        class_1297 fromBucket2;
        class_5250 name;
        class_1297 hasNectar2;
        class_1297 isDancing2;
        class_5250 variant2;
        class_1297 isTamed22;
        ArrayList list = Lists.newArrayList();
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1496) {
            class_1496 horse = (class_1496)class_12972;
            if (!(this.entity instanceof class_7689)) {
                boolean isTamed22 = horse.method_6727();
                if (this.entity instanceof class_1495 || this.entity instanceof class_1498 || this.entity instanceof class_1500) {
                    double speedValue = horse.method_45325(class_5134.field_23719) * 42.157787584;
                    double jumpValue = horse.method_45325(class_5134.field_23728);
                    double jumpHeightValue = -0.1817584952 * Math.pow(jumpValue, 3.0) + 3.689713992 * Math.pow(jumpValue, 2.0) + 2.128599134 * jumpValue - 0.343930367;
                    String jump = String.format(Locale.ROOT, "\u00a72%.1f \u00a78/ \u00a725.29", jumpHeightValue);
                    String speed = String.format(Locale.ROOT, "\u00a72%.1f \u00a78/ \u00a7214.23", speedValue);
                    list.add(TextUtils.entityLine("horse.jump", jump));
                    list.add(TextUtils.entityLine("horse.speed", speed));
                    if (this.entity instanceof class_1498) {
                        class_5250 variant3 = TextUtils.transEntityProp("horse.variant." + this.getAnimalVariant());
                        list.add(TextUtils.entityLine("variant", (class_2561)variant3));
                    }
                } else {
                    class_1297 speedValue = this.entity;
                    if (speedValue instanceof class_1501) {
                        class_1501 llama = (class_1501)speedValue;
                        int strengthValue = llama.method_6803();
                        String strength = strengthValue + "/5";
                        String storage = 3 * strengthValue + "/15";
                        class_5250 variant4 = TextUtils.transEntityProp("llama.variant." + this.getAnimalVariant());
                        list.addAll(List.of(TextUtils.entityLine("llama.strength", strength), TextUtils.entityLine("llama.storage", storage), TextUtils.entityLine("variant", (class_2561)variant4)));
                    }
                }
                list.add(TextUtils.entityLine("tamed", (class_2561)TextUtils.trueFalse(isTamed22, true)));
            }
        }
        if ((isTamed22 = this.entity) instanceof class_7298) {
            class_7298 allay = (class_7298)isTamed22;
            boolean isDancing2 = allay.method_44359();
            boolean isPanicking = allay.method_52546();
            list.add(TextUtils.entityLine("allay.dancing", (class_2561)TextUtils.trueFalse(isDancing2, false)));
            list.add(TextUtils.entityLine("allay.panicking", (class_2561)TextUtils.trueFalse(isPanicking, true)));
        }
        if (this.entity instanceof class_5762) {
            variant2 = TextUtils.transEntityProp("axolotl.variant." + this.getAnimalVariant());
            list.add(TextUtils.entityLine("variant", (class_2561)variant2));
        }
        if ((isDancing2 = this.entity) instanceof class_4466) {
            class_4466 bee = (class_4466)isDancing2;
            boolean hasNectar2 = bee.method_21784();
            list.add(TextUtils.entityLine("bee.has_nectar", (class_2561)TextUtils.trueFalse(hasNectar2, false)));
        }
        if ((hasNectar2 = this.entity) instanceof class_5761) {
            class_5761 bucketable = (class_5761)hasNectar2;
            boolean fromBucket2 = bucketable.method_6453();
            if (this.entity instanceof class_1462) {
                class_5250 variant5 = TextUtils.transEntityProp("salmon.variant." + this.getAnimalVariant());
                list.add(TextUtils.entityLine("variant", (class_2561)variant5));
            } else if (this.entity instanceof class_1474) {
                int variantValue = this.getTropicalFishVariant();
                int baseColorValue = class_1474.method_6652((int)variantValue).method_16357();
                int patternColorValue = class_1474.method_6651((int)variantValue).method_16357();
                String variety = class_1474.method_47864((int)variantValue).method_47871().getString();
                name = TextUtils.dash();
                class_5250 type = TextUtils.translate(variety);
                class_5250 baseColor = TextUtils.write("\u2588 ", baseColorValue);
                class_5250 patternColor = TextUtils.write("\u2588", patternColorValue);
                class_5250 color = TextUtils.empty().method_10852((class_2561)baseColor).method_10852((class_2561)patternColor);
                class_124 formatting = class_124.field_1076;
                for (int i = 0; i < class_1474.field_41573.size(); ++i) {
                    if (variantValue != ((class_1474.class_7992)class_1474.field_41573.get(i)).method_47872()) continue;
                    name = TextUtils.translate(class_1474.method_6649((int)i));
                    formatting = class_124.field_1080;
                    break;
                }
                class_5250 variant6 = TextUtils.write(TextUtils.str(variantValue), formatting);
                list.addAll(List.of(TextUtils.entityLine("tropical_fish.name", (class_2561)name), TextUtils.entityLine("tropical_fish.type", (class_2561)type), TextUtils.entityLine("tropical_fish.color", (class_2561)color), TextUtils.entityLine("variant", (class_2561)variant6)));
            }
            list.add(TextUtils.entityLine("from_bucket", (class_2561)TextUtils.trueFalse(fromBucket2, false)));
        }
        if (this.entity instanceof class_1428 || this.entity instanceof class_10730 || this.entity instanceof class_7102 || this.entity instanceof class_1452) {
            variant2 = TextUtils.transEntityProp("variant." + this.getAnimalVariant());
            list.add(TextUtils.entityLine("variant", (class_2561)variant2));
        }
        if ((fromBucket2 = this.entity) instanceof class_11573) {
            class_11573 copperGolem = (class_11573)fromBucket2;
            oxidationValue = copperGolem.method_72477().method_15434();
            String taskValue = copperGolem.method_72476().method_15434();
            class_5250 oxidation = TextUtils.transBlockProp("oxidation." + (String)oxidationValue);
            class_5250 task = TextUtils.transEntityProp("copper_golem.task." + taskValue);
            list.addAll(List.of(TextUtils.blockLine("oxidation", ""), TextUtils.shifted((class_2561)oxidation), TextUtils.entityLine("villager.task", (class_2561)task)));
        }
        if ((oxidationValue = this.entity) instanceof class_10275) {
            class_10275 creaking = (class_10275)oxidationValue;
            home = creaking.method_65900();
            int x = home.method_10263();
            int y = home.method_10264();
            int z = home.method_10260();
            String s = String.format("\u00a7c%d \u00a72%d \u00a79%d", x, y, z);
            list.add(TextUtils.entityLine("creaking.creaking_heart", (class_2561)TextUtils.empty()));
            list.add(TextUtils.shifted(s));
        }
        if ((home = this.entity) instanceof class_1433) {
            class_1433 dolphin = (class_1433)home;
            boolean hasFish2 = dolphin.method_6487();
            list.add(TextUtils.entityLine("dolphin.has_fish", (class_2561)TextUtils.trueFalse(hasFish2, false)));
        }
        if (this.entity instanceof class_4019) {
            variant2 = TextUtils.transEntityProp("fox.variant." + this.getAnimalVariant());
            list.add(TextUtils.entityLine("variant", (class_2561)variant2));
            list.add(TextUtils.entityLine("fox.trusting", (class_2561)TextUtils.trueFalse(this.isFoxTrustingPlayer(), false)));
            if (!this.getFoxTrustedPlayersUUID().isEmpty()) {
                this.getFoxTrustingPlayersNames(list);
            }
        }
        if ((hasFish2 = this.entity) instanceof class_6053) {
            class_6053 goat = (class_6053)hasFish2;
            boolean isScreaming2 = goat.method_35178();
            list.add(TextUtils.entityLine("goat.screaming", (class_2561)TextUtils.trueFalse(isScreaming2, false)));
        }
        if ((isScreaming2 = this.entity) instanceof class_11187) {
            class_11187 happyGhast = (class_11187)isScreaming2;
            passengers = happyGhast.method_5685();
            if (passengers.isEmpty()) {
                return List.of();
            }
            list.add(TextUtils.entityLine("passengers", ""));
            int i = 1;
            Iterator y = passengers.iterator();
            while (y.hasNext()) {
                class_1297 passenger = (class_1297)y.next();
                class_5250 entityName = passenger.method_5477().method_27661().method_27692(class_124.field_1060);
                name = TextUtils.write(" #" + i++ + ": ", class_124.field_1063).method_10852((class_2561)entityName);
                list.add(name);
            }
        }
        if ((passengers = this.entity) instanceof class_1439) {
            class_1439 golem = (class_1439)passengers;
            crackLevelValue = golem.method_23347().name().toLowerCase();
            boolean playerCreated = golem.method_6496();
            class_5250 crackLevel = TextUtils.transEntityProp("iron_golem.crack_level." + (String)crackLevelValue);
            list.add(TextUtils.entityLine("iron_golem.crack_level", (class_2561)crackLevel));
            list.add(TextUtils.entityLine("iron_golem.player_created", (class_2561)TextUtils.trueFalse(playerCreated, false)));
        }
        if ((crackLevelValue = this.entity) instanceof class_1533) {
            class_1533 frame = (class_1533)crackLevelValue;
            int rotationValue2 = frame.method_6934();
            String rotation = rotationValue2 + "/7";
            list.add(TextUtils.entityLine("item_frame.rotation", rotation));
        }
        if ((rotationValue2 = this.entity) instanceof class_1438) {
            class_1799 mainHand;
            class_1438 mooshroom = (class_1438)rotationValue2;
            variant = TextUtils.transEntityProp("mooshroom.variant." + this.getAnimalVariant());
            list.add(TextUtils.entityLine("variant", (class_2561)variant));
            if (mooshroom.method_47847() == class_1438.class_4053.field_18110 && (mainHand = this.client.field_1724.method_6047()).method_31573(class_3489.field_15543)) {
                class_7917 ingredient = class_7917.method_47380((class_1935)mainHand.method_7909());
                class_9298 effects = ingredient.method_53233();
                list.add(TextUtils.entityLine("mooshroom.flower.effect", (class_2561)TextUtils.empty()));
                for (class_9298.class_8751 stewEffect : effects.comp_2416()) {
                    class_1291 statusEffect = (class_1291)stewEffect.comp_1838().comp_349();
                    class_1293 instance = stewEffect.method_53247();
                    class_2561 name2 = statusEffect.method_5560();
                    class_2561 duration = Utils.getStatusEffectDurationText(instance);
                    class_5250 effect = TextUtils.shifted(name2).method_10852(duration).method_27692(Utils.getStatusEffectFormatting(statusEffect));
                    list.add(effect);
                }
            }
        }
        if (this.entity instanceof class_3701) {
            boolean isTrusting = this.isOcelotTrusting();
            list.add(TextUtils.entityLine("ocelot.trusting", (class_2561)TextUtils.trueFalse(isTrusting, false)));
        }
        if ((variant = this.entity) instanceof class_1440) {
            class_1440 panda = (class_1440)variant;
            mainGene = TextUtils.transEntityProp("panda.gene." + panda.method_6525().method_6564());
            class_5250 hiddenGene = TextUtils.transEntityProp("panda.gene." + panda.method_6508().method_6564());
            list.add(TextUtils.entityLine("panda.main_gene", (class_2561)mainGene));
            list.add(TextUtils.entityLine("panda.hidden_gene", (class_2561)hiddenGene));
        }
        if ((mainGene = this.entity) instanceof class_1534) {
            class_1534 painting = (class_1534)mainGene;
            painting.method_43404().method_40230().ifPresent(key -> {
                class_1535 variant = (class_1535)painting.method_43404().comp_349();
                class_5250 title = TextUtils.translate(key.method_29177().method_48747("painting", "title"));
                class_5250 author = TextUtils.translate(key.method_29177().method_48747("painting", "author"));
                class_5250 size = class_2561.method_43469((String)"painting.dimensions", (Object[])new Object[]{variant.comp_2670(), variant.comp_2671()});
                list.addAll(List.of(TextUtils.entityLine("painting.title", (class_2561)TextUtils.empty()), TextUtils.shifted((class_2561)title).method_27692(class_124.field_1054), TextUtils.entityLine("painting.author", (class_2561)TextUtils.empty()), TextUtils.shifted((class_2561)author).method_27692(class_124.field_1080), TextUtils.entityLine("painting.size", (class_2561)size)));
            });
        }
        if (this.entity instanceof class_1463) {
            class_5250 variant7 = TextUtils.transEntityProp("rabbit.variant." + this.getAnimalVariant());
            list.add(TextUtils.entityLine("variant", (class_2561)variant7));
        }
        if ((mainGene = this.entity) instanceof class_1321) {
            class_1321 tameable = (class_1321)mainGene;
            boolean isTamed3 = tameable.method_6181();
            if (this.entity instanceof class_1451) {
                class_5250 variant8 = TextUtils.transEntityProp("cat.variant." + this.getAnimalVariant());
                list.add(TextUtils.entityLine("variant", (class_2561)variant8));
            } else if (this.entity instanceof class_1493) {
                class_5250 variant9 = TextUtils.transEntityProp("wolf.variant." + this.getAnimalVariant());
                list.add(TextUtils.entityLine("variant", (class_2561)variant9));
            }
            list.add(TextUtils.entityLine("tamed", (class_2561)TextUtils.trueFalse(isTamed3, true)));
            if (isTamed3) {
                this.getTameableOwner(list);
            }
        }
        if ((isTamed3 = this.entity) instanceof class_1481) {
            class_1481 turtle = (class_1481)isTamed3;
            boolean hasEgg = turtle.method_6679();
            list.add(TextUtils.entityLine("turtle.has_egg", (class_2561)TextUtils.trueFalse(hasEgg, false)));
        }
        if (this.entity instanceof class_1646 || this.entity instanceof class_1641) {
            boolean isVillager = this.entity instanceof class_1646;
            class_3850 data = isVillager ? ((class_1646)this.entity).method_7231() : ((class_1641)this.entity).method_7231();
            class_2561 profession = this.getVillagerProfession(data);
            class_5250 level = TextUtils.translate("merchant.level." + data.comp_3522());
            String biomeValue = ((class_5321)data.comp_3520().method_40230().get()).method_29177().method_12832();
            class_5250 biome = TextUtils.translate("biome.minecraft." + biomeValue);
            list.addAll(TextUtils.shiftedEntityProperty("villager.profession", profession));
            list.add(TextUtils.entityLine("villager.level", (class_2561)level));
            list.add(TextUtils.entityLine("villager.biome", (class_2561)biome));
            if (isVillager) {
                class_2561 task = this.getVillagerTask((class_1646)this.entity);
                list.add(TextUtils.entityLine("villager.task", task));
            }
        }
        return list;
    }

    private String getEntityName() {
        String baseName;
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1688) {
            class_1688 minecart = (class_1688)class_12972;
            baseName = minecart.method_31480().method_7964().getString();
        } else {
            String name;
            baseName = this.entity instanceof class_1531 ? ((name = this.entity.method_5477().getString()).contains(";") ? this.entity.method_5864().method_5897().getString() : name) : (this.entity instanceof class_1646 ? TextUtils.translate("entity.minecraft.villager").getString() : this.entity.method_5477().getString());
        }
        String color = this.coloredText ? this.getEntityColor() : "\u00a77";
        return color + baseName;
    }

    private String getEntityColor() {
        class_5354 a;
        class_1463 rabbit;
        if (this.entity instanceof class_1474) {
            int variant = this.getTropicalFishVariant();
            boolean isCommon = class_1474.field_41573.stream().anyMatch(v -> v.method_47872() == variant);
            return isCommon ? "\u00a72" : "\u00a7d";
        }
        class_1297 class_12972 = this.entity;
        boolean isKillerBunny = class_12972 instanceof class_1463 && (rabbit = (class_1463)class_12972).method_47855().method_47856() == 99;
        class_1297 class_12973 = this.entity;
        boolean isAngry = class_12973 instanceof class_5354 && (a = (class_5354)class_12973).method_29507() > 0;
        boolean isHostile = this.entity instanceof class_1588 || this.entity instanceof class_4760 || this.entity instanceof class_1606 || this.entity instanceof class_1621 || this.entity instanceof class_1674 || this.entity instanceof class_1511 || isKillerBunny || isAngry;
        return isHostile ? "\u00a7c" : "\u00a72";
    }

    private String getEntityCoordinates() {
        int x = this.entity.method_31477();
        int y = this.entity.method_31478();
        int z = this.entity.method_31479();
        if (this.coloredText) {
            return "\u00a7c" + x + " \u00a72" + y + " \u00a79" + z;
        }
        return "\u00a77" + x + " " + y + " " + z;
    }

    private String getEntityId() {
        return class_7923.field_41177.method_10221((Object)this.entity.method_5864()).toString();
    }

    private class_2561 getEntityIdText() {
        return TextUtils.write(this.getEntityId()).method_27692(class_124.field_1063);
    }

    private String getEntityModId() {
        String color = this.coloredText ? "\u00a75" : "\u00a77";
        String id = ((class_5321)class_7923.field_41177.method_29113((Object)this.entity.method_5864()).get()).method_29177().method_12836();
        String modName = ((ModContainer)FabricLoader.getInstance().getModContainer(id).get()).getMetadata().getName();
        return color + modName;
    }

    private boolean entityHasHealth() {
        return this.entity instanceof class_1309 && !(this.entity instanceof class_1531);
    }

    private String getEntityHealth() {
        if (!this.entityHasHealth()) {
            return "";
        }
        class_1309 living = (class_1309)this.entity;
        int health = class_3532.method_15386((float)living.method_6032());
        int maxHealth = class_3532.method_15386((float)living.method_6063());
        return String.format("\u00a77%d/%d", health, maxHealth);
    }

    private class_2561 getVillagerTask(class_1646 villager) {
        class_6880 profession = villager.method_7231().comp_3521();
        boolean isBaby = villager.method_6109();
        long time = this.client.field_1687.method_8532() % 24000L;
        String key = isBaby ? (time >= 12000L ? "sleep" : (time >= 3000L && time < 6000L ? "play" : "wander")) : (profession == class_3852.field_17051 || profession == class_3852.field_17062 ? (time >= 12000L ? "sleep" : (time >= 0L && time < 9000L || time >= 10000L && time < 12000L ? "wander" : (time >= 9000L && time < 10000L ? "gather" : "wander"))) : (time >= 12000L ? "sleep" : (time >= 0L && time < 2000L || time >= 10000L && time < 12000L ? "wander" : (time >= 2000L && time < 9000L ? "work" : (time >= 9000L && time < 10000L ? "gather" : "wander")))));
        return TextUtils.transEntityProp("villager.task." + key);
    }

    private String[] getEntityGroupAndPath() {
        class_4985 strider;
        class_1473 snowGolem;
        class_11187 happyGhast;
        class_4466 bee;
        class_1634 vex;
        class_1571 ghast;
        class_1606 shulker;
        class_1297 class_12972;
        String group = "";
        Object path = class_7923.field_41177.method_10221((Object)this.entity.method_5864()).method_12832();
        if (this.entity instanceof class_10255) {
            group = "boat/";
            path = this.entity.method_5864().method_35050();
        }
        if (this.entity instanceof class_1688) {
            group = "minecart/";
        }
        if (this.entity instanceof class_10275) {
            path = "creaking";
        }
        if ((class_12972 = this.entity) instanceof class_1606 && (shulker = (class_1606)class_12972).method_7121() != null) {
            group = ((String)path).concat("/");
            path = shulker.method_7121().method_7792();
        }
        if ((class_12972 = this.entity) instanceof class_1571 && (ghast = (class_1571)class_12972).method_7050()) {
            path = ((String)path).concat("_shooting");
        }
        if ((class_12972 = this.entity) instanceof class_1634 && (vex = (class_1634)class_12972).method_7176()) {
            path = ((String)path).concat("_charging");
        }
        if ((class_12972 = this.entity) instanceof class_1641) {
            class_1641 zombieVillager = (class_1641)class_12972;
            group = ((String)path).concat("/");
            path = this.getVillagerProfessionId(zombieVillager.method_7231());
        }
        if ((class_12972 = this.entity) instanceof class_4466 && (bee = (class_4466)class_12972).method_29507() > 0) {
            path = ((String)path).concat("_angry");
        }
        if (this.entity instanceof class_5762 || this.entity instanceof class_1451 || this.entity instanceof class_1428 || this.entity instanceof class_10730 || this.entity instanceof class_7102 || this.entity instanceof class_1453 || this.entity instanceof class_1452) {
            group = ((String)path).concat("/");
            path = this.getAnimalVariant();
        }
        if ((class_12972 = this.entity) instanceof class_11573) {
            class_11573 copperGolem = (class_11573)class_12972;
            group = ((String)path).concat("/");
            path = copperGolem.method_72477().method_15434();
        }
        if (this.entity instanceof class_4019) {
            path = ((String)path).concat("_" + this.getAnimalVariant());
        }
        if ((class_12972 = this.entity) instanceof class_11187 && (happyGhast = (class_11187)class_12972).method_56677() && happyGhast.method_5782()) {
            path = ((String)path).concat("_mounted");
        }
        if ((class_12972 = this.entity) instanceof class_1498) {
            class_1498 horse = (class_1498)class_12972;
            group = ((String)path).concat("/");
            path = horse.method_27077().method_15434();
        }
        if ((class_12972 = this.entity) instanceof class_1501) {
            class_1501 llama = (class_1501)class_12972;
            group = ((String)path).concat("/");
            path = llama.method_6809().method_15434();
        }
        if (this.entity instanceof class_1438) {
            group = "cow/";
            path = ((String)path).concat("_" + this.getAnimalVariant());
        }
        if ((class_12972 = this.entity) instanceof class_1440) {
            class_1440 panda = (class_1440)class_12972;
            group = ((String)path).concat("/");
            path = panda.method_6554().method_15434();
        }
        if ((class_12972 = this.entity) instanceof class_1463) {
            class_1463 rabbit = (class_1463)class_12972;
            group = ((String)path).concat("/");
            Object object = path = this.entity.method_5797() != null && this.entity.method_5797().getString().contains("Toast") ? "toast" : rabbit.method_47855().method_15434();
        }
        if ((class_12972 = this.entity) instanceof class_1473 && (snowGolem = (class_1473)class_12972).method_6643()) {
            path = ((String)path).concat("_pumpkin");
        }
        if ((class_12972 = this.entity) instanceof class_1472) {
            class_1472 sheep = (class_1472)class_12972;
            group = ((String)path).concat("/");
            path = sheep.method_6633().method_7792();
        }
        if ((class_12972 = this.entity) instanceof class_4985 && (strider = (class_4985)class_12972).method_26348()) {
            path = ((String)path).concat("_cold");
        }
        if ((class_12972 = this.entity) instanceof class_1646) {
            class_1646 villager = (class_1646)class_12972;
            group = ((String)path).concat("/");
            path = this.getVillagerProfessionId(villager.method_7231());
        }
        if ((class_12972 = this.entity) instanceof class_1493) {
            class_1493 wolf = (class_1493)class_12972;
            group = ((String)path).concat("/");
            path = this.getAnimalVariant() + (wolf.method_6181() ? "_tame" : (wolf.method_29507() > 0 ? "_angry" : ""));
        }
        if (((String)path).contains(":")) {
            String[] split = ((String)path).split(":");
            group = group.concat(split[0] + "/");
            path = split[1];
        }
        return new String[]{group, path};
    }

    private boolean isFoxTrustingPlayer() {
        UUID playerUUID = this.client.field_1724.method_5667();
        return ((AccessorFoxEntity)this.entity).getFoxTrustedPlayers().anyMatch(ref -> playerUUID.equals(ref.method_66263()));
    }

    private List<UUID> getFoxTrustedPlayersUUID() {
        return ((AccessorFoxEntity)this.entity).getFoxTrustedPlayers().map(class_10583::method_66263).filter(Objects::nonNull).toList();
    }

    private void getFoxTrustingPlayersNames(List<class_2561> list) {
        List<UUID> uuids = this.getFoxTrustedPlayersUUID();
        if (uuids.isEmpty()) {
            return;
        }
        List<class_5250> names = uuids.stream().map(uuid -> {
            class_1657 player = this.client.field_1687.method_18470(uuid);
            if (player != null) {
                return TextUtils.shifted((class_2561)player.method_5477().method_27661().method_27695(new class_124[]{class_124.field_1077, class_124.field_1056}));
            }
            return TextUtils.shifted((class_2561)TextUtils.transEntityProp("owner.offline").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
        }).toList();
        if (names.size() == 1) {
            class_5250 inline = TextUtils.entityLine("owner.trusted", (class_2561)names.get(0));
            if (TextUtils.width(inline) <= 90) {
                list.add((class_2561)inline);
            } else {
                list.add((class_2561)TextUtils.entityLine("owner.trusted", (class_2561)TextUtils.empty()));
                list.add((class_2561)names.get(0));
            }
        } else {
            list.add((class_2561)TextUtils.entityLine("owner.trusted", (class_2561)TextUtils.empty()));
            list.addAll(names);
        }
    }

    private void getTameableOwner(List<class_2561> list) {
        class_124[] class_124Array;
        boolean isOnline;
        UUID uuid = ((class_1321)this.entity).method_66287().method_66263();
        boolean bl = isOnline = uuid != null && this.client.field_1687.method_18470(uuid) != null;
        if (isOnline) {
            class_124[] class_124Array2 = new class_124[2];
            class_124Array2[0] = class_124.field_1077;
            class_124Array = class_124Array2;
            class_124Array2[1] = class_124.field_1056;
        } else {
            class_124[] class_124Array3 = new class_124[2];
            class_124Array3[0] = class_124.field_1063;
            class_124Array = class_124Array3;
            class_124Array3[1] = class_124.field_1056;
        }
        class_124[] formatting = class_124Array;
        class_5250 name = TextUtils.shifted((class_2561)(isOnline ? this.client.field_1687.method_18470(uuid).method_5477().method_27661().method_27695(formatting) : TextUtils.transEntityProp("owner.offline").method_27695(formatting)));
        list.addAll(TextUtils.shiftedEntityProperty("owner", (class_2561)name));
    }

    private boolean isOcelotTrusting() {
        return ((AccessorOcelotEntity)this.entity).isOcelotTrusting();
    }

    private String getAnimalVariant() {
        class_1297 class_12972 = this.entity;
        Objects.requireNonNull(class_12972);
        class_1297 class_12973 = class_12972;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_5762.class, class_1451.class, class_1428.class, class_10730.class, class_4019.class, class_7102.class, class_1498.class, class_1501.class, class_1438.class, class_1453.class, class_1452.class, class_1463.class, class_1462.class, class_1493.class}, (Object)class_12973, n)) {
            case 0 -> {
                class_5762 axolotl = (class_5762)class_12973;
                yield axolotl.method_33225().method_15434();
            }
            case 1 -> {
                class_1451 cat = (class_1451)class_12973;
                yield ((class_5321)cat.method_47843().method_40230().get()).method_29177().method_43903();
            }
            case 2 -> {
                class_1428 chicken = (class_1428)class_12973;
                yield ((class_5321)chicken.method_67522().method_40230().get()).method_29177().method_43903();
            }
            case 3 -> {
                class_10730 cow = (class_10730)class_12973;
                yield ((class_5321)cow.method_67349().method_40230().get()).method_29177().method_43903();
            }
            case 4 -> {
                class_4019 fox = (class_4019)class_12973;
                yield fox.method_47845().method_15434();
            }
            case 5 -> {
                class_7102 frog = (class_7102)class_12973;
                yield ((class_5321)frog.method_41354().method_40230().get()).method_29177().method_43903();
            }
            case 6 -> {
                class_1498 horse = (class_1498)class_12973;
                yield String.valueOf(horse.method_27077().method_27082());
            }
            case 7 -> {
                class_1501 llama = (class_1501)class_12973;
                yield String.valueOf(llama.method_6809().method_47875());
            }
            case 8 -> {
                class_1438 mooshroom = (class_1438)class_12973;
                yield mooshroom.method_47847().method_15434();
            }
            case 9 -> {
                class_1453 parrot = (class_1453)class_12973;
                yield parrot.method_6584().method_15434();
            }
            case 10 -> {
                class_1452 pig = (class_1452)class_12973;
                yield ((class_5321)pig.method_66299().method_40230().get()).method_29177().method_43903();
            }
            case 11 -> {
                class_1463 rabbit = (class_1463)class_12973;
                yield String.valueOf(rabbit.method_47855().method_47856());
            }
            case 12 -> {
                class_1462 salmon = (class_1462)class_12973;
                yield salmon.method_61472().method_15434();
            }
            case 13 -> {
                class_1493 wolf = (class_1493)class_12973;
                yield ((class_5321)((AccessorWolfEntity)wolf).getWolfVariant().method_40230().get()).method_29177().method_43903();
            }
            default -> "";
        };
    }

    private String getVillagerProfessionId(class_3850 data) {
        String idString = data.comp_3521().method_55840();
        class_2960 id = class_2960.method_12829((String)idString);
        return id != null ? id.method_12832() : idString;
    }

    private class_2561 getVillagerProfession(class_3850 data) {
        String fullId = data.comp_3521().method_55840();
        String professionId = this.getVillagerProfessionId(data);
        boolean isVanilla = fullId.startsWith("minecraft:");
        String displayName = TextUtils.capTitle(professionId.replace("_", " "));
        if (isVanilla) {
            return TextUtils.translate("entity.minecraft.villager." + professionId);
        }
        return TextUtils.write(displayName);
    }

    private int getTropicalFishVariant() {
        return NbtUtils.writeEntityToNbt(this.entity).method_68083("Variant", -1);
    }
}

