/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.screen;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.gui.screen.ScreenBaseScrollable;
import lordrius.essentialgui.util.TextUtils;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ClientPlayerWorldScreen
extends ScreenBaseScrollable {
    private final ConfigData.ClientPlayerWorld config;
    private final String key = "screen.client.";

    public ClientPlayerWorldScreen(class_437 parent) {
        super(parent, (class_2561)TextUtils.translate("screen.client.title"));
        this.config = Data.cfg.client;
        this.key = "screen.client.";
    }

    @Override
    public void method_25426() {
        super.method_25426();
    }

    @Override
    public void addEntries() {
        class_5250 PERFORMANCE_HEADER = TextUtils.translate("screen.client.performance");
        class_5250 POSITION_HEADER = TextUtils.translate("screen.client.position");
        class_5250 WORLD_HEADER = TextUtils.translate("screen.client.world");
        this.addCategory("performance", (class_2561)PERFORMANCE_HEADER, () -> this.config.performance.enabled, v -> {
            this.config.performance.enabled = v;
        }, this.performanceOptions());
        this.addCategory("position", (class_2561)POSITION_HEADER, () -> this.config.position.enabled, v -> {
            this.config.position.enabled = v;
        }, this.positionOptions());
        this.addCategory("world", (class_2561)WORLD_HEADER, () -> this.config.world.enabled, v -> {
            this.config.world.enabled = v;
        }, this.worldOptions());
    }

    private void addCategory(String prefix, class_2561 header, BooleanSupplier enabled, Consumer<Boolean> toggle, List<BooleanOption> options) {
        this.addCategoryHeader(header, enabled, toggle);
        this.addBooleanGroup(prefix, options);
    }

    private void addBooleanGroup(String prefix, List<BooleanOption> options) {
        for (BooleanOption option : options) {
            class_5250 label = TextUtils.translate("screen.client." + prefix + "." + option.key());
            class_2561 tooltip = this.safeTranslate("screen.client." + prefix + "." + option.key() + ".tooltip");
            this.addBooleanEntry((class_2561)label, tooltip, option.getter(), option.setter());
        }
    }

    private List<BooleanOption> performanceOptions() {
        return List.of(new BooleanOption("fps", () -> this.config.performance.fps, v -> {
            this.config.performance.fps = v;
        }), new BooleanOption("cpu", () -> this.config.performance.cpu, v -> {
            this.config.performance.cpu = v;
        }), new BooleanOption("memory", () -> this.config.performance.memory, v -> {
            this.config.performance.memory = v;
        }), new BooleanOption("latency", () -> this.config.performance.latency, v -> {
            this.config.performance.latency = v;
        }), new BooleanOption("packets", () -> this.config.performance.packets, v -> {
            this.config.performance.packets = v;
        }));
    }

    private List<BooleanOption> positionOptions() {
        return List.of(new BooleanOption("coords", () -> this.config.position.coords, v -> {
            this.config.position.coords = v;
        }), new BooleanOption("coords_dim", () -> this.config.position.coordsDim, v -> {
            this.config.position.coordsDim = v;
        }), new BooleanOption("chunk", () -> this.config.position.chunk, v -> {
            this.config.position.chunk = v;
        }), new BooleanOption("chunk_slime", () -> this.config.position.chunkSlime, v -> {
            this.config.position.chunkSlime = v;
        }), new BooleanOption("facing", () -> this.config.position.facing, v -> {
            this.config.position.facing = v;
        }), new BooleanOption("facing_axis", () -> this.config.position.facingAxis, v -> {
            this.config.position.facingAxis = v;
        }), new BooleanOption("rotation", () -> this.config.position.rotation, v -> {
            this.config.position.rotation = v;
        }), new BooleanOption("light", () -> this.config.position.light, v -> {
            this.config.position.light = v;
        }), new BooleanOption("speed", () -> this.config.position.speed, v -> {
            this.config.position.speed = v;
        }));
    }

    private List<BooleanOption> worldOptions() {
        return List.of(new BooleanOption("biome", () -> this.config.world.biome, v -> {
            this.config.world.biome = v;
        }), new BooleanOption("entities", () -> this.config.world.entities, v -> {
            this.config.world.entities = v;
        }), new BooleanOption("entities_block", () -> this.config.world.entitiesBlock, v -> {
            this.config.world.entitiesBlock = v;
        }), new BooleanOption("time", () -> this.config.world.time, v -> {
            this.config.world.time = v;
        }), new BooleanOption("time_days", () -> this.config.world.timeDays, v -> {
            this.config.world.timeDays = v;
        }), new BooleanOption("days", () -> this.config.world.days, v -> {
            this.config.world.days = v;
        }));
    }

    public record BooleanOption(String key, BooleanSupplier getter, Consumer<Boolean> setter) {
    }
}

