/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.screen;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.gui.screen.BiomeWeatherTimeScreen;
import lordrius.essentialgui.gui.screen.ClientPlayerWorldScreen;
import lordrius.essentialgui.gui.screen.PlayerEquipmentScreen;
import lordrius.essentialgui.gui.screen.PlayerWarningAreaScreen;
import lordrius.essentialgui.gui.screen.VanillaHudScreen;
import lordrius.essentialgui.gui.screen.options.EntityStatsBarsScreen;
import lordrius.essentialgui.util.Draw;
import lordrius.essentialgui.util.HudStyles;
import lordrius.essentialgui.util.TextUtils;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.lwjgl.glfw.GLFW;

public class HudPositionScreen
extends class_437 {
    private static final ConfigData config = Data.cfg;
    private static HudSection lastSection = HudSection.CLIENT_PLAYER_WORLD;
    private HudSection section = lastSection;
    private static final String LANG_PREFIX = "screen.hud_location.custom.";
    private int prevMouseX = -1;
    private int prevMouseY = -1;
    private final class_2561[] MESSAGES = new class_2561[]{TextUtils.translate("screen.hud_location.custom.message.1"), TextUtils.translate("screen.hud_location.custom.message.2"), TextUtils.translate("screen.hud_location.custom.message.3"), TextUtils.translate("screen.hud_location.custom.message.4"), TextUtils.translate("screen.hud_location.custom.message.5"), TextUtils.translate("screen.hud_location.custom.message.6"), TextUtils.translate("screen.hud_location.custom.message.7")};

    public HudPositionScreen(class_437 parent) {
        super((class_2561)class_2561.method_43473());
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.isLeftMousePressed()) {
            if (this.prevMouseX != -1 && this.prevMouseY != -1) {
                if (this.section.getCoords()[0] == -1 && this.section.getCoords()[1] == -1) {
                    this.section.setInitialCoords();
                }
                int deltaX = mouseX - this.prevMouseX;
                int deltaY = mouseY - this.prevMouseY;
                this.section.applyDelta(deltaX, deltaY, this.field_22789, this.field_22790);
            }
            this.prevMouseX = mouseX;
            this.prevMouseY = mouseY;
        } else {
            this.prevMouseX = -1;
            this.prevMouseY = -1;
        }
        int baseX = this.field_22789 / 2 - 59;
        int baseY = this.field_22790 / 2 - 40;
        int lineHeight = 14;
        class_5250 currentSection = TextUtils.translate("screen.hud_location.custom.section", this.section.getTranslatedTitle());
        Draw.drawCenteredTextWithBackground(context, this.field_22789 / 2, 4, (class_2561)currentSection);
        for (int i = 0; i < this.MESSAGES.length; ++i) {
            Draw.drawTextWithBackground(context, baseX, baseY + lineHeight * i, this.MESSAGES[i]);
        }
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        this.section.onClick(click);
        return super.method_25402(click, doubled);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.section = this.section.cycleSections(verticalAmount);
        return true;
    }

    public boolean isLeftMousePressed() {
        long handle = class_310.method_1551().method_22683().method_4490();
        return GLFW.glfwGetMouseButton((long)handle, (int)0) == 1;
    }

    public boolean method_25404(class_11908 input) {
        if (input.method_74236()) {
            this.section.toggleHudStyle();
            return true;
        }
        if (input.method_74228() == 82) {
            this.section.resetCoords();
            return true;
        }
        return super.method_25404(input);
    }

    public void method_25419() {
        Data.save();
        lastSection = this.section;
        this.field_22787.method_1507(null);
    }

    public static enum HudSection {
        CLIENT_PLAYER_WORLD("screen.hud_location.custom.section.0", HudStyles.CLIENT_HUD_STYLES.toArray(new String[0]), v -> {
            HudPositionScreen.config.client.style = v;
        }, () -> HudPositionScreen.config.client.style, (dx, dy) -> {
            HudPositionScreen.config.client.x += dx.intValue();
            HudPositionScreen.config.client.y += dy.intValue();
        }, (x, y) -> {
            HudPositionScreen.config.client.x = x;
            HudPositionScreen.config.client.y = y;
        }),
        STATUS_WARNINGS("screen.hud_location.custom.section.1.0", HudStyles.TEXTURE_TYPES.toArray(new String[0]), v -> {
            HudPositionScreen.config.warning.texture = v;
        }, () -> HudPositionScreen.config.warning.texture, (dx, dy) -> {
            HudPositionScreen.config.warning.statusX += dx.intValue();
            HudPositionScreen.config.warning.statusY += dy.intValue();
        }, (x, y) -> {
            HudPositionScreen.config.warning.statusX = x;
            HudPositionScreen.config.warning.statusY = y;
        }),
        EQUIPMENT_WARNINGS("screen.hud_location.custom.section.1.1", HudStyles.TEXTURE_TYPES.toArray(new String[0]), v -> {
            HudPositionScreen.config.warning.texture = v;
        }, () -> HudPositionScreen.config.warning.texture, (dx, dy) -> {
            HudPositionScreen.config.warning.equipmentX += dx.intValue();
            HudPositionScreen.config.warning.equipmentY += dy.intValue();
        }, (x, y) -> {
            HudPositionScreen.config.warning.equipmentX = x;
            HudPositionScreen.config.warning.equipmentY = y;
        }),
        OXYGEN_BAR("screen.hud_location.custom.section.1.2", HudStyles.STATS_BARS_STYLES.toArray(new String[0]), v -> {
            HudPositionScreen.config.entity.statsBars.style = v;
        }, () -> HudPositionScreen.config.entity.statsBars.style, (dx, dy) -> {
            HudPositionScreen.config.warning.oxygenBar.x += dx.intValue();
            HudPositionScreen.config.warning.oxygenBar.y += dy.intValue();
        }, (x, y) -> {
            HudPositionScreen.config.warning.oxygenBar.x = x;
            HudPositionScreen.config.warning.oxygenBar.y = y;
        }),
        QUIVER("screen.hud_location.custom.section.4.0", HudStyles.QUIVER_TEXTURES.toArray(new String[0]), v -> {
            HudPositionScreen.config.equipment.quiver.texture = v;
        }, () -> HudPositionScreen.config.equipment.quiver.texture, (dx, dy) -> {
            HudPositionScreen.config.equipment.quiver.x += dx.intValue();
            HudPositionScreen.config.equipment.quiver.y += dy.intValue();
        }, (x, y) -> {
            HudPositionScreen.config.equipment.quiver.x = x;
            HudPositionScreen.config.equipment.quiver.y = y;
        }),
        ITEM_STOCK("screen.hud_location.custom.section.4.1", HudStyles.ITEM_STOCK_TEXTURES.toArray(new String[0]), v -> {
            HudPositionScreen.config.equipment.stock.texture = v;
        }, () -> HudPositionScreen.config.equipment.stock.texture, (dx, dy) -> {
            HudPositionScreen.config.equipment.stock.x += dx.intValue();
            HudPositionScreen.config.equipment.stock.y += dy.intValue();
        }, (x, y) -> {
            HudPositionScreen.config.equipment.stock.x = x;
            HudPositionScreen.config.equipment.stock.y = y;
        }),
        SCREEN_EQUIPMENT("screen.hud_location.custom.section.4.2", HudStyles.ON_SCREEN_TEXTURES.toArray(new String[0]), v -> {
            HudPositionScreen.config.equipment.screen.texture = v;
        }, () -> HudPositionScreen.config.equipment.screen.texture, (dx, dy) -> {
            HudPositionScreen.config.equipment.screen.x += dx.intValue();
            HudPositionScreen.config.equipment.screen.y += dy.intValue();
        }, (x, y) -> {
            HudPositionScreen.config.equipment.screen.x = x;
            HudPositionScreen.config.equipment.screen.y = y;
        }),
        BIOME_WEATHER_TIME("screen.hud_location.custom.section.5", HudStyles.BIOME_TEXTURES.toArray(new String[0]), v -> {
            HudPositionScreen.config.biome.texture = v;
        }, () -> HudPositionScreen.config.biome.texture, (dx, dy) -> {
            HudPositionScreen.config.biome.x += dx.intValue();
            HudPositionScreen.config.biome.y += dy.intValue();
        }, (x, y) -> {
            HudPositionScreen.config.biome.x = x;
            HudPositionScreen.config.biome.y = y;
        }),
        STATUS_EFFECTS("screen.hud_location.custom.section.6", HudStyles.EFFECTS_TEXTURES.toArray(new String[0]), v -> {
            HudPositionScreen.config.vanilla.effects.texture = v;
        }, () -> HudPositionScreen.config.vanilla.effects.texture, (dx, dy) -> {
            HudPositionScreen.config.vanilla.effects.x += dx.intValue();
            HudPositionScreen.config.vanilla.effects.y += dy.intValue();
        }, (x, y) -> {
            HudPositionScreen.config.vanilla.effects.x = x;
            HudPositionScreen.config.vanilla.effects.y = y;
        });

        private final String titleKey;
        private final String[] styles;
        private final Consumer<String> setter;
        private final Supplier<String> getter;
        private final BiConsumer<Integer, Integer> coordSetter;
        private final BiConsumer<Integer, Integer> coordResetter;

        private HudSection(String titleKey, String[] styles, Consumer<String> setter, Supplier<String> getter, BiConsumer<Integer, Integer> coordSetter, BiConsumer<Integer, Integer> coordResetter) {
            this.titleKey = titleKey;
            this.styles = styles;
            this.setter = setter;
            this.getter = getter;
            this.coordSetter = coordSetter;
            this.coordResetter = coordResetter;
        }

        public class_2561 getTranslatedTitle() {
            return TextUtils.translate(this.titleKey);
        }

        public void resetCoords() {
            this.coordResetter.accept(-1, -1);
        }

        public void setInitialCoords() {
            int width = class_310.method_1551().method_22683().method_4486();
            int height = class_310.method_1551().method_22683().method_4502();
            switch (this.ordinal()) {
                case 0: {
                    int x = 5;
                    int y = 28;
                    HudPositionScreen.config.client.x = Utils.toRelative(x, width);
                    HudPositionScreen.config.client.y = Utils.toRelative(y, height);
                    break;
                }
                case 1: {
                    int x = 2;
                    int y = height - 22;
                    HudPositionScreen.config.warning.statusX = Utils.toRelative(x, width);
                    HudPositionScreen.config.warning.statusY = Utils.toRelative(y, height);
                    break;
                }
                case 2: {
                    int x = width - 22;
                    int y = height - 22;
                    HudPositionScreen.config.warning.equipmentX = Utils.toRelative(x, width);
                    HudPositionScreen.config.warning.equipmentY = Utils.toRelative(y, height);
                    break;
                }
                case 3: {
                    int barWidth = HudPositionScreen.config.warning.oxygenBar.width;
                    int x = (width - barWidth - 2) / 2;
                    int y = height - 80;
                    HudPositionScreen.config.warning.oxygenBar.x = Utils.toRelative(x, width);
                    HudPositionScreen.config.warning.oxygenBar.y = Utils.toRelative(y, height);
                    break;
                }
                case 4: {
                    int x = width - 22;
                    int y = height / 2 - 81;
                    HudPositionScreen.config.equipment.quiver.x = Utils.toRelative(x, width);
                    HudPositionScreen.config.equipment.quiver.y = Utils.toRelative(y, height);
                    break;
                }
                case 5: {
                    int x = width / 2 + 100;
                    int y = height - 21;
                    HudPositionScreen.config.equipment.stock.x = Utils.toRelative(x, width);
                    HudPositionScreen.config.equipment.stock.y = Utils.toRelative(y, height);
                    break;
                }
                case 6: {
                    int x = width - 20;
                    int y = height / 2 - 56;
                    HudPositionScreen.config.equipment.screen.x = Utils.toRelative(x, width);
                    HudPositionScreen.config.equipment.screen.y = Utils.toRelative(y, height);
                    break;
                }
                case 7: {
                    int x = 2;
                    int y = 2;
                    HudPositionScreen.config.biome.x = Utils.toRelative(x, width);
                    HudPositionScreen.config.biome.y = Utils.toRelative(y, height);
                    break;
                }
                case 8: {
                    int x = width - 25;
                    int y = 2;
                    HudPositionScreen.config.vanilla.effects.x = Utils.toRelative(x, width);
                    HudPositionScreen.config.vanilla.effects.y = Utils.toRelative(y, height);
                }
            }
        }

        public int[] getCoords() {
            int[] nArray;
            switch (this.ordinal()) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    int[] nArray2 = new int[2];
                    nArray2[0] = HudPositionScreen.config.client.x;
                    nArray = nArray2;
                    nArray2[1] = HudPositionScreen.config.client.y;
                    break;
                }
                case 1: {
                    int[] nArray3 = new int[2];
                    nArray3[0] = HudPositionScreen.config.warning.statusX;
                    nArray = nArray3;
                    nArray3[1] = HudPositionScreen.config.warning.statusY;
                    break;
                }
                case 2: {
                    int[] nArray4 = new int[2];
                    nArray4[0] = HudPositionScreen.config.warning.equipmentX;
                    nArray = nArray4;
                    nArray4[1] = HudPositionScreen.config.warning.equipmentY;
                    break;
                }
                case 3: {
                    int[] nArray5 = new int[2];
                    nArray5[0] = HudPositionScreen.config.warning.oxygenBar.x;
                    nArray = nArray5;
                    nArray5[1] = HudPositionScreen.config.warning.oxygenBar.y;
                    break;
                }
                case 4: {
                    int[] nArray6 = new int[2];
                    nArray6[0] = HudPositionScreen.config.equipment.quiver.x;
                    nArray = nArray6;
                    nArray6[1] = HudPositionScreen.config.equipment.quiver.y;
                    break;
                }
                case 5: {
                    int[] nArray7 = new int[2];
                    nArray7[0] = HudPositionScreen.config.equipment.stock.x;
                    nArray = nArray7;
                    nArray7[1] = HudPositionScreen.config.equipment.stock.y;
                    break;
                }
                case 6: {
                    int[] nArray8 = new int[2];
                    nArray8[0] = HudPositionScreen.config.equipment.screen.x;
                    nArray = nArray8;
                    nArray8[1] = HudPositionScreen.config.equipment.screen.y;
                    break;
                }
                case 7: {
                    int[] nArray9 = new int[2];
                    nArray9[0] = HudPositionScreen.config.biome.x;
                    nArray = nArray9;
                    nArray9[1] = HudPositionScreen.config.biome.y;
                    break;
                }
                case 8: {
                    int[] nArray10 = new int[2];
                    nArray10[0] = HudPositionScreen.config.vanilla.effects.x;
                    nArray = nArray10;
                    nArray10[1] = HudPositionScreen.config.vanilla.effects.y;
                }
            }
            return nArray;
        }

        public HudSection cycleSections(double verticalAmount) {
            HudSection[] sections = HudSection.values();
            int ordinal = this.ordinal();
            if (verticalAmount > 0.0) {
                ordinal = (ordinal + 1) % sections.length;
            } else if (verticalAmount < 0.0) {
                ordinal = (ordinal - 1 + sections.length) % sections.length;
            }
            return sections[ordinal];
        }

        public void toggleHudStyle() {
            String current = this.getter.get();
            int index = -1;
            for (int i = 0; i < this.styles.length; ++i) {
                if (!this.styles[i].equals(current)) continue;
                index = i;
                break;
            }
            if (index >= 0) {
                int newIndex = (index + 1) % this.styles.length;
                this.setter.accept(this.styles[newIndex]);
            }
        }

        public void applyDelta(int dx, int dy, int width, int height) {
            int relDx = dx * 1000 / width;
            int relDy = dy * 1000 / height;
            this.coordSetter.accept(relDx, relDy);
        }

        public void onClick(class_11909 click) {
            class_310 client = class_310.method_1551();
            class_437 currentScreen = client.field_1755;
            boolean middleButton = click.method_74245() == 2;
            boolean rightButton = click.method_74245() == 1;
            switch (this.ordinal()) {
                case 0: {
                    if (rightButton) {
                        boolean bl = HudPositionScreen.config.client.borders = !HudPositionScreen.config.client.borders;
                    }
                    if (!middleButton) break;
                    client.method_1507((class_437)new ClientPlayerWorldScreen(currentScreen));
                    break;
                }
                case 1: 
                case 2: {
                    if (!middleButton) break;
                    client.method_1507((class_437)new PlayerWarningAreaScreen(currentScreen));
                    break;
                }
                case 3: {
                    if (rightButton) {
                        boolean bl = HudPositionScreen.config.entity.statsBars.values = !HudPositionScreen.config.entity.statsBars.values;
                    }
                    if (!middleButton) break;
                    client.method_1507((class_437)new EntityStatsBarsScreen(currentScreen));
                    break;
                }
                case 4: 
                case 5: {
                    if (!middleButton) break;
                    client.method_1507((class_437)new PlayerEquipmentScreen(currentScreen));
                    break;
                }
                case 6: {
                    if (rightButton) {
                        boolean bl = HudPositionScreen.config.equipment.screen.durability = !HudPositionScreen.config.equipment.screen.durability;
                    }
                    if (!middleButton) break;
                    client.method_1507((class_437)new PlayerEquipmentScreen(currentScreen));
                    break;
                }
                case 7: {
                    if (rightButton) {
                        boolean bl = HudPositionScreen.config.biome.time = !HudPositionScreen.config.biome.time;
                    }
                    if (!middleButton) break;
                    client.method_1507((class_437)new BiomeWeatherTimeScreen(currentScreen));
                    break;
                }
                case 8: {
                    if (rightButton) {
                        boolean bl = HudPositionScreen.config.vanilla.effects.duration = !HudPositionScreen.config.vanilla.effects.duration;
                    }
                    if (!middleButton) break;
                    client.method_1507((class_437)new VanillaHudScreen(currentScreen));
                    break;
                }
            }
        }
    }
}

