/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.gui.screen;

import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.gui.screen.ScreenBaseScrollable;
import lordrius.essentialgui.util.TextUtils;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ItemTooltipsScreen
extends ScreenBaseScrollable {
    private final ConfigData.AdvancedItemTooltips config;
    private final String key = "screen.tooltips.";

    public ItemTooltipsScreen(class_437 parent) {
        super(parent, (class_2561)TextUtils.translate("screen.tooltips.title"));
        this.config = Data.cfg.tooltips;
        this.key = "screen.tooltips.";
    }

    @Override
    public void method_25426() {
        super.method_25426();
    }

    @Override
    public void addEntries() {
        class_5250 TOOLTIPS = TextUtils.translate("screen.tooltips");
        class_5250 DAMAGEABLES = TextUtils.translate("screen.tooltips.damageables");
        class_5250 FOOD = TextUtils.translate("screen.tooltips.food");
        class_5250 NBT = TextUtils.translate("screen.tooltips.nbt");
        class_5250 PATTERNS = TextUtils.translate("screen.tooltips.patterns");
        this.addStaticCategory((class_2561)TOOLTIPS, this.tooltips());
        this.addCategory("damageables", (class_2561)DAMAGEABLES, () -> this.config.damageables.enabled, v -> {
            this.config.damageables.enabled = v;
        }, this.damageables());
        this.addCategory("food", (class_2561)FOOD, () -> this.config.food.enabled, v -> {
            this.config.food.enabled = v;
        }, this.food());
        this.addCategory("nbt", (class_2561)NBT, () -> this.config.nbt.enabled, v -> {
            this.config.nbt.enabled = v;
        }, this.nbt());
        this.addCategory("patterns", (class_2561)PATTERNS, () -> this.config.patterns.enabled, v -> {
            this.config.patterns.enabled = v;
        }, this.patterns());
    }

    private void addStaticCategory(class_2561 header, List<BooleanOption> options) {
        this.addStaticHeader(header);
        this.addBooleanGroup("", options);
    }

    private void addCategory(String prefix, class_2561 header, BooleanSupplier enabled, Consumer<Boolean> toggle, List<BooleanOption> options) {
        this.addCategoryHeader(header, enabled, toggle);
        this.addBooleanGroup(prefix + ".", options);
    }

    private void addBooleanGroup(String prefix, List<BooleanOption> options) {
        for (BooleanOption option : options) {
            class_5250 label = TextUtils.translate("screen.tooltips." + prefix + option.key());
            class_2561 tooltip = this.safeTranslate("screen.tooltips." + prefix + option.key() + ".tooltip");
            this.addBooleanEntry((class_2561)label, tooltip, option.getter(), option.setter());
        }
    }

    private List<BooleanOption> tooltips() {
        return List.of(new BooleanOption("lodestone_compass", () -> this.config.lodestoneCompass, v -> {
            this.config.lodestoneCompass = v;
        }), new BooleanOption("salmon_bucket", () -> this.config.salmonBucket, v -> {
            this.config.salmonBucket = v;
        }), new BooleanOption("axolotl_bucket", () -> this.config.axolotlBucket, v -> {
            this.config.axolotlBucket = v;
        }), new BooleanOption("recovery_compass", () -> this.config.recoveryCompass, v -> {
            this.config.recoveryCompass = v;
        }), new BooleanOption("tropical_fish_bucket", () -> this.config.tropicalFishBucket, v -> {
            this.config.tropicalFishBucket = v;
        }), new BooleanOption("books", () -> this.config.books, v -> {
            this.config.books = v;
        }), new BooleanOption("milk_bucket", () -> this.config.milkBucket, v -> {
            this.config.milkBucket = v;
        }), new BooleanOption("turtle_helmet", () -> this.config.turtleHelmet, v -> {
            this.config.turtleHelmet = v;
        }), new BooleanOption("maps", () -> this.config.maps, v -> {
            this.config.maps = v;
        }), new BooleanOption("fuel_stats", () -> this.config.fuelStats, v -> {
            this.config.fuelStats = v;
        }), new BooleanOption("discs", () -> this.config.discs, v -> {
            this.config.discs = v;
        }), new BooleanOption("decorated_pots", () -> this.config.decoratedPots, v -> {
            this.config.decoratedPots = v;
        }));
    }

    private List<BooleanOption> damageables() {
        return List.of(new BooleanOption("durability", () -> this.config.damageables.durability, v -> {
            this.config.damageables.durability = v;
        }), new BooleanOption("durability_colored", () -> this.config.damageables.durabilityColored, v -> {
            this.config.damageables.durabilityColored = v;
        }), new BooleanOption("durability_percent", () -> this.config.damageables.durabilityPercent, v -> {
            this.config.damageables.durabilityPercent = v;
        }), new BooleanOption("durability_always", () -> this.config.damageables.durabilityAlways, v -> {
            this.config.damageables.durabilityAlways = v;
        }), new BooleanOption("penalty", () -> this.config.damageables.penalty, v -> {
            this.config.damageables.penalty = v;
        }), new BooleanOption("comparison", () -> this.config.damageables.comparison, v -> {
            this.config.damageables.comparison = v;
        }), new BooleanOption("better_tooltip", () -> this.config.damageables.betterTooltip, v -> {
            this.config.damageables.betterTooltip = v;
        }));
    }

    private List<BooleanOption> food() {
        return List.of(new BooleanOption("simple_style", () -> this.config.food.simpleStyle, v -> {
            this.config.food.simpleStyle = v;
        }), new BooleanOption("player_hunger", () -> this.config.food.playerHunger, v -> {
            this.config.food.playerHunger = v;
        }), new BooleanOption("effects", () -> this.config.food.foodEffects, v -> {
            this.config.food.foodEffects = v;
        }), new BooleanOption("stew_effects", () -> this.config.food.stewEffects, v -> {
            this.config.food.stewEffects = v;
        }));
    }

    private List<BooleanOption> nbt() {
        return List.of(new BooleanOption("beehive", () -> this.config.nbt.beehive, v -> {
            this.config.nbt.beehive = v;
        }), new BooleanOption("lectern", () -> this.config.nbt.lectern, v -> {
            this.config.nbt.lectern = v;
        }), new BooleanOption("jukebox", () -> this.config.nbt.jukebox, v -> {
            this.config.nbt.jukebox = v;
        }), new BooleanOption("sign", () -> this.config.nbt.sign, v -> {
            this.config.nbt.sign = v;
        }), new BooleanOption("beacon", () -> this.config.nbt.beacon, v -> {
            this.config.nbt.beacon = v;
        }), new BooleanOption("spawner", () -> this.config.nbt.spawner, v -> {
            this.config.nbt.spawner = v;
        }), new BooleanOption("container_items", () -> this.config.nbt.containerItems, v -> {
            this.config.nbt.containerItems = v;
        }));
    }

    private List<BooleanOption> patterns() {
        return List.of(new BooleanOption("hide_in_shield", () -> this.config.patterns.hideShieldPatterns, v -> {
            this.config.patterns.hideShieldPatterns = v;
        }), new BooleanOption("internal_names", () -> this.config.patterns.internalNames, v -> {
            this.config.patterns.internalNames = v;
        }));
    }

    public record BooleanOption(String key, BooleanSupplier getter, Consumer<Boolean> setter) {
    }
}

