/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.util.Draw;
import lordrius.essentialgui.util.TextUtils;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_10209;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1720;
import net.minecraft.class_1726;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2260;
import net.minecraft.class_2315;
import net.minecraft.class_2363;
import net.minecraft.class_2371;
import net.minecraft.class_2377;
import net.minecraft.class_2480;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3708;
import net.minecraft.class_3922;
import net.minecraft.class_4081;
import net.minecraft.class_4174;
import net.minecraft.class_4739;
import net.minecraft.class_5134;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7714;
import net.minecraft.class_8002;
import net.minecraft.class_9285;
import net.minecraft.class_9288;
import net.minecraft.class_9290;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import net.minecraft.class_9895;

public class DrawMixins {
    private static final ConfigData.VanillaHudChanges config = Data.cfg.vanilla;
    private static final class_310 client = class_310.method_1551();
    private static final class_327 textRenderer = DrawMixins.client.field_1772;
    public static int heldItemTooltipY;

    private static void drawFurnaceProgressBars(class_332 context, int x, int y, float cookProgress, float fuelProgress) {
        int cookProgressPercentage = Math.round(cookProgress * 100.0f);
        int fuelProgressPercentage = Math.round(fuelProgress * 100.0f);
        int cookValue = cookProgressPercentage * 96 / 100;
        int fuelValue = fuelProgressPercentage * 96 / 100;
        String cookText = cookProgressPercentage + "%";
        String fuelText = fuelProgressPercentage + "%";
        Draw.drawCustomRectangle(context, x - 3, y - 3, 97, 12);
        Draw.drawCustomRectangle(context, x - 3, y + 27, 97, 12);
        context.method_25294(x - 2, y - 2, x + cookValue - 2, y + 9, Draw.DARK_GREEN);
        context.method_25294(x - 2, y + 28, x + fuelValue - 2, y + 39, Draw.GOLD);
        context.method_25300(textRenderer, cookText, x + 45, y, -1);
        context.method_25300(textRenderer, fuelText, x + 45, y + 30, -1);
    }

    public static void drawFurnaceStats(class_332 context, class_1720 handler) {
        ConfigData.MiscFeatures config = Data.cfg.misc;
        class_9895 fuelRegistry = DrawMixins.client.field_1687.method_61269();
        boolean isBookOpen = DrawMixins.client.field_1724.method_3130().method_14887(handler.method_30264());
        int width = context.method_51421();
        int height = context.method_51443();
        class_1799 fuel = (class_1799)handler.method_7602().get(1);
        long fuelTime = fuelRegistry.method_61755(fuel);
        long fuelTimeValue = fuelTime * (long)fuel.method_7947();
        long operationsPerFuelValue = fuelTime * (long)fuel.method_7947() / 20L / 10L;
        String noFuel = TextUtils.translate("hud.furnace_stats.no_fuel").getString();
        String burningTime = fuel.method_7960() ? noFuel : Utils.ticksToHours(fuelTimeValue);
        String operationsPerFuel = fuel.method_7960() ? noFuel : String.format(Locale.GERMAN, "%,d", operationsPerFuelValue) + TextUtils.translate("hud.furnace_stats.items").getString();
        boolean isTextureDark = config.furnaceStats.texture.contains("dark");
        int x = isBookOpen ? width / 2 + 167 : width / 2 + 89;
        int y = height / 2 - 83;
        class_2960 BACKGROUND = class_2960.method_60654((String)"essentialgui:textures/gui/furnace.png");
        Draw.drawTextureSprite(context, BACKGROUND, x, y, isTextureDark ? 110.0f : 0.0f, 0.0f, 110, 166);
        context.method_51427(fuel, x + 10, y + 26);
        context.method_51431(textRenderer, fuel, x + 10, y + 26);
        if (handler.method_17365()) {
            if (Math.round(handler.method_17364() * 100.0f) >= 25) {
                Draw.drawTextureSprite(context, BACKGROUND, x + 14, y + 76, 0.0f, 166.0f, 80, 21);
            } else {
                Draw.drawTextureSprite(context, BACKGROUND, x + 14, y + 76, 0.0f, 187.0f, 80, 21);
            }
        } else {
            Draw.drawTextureSprite(context, BACKGROUND, x + 14, y + 76, 0.0f, 208.0f, 80, 21);
        }
        DrawMixins.drawFurnaceProgressBars(context, x + 9, y + 119, handler.method_17363(), handler.method_17364());
        context.method_27534(textRenderer, (class_2561)TextUtils.translate("hud.furnace_stats.fuel_stats"), x + 55, y + 8, -1);
        context.method_25300(textRenderer, burningTime, x + 69, y + 23, Draw.GREEN);
        context.method_25300(textRenderer, operationsPerFuel, x + 69, y + 37, Draw.GREEN);
        context.method_27534(textRenderer, (class_2561)TextUtils.translate("hud.furnace_stats.furnace_status"), x + 55, y + 62, -1);
        context.method_27534(textRenderer, (class_2561)TextUtils.translate("hud.furnace_stats.cooking_progress"), x + 55, y + 104, -1);
        context.method_27534(textRenderer, (class_2561)TextUtils.translate("hud.furnace_stats.fuel_level"), x + 55, y + 134, -1);
    }

    public static void drawBetterTooltip(class_332 context, class_1799 stack, int x, int y) {
        class_9290 loreComponent;
        class_9304 itemEnchantmentsComponent;
        ArrayList list = Lists.newArrayList();
        double attackValue = DrawMixins.client.field_1724.method_45326(class_5134.field_23721);
        double attackSpeedValue = DrawMixins.client.field_1724.method_45326(class_5134.field_23723);
        double armorValue = DrawMixins.client.field_1724.method_45326(class_5134.field_23724);
        double armorToughnessValue = DrawMixins.client.field_1724.method_45326(class_5134.field_23725);
        class_9285 attributeModifiersComponent = (class_9285)stack.method_58695(class_9334.field_49636, (Object)class_9285.field_49326);
        for (class_9285.class_9287 entry : attributeModifiersComponent.comp_2393()) {
            if (entry.comp_2395() == class_5134.field_23721) {
                attackValue += entry.comp_2396().comp_2449();
            }
            if (entry.comp_2395() == class_5134.field_23723) {
                attackSpeedValue += entry.comp_2396().comp_2449();
            }
            if (entry.comp_2395() == class_5134.field_23724) {
                armorValue += entry.comp_2396().comp_2449();
            }
            if (entry.comp_2395() != class_5134.field_23725) continue;
            armorToughnessValue += entry.comp_2396().comp_2449();
        }
        boolean isArmor = Utils.isArmor(stack) || Utils.isAnimalArmor(stack);
        boolean isTough = armorToughnessValue > 0.0;
        boolean attacks = attackValue > 1.0;
        boolean isDamageable = stack.method_7963();
        class_5250 prefix = class_2561.method_43470((String)"   \u00a77\u2192 ");
        class_5250 attack = class_2561.method_43470((String)("\u00a72" + attackValue));
        class_5250 speed = class_2561.method_43470((String)String.format(Locale.ROOT, "\u00a72%.1f", attackSpeedValue));
        class_5250 armor = class_2561.method_43470((String)("\u00a79+" + armorValue));
        class_5250 armorToughness = class_2561.method_43470((String)("\u00a79+" + armorToughnessValue));
        list.add(stack.method_63015());
        if (isArmor) {
            list.add(prefix.method_27661().method_10852((class_2561)armor));
            if (isTough) {
                list.add(prefix.method_27661().method_10852((class_2561)armorToughness));
            }
        }
        if (attacks) {
            list.add(prefix.method_27661().method_10852((class_2561)attack));
            list.add(prefix.method_27661().method_10852((class_2561)speed));
        }
        if (isDamageable) {
            list.add(prefix.method_27661().method_10852(Utils.getDurabilityTooltip(stack)));
        }
        if ((itemEnchantmentsComponent = (class_9304)stack.method_58695(class_9334.field_49633, (Object)class_9304.field_49385)).method_57541() > 0) {
            list.add(class_2561.method_43473());
            list.add(class_2561.method_43471((String)"hud.item_tooltip.enchantments").method_27692(class_124.field_1080));
            for (Object entry : itemEnchantmentsComponent.method_57534()) {
                class_5250 enchantment = class_1887.method_8179((class_6880)entry, (int)itemEnchantmentsComponent.method_57536((class_6880)entry)).method_27661();
                class_124 f = entry.method_40220(class_9636.field_51551) ? class_124.field_1061 : class_124.field_1062;
                enchantment.method_10862(enchantment.method_10866().method_27706(f));
                class_5250 name = class_5244.method_48320().method_10852((class_2561)enchantment.method_27692(f));
                list.add(name);
            }
        }
        if ((loreComponent = (class_9290)stack.method_58695(class_9334.field_49632, (Object)class_9290.field_49340)).comp_2401().size() > 0) {
            list.add(class_2561.method_43473());
            list.add(class_2561.method_43471((String)"hud.item_tooltip.lore").method_27692(class_124.field_1080));
            for (class_2561 t : loreComponent.comp_2401()) {
                list.add(class_5244.method_48320().method_10852(t));
            }
        }
        Draw.drawTooltip(context, list, x, y);
        int i = Utils.tooltipVector(list, x, y)[0];
        int j = Utils.tooltipVector(list, x, y)[1];
        if (isArmor) {
            Draw.drawTexture(context, Draw.ARMOR, i, j + 11, 9);
            if (isTough) {
                Draw.drawTexture(context, Draw.ARMOR_TOUGHNESS, i, j + 21, 9);
            }
        }
        if (attacks) {
            Draw.drawTexture(context, Draw.ATTACK, i, j + 11, 9);
            Draw.drawTexture(context, Draw.ATTACK_SPEED, i, j + 21, 9);
        }
        if (isDamageable) {
            int k = !isArmor && !attacks ? j + 11 : (!isArmor || isTough ? j + 31 : j + 21);
            Draw.drawTexture(context, Draw.DURABILITY, i, k, 9);
        }
    }

    public static void drawContainerTooltip(class_332 context, class_2248 block, class_1799 stack, int x, int y) {
        boolean hasCustomColor;
        int k;
        boolean container27;
        boolean container3 = block instanceof class_2363;
        boolean container4 = block instanceof class_3922;
        boolean container5 = block instanceof class_2377;
        boolean container5bs = block instanceof class_2260;
        boolean container6 = block instanceof class_7714;
        boolean container9 = block instanceof class_2315;
        boolean bl = container27 = block instanceof class_4739 || block instanceof class_3708 || block instanceof class_2480;
        int n = container27 ? 158 : (container9 || container6 ? 50 : (container5 ? 86 : (container5bs ? 124 : (k = container4 ? 32 : 88))));
        int n2 = container27 || container9 ? 50 : (container6 || container4 ? 32 : 14);
        int l = x + 12;
        int m = y - 12;
        boolean isShulkerBox = block instanceof class_2480;
        boolean bl2 = hasCustomColor = isShulkerBox && ((class_2480)block).method_10528() != null;
        int containerColor = isShulkerBox ? (hasCustomColor ? ((class_2480)block).method_10528().method_7787() : -6853993) : -1;
        int textureX = l - 2;
        int textureY = m + 13;
        if (container27) {
            class_2561 containerName = stack.method_63015();
            int nameWidth = textRenderer.method_27525((class_5348)containerName);
            int totalWidth = Math.max(k, nameWidth);
            int totalHeight = n2 + 12;
            textureY += 12;
            class_8002.method_47946((class_332)context, (int)l, (int)m, (int)totalWidth, (int)totalHeight, null);
            context.method_27535(textRenderer, containerName, l, m, -1);
        } else {
            class_8002.method_47946((class_332)context, (int)l, (int)m, (int)k, (int)n2, null);
        }
        if (container27) {
            Draw.drawTextureSpriteTinted(context, Draw.SHULKER_HUD, textureX, textureY - 15, 7.0f, 17.0f, 162, 54, containerColor);
        } else if (container9) {
            Draw.drawTextureSprite(context, Draw.SHULKER_HUD, textureX, textureY - 15, 7.0f, 17.0f, 54, 54);
        } else if (container5) {
            Draw.drawTextureSprite(context, Draw.SHULKER_HUD, textureX, textureY - 15, 7.0f, 17.0f, 90, 18);
        } else if (container4) {
            Draw.drawTextureSprite(context, Draw.SHULKER_HUD, textureX, textureY - 15, 7.0f, 17.0f, 36, 36);
        } else if (container6) {
            Draw.drawTextureSprite(context, Draw.SHULKER_HUD, textureX, textureY - 15, 7.0f, 17.0f, 54, 36);
        } else if (container3) {
            Draw.drawTextureSprite(context, Draw.SHULKER_HUD, textureX, textureY - 15, 0.0f, 81.0f, 101, 18);
        } else if (container5bs) {
            Draw.drawTextureSprite(context, Draw.SHULKER_HUD, textureX, textureY - 15, 0.0f, 99.0f, 128, 18);
        }
        DrawMixins.drawContainerInventory(context, block, stack, textureX - 13, textureY - 28);
    }

    public static void drawContainerInventory(class_332 context, class_2248 block, class_1799 stack, int x, int y) {
        boolean container27;
        class_9288 container = (class_9288)stack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        boolean container3 = block instanceof class_2363;
        boolean container4 = block instanceof class_3922;
        boolean container5 = block instanceof class_2377;
        boolean container5bs = block instanceof class_2260;
        boolean container6 = block instanceof class_7714;
        boolean container9 = block instanceof class_2315;
        boolean bl = container27 = block instanceof class_4739 || block instanceof class_3708 || block instanceof class_2480;
        int size = container27 ? 27 : (container9 ? 9 : (container6 ? 6 : (container5 || container5bs ? 5 : (container4 ? 4 : 3))));
        class_2371 defaultedList = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        container.method_57492(defaultedList);
        int slotSize = 18;
        int offset = 14;
        int cols = size;
        if (container27) {
            cols = 9;
        } else if (container9 || container6) {
            cols = 3;
        } else if (container5 || container5bs) {
            cols = 5;
        } else if (container4) {
            cols = 2;
        }
        if (container3) {
            Draw.drawItem(context, (class_1799)defaultedList.get(1), x + 14, y + 14);
            Draw.drawItem(context, (class_1799)defaultedList.get(0), x + 51, y + 14);
            Draw.drawItem(context, (class_1799)defaultedList.get(2), x + 88, y + 14);
        } else if (container5bs) {
            Draw.drawItem(context, (class_1799)defaultedList.get(4), x + 14, y + 14);
            Draw.drawItem(context, (class_1799)defaultedList.get(3), x + 51, y + 14);
            for (int i = 0; i < 3; ++i) {
                Draw.drawItem(context, (class_1799)defaultedList.get(i), x + slotSize * i + 87, y + 14);
            }
        } else {
            for (int i = 0; i < size; ++i) {
                int row = i / cols;
                int col = i % cols;
                int xPos = x + slotSize * col + offset;
                int yPos = y + slotSize * row + offset;
                Draw.drawItem(context, (class_1799)defaultedList.get(i), xPos, yPos);
            }
        }
    }

    public static void drawSimpleFoodTooltip(class_332 context, class_1799 stack, int x, int y) {
        class_4174 food = (class_4174)stack.method_58694(class_9334.field_50075);
        int hungerValue = food.comp_2491();
        class_2561 hunger = class_2561.method_30163((String)(" \u00a77(\u00a7a" + hungerValue + "\u00a77)"));
        int hWidth = textRenderer.method_27525((class_5348)hunger);
        int sizeX = (hungerValue > 0 && hungerValue <= 2 ? 32 : (hungerValue > 2 && hungerValue <= 4 ? 40 : (hungerValue > 4 && hungerValue <= 6 ? 48 : (hungerValue > 6 && hungerValue <= 8 ? 56 : 64)))) + hWidth;
        Objects.requireNonNull(textRenderer);
        int sizeY = 9 + 10;
        int xPos = x + 12;
        int yPos = y - 12;
        int iconsX = xPos;
        int iconsY = yPos + 10;
        class_2561 name = stack.method_63015();
        int nameWidth = textRenderer.method_27525((class_5348)name);
        if (nameWidth > sizeX) {
            sizeX = nameWidth;
        }
        class_8002.method_47946((class_332)context, (int)xPos, (int)yPos, (int)sizeX, (int)sizeY, null);
        context.method_27535(textRenderer, name, xPos, yPos, -1);
        Draw.drawTexture(context, Draw.HUNGER_FULL, iconsX, iconsY, 9);
        context.method_27535(textRenderer, class_2561.method_30163((String)" \u00a77\u2192 "), iconsX + 9, iconsY + 1, -1);
        context.method_27535(textRenderer, hunger, iconsX + sizeX - hWidth, iconsY + 1, -1);
        for (int i = 0; i < hungerValue; ++i) {
            if (i * 2 + 1 < hungerValue) {
                Draw.drawTexture(context, Draw.HUNGER_FULL, iconsX + i * 8 + 23, iconsY, 9);
            }
            if (i * 2 + 1 != hungerValue) continue;
            Draw.drawTexture(context, Draw.HUNGER_HALF, iconsX + i * 8 + 23, iconsY, 9);
        }
    }

    public static void drawItemComparisonTooltip(class_332 context, class_1799 hoverStack, int x, int y) {
        class_1799 equippedStack = Utils.getPlayerEquippedStackForComparison(hoverStack, (class_1657)DrawMixins.client.field_1724);
        List listEquipped = equippedStack.method_7950(class_1792.class_9635.method_59528((class_1937)DrawMixins.client.field_1687), (class_1657)DrawMixins.client.field_1724, (class_1836)(DrawMixins.client.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070));
        int xPos = x - TextUtils.tooltipWidth(listEquipped) - 20;
        if (Data.cfg.tooltips.damageables.betterTooltip) {
            DrawMixins.drawBetterTooltip(context, equippedStack, xPos, y);
        } else {
            Draw.drawTooltip(context, listEquipped, xPos, y);
        }
    }

    public static void drawOverlayMessage(class_332 context, class_2561 overlayMessage, class_9779 tickCounter, boolean overlayTinted) {
        int overlayRemaining = Utils.getOverlayRemaining();
        if (overlayMessage != null && overlayRemaining > 0) {
            class_10209.method_64146().method_15396("overlayMessage");
            float f = (float)overlayRemaining - tickCounter.method_60637(false);
            int i = (int)(f * 255.0f / 20.0f);
            if (i > 255) {
                i = 255;
            }
            if (i > 8) {
                boolean rounded = DrawMixins.config.overlayMessageStyle.contains("rounded");
                int x = context.method_51421() / 2;
                int y = context.method_51443() - 80;
                int j = overlayTinted ? class_3532.method_60599((float)(f / 50.0f), (float)0.7f, (float)0.6f, (int)i) : class_9848.method_61330((int)i, (int)-1);
                if (rounded) {
                    Draw.drawCenteredTextWithBackgroundRoundedF(context, x, y, overlayMessage, j);
                } else {
                    Draw.drawCenteredTextWithBackgroundF(context, x, y, overlayMessage, j);
                }
            }
            class_10209.method_64146().method_15407();
        }
    }

    public static void drawHeldItemTooltip(class_332 context, class_1799 stack) {
        class_10209.method_64146().method_15396("selectedItemName");
        int tooltipFade = Utils.getHeldItemTooltipFade();
        if (!stack.method_7960() && tooltipFade > 0) {
            String style = DrawMixins.config.heldItemTooltipStyle;
            boolean rounded = style.contains("rounded");
            boolean statusBars = DrawMixins.client.field_1761.method_2908();
            boolean absortion = statusBars && DrawMixins.client.field_1724.method_6067() > 0.0f;
            class_2561 name = stack.method_63015();
            int i = textRenderer.method_27525((class_5348)name);
            int j = (context.method_51421() - i) / 2;
            int k = context.method_51443() - 64;
            if (!statusBars) {
                k += 19;
            }
            if (absortion) {
                k -= 8;
            }
            heldItemTooltipY = k;
            int fadeTransition = Utils.getTooltipFadeTransition();
            if (Utils.getTooltipFade() > 0) {
                int backgroundColor = Utils.getBackgroundOpacity();
                int borderColor = new Color(0, 0, 0, 200).getRGB();
                if (rounded) {
                    Draw.drawCenteredTextWithBackgroundRounded(context, j, k, name, false, borderColor, backgroundColor, fadeTransition);
                } else {
                    Draw.drawCenteredTextWithBackground(context, j, k, name, false, borderColor, backgroundColor, fadeTransition);
                }
            }
        }
        class_10209.method_64146().method_15407();
    }

    public static void drawCrosshair(class_332 context) {
        int size = DrawMixins.config.crosshair.size;
        int x = (context.method_51421() - size) / 2;
        int y = (context.method_51443() - size) / 2;
        DrawMixins.drawCrosshairRaw(context, x, y);
    }

    public static void drawCrosshairRaw(class_332 context, int x, int y) {
        Color outlineColor;
        Color color;
        if (!DrawMixins.config.crosshair.show) {
            return;
        }
        class_2960 CROSSHAIR_TEXTURE = class_2960.method_60656((String)"hud/crosshair");
        class_746 player = DrawMixins.client.field_1724;
        boolean lowHealth = DrawMixins.config.crosshair.lowHealth && player != null && class_3532.method_15386((float)player.method_6032()) <= 10;
        int size = DrawMixins.config.crosshair.size;
        Color color2 = color = lowHealth ? Utils.hexToColor(DrawMixins.config.crosshair.lowHealthColor) : Utils.hexToColor(DrawMixins.config.crosshair.color);
        if (color == null) {
            color = new Color(0, 0, 0);
        }
        if ((outlineColor = Utils.hexToColor(DrawMixins.config.crosshair.outlineColor)) == null) {
            outlineColor = new Color(0, 0, 0);
        }
        if (DrawMixins.config.crosshair.outline) {
            context.method_52707(class_10799.field_56883, CROSSHAIR_TEXTURE, x - 1, y, size, size, outlineColor.getRGB());
            context.method_52707(class_10799.field_56883, CROSSHAIR_TEXTURE, x + 1, y, size, size, outlineColor.getRGB());
            context.method_52707(class_10799.field_56883, CROSSHAIR_TEXTURE, x, y - 1, size, size, outlineColor.getRGB());
            context.method_52707(class_10799.field_56883, CROSSHAIR_TEXTURE, x, y + 1, size, size, outlineColor.getRGB());
            context.method_52707(class_10799.field_56883, CROSSHAIR_TEXTURE, x - 1, y - 1, size, size, outlineColor.getRGB());
            context.method_52707(class_10799.field_56883, CROSSHAIR_TEXTURE, x + 1, y - 1, size, size, outlineColor.getRGB());
            context.method_52707(class_10799.field_56883, CROSSHAIR_TEXTURE, x - 1, y + 1, size, size, outlineColor.getRGB());
            context.method_52707(class_10799.field_56883, CROSSHAIR_TEXTURE, x + 1, y + 1, size, size, outlineColor.getRGB());
        }
        context.method_52707(class_10799.field_56883, CROSSHAIR_TEXTURE, x, y, size, size, color.getRGB());
    }

    public static void drawStatusEffectsOverlay(class_332 context) {
        Collection effects = DrawMixins.client.field_1724.method_6026();
        if (effects.isEmpty()) {
            return;
        }
        boolean showDuration = DrawMixins.config.effects.duration;
        int iconWidth = 26;
        int iconHeight = showDuration ? 41 : 25;
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        int baseX = Utils.resolveRenderCoord(DrawMixins.config.effects.x, screenWidth - 25, screenWidth);
        int baseY = Utils.resolveRenderCoord(DrawMixins.config.effects.y, 2, screenHeight);
        if (client.method_1530()) {
            baseY += 15;
        }
        boolean toLeft = baseX > screenWidth / 2;
        boolean drawBelow = baseY < screenHeight / 2;
        int beneficialCount = 0;
        for (class_1293 e : effects) {
            if (!e.method_5592() || !((class_1291)e.method_5579().comp_349()).method_5573()) continue;
            ++beneficialCount;
        }
        int i = 0;
        int j = 0;
        for (class_1293 effectInstance : Ordering.natural().reverse().sortedCopy((Iterable)effects)) {
            int durationY;
            int level;
            class_1291 effect = (class_1291)effectInstance.method_5579().comp_349();
            if (!effectInstance.method_5592()) continue;
            boolean isAmbient = effectInstance.method_5591();
            boolean isBeneficial = effect.method_5573();
            boolean isNeutral = effect.method_18792() == class_4081.field_18273;
            boolean isVanilla = DrawMixins.config.effects.texture.contains("vanilla");
            int index = isBeneficial ? ++i : ++j;
            int x = baseX + (toLeft ? -iconWidth * (index - 1) : iconWidth * (index - 1));
            int y = baseY;
            if (!isBeneficial && beneficialCount > 0) {
                y += drawBelow ? iconHeight : -iconHeight;
            }
            float f = 1.0f;
            if (!isAmbient && effectInstance.method_48557(100)) {
                int m = effectInstance.method_5584();
                int n = 10 - m / 20;
                f = class_3532.method_15363((float)((float)m / 50.0f), (float)0.0f, (float)0.5f) + class_3532.method_15362((float)((float)m * (float)Math.PI / 5.0f)) * class_3532.method_15363((float)((float)n / 10.0f * 0.25f), (float)0.0f, (float)0.25f);
                f = class_3532.method_15363((float)f, (float)0.0f, (float)1.0f);
            }
            int spriteX = isAmbient ? (isVanilla ? 48 : 123) : (isNeutral ? (isVanilla ? 23 : 148) : (isVanilla ? 23 : (isBeneficial ? 98 : 73)));
            Draw.drawTextureSprite(context, Draw.WIDGETS, x, y, spriteX, 0.0f, 25, 24);
            context.method_52707(class_10799.field_56883, class_329.method_71644((class_6880)effectInstance.method_5579()), x + 3, y + 3, 18, 18, class_9848.method_61317((float)f));
            if (DrawMixins.config.effects.amplifier && (level = effectInstance.method_5578() + 1) > 1 && level < 11) {
                String text = (DrawMixins.config.effects.durationColored ? "\u00a7e" : "\u00a77") + class_1074.method_4662((String)("enchantment.level." + level), (Object[])new Object[0]);
                int textWidth = textRenderer.method_1727(text);
                context.method_25303(textRenderer, text, x + 24 - textWidth, y + 1, -1);
            }
            if (!showDuration) continue;
            String duration = effectInstance.method_48559() ? "\u221e" : Utils.ticksToMinutes(effectInstance.method_5584());
            int textureY = drawBelow ? y + 25 : y - 16;
            int n = durationY = drawBelow ? y + 29 : y - 12;
            int color = DrawMixins.config.effects.durationColored ? (isBeneficial ? (isAmbient ? Draw.DARK_AQUA : Draw.DARK_GREEN) : (isNeutral ? Draw.GOLD : Draw.RED)) : Draw.GRAY;
            Draw.drawTextureSprite(context, Draw.WIDGETS, x, textureY, spriteX, 25.0f, 25, 15);
            context.method_25300(textRenderer, duration, x + 13, durationY, color);
        }
    }

    public static void drawLoomSelectedPatternText(class_332 context) {
        ConfigData.AdvancedItemTooltips.EnhancedPatterns config = Data.cfg.tooltips.patterns;
        class_1726 handler = (class_1726)DrawMixins.client.field_1724.field_7512;
        int x = client.method_22683().method_4486() / 2;
        int y = client.method_22683().method_4502() / 2 - 99;
        if (handler.method_43706().isEmpty() || handler.method_7647() == -1) {
            return;
        }
        int patternId = handler.method_7647();
        String pattern = ((class_5321)((class_6880)handler.method_43706().get(patternId)).method_40229().left().get()).method_29177().method_43903();
        String color = ((class_1769)handler.method_17429().method_7677().method_7909()).method_7802().method_7792();
        class_5250 titlePattern = config.internalNames ? class_2561.method_43470((String)TextUtils.capTitle(pattern.replace("_", " "))) : class_2561.method_43471((String)("block.minecraft.banner." + pattern + "." + color));
        class_5250 text = class_2561.method_43471((String)"hud.loom_pattern.pattern").method_10852((class_2561)titlePattern);
        Draw.drawCenteredTextWithBackground(context, x, y, (class_2561)text);
    }
}

