/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.util;

import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lordrius.essentialgui.gui.widgets.ButtonWidgetRegular;
import lordrius.essentialgui.gui.widgets.ButtonWidgetSmall;
import lordrius.essentialgui.gui.widgets.ButtonWidgetToggle;
import lordrius.essentialgui.gui.widgets.TextWidget;
import lordrius.essentialgui.util.TextUtils;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;

public class ScreenUtils {
    private static final class_310 client = class_310.method_1551();

    public static ButtonWidgetSmall colorPickerButton(int x, int y) {
        class_5250 text = TextUtils.translate("screen.options.settings.color_picker");
        String URL2 = TextUtils.translate("screen.options.settings.color_picker.url").getString();
        return ScreenUtils.customizeButton(x, y, (class_2561)text, btn -> class_156.method_668().method_670(URL2));
    }

    public static ButtonWidgetSmall customizeButton(int x, int y, Runnable runnable) {
        class_5250 text = TextUtils.translate("screen.options.settings.customize.tooltip");
        return ScreenUtils.customizeButton(x, y, (class_2561)text, btn -> runnable.run());
    }

    public static ButtonWidgetSmall customizeButton(int x, int y, class_2561 text, class_4185.class_4241 onPress) {
        class_2960 texture = class_2960.method_60654((String)"essentialgui:textures/gui/buttons/color_picker.png");
        return new ButtonWidgetSmall(x, y, texture, text, onPress);
    }

    public static class_4185 doneButton(Runnable runnable) {
        int x = client.method_22683().method_4486() / 2 - 100;
        int y = client.method_22683().method_4502() - 25;
        return new ButtonWidgetRegular(x, y, 200, 20, (class_2561)TextUtils.translate("gui.done"), btn -> runnable.run());
    }

    public static TextWidget field(int x, int y, class_2561 label, class_2561 tooltip, String initialText, Consumer<String> onChange) {
        TextWidget widget = new TextWidget(x, y, label, tooltip);
        widget.method_1852(initialText);
        widget.method_1863(f -> onChange.accept((String)f));
        return widget;
    }

    public static TextWidget fieldColor(int x, int y, class_2561 label, class_2561 tooltip, boolean showColor, boolean colorToLeft, String initialText, Consumer<String> onChange) {
        TextWidget widget = new TextWidget(x, y, label, tooltip, showColor, colorToLeft);
        widget.method_1852(initialText);
        widget.method_1863(f -> {
            String raw = f.trim();
            String value = "#" + raw.replace("#", "");
            if (!value.equals(widget.method_1882())) {
                widget.method_1852(value);
            }
            if (Utils.hexToColor(value) != null) {
                widget.method_1868(-1);
                onChange.accept(value);
            } else {
                widget.method_1868(-65536);
            }
        });
        return widget;
    }

    public static TextWidget fieldNumeric(int x, int y, class_2561 label, class_2561 tooltip, int initialValue, Consumer<Integer> onChange) {
        TextWidget widget = new TextWidget(x, y, label, tooltip);
        widget.method_1852(Integer.toString(initialValue));
        widget.method_1863(input -> {
            try {
                int value = Integer.parseInt(input.trim());
                widget.method_1868(-1);
                onChange.accept(value);
            }
            catch (NumberFormatException ignored) {
                widget.method_1868(-65536);
            }
        });
        return widget;
    }

    public static TextWidget fieldFloat(int x, int y, class_2561 label, class_2561 tooltip, float initialValue, Consumer<Float> onChange) {
        TextWidget widget = new TextWidget(x, y, label, tooltip);
        widget.method_1852(Float.toString(initialValue));
        widget.method_1863(input -> {
            try {
                float value = Float.parseFloat(input.trim());
                if (value < 0.0f || value > 1.0f) {
                    widget.method_1868(-65536);
                    return;
                }
                widget.method_1868(-1);
                onChange.accept(Float.valueOf(value));
            }
            catch (NumberFormatException ignored) {
                widget.method_1868(-65536);
            }
        });
        return widget;
    }

    public static ButtonWidgetSmall genericStyleButton(int x, int y, Supplier<class_2561> style, class_4185.class_4241 onPress) {
        return new ButtonWidgetSmall(x, y, new class_1799((class_1935)class_1802.field_8498), style.get(), btn -> {
            onPress.onPress(btn);
            btn.method_47400(class_7919.method_47407((class_2561)((class_2561)style.get())));
        });
    }

    public static ButtonWidgetSmall hudStyleButton(int x, int y, Supplier<class_2561> style, class_4185.class_4241 onPress) {
        return new ButtonWidgetSmall(x, y, new class_1799((class_1935)class_1802.field_8573), (class_2561)class_2561.method_43471((String)"screen.hud_style").method_10852(style.get()), btn -> {
            onPress.onPress(btn);
            class_5250 updatedTooltip = TextUtils.translate("screen.hud_style").method_10852((class_2561)style.get());
            btn.method_47400(class_7919.method_47407((class_2561)updatedTooltip));
        });
    }

    public static ButtonWidgetRegular jumpButton(int x, int y, class_2561 label, Runnable runnable) {
        return new ButtonWidgetRegular(x, y, label, btn -> runnable.run());
    }

    public static ButtonWidgetRegular jumpButtonBig(int x, int y, class_2561 label, Runnable runnable) {
        return new ButtonWidgetRegular(x, y, 200, 20, label, btn -> runnable.run());
    }

    public static ButtonWidgetSmall jumpButtonItem(int x, int y, class_1792 item, class_2561 tooltip, BooleanSupplier stateGetter, Runnable runnable) {
        class_5250 label = tooltip.method_27661().method_27692(class_124.field_1054);
        ButtonWidgetSmall button = new ButtonWidgetSmall(x, y, item.method_7854(), (class_2561)label, btn -> runnable.run());
        button.field_22763 = stateGetter.getAsBoolean();
        return button;
    }

    public static ButtonWidgetSmall optionsButton(int x, int y, class_2561 tooltip, Runnable runnable) {
        class_2960 texture = class_2960.method_60654((String)"essentialgui:textures/gui/buttons/options.png");
        return ScreenUtils.texturedButton(x, y, texture, tooltip, runnable);
    }

    public static ButtonWidgetRegular sectionButton(int x, int y, class_1792 item, class_2561 label, boolean itemToRight, Runnable runnable) {
        return new ButtonWidgetRegular(x, y, new class_1799((class_1935)item), label, itemToRight, btn -> runnable.run());
    }

    public static ButtonWidgetToggle switchButton(int x, int y, BooleanSupplier stateGetter, Consumer<Boolean> stateSetter) {
        return ScreenUtils.switchButton(x, y, stateGetter, stateSetter, btn -> {});
    }

    public static ButtonWidgetToggle switchButton(int x, int y, BooleanSupplier stateGetter, Consumer<Boolean> stateSetter, class_4185.class_4241 onPress) {
        return new ButtonWidgetToggle(x, y, stateGetter.getAsBoolean(), btn -> {
            onPress.onPress(btn);
            boolean newState = !stateGetter.getAsBoolean();
            stateSetter.accept(newState);
            ((ButtonWidgetToggle)btn).updateState(newState);
        });
    }

    public static ButtonWidgetToggle switchButton(int x, int y, class_2960 texture, Supplier<class_2561> tooltip, BooleanSupplier stateGetter, Consumer<Boolean> stateSetter) {
        return ScreenUtils.switchButton(x, y, texture, tooltip, stateGetter, stateSetter, () -> {});
    }

    public static ButtonWidgetToggle switchButton(int x, int y, class_2960 texture, Supplier<class_2561> tooltip, BooleanSupplier stateGetter, Consumer<Boolean> stateSetter, Runnable runnable) {
        return new ButtonWidgetToggle(x, y, texture, stateGetter.getAsBoolean(), tooltip.get(), btn -> {
            boolean newState = !stateGetter.getAsBoolean();
            stateSetter.accept(newState);
            class_2561 updatedTooltip = (class_2561)tooltip.get();
            btn.method_47400(class_7919.method_47407((class_2561)updatedTooltip));
            ((ButtonWidgetToggle)btn).updateState(newState);
            runnable.run();
        });
    }

    public static ButtonWidgetSmall texturedButton(int x, int y, class_2960 texture, class_2561 tooltip, Runnable runnable) {
        return new ButtonWidgetSmall(x, y, texture, tooltip, btn -> runnable.run());
    }

    public static ButtonWidgetSmall textureTypeButton(int x, int y, Supplier<class_2561> style, class_4185.class_4241 onPress) {
        return new ButtonWidgetSmall(x, y, new class_1799((class_1935)class_1802.field_42716), (class_2561)TextUtils.translate("screen.hud_texture_type").method_10852(style.get()), btn -> {
            onPress.onPress(btn);
            class_5250 updatedTooltip = TextUtils.translate("screen.hud_texture_type").method_10852((class_2561)style.get());
            btn.method_47400(class_7919.method_47407((class_2561)updatedTooltip));
        });
    }

    public static ButtonWidgetRegular toggleButton(int x, int y, Supplier<class_2561> label, class_2561 tooltip, BooleanSupplier stateGetter, Consumer<Boolean> stateSetter) {
        return new ButtonWidgetRegular(x, y, label.get(), tooltip, btn -> {
            boolean newState = !stateGetter.getAsBoolean();
            stateSetter.accept(newState);
            btn.method_25355((class_2561)label.get());
        });
    }

    public static ButtonWidgetRegular toggleButtonBig(int x, int y, Supplier<class_2561> label, BooleanSupplier stateGetter, Consumer<Boolean> stateSetter) {
        return new ButtonWidgetRegular(x, y, 200, 20, label.get(), btn -> {
            boolean newState = !stateGetter.getAsBoolean();
            stateSetter.accept(newState);
            btn.method_25355((class_2561)label.get());
        });
    }

    public static ButtonWidgetRegular toggleStringButton(int x, int y, Supplier<class_2561> label, class_4185.class_4241 onPress) {
        return new ButtonWidgetRegular(x, y, label.get(), btn -> {
            onPress.onPress(btn);
            btn.method_25355((class_2561)label.get());
        });
    }

    public static ButtonWidgetRegular toggleStringButton(Supplier<class_2561> label, class_4185.class_4241 onPress) {
        return new ButtonWidgetRegular(0, 0, 70, 20, label.get(), btn -> {
            onPress.onPress(btn);
            btn.method_25355((class_2561)label.get());
        });
    }

    public static boolean isMouseOverTextLabel(class_327 font, class_2561 label, int x, int y, int mouseX, int mouseY) {
        int textWidth = font.method_27525((class_5348)label);
        int textHeight = 17;
        return mouseX >= x && mouseX <= x + textWidth && mouseY >= y && mouseY <= y + textHeight;
    }

    public static boolean isMouseOverCategoryLabel(class_327 font, class_2561 text, int centerX, int y, int mouseX, int mouseY) {
        int textWidth = font.method_27525((class_5348)text);
        int textHeight = 18;
        int textX = centerX - textWidth / 2;
        return mouseX >= textX && mouseX <= textX + textWidth && mouseY >= y && mouseY <= y + textHeight;
    }
}

