/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.util.Utils;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;

public class TextUtils {
    private static final ConfigData.Settings config = Data.cfg.settings;

    public static class_5250 write(String key) {
        return class_2561.method_43470((String)key);
    }

    public static class_5250 write(String key, int rgb) {
        return TextUtils.write(key).method_27694(style -> style.method_36139(rgb));
    }

    public static class_5250 write(String key, class_124 format) {
        return TextUtils.write(key).method_27692(format);
    }

    public static class_5250 translate(String key) {
        return class_2561.method_43471((String)key);
    }

    public static class_5250 translate(String key, int rgb) {
        return TextUtils.translate(key).method_27694(style -> style.method_36139(rgb));
    }

    public static class_5250 translate(String key, class_124 format) {
        return TextUtils.translate(key).method_27692(format);
    }

    public static class_5250 translate(String key, Object ... args) {
        return class_2561.method_43469((String)key, (Object[])args);
    }

    public static class_5250 transClientProp(String key) {
        return TextUtils.translate("hud.client-player-world." + key);
    }

    public static class_5250 transBlockProp(String key) {
        return TextUtils.translate("hud.block.properties." + key);
    }

    public static class_5250 transEntityProp(String key) {
        return TextUtils.translate("hud.entity.properties." + key);
    }

    public static class_5250 shifted(String str) {
        return TextUtils.shifted((class_2561)class_2561.method_43470((String)str));
    }

    public static class_5250 shifted(class_2561 value) {
        return class_5244.method_48320().method_10852(value);
    }

    public static List<class_2561> shiftedEntityProperty(String key, class_2561 value) {
        ArrayList list = Lists.newArrayList();
        class_5250 text = TextUtils.entityLine(key, value);
        int width = TextUtils.width(text);
        if (width > TextUtils.tooltipSize()) {
            list.add(TextUtils.entityLine(key, (class_2561)TextUtils.empty()));
            list.add(TextUtils.shifted(value).method_27692(class_124.field_1080));
        } else {
            list.add(text);
        }
        return list;
    }

    public static List<class_2561> shiftedTooltip(String key, class_2561 value, List<class_2561> lines) {
        return TextUtils.shiftedTooltip(key, value, lines, false);
    }

    public static List<class_2561> shiftedTooltip(String key, class_2561 value, List<class_2561> lines, boolean whiteLine) {
        ArrayList list = Lists.newArrayList();
        class_5250 combined = TextUtils.tooltipLine(key, value);
        int combinedColor = combined.method_10866().method_10973().method_27716();
        int combinedWidth = TextUtils.width(combined);
        int tooltipMaxWidth = TextUtils.tooltipWidth(lines);
        if (whiteLine) {
            list.add(class_2561.method_43473());
        }
        if (combinedWidth > tooltipMaxWidth) {
            list.add(TextUtils.translate(key).method_54663(combinedColor));
            list.add(TextUtils.shifted(value));
        } else {
            list.add(combined);
        }
        return list;
    }

    public static class_5250 itemTooltipLine(String key, class_2561 value) {
        return TextUtils.tooltipLine("hud.item_tooltip." + key, value);
    }

    public static class_5250 tooltipLine(String key, class_2561 value) {
        return TextUtils.coloredLine(key, value, TextUtils.config.itemTooltipsTagColor);
    }

    public static class_5250 tooltipLine(class_2561 value) {
        return value.method_27661().method_27694(style -> style.method_36139(TextUtils.tooltipTagColor()));
    }

    public static class_5250 blockLine(String key, String value) {
        return TextUtils.blockLine(key, (class_2561)TextUtils.write(value));
    }

    public static class_5250 blockLine(String key, class_2561 value) {
        return TextUtils.coloredLine("hud.block.properties." + key, value, TextUtils.config.blockPropertiesTagColor);
    }

    public static class_5250 entityLine(String key, String value) {
        return TextUtils.entityLine(key, (class_2561)TextUtils.write(value));
    }

    public static class_5250 entityLine(String key, class_2561 value) {
        return TextUtils.coloredLine("hud.entity.properties." + key, value, TextUtils.config.entityPropertiesTagColor);
    }

    public static class_5250 coloredLine(String key, class_2561 value, String configColor) {
        int tagColor = Utils.getColor(configColor);
        class_5251 textColor = value.method_10866().method_10973();
        if (textColor == null || textColor.method_27721().equalsIgnoreCase("#FFFFFF")) {
            textColor = class_5251.method_27718((class_124)class_124.field_1080);
        }
        return TextUtils.translate(key, tagColor).method_10852((class_2561)value.method_27661().method_54663(textColor.method_27716()));
    }

    public static class_5250 empty() {
        return class_2561.method_43473();
    }

    public static class_5250 dash() {
        return TextUtils.write("-", class_124.field_1080);
    }

    public static class_5250 separator() {
        return TextUtils.write(Data.cfg.settings.separator);
    }

    public static String str(Object o) {
        return String.valueOf(o);
    }

    public static class_5250 trueText() {
        return TextUtils.translate("hud.enabled.true", class_124.field_1080);
    }

    public static class_5250 falseText() {
        return TextUtils.translate("hud.enabled.false", class_124.field_1080);
    }

    public static class_5250 trueFalse(boolean condition) {
        return TextUtils.translate(condition ? "hud.enabled.true" : "hud.enabled.false").method_27692(class_124.field_1080);
    }

    public static class_5250 trueFalse(boolean condition, boolean inverted) {
        boolean result = inverted ? !condition : condition;
        class_124 f = result ? class_124.field_1060 : class_124.field_1061;
        return TextUtils.translate(condition ? "hud.enabled.true" : "hud.enabled.false").method_27692(f);
    }

    public static int width(Object ... components) {
        class_5250 combined = class_2561.method_43473();
        for (Object obj : components) {
            if (obj instanceof class_2561) {
                class_2561 text = (class_2561)obj;
                combined = combined.method_27661().method_10852(text);
                continue;
            }
            if (obj instanceof String) {
                String str = (String)obj;
                combined = combined.method_27661().method_10852((class_2561)class_2561.method_43470((String)str));
                continue;
            }
            throw new IllegalArgumentException("Only String or Text are allowed: " + String.valueOf(obj));
        }
        return TextUtils.font().method_27525((class_5348)combined);
    }

    public static int tooltipWidth(List<class_2561> lines) {
        return lines.stream().mapToInt(t -> TextUtils.font().method_27525((class_5348)t)).max().orElse(0);
    }

    public static String capTitle(String str) {
        CharSequence[] words = str.split(" ");
        for (int i = 0; i < words.length; ++i) {
            if (words[i].isEmpty()) continue;
            words[i] = TextUtils.capStr((String)words[i]);
        }
        return String.join((CharSequence)" ", words);
    }

    public static String capStr(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static class_327 font() {
        return class_310.method_1551().field_1772;
    }

    private static int tooltipSize() {
        return 90;
    }

    public static int tooltipTagColor() {
        return Utils.getColor(TextUtils.config.itemTooltipsTagColor);
    }
}

