/*
 * Decompiled with CFR 0.152.
 */
package lordrius.essentialgui.util;

import java.awt.Color;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import lordrius.essentialgui.config.ConfigData;
import lordrius.essentialgui.config.Data;
import lordrius.essentialgui.gui.hud.PlayerEquipment;
import lordrius.essentialgui.gui.hud.PointedBlock;
import lordrius.essentialgui.gui.hud.PointedEntity;
import lordrius.essentialgui.mixin.AccessorBossBarHud;
import lordrius.essentialgui.mixin.AccessorInGameHud;
import lordrius.essentialgui.util.DrawMixins;
import lordrius.essentialgui.util.TextUtils;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1786;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_4081;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5684;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8000;
import net.minecraft.class_8001;
import net.minecraft.class_9288;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import net.minecraft.class_9895;
import org.joml.Vector2ic;

public class Utils {
    private static final class_310 client = class_310.method_1551();

    public static long timeOfDay() {
        return Utils.client.field_1687.method_8532() % 24000L;
    }

    public static long worldDays() {
        return Utils.client.field_1687.method_8532() / 24000L;
    }

    public static String timeString(String format) {
        String suffix;
        String prefix;
        int hour;
        long timeOfDay = Utils.timeOfDay();
        boolean twelveHour = format.contains("12_hour");
        boolean showHour = format.contains("hour");
        int hour24 = (int)((timeOfDay / 1000L + 6L) % 24L);
        int n = hour = twelveHour ? hour24 % 12 : hour24;
        if (twelveHour && hour == 0) {
            hour = 12;
        }
        int minutes = (int)((float)timeOfDay / 16.666666f % 60.0f);
        String string = Data.cfg.client.colored ? (Utils.isSunrise() ? "\u00a77" : (Utils.isMorning() ? "\u00a73" : (Utils.isDay() ? "\u00a7b" : (Utils.isNoon() ? "\u00a7e" : (Utils.isSunset() ? "\u00a76" : "\u00a78"))))) : (prefix = "\u00a77");
        String string2 = twelveHour ? (hour24 >= 12 ? " PM" : " AM") : (suffix = "");
        if (showHour) {
            String pattern = twelveHour ? "%s%d:%02d%s" : "%s%02d:%02d%s";
            return pattern.formatted(prefix, hour, minutes, suffix);
        }
        return "%s%d".formatted(prefix, timeOfDay);
    }

    public static String worldDaysString() {
        return "\u00a7r%,d".formatted(Utils.worldDays());
    }

    public static boolean isSunrise() {
        return Utils.timeOfDay() >= 23000L && Utils.timeOfDay() < 24000L;
    }

    public static boolean isMorning() {
        return Utils.timeOfDay() >= 0L && Utils.timeOfDay() < 2000L;
    }

    public static boolean isDay() {
        return Utils.timeOfDay() >= 2000L && Utils.timeOfDay() < 6000L;
    }

    public static boolean isNoon() {
        return Utils.timeOfDay() >= 6000L && Utils.timeOfDay() < 12000L;
    }

    public static boolean isSunset() {
        return Utils.timeOfDay() >= 12000L && Utils.timeOfDay() < 13000L;
    }

    public static boolean isNight() {
        return Utils.timeOfDay() >= 13000L && Utils.timeOfDay() < 23000L;
    }

    public static boolean isTimeToSleep() {
        return Utils.timeOfDay() >= 12544L && Utils.timeOfDay() <= 23461L;
    }

    public static boolean isBossBarRendered() {
        return Utils.getBossBarsRendered() > 0;
    }

    public static int getBossBarsRendered() {
        return ((AccessorBossBarHud)Utils.client.field_1705.method_1740()).getBossBars().size();
    }

    public static String ticksToHours(long ticks) {
        int seconds = (int)ticks / 20;
        long sec = seconds % 60;
        long minutes = seconds % 3600 / 60;
        long hours = seconds % 86400 / 3600;
        return String.format("%01d:%02d:%02d", Math.round(hours), Math.round(minutes), Math.round(sec));
    }

    public static String ticksToMinutes(long ticks) {
        int seconds = (int)ticks / 20;
        long sec = seconds % 60;
        long minutes = seconds % 3600 / 60;
        return String.format("%01d:%02d", Math.round(minutes), Math.round(sec));
    }

    public static String formatTicks(int ticks) {
        return Utils.formatTicks(ticks, false);
    }

    public static String formatTicks(int ticks, boolean alwaysHours) {
        float tickRate = Utils.client.field_1687 != null ? Utils.client.field_1687.method_54719().method_54748() : 20.0f;
        int i = class_3532.method_15375((float)((float)ticks / tickRate));
        int j = i / 60;
        int k = j / 60;
        return k > 0 || alwaysHours ? String.format(Locale.ROOT, "%02d:%02d:%02d", k, j, i) : String.format(Locale.ROOT, "%02d:%02d", j %= 60, i %= 60);
    }

    public static boolean isEntityPropertiesOpen() {
        return PointedEntity.isEntityPropertiesOpen;
    }

    public static boolean isBlockPropertiesOpen() {
        return PointedBlock.isBlockPropertiesOpen;
    }

    public static boolean isCenterHudOpen() {
        return PlayerEquipment.isHudOpen || PointedEntity.isMultiplayerEquipmentOpen;
    }

    public static boolean isVanillaBlock(class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block).method_12836() == "minecraft";
    }

    public static boolean isVanillaItem(class_1792 item) {
        return class_7923.field_41178.method_10221((Object)item).method_12836() == "minecraft";
    }

    public static class_1799 getPlayerEquippedStackForComparison(class_1799 hoverStack, class_1657 player) {
        class_1304 slot = null;
        if (player != null) {
            slot = player.method_32326(hoverStack);
            class_1799 equippedItem = player.method_6118(slot);
            if (equippedItem == hoverStack) {
                return class_1799.field_8037;
            }
            return equippedItem;
        }
        return class_1799.field_8037;
    }

    public static boolean isPlayerItemComparable(class_1799 hoverStack, class_1657 player) {
        class_1799 equippedStack = Utils.getPlayerEquippedStackForComparison(hoverStack, player);
        boolean isHoverItemComparable = Utils.isToolOrArmor(hoverStack);
        boolean isEquippedStackComparable = Utils.isToolOrArmor(equippedStack);
        return isHoverItemComparable && isEquippedStackComparable;
    }

    public static class_2561 getDurabilityTooltip(class_1799 stack) {
        ConfigData.AdvancedItemTooltips.Damageables config = Data.cfg.tooltips.damageables;
        int currentUses = Utils.getRemainingUses(stack);
        int percentage = currentUses * 100 / stack.method_7936();
        boolean isPercentage = config.durabilityPercent;
        boolean isPenalty = config.penalty && Utils.getRepairCost(stack) > 0;
        String percent = isPercentage ? String.format(" (%d%%)", percentage) : "";
        String penalty = isPenalty ? " \u00a78(" + Utils.getPenaltyLevel(stack).getString() + "\u00a78)" : "";
        class_5250 durability = TextUtils.write(currentUses + "/" + stack.method_7936() + percent + penalty, class_124.field_1080);
        if (config.durabilityColored) {
            durability.method_10862(durability.method_10866().method_36139(stack.method_31580()));
        }
        return durability;
    }

    public static int getRemainingUses(class_1799 stack) {
        return stack.method_7936() - stack.method_7919();
    }

    public static class_2561 getPenaltyLevel(class_1799 stack) {
        String prefix;
        int timesRepaired;
        int cost = Utils.getRepairCost(stack);
        if (cost <= 0) {
            return class_2561.method_43473();
        }
        if (cost == 1) {
            timesRepaired = 1;
            prefix = "\u00a7a";
        } else if (cost == 3) {
            timesRepaired = 2;
            prefix = "\u00a72";
        } else if (cost == 7) {
            timesRepaired = 3;
            prefix = "\u00a7e";
        } else if (cost == 15) {
            timesRepaired = 4;
            prefix = "\u00a76";
        } else if (cost == 31) {
            timesRepaired = 5;
            prefix = "\u00a7c";
        } else {
            timesRepaired = 6;
            prefix = "\u00a74";
        }
        return TextUtils.write(prefix + timesRepaired + "/6");
    }

    public static int getRepairCost(class_1799 stack) {
        return (Integer)stack.method_58694(class_9334.field_49639);
    }

    public static int getOverlayRemaining() {
        return ((AccessorInGameHud)Utils.client.field_1705).getOverlayRemaining();
    }

    public static boolean isActionBarRendering() {
        return Utils.getOverlayRemaining() > 0;
    }

    public static int getHeldItemTooltipFade() {
        return ((AccessorInGameHud)Utils.client.field_1705).getHeldItemTooltipFade();
    }

    public static boolean isHeldItemTooltipFading() {
        return Utils.getHeldItemTooltipFade() > 0;
    }

    public static boolean canRenderTooltipText() {
        return !Utils.isActionBarRendering() && Utils.isHeldItemTooltipFading();
    }

    public static int getTooltipFade() {
        int l = (int)((float)Utils.getHeldItemTooltipFade() * 256.0f / 10.0f);
        if (l > 255) {
            l = 255;
        }
        return l;
    }

    public static int getTooltipFadeTransition() {
        return class_9848.method_61330((int)Utils.getTooltipFade(), (int)-1);
    }

    public static int getHeldItemTooltipY() {
        boolean bl = !Utils.client.field_1761.method_2908();
        int i = client.method_22683().method_4502() - 59;
        if (bl) {
            i += 14;
        }
        return Data.cfg.vanilla.improvedHeldItemTooltip ? DrawMixins.heldItemTooltipY : i;
    }

    public static int getBackgroundOpacity() {
        return Utils.client.field_1690.method_19345(0.5f);
    }

    public static class_2561 getStatusEffectDurationText(class_1293 statusEffectInstance) {
        int i = class_3532.method_15375((float)((float)statusEffectInstance.method_5584() * 1.0f));
        if (statusEffectInstance.method_48559()) {
            return class_5244.method_48320().method_10852((class_2561)class_2561.method_43471((String)"effect.duration.infinite"));
        }
        return class_2561.method_43470((String)(" (" + Utils.formatTicks(i) + ")"));
    }

    public static class_124 getStatusEffectFormatting(class_1291 effect) {
        class_124 formatting = switch (effect.method_18792()) {
            case class_4081.field_18271 -> class_124.field_1060;
            case class_4081.field_18272 -> class_124.field_1061;
            default -> class_124.field_1065;
        };
        return formatting;
    }

    public static class_1799 getStackFromString(String string) {
        Optional optional = class_7923.field_41178.method_17966(class_2960.method_60654((String)string));
        if (optional.isPresent()) {
            return ((class_1792)optional.get()).method_7854();
        }
        return new class_1799((class_1935)class_1802.field_8162);
    }

    public static int getColor(String s) {
        int color = 0;
        if (Utils.hexToColor(s) != null) {
            color = Utils.hexToColor(s).getRGB();
        }
        return color;
    }

    public static Color hexToColor(String hex) {
        if (hex == null) {
            return null;
        }
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        if (hex.length() != 6 && hex.length() != 8) {
            return null;
        }
        if (!hex.matches("\\p{XDigit}+")) {
            return null;
        }
        try {
            int r = Integer.parseInt(hex.substring(0, 2), 16);
            int g = Integer.parseInt(hex.substring(2, 4), 16);
            int b = Integer.parseInt(hex.substring(4, 6), 16);
            int a = hex.length() == 8 ? Integer.parseInt(hex.substring(6, 8), 16) : 255;
            return new Color(r, g, b, a);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean isParsableToFloat(String text) {
        try {
            if (text.matches("\\d+\\.\\d+")) {
                Float.parseFloat(text);
                return true;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
        return false;
    }

    public static boolean isFood(class_1799 stack) {
        return stack.method_58694(class_9334.field_50075) != null;
    }

    public static boolean hasInfinity(class_1799 itemStack) {
        class_9304 itemEnchantmentsComponent = (class_9304)itemStack.method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
        Iterator iterator = itemEnchantmentsComponent.method_57534().iterator();
        if (iterator.hasNext()) {
            class_6880 entry = (class_6880)iterator.next();
            return entry.method_40225(class_1893.field_9125);
        }
        return false;
    }

    public static int getEnchantmentLevel(class_5321<class_1887> enchantment, class_1799 stack) {
        int level = 0;
        class_9304 itemEnchantmentsComponent = (class_9304)stack.method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
        for (class_6880 entry : itemEnchantmentsComponent.method_57534()) {
            if (!entry.method_40225(enchantment)) continue;
            level = itemEnchantmentsComponent.method_57536(entry);
        }
        return level;
    }

    public static boolean hasEnchantment(class_5321<class_1887> enchantment, class_1799 stack) {
        class_9304 itemEnchantmentsComponent = (class_9304)stack.method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
        for (class_6880 entry : itemEnchantmentsComponent.method_57534()) {
            if (!entry.method_40225(enchantment)) continue;
            return true;
        }
        return false;
    }

    public static float[] getColorComponents(int color) {
        int j = (color & 0xFF0000) >> 16;
        int k = (color & 0xFF00) >> 8;
        int l = (color & 0xFF) >> 0;
        return new float[]{(float)j / 255.0f, (float)k / 255.0f, (float)l / 255.0f};
    }

    public static boolean isMusicDisc(class_1799 stack) {
        return stack.method_58694(class_9334.field_52175) != null;
    }

    public static boolean isHighContrast() {
        return client.method_1520().method_29210().contains("high_contrast");
    }

    public static boolean isElytra(class_1799 stack) {
        return stack.method_58694(class_9334.field_54197) != null;
    }

    public static boolean isTool(class_1799 stack) {
        return stack.method_7909() instanceof class_1786 || stack.method_31573(ConventionalItemTags.MINING_TOOL_TOOLS) || stack.method_31573(ConventionalItemTags.FISHING_ROD_TOOLS) || stack.method_31573(class_3489.field_42613) || stack.method_31573(class_3489.field_42615) || stack.method_31573(ConventionalItemTags.SHIELD_TOOLS) || stack.method_31573(ConventionalItemTags.SHEAR_TOOLS) || stack.method_31573(ConventionalItemTags.BRUSH_TOOLS);
    }

    public static boolean isAnimalArmor(class_1799 stack) {
        return stack.method_31574(class_1802.field_8807) || stack.method_31574(class_1802.field_8560) || stack.method_31574(class_1802.field_8578) || stack.method_31574(class_1802.field_18138) || stack.method_31574(class_1802.field_47831);
    }

    public static boolean isArmor(class_1799 stack) {
        return stack.method_31573(ConventionalItemTags.ARMORS) || stack.method_31573(class_3489.field_48297) || stack.method_31573(class_3489.field_48296) || stack.method_31573(class_3489.field_48295) || stack.method_31573(class_3489.field_48294);
    }

    public static boolean isToolOrArmor(class_1799 stack) {
        return Utils.isTool(stack) || Utils.isArmor(stack) || Utils.isAnimalArmor(stack) || stack.method_31573(ConventionalItemTags.MELEE_WEAPON_TOOLS) || stack.method_31573(ConventionalItemTags.RANGED_WEAPON_TOOLS);
    }

    public static boolean containerHasItems(class_1799 stack) {
        class_9288 container = (class_9288)stack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        return container.method_59714().iterator().hasNext();
    }

    public static int[] tooltipVector(List<class_2561> text, int x, int y) {
        List<class_5684> components = text.stream().map(class_2561::method_30937).map(class_5684::method_32662).toList();
        class_8000 positioner = class_8001.field_41687;
        int l = 0;
        int m = 0;
        if (!components.isEmpty()) {
            int i = 0;
            int j = components.size() == 1 ? -2 : 0;
            for (class_5684 tooltipComponent : components) {
                int k = tooltipComponent.method_32664(Utils.client.field_1772);
                if (k > i) {
                    i = k;
                }
                j += tooltipComponent.method_32661(Utils.client.field_1772);
            }
            Vector2ic vector2ic = positioner.method_47944(Utils.client.field_1755.field_22789, Utils.client.field_1755.field_22790, x, y, i, j);
            l = vector2ic.x();
            m = vector2ic.y();
        }
        return new int[]{l, m};
    }

    public static boolean isFuel(class_1799 stack) {
        return Utils.fuel().method_61752(stack);
    }

    public static class_9895 fuel() {
        return Utils.client.field_1687.method_61269();
    }

    public static boolean isHalloween() {
        return Utils.getDayAndMonth()[0] == 31 && Utils.getDayAndMonth()[1] == 10;
    }

    public static boolean isAprilFools() {
        return Utils.getDayAndMonth()[0] == 1 && Utils.getDayAndMonth()[1] == 4;
    }

    public static boolean isChristmas() {
        return Utils.getDayAndMonth()[0] == 25 && Utils.getDayAndMonth()[1] == 12;
    }

    public static boolean isNewYear() {
        return Utils.getDayAndMonth()[0] == 1 && Utils.getDayAndMonth()[1] == 1;
    }

    public static int[] getDayAndMonth() {
        LocalDate date = LocalDate.now();
        return new int[]{date.get(ChronoField.DAY_OF_MONTH), date.get(ChronoField.MONTH_OF_YEAR)};
    }

    public static boolean isNether() {
        return Utils.client.field_1687.method_27983() == class_1937.field_25180;
    }

    public static boolean isEnd() {
        return Utils.client.field_1687.method_27983() == class_1937.field_25181;
    }

    public static boolean isOverworld() {
        return Utils.client.field_1687.method_27983() == class_1937.field_25179;
    }

    public static int toRelative(int pixel, int screenSize) {
        return Math.max(0, Math.min(1000, pixel * 1000 / screenSize));
    }

    public static int toPixels(int relative, int screenSize) {
        return relative * screenSize / 1000;
    }

    public static int resolveRenderCoord(int configValue, int fallbackPixels, int screenSize) {
        int relative = configValue == -1 ? Utils.toRelative(fallbackPixels, screenSize) : configValue;
        return Utils.toPixels(relative, screenSize);
    }

    public static boolean isShiftDown() {
        return class_3675.method_15987((class_1041)client.method_22683(), (int)340) || class_3675.method_15987((class_1041)client.method_22683(), (int)344);
    }

    public static boolean isControlDown() {
        return class_3675.method_15987((class_1041)client.method_22683(), (int)341) || class_3675.method_15987((class_1041)client.method_22683(), (int)345);
    }
}

