/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.moreusefultables.client.renderer;

import net.mcreator.moreusefultables.client.model.ModelGelid;
import net.mcreator.moreusefultables.client.model.animations.GelidAnimation;
import net.mcreator.moreusefultables.entity.GelidEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class GelidRenderer
extends MobRenderer<GelidEntity, ModelGelid<GelidEntity>> {
    public GelidRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(ModelGelid.LAYER_LOCATION)), 0.5f);
    }

    public ResourceLocation getTextureLocation(GelidEntity entity) {
        return ResourceLocation.parse((String)"more_usefull_tables:textures/entities/gelid.png");
    }

    private static final class AnimatedModel
    extends ModelGelid<GelidEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<GelidEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(GelidEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animateWalk(GelidAnimation.Walk, limbSwing, limbSwingAmount, 1.0f, 10.0f);
                this.animate(entity.animationState1, GelidAnimation.Idle, ageInTicks, 1.0f);
                this.animate(entity.animationState2, GelidAnimation.Attack, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(GelidEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

