/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.moreusefultables.item;

import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.function.Consumer;
import net.mcreator.moreusefultables.init.MoreUsefullTablesModItems;
import net.mcreator.moreusefultables.procedures.Turtle2HelmetTickEventProcedure;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class Turtle2Item
extends Item {
    public static ArmorMaterial ARMOR_MATERIAL = new ArmorMaterial(11, Map.of(ArmorType.BOOTS, 2, ArmorType.LEGGINGS, 0, ArmorType.CHESTPLATE, 0, ArmorType.HELMET, 2, ArmorType.BODY, 0), 1, BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)SoundEvents.EMPTY), 0.0f, 0.0f, TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)"more_usefull_tables:turtle_2_repair_items")), ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.parse((String)"more_usefull_tables:turtle_2")));

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            public ResourceLocation getArmorTexture(ItemStack stack, EquipmentClientInfo.LayerType type, EquipmentClientInfo.Layer layer, ResourceLocation _default) {
                return ResourceLocation.parse((String)"more_usefull_tables:textures/entities/turtle_layer_1.png");
            }
        }, new Item[]{(Item)MoreUsefullTablesModItems.TURTLE_2_HELMET.get()});
    }

    private Turtle2Item(Item.Properties properties) {
        super(properties);
    }

    public static class Helmet
    extends Turtle2Item {
        public Helmet(Item.Properties properties) {
            super(properties.humanoidArmor(ARMOR_MATERIAL, ArmorType.HELMET));
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> list, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, display, list, flag);
            list.accept((Component)Component.translatable((String)"item.more_usefull_tables.turtle_2_helmet.description_0"));
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean isFoil(ItemStack itemstack) {
            return true;
        }

        public void inventoryTick(ItemStack itemstack, ServerLevel world, Entity entity, EquipmentSlot slot) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot);
            if (entity instanceof Player && !Iterables.contains((Iterable)(player = (Player)entity).getInventory().getNonEquipmentItems(), (Object)itemstack)) {
                Turtle2HelmetTickEventProcedure.execute((LevelAccessor)world, itemstack);
            }
        }
    }
}

