/*
 * Decompiled with CFR 0.152.
 */
package ru.mrbedrockpy.suneclipse.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={LevelRenderer.class})
public class SunTextureMixin {
    private static final ResourceLocation ECLIPSE_SUN = new ResourceLocation("suneclipse", "textures/environment/sun_eclipse.png");
    private boolean eclipseToday = false;
    private long lastDayChecked = Long.MIN_VALUE;

    private void updateEclipseFlag(ClientLevel level) {
        long day = level.m_46468_() / 24000L;
        if (day != this.lastDayChecked) {
            this.lastDayChecked = day;
            this.eclipseToday = Math.random() < 0.1;
        }
    }

    @ModifyExpressionValue(method={"renderSky"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/LevelRenderer;SUN_LOCATION:Lnet/minecraft/resources/ResourceLocation;")})
    private ResourceLocation replaceSunTexture(ResourceLocation original) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        if (world != null) {
            this.updateEclipseFlag(world);
            long timeOfDay = world.m_46468_() % 24000L;
            if (this.eclipseToday && timeOfDay < 12000L) {
                return ECLIPSE_SUN;
            }
        }
        return original;
    }

    @ModifyVariable(method={"renderSky"}, at=@At(value="STORE"), ordinal=0)
    private Vec3 replaceSkyColor(Vec3 original) {
        return this.eclipseToday ? new Vec3(0.0, 0.0, 0.02) : original;
    }
}

